/**
 * @stability stable
 */
export interface RunnerConfiguration {
    /**
     * The runner’s description.
     *
     * Informational only.
     *
     * @default "gitlab-runner"
     * @stability stable
     */
    readonly name?: string;
    /**
     * GitLab instance URL.
     *
     * @default "https://gitlab.com"
     * @stability stable
     */
    readonly url?: string;
    /**
     * The runner’s authentication token, which is obtained during runner registration.
     *
     * Not the same as the registration token.
     *
     * @stability stable
     */
    readonly token?: string;
    /**
     * When using HTTPS, file that contains the certificates to verify the peer.
     *
     * See Self-signed certificates or custom Certification Authorities documentation.
     *
     * @stability stable
     */
    readonly tlsCaFile?: string;
    /**
     * When using HTTPS, file that contains the certificate to authenticate with the peer.
     *
     * @stability stable
     */
    readonly tlsCertFile?: string;
    /**
     * When using HTTPS, file that contains the private key to authenticate with the peer.
     *
     * @stability stable
     */
    readonly tlsKeyFile?: string;
    /**
     * Limit how many jobs can be handled concurrently by this registered runner.
     *
     * 0 (default) means do not limit.
     *
     * @default 10
     * @stability stable
     */
    readonly limit?: number;
    /**
     * Select how a project should be built.
     *
     * @default "docker+machine"
     * @stability stable
     */
    readonly executor?: Executor;
    /**
     * Name of shell to generate the script.
     *
     * Default value is platform dependent.
     *
     * @stability stable
     */
    readonly shell?: string;
    /**
     * Absolute path to a directory where builds are stored in the context of the selected executor.
     *
     * For example, locally, Docker, or SSH.
     *
     * @stability stable
     */
    readonly buildsDir?: string;
    /**
     * Absolute path to a directory where build caches are stored in context of selected executor.
     *
     * For example, locally, Docker, or SSH. If the docker executor is used, this directory needs to be included in its volumes parameter.
     *
     * @stability stable
     */
    readonly cacheDir?: string;
    /**
     * Append or overwrite environment variables.
     *
     * @default ["DOCKER_DRIVER=overlay2", "DOCKER_TLS_CERTDIR=/certs"]
     * @stability stable
     */
    readonly environment?: string[];
    /**
     * Limit number of concurrent requests for new jobs from GitLab.
     *
     * Default is 1.
     *
     * @stability stable
     */
    readonly requestConcurrency?: number;
    /**
     * Maximum build log size in kilobytes.
     *
     * Default is 4096 (4MB).
     *
     * @default 52428800 (50GB)
     * @stability stable
     */
    readonly outputLimit?: number;
    /**
     * Commands to be executed on the runner before cloning the Git repository.
     *
     * Use it to adjust the Git client configuration first, for example. To insert multiple commands, use a (triple-quoted) multi-line string or \n character.
     *
     * @stability stable
     */
    readonly preCloneScript?: string;
    /**
     * Commands to be executed on the runner after cloning the Git repository, but before executing the build.
     *
     * To insert multiple commands, use a (triple-quoted) multi-line string or \n character.
     *
     * @stability stable
     */
    readonly preBuildScript?: string;
    /**
     * Commands to be executed on the runner just after executing the build, but before executing after_script.
     *
     * To insert multiple commands, use a (triple-quoted) multi-line string or \n character.
     *
     * @stability stable
     */
    readonly postBuildScript?: string;
    /**
     * Overwrite the URL for the GitLab instance.
     *
     * Used only if the runner can’t connect to the GitLab URL.
     *
     * @stability stable
     */
    readonly cloneUrl?: string;
    /**
     * Disables the CI_DEBUG_TRACE feature.
     *
     * When set to true, then debug log (trace) remains disabled, even if CI_DEBUG_TRACE is set to true by the user.
     *
     * @stability stable
     */
    readonly debugTraceDisabled?: boolean;
    /**
     * Extra job monitoring workers that pass their results as job artifacts to GitLab.
     *
     * @stability stable
     */
    readonly referees?: string;
}
export declare type Executor = "docker+machine" | "docker";
