# Generated by Django 4.1.2 on 2022-12-05 14:57

import _socket
from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django_audit_fields.models.audit_model_mixin
import django_revision.revision_field
import edc_crf.model_mixins.crf_status_model_mixin
import edc_model.models.fields.other_charfield
import edc_model.validators.date
import edc_protocol.validators
import edc_utils.date
import edc_visit_tracking.managers
import simple_history.models
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ("sites", "0002_alter_domain_unique"),
        ("intecomm_lists", "0003_dmmanagement_dmmanagement_intecomm_li_id_b4d41f_idx"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("intecomm_subject", "0004_historicalsocialharms_employment_impact_and_more"),
    ]

    operations = [
        migrations.AlterField(
            model_name="historicalsocialharms",
            name="coworkers_impact",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                max_length=25,
                verbose_name="... with your coworkers?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsocialharms",
            name="employment_impact",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                max_length=25,
                verbose_name="... with your employment?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsocialharms",
            name="family_impact",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                max_length=25,
                verbose_name="... with your family?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsocialharms",
            name="friends_impact",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                max_length=25,
                verbose_name="... with your friends?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsocialharms",
            name="healthcare_impact",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                max_length=25,
                verbose_name="... with your healthcare?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsocialharms",
            name="insurance_impact",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                max_length=25,
                verbose_name="... with your insurance?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsocialharms",
            name="other_impact",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                max_length=25,
                verbose_name="... with any other aspect of your life",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsocialharms",
            name="other_impact_description",
            field=models.CharField(
                blank=True, max_length=50, null=True, verbose_name="Please describe ..."
            ),
        ),
        migrations.AlterField(
            model_name="historicalsocialharms",
            name="other_service_impact",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                max_length=25,
                verbose_name="... with any other health service",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsocialharms",
            name="other_service_impact_description",
            field=models.CharField(
                blank=True, max_length=50, null=True, verbose_name="Please describe ..."
            ),
        ),
        migrations.AlterField(
            model_name="socialharms",
            name="coworkers_impact",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                max_length=25,
                verbose_name="... with your coworkers?",
            ),
        ),
        migrations.AlterField(
            model_name="socialharms",
            name="employment_impact",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                max_length=25,
                verbose_name="... with your employment?",
            ),
        ),
        migrations.AlterField(
            model_name="socialharms",
            name="family_impact",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                max_length=25,
                verbose_name="... with your family?",
            ),
        ),
        migrations.AlterField(
            model_name="socialharms",
            name="friends_impact",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                max_length=25,
                verbose_name="... with your friends?",
            ),
        ),
        migrations.AlterField(
            model_name="socialharms",
            name="healthcare_impact",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                max_length=25,
                verbose_name="... with your healthcare?",
            ),
        ),
        migrations.AlterField(
            model_name="socialharms",
            name="insurance_impact",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                max_length=25,
                verbose_name="... with your insurance?",
            ),
        ),
        migrations.AlterField(
            model_name="socialharms",
            name="other_impact",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                max_length=25,
                verbose_name="... with any other aspect of your life",
            ),
        ),
        migrations.AlterField(
            model_name="socialharms",
            name="other_impact_description",
            field=models.CharField(
                blank=True, max_length=50, null=True, verbose_name="Please describe ..."
            ),
        ),
        migrations.AlterField(
            model_name="socialharms",
            name="other_service_impact",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                max_length=25,
                verbose_name="... with any other health service",
            ),
        ),
        migrations.AlterField(
            model_name="socialharms",
            name="other_service_impact_description",
            field=models.CharField(
                blank=True, max_length=50, null=True, verbose_name="Please describe ..."
            ),
        ),
        migrations.CreateModel(
            name="HistoricalHealthEconomics",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "occupation",
                    models.CharField(
                        max_length=50, verbose_name="What is your occupation/profession?"
                    ),
                ),
                (
                    "education_in_years",
                    models.IntegerField(
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(50),
                        ],
                        verbose_name="How many years of education did you complete?",
                    ),
                ),
                (
                    "education_certificate",
                    models.CharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="What is your highest education certificate?",
                    ),
                ),
                (
                    "primary_school",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        max_length=15,
                        verbose_name="Did you go to primary/elementary school?",
                    ),
                ),
                (
                    "primary_school_in_years",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(10),
                        ],
                        verbose_name="If YES, for how many years",
                    ),
                ),
                (
                    "secondary_school",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        max_length=15,
                        verbose_name="Did you go to secondary school?",
                    ),
                ),
                (
                    "secondary_school_in_years",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(10),
                        ],
                        verbose_name="If YES, for how many years",
                    ),
                ),
                (
                    "higher_education",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        max_length=15,
                        verbose_name="Did you go to higher education?",
                    ),
                ),
                (
                    "higher_education_in_years",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(10),
                        ],
                        verbose_name="If YES, for how many years",
                    ),
                ),
                (
                    "welfare",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Do you receive any welfare or social service support",
                    ),
                ),
                (
                    "income_per_month",
                    models.IntegerField(
                        help_text="in local currency",
                        null=True,
                        verbose_name="How much do you earn (take home) per month?",
                    ),
                ),
                (
                    "household_income_per_month",
                    models.IntegerField(
                        help_text="in local currency",
                        null=True,
                        verbose_name="What is the total income in your household per month?",
                    ),
                ),
                (
                    "is_highest_earner",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Are you the person who earns the highest income in your household?",
                    ),
                ),
                (
                    "highest_earner",
                    models.CharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="If NO, what is the profession of the person who earns the highest income?",
                    ),
                ),
                (
                    "food_per_month",
                    models.IntegerField(
                        help_text="in local currency",
                        null=True,
                        verbose_name="How much do you/your family spend on food in a month?",
                    ),
                ),
                (
                    "accomodation_per_month",
                    models.IntegerField(
                        help_text="in local currency",
                        null=True,
                        verbose_name="How much do you/your family spend on rent (or house loan/mortgage) and utilities in a month?",
                    ),
                ),
                (
                    "large_expenditure_year",
                    models.IntegerField(
                        help_text="e.g. furniture, electrical items, cars (in local currency)",
                        null=True,
                        verbose_name="How much have you spent on large items in the last year",
                    ),
                ),
                (
                    "received_rx_month",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="not including today",
                        max_length=15,
                        verbose_name="Over the last month, did you get any drugs on your visit to the health facility?",
                    ),
                ),
                (
                    "rx_dm_month",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="not including today",
                        max_length=15,
                        verbose_name="Did you receive drugs for raised blood sugar (diabetes) over the last month?",
                    ),
                ),
                (
                    "rx_dm_paid_month_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If `other pay source`, please specify ... (DM)",
                    ),
                ),
                (
                    "rx_dm_cost_month",
                    models.IntegerField(
                        blank=True,
                        help_text="In local currency",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If these drugs were not free, how much did you pay?",
                    ),
                ),
                (
                    "rx_htn_month",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="not including today",
                        max_length=15,
                        verbose_name="Did you receive drugs for raised blood pressure (hypertension) over the last month?",
                    ),
                ),
                (
                    "rx_htn_paid_month_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If `other pay source`, please specify ...(HTN)",
                    ),
                ),
                (
                    "rx_htn_cost_month",
                    models.IntegerField(
                        blank=True,
                        help_text="In local currency",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If these drugs were not free, how much did you pay?",
                    ),
                ),
                (
                    "rx_hiv_month",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="not including today",
                        max_length=15,
                        verbose_name="Did you receive anti-retroviral drugs for HIV over the last month?",
                    ),
                ),
                (
                    "rx_hiv_paid_month_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If `other pay source`, please specify ... (HIV)",
                    ),
                ),
                (
                    "rx_hiv_cost_month",
                    models.IntegerField(
                        blank=True,
                        help_text="In local currency",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If these drugs were not free, how much did you pay?",
                    ),
                ),
                (
                    "rx_other_month",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Did you receive any 'other' drugs?",
                    ),
                ),
                (
                    "rx_other_paid_month_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If `other pay source`, please specify ...",
                    ),
                ),
                (
                    "rx_other_cost_month",
                    models.IntegerField(
                        blank=True,
                        help_text="In local currency",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If not free, how much did you pay for these 'other' drugs?",
                    ),
                ),
                (
                    "non_drug_activities_month",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Over the last month, did you spend money on other activities (not drugs) relating to your health?",
                    ),
                ),
                (
                    "non_drug_activities_detail_month",
                    models.TextField(
                        blank=True, null=True, verbose_name="If YES, what was the activity"
                    ),
                ),
                (
                    "non_drug_activities_cost_month",
                    models.IntegerField(
                        blank=True,
                        help_text="In local currency",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If YES, how much was spent on other activities (not drugs) relating to your health?",
                    ),
                ),
                (
                    "healthcare_expenditure_total_month",
                    models.IntegerField(
                        help_text="In local currency",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="How much in total has been spent on your healthcare in the last month?",
                    ),
                ),
                (
                    "missed_routine_activities",
                    models.CharField(
                        choices=[
                            ("working", "Working"),
                            ("studying", "Studying"),
                            ("caring_for_children", "Caring for children"),
                            ("house_maintenance", "House maintenance"),
                            ("nothing", "Nothing"),
                            ("OTHER", "Other, please specify"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="What would you be doing if you had not come to the health facility today?",
                    ),
                ),
                (
                    "missed_routine_activities_other",
                    models.CharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="If OTHER, please specify",
                    ),
                ),
                (
                    "off_work_days",
                    models.DecimalField(
                        decimal_places=1,
                        help_text="in days. (1,2,3 etc. If half-day 0.5)",
                        max_digits=4,
                        null=True,
                        verbose_name="How much time did you take off work?",
                    ),
                ),
                (
                    "travel_time",
                    models.CharField(
                        help_text="in hours and minutes (format HH:MM)",
                        max_length=5,
                        null=True,
                        verbose_name="How long did it take you to reach here?",
                    ),
                ),
                (
                    "hospital_time",
                    models.CharField(
                        help_text="in hours and minutes (format HH:MM)",
                        max_length=5,
                        null=True,
                        verbose_name="How much time did you spend at the health care facility?",
                    ),
                ),
                (
                    "lost_income",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Did you lose earnings as a result of coming here today? ",
                    ),
                ),
                (
                    "lost_income_amount",
                    models.IntegerField(
                        blank=True,
                        help_text="In local currency",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If Yes, how much did you lose?",
                    ),
                ),
                (
                    "childcare",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Did you ask anyone else, such as your family member/friend to look after your child/children in order to come here?",
                    ),
                ),
                (
                    "childcare_source",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("working", "Working"),
                            ("studying", "Studying"),
                            ("caring_for_children", "Caring for children"),
                            ("house_maintenance", "House maintenance"),
                            ("nothing", "Nothing"),
                            ("OTHER", "Other, specify"),
                        ],
                        default="N/A",
                        max_length=25,
                        null=True,
                        verbose_name="If Yes, what would they have been doing if they had not stayed to look after your child or children?",
                    ),
                ),
                (
                    "childcare_source_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "childcare_source_timeoff",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        help_text="in days. (1,2,3 etc. If half-day 0.5)",
                        max_digits=4,
                        null=True,
                        verbose_name="How much time did a family member or friend take off?",
                    ),
                ),
                (
                    "transport_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If `other reason`, please specify ...",
                    ),
                ),
                (
                    "transport_cost",
                    models.IntegerField(
                        help_text="Coming to the health care facility going back home. (In local currency)",
                        null=True,
                        verbose_name="How much did you spend on transport in total?",
                    ),
                ),
                (
                    "food_cost",
                    models.IntegerField(
                        help_text="In local currency",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="How much did you spend on food while you were at the health care faility today?",
                    ),
                ),
                (
                    "received_rx_today",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Did you get any drugs on your visit to the health facility today?",
                    ),
                ),
                (
                    "rx_dm_today",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Did you receive drugs for raised blood sugar (diabetes) today?",
                    ),
                ),
                (
                    "rx_dm_paid_today_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If `other pay source`, please specify ...",
                    ),
                ),
                (
                    "rx_dm_cost_today",
                    models.IntegerField(
                        blank=True,
                        help_text="In local currency",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If not free, how much did you pay for raised blood sugar (diabetes) drugs?",
                    ),
                ),
                (
                    "rx_htn_today",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Did you receive raised blood pressure (hypertension) drugs today?",
                    ),
                ),
                (
                    "rx_htn_paid_today_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If `other pay source`, please specify ...",
                    ),
                ),
                (
                    "rx_htn_cost_today",
                    models.IntegerField(
                        blank=True,
                        help_text="In local currency",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If not free, how much did you pay for high blood pressure (Hypertension) drugs?",
                    ),
                ),
                (
                    "rx_hiv_today",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Did you receive ARVs (HIV) today?",
                    ),
                ),
                (
                    "rx_hiv_paid_today_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If `other pay source`, please specify ...",
                    ),
                ),
                (
                    "rx_hiv_cost_today",
                    models.IntegerField(
                        blank=True,
                        help_text="In local currency",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If not free, how much did you pay for ARV (HIV) drugs?",
                    ),
                ),
                (
                    "rx_other_today",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Did you receive 'other' drugs today?",
                    ),
                ),
                (
                    "rx_other_paid_today_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If `other pay source`, please specify ...",
                    ),
                ),
                (
                    "rx_other_cost_today",
                    models.IntegerField(
                        blank=True,
                        help_text="In local currency",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If not free, how much did you pay for these 'other' drugs?",
                    ),
                ),
                (
                    "non_drug_activities_today",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Did you spend money on other activities (not drugs) relating to your health today?",
                    ),
                ),
                (
                    "non_drug_activities_detail_today",
                    models.TextField(
                        blank=True, null=True, verbose_name="If YES, what was the activity"
                    ),
                ),
                (
                    "non_drug_activities_cost_today",
                    models.IntegerField(
                        blank=True,
                        help_text="In local currency",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If YES, how much did you spend?",
                    ),
                ),
                (
                    "healthcare_expenditure_total_month_today",
                    models.IntegerField(
                        help_text="In local currency",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="How much in total has been spent on your healthcare in the last month?",
                    ),
                ),
                (
                    "finance_by_sale",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Do you sell anything to pay for your visit today?",
                    ),
                ),
                (
                    "finance_by_loan",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Did you take any loans to pay for your visit?",
                    ),
                ),
                (
                    "health_insurance",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Do you have private healthcare insurance?",
                    ),
                ),
                (
                    "health_insurance_cost",
                    models.IntegerField(
                        blank=True,
                        help_text="in local currency",
                        null=True,
                        verbose_name="If Yes, how much do you pay towards your contributions to healthcare insurance every month?",
                    ),
                ),
                (
                    "patient_club",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Do you contribute to a patient club?",
                    ),
                ),
                (
                    "patient_club_cost",
                    models.IntegerField(
                        blank=True,
                        help_text="in local currency",
                        null=True,
                        verbose_name="If Yes, how much do you pay towards your contributions to the patient club every month?",
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Health Economics (Rev 1)",
                "verbose_name_plural": "historical Health Economics (Rev 1)",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HealthEconomics",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "occupation",
                    models.CharField(
                        max_length=50, verbose_name="What is your occupation/profession?"
                    ),
                ),
                (
                    "education_in_years",
                    models.IntegerField(
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(50),
                        ],
                        verbose_name="How many years of education did you complete?",
                    ),
                ),
                (
                    "education_certificate",
                    models.CharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="What is your highest education certificate?",
                    ),
                ),
                (
                    "primary_school",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        max_length=15,
                        verbose_name="Did you go to primary/elementary school?",
                    ),
                ),
                (
                    "primary_school_in_years",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(10),
                        ],
                        verbose_name="If YES, for how many years",
                    ),
                ),
                (
                    "secondary_school",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        max_length=15,
                        verbose_name="Did you go to secondary school?",
                    ),
                ),
                (
                    "secondary_school_in_years",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(10),
                        ],
                        verbose_name="If YES, for how many years",
                    ),
                ),
                (
                    "higher_education",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        max_length=15,
                        verbose_name="Did you go to higher education?",
                    ),
                ),
                (
                    "higher_education_in_years",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(10),
                        ],
                        verbose_name="If YES, for how many years",
                    ),
                ),
                (
                    "welfare",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Do you receive any welfare or social service support",
                    ),
                ),
                (
                    "income_per_month",
                    models.IntegerField(
                        help_text="in local currency",
                        null=True,
                        verbose_name="How much do you earn (take home) per month?",
                    ),
                ),
                (
                    "household_income_per_month",
                    models.IntegerField(
                        help_text="in local currency",
                        null=True,
                        verbose_name="What is the total income in your household per month?",
                    ),
                ),
                (
                    "is_highest_earner",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Are you the person who earns the highest income in your household?",
                    ),
                ),
                (
                    "highest_earner",
                    models.CharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="If NO, what is the profession of the person who earns the highest income?",
                    ),
                ),
                (
                    "food_per_month",
                    models.IntegerField(
                        help_text="in local currency",
                        null=True,
                        verbose_name="How much do you/your family spend on food in a month?",
                    ),
                ),
                (
                    "accomodation_per_month",
                    models.IntegerField(
                        help_text="in local currency",
                        null=True,
                        verbose_name="How much do you/your family spend on rent (or house loan/mortgage) and utilities in a month?",
                    ),
                ),
                (
                    "large_expenditure_year",
                    models.IntegerField(
                        help_text="e.g. furniture, electrical items, cars (in local currency)",
                        null=True,
                        verbose_name="How much have you spent on large items in the last year",
                    ),
                ),
                (
                    "received_rx_month",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="not including today",
                        max_length=15,
                        verbose_name="Over the last month, did you get any drugs on your visit to the health facility?",
                    ),
                ),
                (
                    "rx_dm_month",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="not including today",
                        max_length=15,
                        verbose_name="Did you receive drugs for raised blood sugar (diabetes) over the last month?",
                    ),
                ),
                (
                    "rx_dm_paid_month_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If `other pay source`, please specify ... (DM)",
                    ),
                ),
                (
                    "rx_dm_cost_month",
                    models.IntegerField(
                        blank=True,
                        help_text="In local currency",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If these drugs were not free, how much did you pay?",
                    ),
                ),
                (
                    "rx_htn_month",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="not including today",
                        max_length=15,
                        verbose_name="Did you receive drugs for raised blood pressure (hypertension) over the last month?",
                    ),
                ),
                (
                    "rx_htn_paid_month_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If `other pay source`, please specify ...(HTN)",
                    ),
                ),
                (
                    "rx_htn_cost_month",
                    models.IntegerField(
                        blank=True,
                        help_text="In local currency",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If these drugs were not free, how much did you pay?",
                    ),
                ),
                (
                    "rx_hiv_month",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="not including today",
                        max_length=15,
                        verbose_name="Did you receive anti-retroviral drugs for HIV over the last month?",
                    ),
                ),
                (
                    "rx_hiv_paid_month_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If `other pay source`, please specify ... (HIV)",
                    ),
                ),
                (
                    "rx_hiv_cost_month",
                    models.IntegerField(
                        blank=True,
                        help_text="In local currency",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If these drugs were not free, how much did you pay?",
                    ),
                ),
                (
                    "rx_other_month",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Did you receive any 'other' drugs?",
                    ),
                ),
                (
                    "rx_other_paid_month_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If `other pay source`, please specify ...",
                    ),
                ),
                (
                    "rx_other_cost_month",
                    models.IntegerField(
                        blank=True,
                        help_text="In local currency",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If not free, how much did you pay for these 'other' drugs?",
                    ),
                ),
                (
                    "non_drug_activities_month",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Over the last month, did you spend money on other activities (not drugs) relating to your health?",
                    ),
                ),
                (
                    "non_drug_activities_detail_month",
                    models.TextField(
                        blank=True, null=True, verbose_name="If YES, what was the activity"
                    ),
                ),
                (
                    "non_drug_activities_cost_month",
                    models.IntegerField(
                        blank=True,
                        help_text="In local currency",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If YES, how much was spent on other activities (not drugs) relating to your health?",
                    ),
                ),
                (
                    "healthcare_expenditure_total_month",
                    models.IntegerField(
                        help_text="In local currency",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="How much in total has been spent on your healthcare in the last month?",
                    ),
                ),
                (
                    "missed_routine_activities",
                    models.CharField(
                        choices=[
                            ("working", "Working"),
                            ("studying", "Studying"),
                            ("caring_for_children", "Caring for children"),
                            ("house_maintenance", "House maintenance"),
                            ("nothing", "Nothing"),
                            ("OTHER", "Other, please specify"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="What would you be doing if you had not come to the health facility today?",
                    ),
                ),
                (
                    "missed_routine_activities_other",
                    models.CharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="If OTHER, please specify",
                    ),
                ),
                (
                    "off_work_days",
                    models.DecimalField(
                        decimal_places=1,
                        help_text="in days. (1,2,3 etc. If half-day 0.5)",
                        max_digits=4,
                        null=True,
                        verbose_name="How much time did you take off work?",
                    ),
                ),
                (
                    "travel_time",
                    models.CharField(
                        help_text="in hours and minutes (format HH:MM)",
                        max_length=5,
                        null=True,
                        verbose_name="How long did it take you to reach here?",
                    ),
                ),
                (
                    "hospital_time",
                    models.CharField(
                        help_text="in hours and minutes (format HH:MM)",
                        max_length=5,
                        null=True,
                        verbose_name="How much time did you spend at the health care facility?",
                    ),
                ),
                (
                    "lost_income",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Did you lose earnings as a result of coming here today? ",
                    ),
                ),
                (
                    "lost_income_amount",
                    models.IntegerField(
                        blank=True,
                        help_text="In local currency",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If Yes, how much did you lose?",
                    ),
                ),
                (
                    "childcare",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Did you ask anyone else, such as your family member/friend to look after your child/children in order to come here?",
                    ),
                ),
                (
                    "childcare_source",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("working", "Working"),
                            ("studying", "Studying"),
                            ("caring_for_children", "Caring for children"),
                            ("house_maintenance", "House maintenance"),
                            ("nothing", "Nothing"),
                            ("OTHER", "Other, specify"),
                        ],
                        default="N/A",
                        max_length=25,
                        null=True,
                        verbose_name="If Yes, what would they have been doing if they had not stayed to look after your child or children?",
                    ),
                ),
                (
                    "childcare_source_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "childcare_source_timeoff",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        help_text="in days. (1,2,3 etc. If half-day 0.5)",
                        max_digits=4,
                        null=True,
                        verbose_name="How much time did a family member or friend take off?",
                    ),
                ),
                (
                    "transport_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If `other reason`, please specify ...",
                    ),
                ),
                (
                    "transport_cost",
                    models.IntegerField(
                        help_text="Coming to the health care facility going back home. (In local currency)",
                        null=True,
                        verbose_name="How much did you spend on transport in total?",
                    ),
                ),
                (
                    "food_cost",
                    models.IntegerField(
                        help_text="In local currency",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="How much did you spend on food while you were at the health care faility today?",
                    ),
                ),
                (
                    "received_rx_today",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Did you get any drugs on your visit to the health facility today?",
                    ),
                ),
                (
                    "rx_dm_today",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Did you receive drugs for raised blood sugar (diabetes) today?",
                    ),
                ),
                (
                    "rx_dm_paid_today_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If `other pay source`, please specify ...",
                    ),
                ),
                (
                    "rx_dm_cost_today",
                    models.IntegerField(
                        blank=True,
                        help_text="In local currency",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If not free, how much did you pay for raised blood sugar (diabetes) drugs?",
                    ),
                ),
                (
                    "rx_htn_today",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Did you receive raised blood pressure (hypertension) drugs today?",
                    ),
                ),
                (
                    "rx_htn_paid_today_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If `other pay source`, please specify ...",
                    ),
                ),
                (
                    "rx_htn_cost_today",
                    models.IntegerField(
                        blank=True,
                        help_text="In local currency",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If not free, how much did you pay for high blood pressure (Hypertension) drugs?",
                    ),
                ),
                (
                    "rx_hiv_today",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Did you receive ARVs (HIV) today?",
                    ),
                ),
                (
                    "rx_hiv_paid_today_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If `other pay source`, please specify ...",
                    ),
                ),
                (
                    "rx_hiv_cost_today",
                    models.IntegerField(
                        blank=True,
                        help_text="In local currency",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If not free, how much did you pay for ARV (HIV) drugs?",
                    ),
                ),
                (
                    "rx_other_today",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Did you receive 'other' drugs today?",
                    ),
                ),
                (
                    "rx_other_paid_today_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If `other pay source`, please specify ...",
                    ),
                ),
                (
                    "rx_other_cost_today",
                    models.IntegerField(
                        blank=True,
                        help_text="In local currency",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If not free, how much did you pay for these 'other' drugs?",
                    ),
                ),
                (
                    "non_drug_activities_today",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Did you spend money on other activities (not drugs) relating to your health today?",
                    ),
                ),
                (
                    "non_drug_activities_detail_today",
                    models.TextField(
                        blank=True, null=True, verbose_name="If YES, what was the activity"
                    ),
                ),
                (
                    "non_drug_activities_cost_today",
                    models.IntegerField(
                        blank=True,
                        help_text="In local currency",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If YES, how much did you spend?",
                    ),
                ),
                (
                    "healthcare_expenditure_total_month_today",
                    models.IntegerField(
                        help_text="In local currency",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="How much in total has been spent on your healthcare in the last month?",
                    ),
                ),
                (
                    "finance_by_sale",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Do you sell anything to pay for your visit today?",
                    ),
                ),
                (
                    "finance_by_loan",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Did you take any loans to pay for your visit?",
                    ),
                ),
                (
                    "health_insurance",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Do you have private healthcare insurance?",
                    ),
                ),
                (
                    "health_insurance_cost",
                    models.IntegerField(
                        blank=True,
                        help_text="in local currency",
                        null=True,
                        verbose_name="If Yes, how much do you pay towards your contributions to healthcare insurance every month?",
                    ),
                ),
                (
                    "patient_club",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Do you contribute to a patient club?",
                    ),
                ),
                (
                    "patient_club_cost",
                    models.IntegerField(
                        blank=True,
                        help_text="in local currency",
                        null=True,
                        verbose_name="If Yes, how much do you pay towards your contributions to the patient club every month?",
                    ),
                ),
                (
                    "rx_dm_paid_month",
                    models.ManyToManyField(
                        blank=True,
                        related_name="+",
                        to="intecomm_lists.drugpaysources",
                        verbose_name="If YES, how were these paid for?",
                    ),
                ),
                (
                    "rx_dm_paid_today",
                    models.ManyToManyField(
                        blank=True,
                        related_name="+",
                        to="intecomm_lists.drugpaysources",
                        verbose_name="If YES, received raised blood sugar (diabetes) drugs, how were these paid for?",
                    ),
                ),
                (
                    "rx_hiv_paid_month",
                    models.ManyToManyField(
                        blank=True,
                        max_length=25,
                        related_name="+",
                        to="intecomm_lists.drugpaysources",
                        verbose_name="If YES, how were these paid for?",
                    ),
                ),
                (
                    "rx_hiv_paid_today",
                    models.ManyToManyField(
                        blank=True,
                        max_length=25,
                        related_name="+",
                        to="intecomm_lists.drugpaysources",
                        verbose_name="If YES, received ARV (HIV) drugs, how were these paid for?",
                    ),
                ),
                (
                    "rx_htn_paid_month",
                    models.ManyToManyField(
                        blank=True,
                        related_name="+",
                        to="intecomm_lists.drugpaysources",
                        verbose_name="If YES, how were these paid for?",
                    ),
                ),
                (
                    "rx_htn_paid_today",
                    models.ManyToManyField(
                        blank=True,
                        related_name="+",
                        to="intecomm_lists.drugpaysources",
                        verbose_name="If YES, received high blood pressure (Hypertension) drugs, how were these paid for?",
                    ),
                ),
                (
                    "rx_other_paid_month",
                    models.ManyToManyField(
                        blank=True,
                        related_name="+",
                        to="intecomm_lists.drugpaysources",
                        verbose_name="If YES, received 'other' drugs, how were these paid for?",
                    ),
                ),
                (
                    "rx_other_paid_today",
                    models.ManyToManyField(
                        blank=True,
                        related_name="+",
                        to="intecomm_lists.drugpaysources",
                        verbose_name="If YES, received 'other' drugs, how were these paid for?",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
                (
                    "transport",
                    models.ManyToManyField(
                        max_length=25,
                        to="intecomm_lists.transportchoices",
                        verbose_name="Which form of transport did you take to get to the hospital today?",
                    ),
                ),
            ],
            options={
                "verbose_name": "Health Economics (Rev 1)",
                "verbose_name_plural": "Health Economics (Rev 1)",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.AddIndex(
            model_name="healtheconomics",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="intecomm_su_subject_0fa533_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="healtheconomics",
            index=models.Index(
                fields=["subject_visit", "report_datetime"],
                name="intecomm_su_subject_10dc95_idx",
            ),
        ),
    ]
