# Generated by Django 4.1.2 on 2022-12-02 22:41

import _socket
from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django_audit_fields.models.audit_model_mixin
import django_revision.revision_field
import edc_crf.model_mixins.crf_status_model_mixin
import edc_model.models.fields.duration
import edc_model.validators.date
import edc_model_fields.fields.other_charfield
import edc_protocol.validators
import edc_utils.date
import edc_visit_tracking.managers
import simple_history.models
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ("sites", "0002_alter_domain_unique"),
        ("intecomm_lists", "0003_dmmanagement_dmmanagement_intecomm_li_id_b4d41f_idx"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("intecomm_subject", "0001_initial"),
    ]

    operations = [
        migrations.RemoveField(
            model_name="historicaldminitialreview",
            name="managed_by",
        ),
        migrations.RemoveField(
            model_name="historicalotherbaselinedata",
            name="num_vegetables_eaten",
        ),
        migrations.RemoveField(
            model_name="historicalotherbaselinedata",
            name="use_salt_on_food",
        ),
        migrations.RemoveField(
            model_name="historicalotherbaselinedata",
            name="work_activity",
        ),
        migrations.RemoveField(
            model_name="historicalotherbaselinedata",
            name="work_activity_days",
        ),
        migrations.RemoveField(
            model_name="historicalotherbaselinedata",
            name="work_activity_exercise",
        ),
        migrations.RemoveField(
            model_name="historicalotherbaselinedata",
            name="work_activity_exercise_time",
        ),
        migrations.RemoveField(
            model_name="otherbaselinedata",
            name="num_vegetables_eaten",
        ),
        migrations.RemoveField(
            model_name="otherbaselinedata",
            name="use_salt_on_food",
        ),
        migrations.RemoveField(
            model_name="otherbaselinedata",
            name="work_activity",
        ),
        migrations.RemoveField(
            model_name="otherbaselinedata",
            name="work_activity_days",
        ),
        migrations.RemoveField(
            model_name="otherbaselinedata",
            name="work_activity_exercise",
        ),
        migrations.RemoveField(
            model_name="otherbaselinedata",
            name="work_activity_exercise_time",
        ),
        migrations.AddField(
            model_name="dminitialreview",
            name="managed_by_other",
            field=edc_model_fields.fields.other_charfield.OtherCharField(
                blank=True,
                max_length=35,
                null=True,
                verbose_name="If other, please specify ...",
            ),
        ),
        migrations.AddField(
            model_name="dminitialreview",
            name="singleton_field",
            field=models.CharField(
                help_text="auto updated for unique constraint",
                max_length=50,
                null=True,
                unique=True,
                verbose_name="subject identifier",
            ),
        ),
        migrations.AddField(
            model_name="historicaldminitialreview",
            name="managed_by_other",
            field=edc_model_fields.fields.other_charfield.OtherCharField(
                blank=True,
                max_length=35,
                null=True,
                verbose_name="If other, please specify ...",
            ),
        ),
        migrations.AddField(
            model_name="historicaldminitialreview",
            name="singleton_field",
            field=models.CharField(
                db_index=True,
                help_text="auto updated for unique constraint",
                max_length=50,
                null=True,
                verbose_name="subject identifier",
            ),
        ),
        migrations.AddField(
            model_name="historicalhivinitialreview",
            name="singleton_field",
            field=models.CharField(
                db_index=True,
                help_text="auto updated for unique constraint",
                max_length=50,
                null=True,
                verbose_name="subject identifier",
            ),
        ),
        migrations.AddField(
            model_name="historicalhtninitialreview",
            name="singleton_field",
            field=models.CharField(
                db_index=True,
                help_text="auto updated for unique constraint",
                max_length=50,
                null=True,
                verbose_name="subject identifier",
            ),
        ),
        migrations.AddField(
            model_name="historicalotherbaselinedata",
            name="activity_combined_mn_avg_day",
            field=models.IntegerField(
                blank=True,
                help_text="Number of minutes in a typical day",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(1080),
                ],
                verbose_name="On an average day, how many MINUTES do you spend on all physical activities combined (moderate or vigorous-intensity work activities, exercise, sports and fitness)",
            ),
        ),
        migrations.AddField(
            model_name="historicalotherbaselinedata",
            name="activity_exercise_days_per_wk",
            field=models.IntegerField(
                blank=True,
                help_text="Number of days in a typical week",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(
                        7, message="Maximum days in a week is 7"
                    ),
                ],
                verbose_name="How many DAYS do you do personal exercise, sports or fitness activities? (in a typical week)",
            ),
        ),
        migrations.AddField(
            model_name="historicalotherbaselinedata",
            name="activity_work",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                help_text="See interviewer notes above.",
                max_length=15,
                null=True,
                verbose_name="Does your work involve moderate or vigorous-intensity physical activity",
            ),
        ),
        migrations.AddField(
            model_name="historicalotherbaselinedata",
            name="activity_work_days_per_wk",
            field=models.IntegerField(
                blank=True,
                help_text="Number of days in a typical week",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(7),
                ],
                verbose_name="If yes, how many DAYS do you do these physical activities as part of your work? (in a typical week)",
            ),
        ),
        migrations.AddField(
            model_name="historicalotherbaselinedata",
            name="adds_salt_to_food",
            field=models.CharField(
                choices=[
                    ("always", "Always"),
                    ("very_often", "Very Often"),
                    ("sometimes", "Sometimes"),
                    ("rarely", "Rarely"),
                    ("NEVER", "Never"),
                ],
                max_length=15,
                null=True,
                verbose_name="Do you add salt to your food in addition to what has been added when cooking?",
            ),
        ),
        migrations.AddField(
            model_name="historicalotherbaselinedata",
            name="num_fruits_eaten",
            field=models.IntegerField(
                default=0,
                help_text="Number per day",
                verbose_name="On average, how many vegetables do you eat in a day?",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="historicalotherbaselinedata",
            name="num_leafy_vegs_eaten",
            field=models.IntegerField(
                default=0,
                help_text="Number per day",
                verbose_name="On average, how many green leafy vegetables do you eat in a day?",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="historicalotherbaselinedata",
            name="num_other_vegs_eaten",
            field=models.IntegerField(
                default=0,
                help_text="Other vegetables like carrots, tomatoes, bell papers etc. Number per day",
                verbose_name="On average, how many other vegetables do you eat in a day?",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="historicalotherbaselinedata",
            name="smoker_current_duration",
            field=edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="historicalotherbaselinedata",
            name="smoker_current_duration_estimated_date",
            field=edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="hivinitialreview",
            name="singleton_field",
            field=models.CharField(
                help_text="auto updated for unique constraint",
                max_length=50,
                null=True,
                unique=True,
                verbose_name="subject identifier",
            ),
        ),
        migrations.AddField(
            model_name="htninitialreview",
            name="singleton_field",
            field=models.CharField(
                help_text="auto updated for unique constraint",
                max_length=50,
                null=True,
                unique=True,
                verbose_name="subject identifier",
            ),
        ),
        migrations.AddField(
            model_name="otherbaselinedata",
            name="activity_combined_mn_avg_day",
            field=models.IntegerField(
                blank=True,
                help_text="Number of minutes in a typical day",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(1080),
                ],
                verbose_name="On an average day, how many MINUTES do you spend on all physical activities combined (moderate or vigorous-intensity work activities, exercise, sports and fitness)",
            ),
        ),
        migrations.AddField(
            model_name="otherbaselinedata",
            name="activity_exercise_days_per_wk",
            field=models.IntegerField(
                blank=True,
                help_text="Number of days in a typical week",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(
                        7, message="Maximum days in a week is 7"
                    ),
                ],
                verbose_name="How many DAYS do you do personal exercise, sports or fitness activities? (in a typical week)",
            ),
        ),
        migrations.AddField(
            model_name="otherbaselinedata",
            name="activity_work",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                help_text="See interviewer notes above.",
                max_length=15,
                null=True,
                verbose_name="Does your work involve moderate or vigorous-intensity physical activity",
            ),
        ),
        migrations.AddField(
            model_name="otherbaselinedata",
            name="activity_work_days_per_wk",
            field=models.IntegerField(
                blank=True,
                help_text="Number of days in a typical week",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(7),
                ],
                verbose_name="If yes, how many DAYS do you do these physical activities as part of your work? (in a typical week)",
            ),
        ),
        migrations.AddField(
            model_name="otherbaselinedata",
            name="adds_salt_to_food",
            field=models.CharField(
                choices=[
                    ("always", "Always"),
                    ("very_often", "Very Often"),
                    ("sometimes", "Sometimes"),
                    ("rarely", "Rarely"),
                    ("NEVER", "Never"),
                ],
                max_length=15,
                null=True,
                verbose_name="Do you add salt to your food in addition to what has been added when cooking?",
            ),
        ),
        migrations.AddField(
            model_name="otherbaselinedata",
            name="num_fruits_eaten",
            field=models.IntegerField(
                default=0,
                help_text="Number per day",
                verbose_name="On average, how many vegetables do you eat in a day?",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="otherbaselinedata",
            name="num_leafy_vegs_eaten",
            field=models.IntegerField(
                default=0,
                help_text="Number per day",
                verbose_name="On average, how many green leafy vegetables do you eat in a day?",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="otherbaselinedata",
            name="num_other_vegs_eaten",
            field=models.IntegerField(
                default=0,
                help_text="Other vegetables like carrots, tomatoes, bell papers etc. Number per day",
                verbose_name="On average, how many other vegetables do you eat in a day?",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="otherbaselinedata",
            name="smoker_current_duration",
            field=edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="otherbaselinedata",
            name="smoker_current_duration_estimated_date",
            field=edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
        ),
        migrations.RemoveField(
            model_name="dminitialreview",
            name="managed_by",
        ),
        migrations.AlterField(
            model_name="historicalotherbaselinedata",
            name="education",
            field=models.CharField(
                choices=[
                    ("no_formal_education", "No Formal Education"),
                    ("primary", "Up to primary"),
                    ("secondary", "Up to secondary / high school"),
                    ("post_secondary", "College or similar higher institution"),
                    ("tertiary", "university educated"),
                ],
                max_length=25,
                verbose_name="How much formal education does the patient have?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalotherbaselinedata",
            name="employment_status",
            field=models.CharField(
                choices=[
                    ("professional", "Professional / office work / business"),
                    ("manual_work", "Skilled / Unskilled manual work"),
                    ("housewife", "Housewife"),
                    ("unemployed", "Not working / seeking work"),
                    ("unemployed_not_seeking", "Not working / NOT seeking work"),
                    ("retired", "Retired"),
                    ("OTHER", "Other, please specify"),
                ],
                max_length=25,
                verbose_name="What is the patient's employment status?",
            ),
        ),
        migrations.AlterField(
            model_name="otherbaselinedata",
            name="education",
            field=models.CharField(
                choices=[
                    ("no_formal_education", "No Formal Education"),
                    ("primary", "Up to primary"),
                    ("secondary", "Up to secondary / high school"),
                    ("post_secondary", "College or similar higher institution"),
                    ("tertiary", "university educated"),
                ],
                max_length=25,
                verbose_name="How much formal education does the patient have?",
            ),
        ),
        migrations.AlterField(
            model_name="otherbaselinedata",
            name="employment_status",
            field=models.CharField(
                choices=[
                    ("professional", "Professional / office work / business"),
                    ("manual_work", "Skilled / Unskilled manual work"),
                    ("housewife", "Housewife"),
                    ("unemployed", "Not working / seeking work"),
                    ("unemployed_not_seeking", "Not working / NOT seeking work"),
                    ("retired", "Retired"),
                    ("OTHER", "Other, please specify"),
                ],
                max_length=25,
                verbose_name="What is the patient's employment status?",
            ),
        ),
        migrations.CreateModel(
            name="SocialHarms",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "partner",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        max_length=25,
                        verbose_name="Does your PARTNER know about your participation in the study?",
                    ),
                ),
                (
                    "partner_disclosure",
                    models.CharField(
                        choices=[
                            ("voluntary", "Voluntary disclosure"),
                            ("involuntary", "Involuntary disclosure"),
                            ("by_others", "Others told them without permission"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        help_text="(e.g., they saw study material, or I had to disclose DM/HTN/HIV",
                        max_length=25,
                        verbose_name="If Yes, how did they find out?",
                    ),
                ),
                (
                    "family",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        max_length=25,
                        verbose_name="Does your FAMILY know about your participation in the study?",
                    ),
                ),
                (
                    "family_disclosure",
                    models.CharField(
                        choices=[
                            ("voluntary", "Voluntary disclosure"),
                            ("involuntary", "Involuntary disclosure"),
                            ("by_others", "Others told them without permission"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        help_text="(e.g., they saw study material, or I had to disclose DM/HTN/HIV",
                        max_length=25,
                        verbose_name="If Yes, how did they find out?",
                    ),
                ),
                (
                    "friends",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=25,
                        verbose_name="Do any of your FRIENDS know about your participation in the study?",
                    ),
                ),
                (
                    "friends_disclosure",
                    models.CharField(
                        choices=[
                            ("voluntary", "Voluntary disclosure"),
                            ("involuntary", "Involuntary disclosure"),
                            ("by_others", "Others told them without permission"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        help_text="(e.g., they saw study material, or I had to disclose DM/HTN/HIV",
                        max_length=25,
                        verbose_name="If Yes, how did they find out?",
                    ),
                ),
                (
                    "coworkers",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        max_length=25,
                        verbose_name="Do any of your CO-WORKERS know about your participation in the study?",
                    ),
                ),
                (
                    "coworkers_disclosure",
                    models.CharField(
                        choices=[
                            ("voluntary", "Voluntary disclosure"),
                            ("involuntary", "Involuntary disclosure"),
                            ("by_others", "Others told them without permission"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        help_text="(e.g., they saw study material, or I had to disclose DM/HTN/HIV",
                        max_length=25,
                        verbose_name="If Yes, how did they find out?",
                    ),
                ),
                (
                    "partner_impact",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        max_length=25,
                        verbose_name="... with your partner?",
                    ),
                ),
                (
                    "partner_impact_severity",
                    models.CharField(
                        choices=[
                            ("minor", "Minor"),
                            ("moderate", "Moderate"),
                            ("major", "Major"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Severity of impact",
                    ),
                ),
                (
                    "partner_impact_status",
                    models.CharField(
                        choices=[
                            ("resolved", "Resolved"),
                            ("ongoing", "Ongoing"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Status of impact",
                    ),
                ),
                (
                    "partner_impact_help",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=25,
                        verbose_name="Would you like help",
                    ),
                ),
                (
                    "partner_impact_referal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=25,
                        verbose_name="Has the participant been referred for further help",
                    ),
                ),
                (
                    "family_impact",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        max_length=25,
                        verbose_name="... with your family?",
                    ),
                ),
                (
                    "family_impact_severity",
                    models.CharField(
                        choices=[
                            ("minor", "Minor"),
                            ("moderate", "Moderate"),
                            ("major", "Major"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Severity of impact",
                    ),
                ),
                (
                    "family_impact_status",
                    models.CharField(
                        choices=[
                            ("resolved", "Resolved"),
                            ("ongoing", "Ongoing"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Status of impact",
                    ),
                ),
                (
                    "family_impact_help",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=25,
                        verbose_name="Would you like help",
                    ),
                ),
                (
                    "family_impact_referal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=25,
                        verbose_name="Has the participant been referred for further help",
                    ),
                ),
                (
                    "friends_impact",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        max_length=25,
                        verbose_name="... with your friends?",
                    ),
                ),
                (
                    "friends_impact_severity",
                    models.CharField(
                        choices=[
                            ("minor", "Minor"),
                            ("moderate", "Moderate"),
                            ("major", "Major"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Severity of impact",
                    ),
                ),
                (
                    "friends_impact_status",
                    models.CharField(
                        choices=[
                            ("resolved", "Resolved"),
                            ("ongoing", "Ongoing"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Status of impact",
                    ),
                ),
                (
                    "friends_impact_help",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=25,
                        verbose_name="Would you like help",
                    ),
                ),
                (
                    "friends_impact_referal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=25,
                        verbose_name="Has the participant been referred for further help",
                    ),
                ),
                (
                    "coworkers_impact",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        max_length=25,
                        verbose_name="... with your co-workers?",
                    ),
                ),
                (
                    "coworkers_impact_severity",
                    models.CharField(
                        choices=[
                            ("minor", "Minor"),
                            ("moderate", "Moderate"),
                            ("major", "Major"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Severity of impact",
                    ),
                ),
                (
                    "coworkers_impact_status",
                    models.CharField(
                        choices=[
                            ("resolved", "Resolved"),
                            ("ongoing", "Ongoing"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Status of impact",
                    ),
                ),
                (
                    "coworkers_impact_help",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=25,
                        verbose_name="Would you like help",
                    ),
                ),
                (
                    "coworkers_impact_referal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=25,
                        verbose_name="Has the participant been referred for further help",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Social Harms",
                "verbose_name_plural": "Social Harms",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="HistoricalSocialHarms",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "partner",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        max_length=25,
                        verbose_name="Does your PARTNER know about your participation in the study?",
                    ),
                ),
                (
                    "partner_disclosure",
                    models.CharField(
                        choices=[
                            ("voluntary", "Voluntary disclosure"),
                            ("involuntary", "Involuntary disclosure"),
                            ("by_others", "Others told them without permission"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        help_text="(e.g., they saw study material, or I had to disclose DM/HTN/HIV",
                        max_length=25,
                        verbose_name="If Yes, how did they find out?",
                    ),
                ),
                (
                    "family",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        max_length=25,
                        verbose_name="Does your FAMILY know about your participation in the study?",
                    ),
                ),
                (
                    "family_disclosure",
                    models.CharField(
                        choices=[
                            ("voluntary", "Voluntary disclosure"),
                            ("involuntary", "Involuntary disclosure"),
                            ("by_others", "Others told them without permission"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        help_text="(e.g., they saw study material, or I had to disclose DM/HTN/HIV",
                        max_length=25,
                        verbose_name="If Yes, how did they find out?",
                    ),
                ),
                (
                    "friends",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=25,
                        verbose_name="Do any of your FRIENDS know about your participation in the study?",
                    ),
                ),
                (
                    "friends_disclosure",
                    models.CharField(
                        choices=[
                            ("voluntary", "Voluntary disclosure"),
                            ("involuntary", "Involuntary disclosure"),
                            ("by_others", "Others told them without permission"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        help_text="(e.g., they saw study material, or I had to disclose DM/HTN/HIV",
                        max_length=25,
                        verbose_name="If Yes, how did they find out?",
                    ),
                ),
                (
                    "coworkers",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        max_length=25,
                        verbose_name="Do any of your CO-WORKERS know about your participation in the study?",
                    ),
                ),
                (
                    "coworkers_disclosure",
                    models.CharField(
                        choices=[
                            ("voluntary", "Voluntary disclosure"),
                            ("involuntary", "Involuntary disclosure"),
                            ("by_others", "Others told them without permission"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        help_text="(e.g., they saw study material, or I had to disclose DM/HTN/HIV",
                        max_length=25,
                        verbose_name="If Yes, how did they find out?",
                    ),
                ),
                (
                    "partner_impact",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        max_length=25,
                        verbose_name="... with your partner?",
                    ),
                ),
                (
                    "partner_impact_severity",
                    models.CharField(
                        choices=[
                            ("minor", "Minor"),
                            ("moderate", "Moderate"),
                            ("major", "Major"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Severity of impact",
                    ),
                ),
                (
                    "partner_impact_status",
                    models.CharField(
                        choices=[
                            ("resolved", "Resolved"),
                            ("ongoing", "Ongoing"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Status of impact",
                    ),
                ),
                (
                    "partner_impact_help",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=25,
                        verbose_name="Would you like help",
                    ),
                ),
                (
                    "partner_impact_referal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=25,
                        verbose_name="Has the participant been referred for further help",
                    ),
                ),
                (
                    "family_impact",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        max_length=25,
                        verbose_name="... with your family?",
                    ),
                ),
                (
                    "family_impact_severity",
                    models.CharField(
                        choices=[
                            ("minor", "Minor"),
                            ("moderate", "Moderate"),
                            ("major", "Major"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Severity of impact",
                    ),
                ),
                (
                    "family_impact_status",
                    models.CharField(
                        choices=[
                            ("resolved", "Resolved"),
                            ("ongoing", "Ongoing"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Status of impact",
                    ),
                ),
                (
                    "family_impact_help",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=25,
                        verbose_name="Would you like help",
                    ),
                ),
                (
                    "family_impact_referal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=25,
                        verbose_name="Has the participant been referred for further help",
                    ),
                ),
                (
                    "friends_impact",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        max_length=25,
                        verbose_name="... with your friends?",
                    ),
                ),
                (
                    "friends_impact_severity",
                    models.CharField(
                        choices=[
                            ("minor", "Minor"),
                            ("moderate", "Moderate"),
                            ("major", "Major"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Severity of impact",
                    ),
                ),
                (
                    "friends_impact_status",
                    models.CharField(
                        choices=[
                            ("resolved", "Resolved"),
                            ("ongoing", "Ongoing"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Status of impact",
                    ),
                ),
                (
                    "friends_impact_help",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=25,
                        verbose_name="Would you like help",
                    ),
                ),
                (
                    "friends_impact_referal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=25,
                        verbose_name="Has the participant been referred for further help",
                    ),
                ),
                (
                    "coworkers_impact",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        max_length=25,
                        verbose_name="... with your co-workers?",
                    ),
                ),
                (
                    "coworkers_impact_severity",
                    models.CharField(
                        choices=[
                            ("minor", "Minor"),
                            ("moderate", "Moderate"),
                            ("major", "Major"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Severity of impact",
                    ),
                ),
                (
                    "coworkers_impact_status",
                    models.CharField(
                        choices=[
                            ("resolved", "Resolved"),
                            ("ongoing", "Ongoing"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Status of impact",
                    ),
                ),
                (
                    "coworkers_impact_help",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=25,
                        verbose_name="Would you like help",
                    ),
                ),
                (
                    "coworkers_impact_referal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=25,
                        verbose_name="Has the participant been referred for further help",
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="intecomm_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Social Harms",
                "verbose_name_plural": "historical Social Harms",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.AddField(
            model_name="dminitialreview",
            name="managed_by",
            field=models.ManyToManyField(
                to="intecomm_lists.dmmanagement",
                verbose_name="How is the patient's diabetes managed?",
            ),
        ),
        migrations.AddIndex(
            model_name="socialharms",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="intecomm_su_subject_99ad70_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="socialharms",
            index=models.Index(
                fields=["subject_visit", "report_datetime"],
                name="intecomm_su_subject_7a815b_idx",
            ),
        ),
    ]
