import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ValidatingWebhookConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#id ValidatingWebhookConfiguration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#metadata ValidatingWebhookConfiguration#metadata}
    */
    readonly metadata: ValidatingWebhookConfigurationMetadata;
    /**
    * webhook block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#webhook ValidatingWebhookConfiguration#webhook}
    */
    readonly webhook: ValidatingWebhookConfigurationWebhook[] | cdktf.IResolvable;
}
export interface ValidatingWebhookConfigurationMetadata {
    /**
    * An unstructured key value map stored with the validating webhook configuration that may be used to store arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#annotations ValidatingWebhookConfiguration#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Prefix, used by the server, to generate a unique name ONLY IF the `name` field has not been provided. This value will also be combined with a unique suffix. Read more: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#idempotency
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#generate_name ValidatingWebhookConfiguration#generate_name}
    */
    readonly generateName?: string;
    /**
    * Map of string keys and values that can be used to organize and categorize (scope and select) the validating webhook configuration. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#labels ValidatingWebhookConfiguration#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the validating webhook configuration, must be unique. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#name ValidatingWebhookConfiguration#name}
    */
    readonly name?: string;
}
export declare function validatingWebhookConfigurationMetadataToTerraform(struct?: ValidatingWebhookConfigurationMetadataOutputReference | ValidatingWebhookConfigurationMetadata): any;
export declare class ValidatingWebhookConfigurationMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ValidatingWebhookConfigurationMetadata | undefined;
    set internalValue(value: ValidatingWebhookConfigurationMetadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _generateName?;
    get generateName(): string;
    set generateName(value: string);
    resetGenerateName(): void;
    get generateNameInput(): string | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get resourceVersion(): string;
    get uid(): string;
}
export interface ValidatingWebhookConfigurationWebhookClientConfigService {
    /**
    * `name` is the name of the service. Required
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#name ValidatingWebhookConfiguration#name}
    */
    readonly name: string;
    /**
    * `namespace` is the namespace of the service. Required
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#namespace ValidatingWebhookConfiguration#namespace}
    */
    readonly namespace: string;
    /**
    * `path` is an optional URL path which will be sent in any request to this service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#path ValidatingWebhookConfiguration#path}
    */
    readonly path?: string;
    /**
    * If specified, the port on the service that hosting webhook. Default to 443 for backward compatibility. `port` should be a valid port number (1-65535, inclusive).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#port ValidatingWebhookConfiguration#port}
    */
    readonly port?: number;
}
export declare function validatingWebhookConfigurationWebhookClientConfigServiceToTerraform(struct?: ValidatingWebhookConfigurationWebhookClientConfigServiceOutputReference | ValidatingWebhookConfigurationWebhookClientConfigService): any;
export declare class ValidatingWebhookConfigurationWebhookClientConfigServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ValidatingWebhookConfigurationWebhookClientConfigService | undefined;
    set internalValue(value: ValidatingWebhookConfigurationWebhookClientConfigService | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    get namespaceInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
}
export interface ValidatingWebhookConfigurationWebhookClientConfig {
    /**
    * `caBundle` is a PEM encoded CA bundle which will be used to validate the webhook's server certificate. If unspecified, system trust roots on the apiserver are used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#ca_bundle ValidatingWebhookConfiguration#ca_bundle}
    */
    readonly caBundle?: string;
    /**
    * `url` gives the location of the webhook, in standard URL form (`scheme://host:port/path`). Exactly one of `url` or `service` must be specified.
  
  The `host` should not refer to a service running in the cluster; use the `service` field instead. The host might be resolved via external DNS in some apiservers (e.g., `kube-apiserver` cannot resolve in-cluster DNS as that would be a layering violation). `host` may also be an IP address.
  
  Please note that using `localhost` or `127.0.0.1` as a `host` is risky unless you take great care to run this webhook on all hosts which run an apiserver which might need to make calls to this webhook. Such installs are likely to be non-portable, i.e., not easy to turn up in a new cluster.
  
  The scheme must be "https"; the URL must begin with "https://".
  
  A path is optional, and if present may be any string permissible in a URL. You may use the path to pass an arbitrary string to the webhook, for example, a cluster identifier.
  
  Attempting to use a user or basic auth e.g. "user:password@" is not allowed. Fragments ("#...") and query parameters ("?...") are not allowed, either.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#url ValidatingWebhookConfiguration#url}
    */
    readonly url?: string;
    /**
    * service block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#service ValidatingWebhookConfiguration#service}
    */
    readonly service?: ValidatingWebhookConfigurationWebhookClientConfigService;
}
export declare function validatingWebhookConfigurationWebhookClientConfigToTerraform(struct?: ValidatingWebhookConfigurationWebhookClientConfigOutputReference | ValidatingWebhookConfigurationWebhookClientConfig): any;
export declare class ValidatingWebhookConfigurationWebhookClientConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ValidatingWebhookConfigurationWebhookClientConfig | undefined;
    set internalValue(value: ValidatingWebhookConfigurationWebhookClientConfig | undefined);
    private _caBundle?;
    get caBundle(): string;
    set caBundle(value: string);
    resetCaBundle(): void;
    get caBundleInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    resetUrl(): void;
    get urlInput(): string | undefined;
    private _service;
    get service(): ValidatingWebhookConfigurationWebhookClientConfigServiceOutputReference;
    putService(value: ValidatingWebhookConfigurationWebhookClientConfigService): void;
    resetService(): void;
    get serviceInput(): ValidatingWebhookConfigurationWebhookClientConfigService | undefined;
}
export interface ValidatingWebhookConfigurationWebhookNamespaceSelectorMatchExpressions {
    /**
    * The label key that the selector applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#key ValidatingWebhookConfiguration#key}
    */
    readonly key?: string;
    /**
    * A key's relationship to a set of values. Valid operators ard `In`, `NotIn`, `Exists` and `DoesNotExist`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#operator ValidatingWebhookConfiguration#operator}
    */
    readonly operator?: string;
    /**
    * An array of string values. If the operator is `In` or `NotIn`, the values array must be non-empty. If the operator is `Exists` or `DoesNotExist`, the values array must be empty. This array is replaced during a strategic merge patch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#values ValidatingWebhookConfiguration#values}
    */
    readonly values?: string[];
}
export declare function validatingWebhookConfigurationWebhookNamespaceSelectorMatchExpressionsToTerraform(struct?: ValidatingWebhookConfigurationWebhookNamespaceSelectorMatchExpressions | cdktf.IResolvable): any;
export declare class ValidatingWebhookConfigurationWebhookNamespaceSelectorMatchExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ValidatingWebhookConfigurationWebhookNamespaceSelectorMatchExpressions | cdktf.IResolvable | undefined;
    set internalValue(value: ValidatingWebhookConfigurationWebhookNamespaceSelectorMatchExpressions | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class ValidatingWebhookConfigurationWebhookNamespaceSelectorMatchExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ValidatingWebhookConfigurationWebhookNamespaceSelectorMatchExpressions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ValidatingWebhookConfigurationWebhookNamespaceSelectorMatchExpressionsOutputReference;
}
export interface ValidatingWebhookConfigurationWebhookNamespaceSelector {
    /**
    * A map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of `match_expressions`, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#match_labels ValidatingWebhookConfiguration#match_labels}
    */
    readonly matchLabels?: {
        [key: string]: string;
    };
    /**
    * match_expressions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#match_expressions ValidatingWebhookConfiguration#match_expressions}
    */
    readonly matchExpressions?: ValidatingWebhookConfigurationWebhookNamespaceSelectorMatchExpressions[] | cdktf.IResolvable;
}
export declare function validatingWebhookConfigurationWebhookNamespaceSelectorToTerraform(struct?: ValidatingWebhookConfigurationWebhookNamespaceSelectorOutputReference | ValidatingWebhookConfigurationWebhookNamespaceSelector): any;
export declare class ValidatingWebhookConfigurationWebhookNamespaceSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ValidatingWebhookConfigurationWebhookNamespaceSelector | undefined;
    set internalValue(value: ValidatingWebhookConfigurationWebhookNamespaceSelector | undefined);
    private _matchLabels?;
    get matchLabels(): {
        [key: string]: string;
    };
    set matchLabels(value: {
        [key: string]: string;
    });
    resetMatchLabels(): void;
    get matchLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _matchExpressions;
    get matchExpressions(): ValidatingWebhookConfigurationWebhookNamespaceSelectorMatchExpressionsList;
    putMatchExpressions(value: ValidatingWebhookConfigurationWebhookNamespaceSelectorMatchExpressions[] | cdktf.IResolvable): void;
    resetMatchExpressions(): void;
    get matchExpressionsInput(): cdktf.IResolvable | ValidatingWebhookConfigurationWebhookNamespaceSelectorMatchExpressions[] | undefined;
}
export interface ValidatingWebhookConfigurationWebhookObjectSelectorMatchExpressions {
    /**
    * The label key that the selector applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#key ValidatingWebhookConfiguration#key}
    */
    readonly key?: string;
    /**
    * A key's relationship to a set of values. Valid operators ard `In`, `NotIn`, `Exists` and `DoesNotExist`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#operator ValidatingWebhookConfiguration#operator}
    */
    readonly operator?: string;
    /**
    * An array of string values. If the operator is `In` or `NotIn`, the values array must be non-empty. If the operator is `Exists` or `DoesNotExist`, the values array must be empty. This array is replaced during a strategic merge patch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#values ValidatingWebhookConfiguration#values}
    */
    readonly values?: string[];
}
export declare function validatingWebhookConfigurationWebhookObjectSelectorMatchExpressionsToTerraform(struct?: ValidatingWebhookConfigurationWebhookObjectSelectorMatchExpressions | cdktf.IResolvable): any;
export declare class ValidatingWebhookConfigurationWebhookObjectSelectorMatchExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ValidatingWebhookConfigurationWebhookObjectSelectorMatchExpressions | cdktf.IResolvable | undefined;
    set internalValue(value: ValidatingWebhookConfigurationWebhookObjectSelectorMatchExpressions | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class ValidatingWebhookConfigurationWebhookObjectSelectorMatchExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ValidatingWebhookConfigurationWebhookObjectSelectorMatchExpressions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ValidatingWebhookConfigurationWebhookObjectSelectorMatchExpressionsOutputReference;
}
export interface ValidatingWebhookConfigurationWebhookObjectSelector {
    /**
    * A map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of `match_expressions`, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#match_labels ValidatingWebhookConfiguration#match_labels}
    */
    readonly matchLabels?: {
        [key: string]: string;
    };
    /**
    * match_expressions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#match_expressions ValidatingWebhookConfiguration#match_expressions}
    */
    readonly matchExpressions?: ValidatingWebhookConfigurationWebhookObjectSelectorMatchExpressions[] | cdktf.IResolvable;
}
export declare function validatingWebhookConfigurationWebhookObjectSelectorToTerraform(struct?: ValidatingWebhookConfigurationWebhookObjectSelectorOutputReference | ValidatingWebhookConfigurationWebhookObjectSelector): any;
export declare class ValidatingWebhookConfigurationWebhookObjectSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ValidatingWebhookConfigurationWebhookObjectSelector | undefined;
    set internalValue(value: ValidatingWebhookConfigurationWebhookObjectSelector | undefined);
    private _matchLabels?;
    get matchLabels(): {
        [key: string]: string;
    };
    set matchLabels(value: {
        [key: string]: string;
    });
    resetMatchLabels(): void;
    get matchLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _matchExpressions;
    get matchExpressions(): ValidatingWebhookConfigurationWebhookObjectSelectorMatchExpressionsList;
    putMatchExpressions(value: ValidatingWebhookConfigurationWebhookObjectSelectorMatchExpressions[] | cdktf.IResolvable): void;
    resetMatchExpressions(): void;
    get matchExpressionsInput(): cdktf.IResolvable | ValidatingWebhookConfigurationWebhookObjectSelectorMatchExpressions[] | undefined;
}
export interface ValidatingWebhookConfigurationWebhookRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#api_groups ValidatingWebhookConfiguration#api_groups}
    */
    readonly apiGroups: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#api_versions ValidatingWebhookConfiguration#api_versions}
    */
    readonly apiVersions: string[];
    /**
    * Operations is the operations the admission hook cares about - CREATE, UPDATE, DELETE, CONNECT or * for all of those operations and any future admission operations that are added. If '*' is present, the length of the slice must be one. Required.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#operations ValidatingWebhookConfiguration#operations}
    */
    readonly operations: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#resources ValidatingWebhookConfiguration#resources}
    */
    readonly resources: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#scope ValidatingWebhookConfiguration#scope}
    */
    readonly scope?: string;
}
export declare function validatingWebhookConfigurationWebhookRuleToTerraform(struct?: ValidatingWebhookConfigurationWebhookRule | cdktf.IResolvable): any;
export declare class ValidatingWebhookConfigurationWebhookRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ValidatingWebhookConfigurationWebhookRule | cdktf.IResolvable | undefined;
    set internalValue(value: ValidatingWebhookConfigurationWebhookRule | cdktf.IResolvable | undefined);
    private _apiGroups?;
    get apiGroups(): string[];
    set apiGroups(value: string[]);
    get apiGroupsInput(): string[] | undefined;
    private _apiVersions?;
    get apiVersions(): string[];
    set apiVersions(value: string[]);
    get apiVersionsInput(): string[] | undefined;
    private _operations?;
    get operations(): string[];
    set operations(value: string[]);
    get operationsInput(): string[] | undefined;
    private _resources?;
    get resources(): string[];
    set resources(value: string[]);
    get resourcesInput(): string[] | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    resetScope(): void;
    get scopeInput(): string | undefined;
}
export declare class ValidatingWebhookConfigurationWebhookRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ValidatingWebhookConfigurationWebhookRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ValidatingWebhookConfigurationWebhookRuleOutputReference;
}
export interface ValidatingWebhookConfigurationWebhook {
    /**
    * AdmissionReviewVersions is an ordered list of preferred `AdmissionReview` versions the Webhook expects. API server will try to use first version in the list which it supports. If none of the versions specified in this list supported by API server, validation will fail for this object. If a persisted webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail and be subject to the failure policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#admission_review_versions ValidatingWebhookConfiguration#admission_review_versions}
    */
    readonly admissionReviewVersions?: string[];
    /**
    * FailurePolicy defines how unrecognized errors from the admission endpoint are handled - allowed values are Ignore or Fail. Defaults to Fail.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#failure_policy ValidatingWebhookConfiguration#failure_policy}
    */
    readonly failurePolicy?: string;
    /**
    * matchPolicy defines how the "rules" list is used to match incoming requests. Allowed values are "Exact" or "Equivalent".
  
  - Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would not be sent to the webhook.
  
  - Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would be converted to apps/v1 and sent to the webhook.
  
  Defaults to "Equivalent"
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#match_policy ValidatingWebhookConfiguration#match_policy}
    */
    readonly matchPolicy?: string;
    /**
    * The name of the admission webhook. Name should be fully qualified, e.g., imagepolicy.kubernetes.io, where "imagepolicy" is the name of the webhook, and kubernetes.io is the name of the organization. Required.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#name ValidatingWebhookConfiguration#name}
    */
    readonly name: string;
    /**
    * SideEffects states whether this webhook has side effects. Acceptable values are: None, NoneOnDryRun (webhooks created via v1beta1 may also specify Some or Unknown). Webhooks with side effects MUST implement a reconciliation system, since a request may be rejected by a future step in the admission chain and the side effects therefore need to be undone. Requests with the dryRun attribute will be auto-rejected if they match a webhook with sideEffects == Unknown or Some.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#side_effects ValidatingWebhookConfiguration#side_effects}
    */
    readonly sideEffects?: string;
    /**
    * TimeoutSeconds specifies the timeout for this webhook. After the timeout passes, the webhook call will be ignored or the API call will fail based on the failure policy. The timeout value must be between 1 and 30 seconds. Default to 10 seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#timeout_seconds ValidatingWebhookConfiguration#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * client_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#client_config ValidatingWebhookConfiguration#client_config}
    */
    readonly clientConfig: ValidatingWebhookConfigurationWebhookClientConfig;
    /**
    * namespace_selector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#namespace_selector ValidatingWebhookConfiguration#namespace_selector}
    */
    readonly namespaceSelector?: ValidatingWebhookConfigurationWebhookNamespaceSelector;
    /**
    * object_selector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#object_selector ValidatingWebhookConfiguration#object_selector}
    */
    readonly objectSelector?: ValidatingWebhookConfigurationWebhookObjectSelector;
    /**
    * rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration#rule ValidatingWebhookConfiguration#rule}
    */
    readonly rule?: ValidatingWebhookConfigurationWebhookRule[] | cdktf.IResolvable;
}
export declare function validatingWebhookConfigurationWebhookToTerraform(struct?: ValidatingWebhookConfigurationWebhook | cdktf.IResolvable): any;
export declare class ValidatingWebhookConfigurationWebhookOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ValidatingWebhookConfigurationWebhook | cdktf.IResolvable | undefined;
    set internalValue(value: ValidatingWebhookConfigurationWebhook | cdktf.IResolvable | undefined);
    private _admissionReviewVersions?;
    get admissionReviewVersions(): string[];
    set admissionReviewVersions(value: string[]);
    resetAdmissionReviewVersions(): void;
    get admissionReviewVersionsInput(): string[] | undefined;
    private _failurePolicy?;
    get failurePolicy(): string;
    set failurePolicy(value: string);
    resetFailurePolicy(): void;
    get failurePolicyInput(): string | undefined;
    private _matchPolicy?;
    get matchPolicy(): string;
    set matchPolicy(value: string);
    resetMatchPolicy(): void;
    get matchPolicyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _sideEffects?;
    get sideEffects(): string;
    set sideEffects(value: string);
    resetSideEffects(): void;
    get sideEffectsInput(): string | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _clientConfig;
    get clientConfig(): ValidatingWebhookConfigurationWebhookClientConfigOutputReference;
    putClientConfig(value: ValidatingWebhookConfigurationWebhookClientConfig): void;
    get clientConfigInput(): ValidatingWebhookConfigurationWebhookClientConfig | undefined;
    private _namespaceSelector;
    get namespaceSelector(): ValidatingWebhookConfigurationWebhookNamespaceSelectorOutputReference;
    putNamespaceSelector(value: ValidatingWebhookConfigurationWebhookNamespaceSelector): void;
    resetNamespaceSelector(): void;
    get namespaceSelectorInput(): ValidatingWebhookConfigurationWebhookNamespaceSelector | undefined;
    private _objectSelector;
    get objectSelector(): ValidatingWebhookConfigurationWebhookObjectSelectorOutputReference;
    putObjectSelector(value: ValidatingWebhookConfigurationWebhookObjectSelector): void;
    resetObjectSelector(): void;
    get objectSelectorInput(): ValidatingWebhookConfigurationWebhookObjectSelector | undefined;
    private _rule;
    get rule(): ValidatingWebhookConfigurationWebhookRuleList;
    putRule(value: ValidatingWebhookConfigurationWebhookRule[] | cdktf.IResolvable): void;
    resetRule(): void;
    get ruleInput(): cdktf.IResolvable | ValidatingWebhookConfigurationWebhookRule[] | undefined;
}
export declare class ValidatingWebhookConfigurationWebhookList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ValidatingWebhookConfigurationWebhook[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ValidatingWebhookConfigurationWebhookOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration kubernetes_validating_webhook_configuration}
*/
export declare class ValidatingWebhookConfiguration extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_validating_webhook_configuration";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/validating_webhook_configuration kubernetes_validating_webhook_configuration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ValidatingWebhookConfigurationConfig
    */
    constructor(scope: Construct, id: string, config: ValidatingWebhookConfigurationConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata;
    get metadata(): ValidatingWebhookConfigurationMetadataOutputReference;
    putMetadata(value: ValidatingWebhookConfigurationMetadata): void;
    get metadataInput(): ValidatingWebhookConfigurationMetadata | undefined;
    private _webhook;
    get webhook(): ValidatingWebhookConfigurationWebhookList;
    putWebhook(value: ValidatingWebhookConfigurationWebhook[] | cdktf.IResolvable): void;
    get webhookInput(): cdktf.IResolvable | ValidatingWebhookConfigurationWebhook[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
