"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubernetesProvider = exports.kubernetesProviderExperimentsToTerraform = exports.kubernetesProviderExecToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function kubernetesProviderExecToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        api_version: cdktf.stringToTerraform(struct.apiVersion),
        args: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.args),
        command: cdktf.stringToTerraform(struct.command),
        env: cdktf.hashMapper(cdktf.stringToTerraform)(struct.env),
    };
}
exports.kubernetesProviderExecToTerraform = kubernetesProviderExecToTerraform;
function kubernetesProviderExperimentsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        manifest_resource: cdktf.booleanToTerraform(struct.manifestResource),
    };
}
exports.kubernetesProviderExperimentsToTerraform = kubernetesProviderExperimentsToTerraform;
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes kubernetes}
*/
class KubernetesProvider extends cdktf.TerraformProvider {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes kubernetes} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KubernetesProviderConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'kubernetes',
            terraformGeneratorMetadata: {
                providerName: 'kubernetes',
                providerVersion: '2.12.1',
                providerVersionConstraint: '~> 2.0'
            },
            terraformProviderSource: 'kubernetes'
        });
        this._clientCertificate = config.clientCertificate;
        this._clientKey = config.clientKey;
        this._clusterCaCertificate = config.clusterCaCertificate;
        this._configContext = config.configContext;
        this._configContextAuthInfo = config.configContextAuthInfo;
        this._configContextCluster = config.configContextCluster;
        this._configPath = config.configPath;
        this._configPaths = config.configPaths;
        this._host = config.host;
        this._ignoreAnnotations = config.ignoreAnnotations;
        this._ignoreLabels = config.ignoreLabels;
        this._insecure = config.insecure;
        this._password = config.password;
        this._proxyUrl = config.proxyUrl;
        this._token = config.token;
        this._username = config.username;
        this._alias = config.alias;
        this._exec = config.exec;
        this._experiments = config.experiments;
    }
    get clientCertificate() {
        return this._clientCertificate;
    }
    set clientCertificate(value) {
        this._clientCertificate = value;
    }
    resetClientCertificate() {
        this._clientCertificate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientCertificateInput() {
        return this._clientCertificate;
    }
    get clientKey() {
        return this._clientKey;
    }
    set clientKey(value) {
        this._clientKey = value;
    }
    resetClientKey() {
        this._clientKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientKeyInput() {
        return this._clientKey;
    }
    get clusterCaCertificate() {
        return this._clusterCaCertificate;
    }
    set clusterCaCertificate(value) {
        this._clusterCaCertificate = value;
    }
    resetClusterCaCertificate() {
        this._clusterCaCertificate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clusterCaCertificateInput() {
        return this._clusterCaCertificate;
    }
    get configContext() {
        return this._configContext;
    }
    set configContext(value) {
        this._configContext = value;
    }
    resetConfigContext() {
        this._configContext = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get configContextInput() {
        return this._configContext;
    }
    get configContextAuthInfo() {
        return this._configContextAuthInfo;
    }
    set configContextAuthInfo(value) {
        this._configContextAuthInfo = value;
    }
    resetConfigContextAuthInfo() {
        this._configContextAuthInfo = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get configContextAuthInfoInput() {
        return this._configContextAuthInfo;
    }
    get configContextCluster() {
        return this._configContextCluster;
    }
    set configContextCluster(value) {
        this._configContextCluster = value;
    }
    resetConfigContextCluster() {
        this._configContextCluster = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get configContextClusterInput() {
        return this._configContextCluster;
    }
    get configPath() {
        return this._configPath;
    }
    set configPath(value) {
        this._configPath = value;
    }
    resetConfigPath() {
        this._configPath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get configPathInput() {
        return this._configPath;
    }
    get configPaths() {
        return this._configPaths;
    }
    set configPaths(value) {
        this._configPaths = value;
    }
    resetConfigPaths() {
        this._configPaths = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get configPathsInput() {
        return this._configPaths;
    }
    get host() {
        return this._host;
    }
    set host(value) {
        this._host = value;
    }
    resetHost() {
        this._host = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hostInput() {
        return this._host;
    }
    get ignoreAnnotations() {
        return this._ignoreAnnotations;
    }
    set ignoreAnnotations(value) {
        this._ignoreAnnotations = value;
    }
    resetIgnoreAnnotations() {
        this._ignoreAnnotations = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ignoreAnnotationsInput() {
        return this._ignoreAnnotations;
    }
    get ignoreLabels() {
        return this._ignoreLabels;
    }
    set ignoreLabels(value) {
        this._ignoreLabels = value;
    }
    resetIgnoreLabels() {
        this._ignoreLabels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ignoreLabelsInput() {
        return this._ignoreLabels;
    }
    get insecure() {
        return this._insecure;
    }
    set insecure(value) {
        this._insecure = value;
    }
    resetInsecure() {
        this._insecure = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get insecureInput() {
        return this._insecure;
    }
    get password() {
        return this._password;
    }
    set password(value) {
        this._password = value;
    }
    resetPassword() {
        this._password = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordInput() {
        return this._password;
    }
    get proxyUrl() {
        return this._proxyUrl;
    }
    set proxyUrl(value) {
        this._proxyUrl = value;
    }
    resetProxyUrl() {
        this._proxyUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get proxyUrlInput() {
        return this._proxyUrl;
    }
    get token() {
        return this._token;
    }
    set token(value) {
        this._token = value;
    }
    resetToken() {
        this._token = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenInput() {
        return this._token;
    }
    get username() {
        return this._username;
    }
    set username(value) {
        this._username = value;
    }
    resetUsername() {
        this._username = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get usernameInput() {
        return this._username;
    }
    get alias() {
        return this._alias;
    }
    set alias(value) {
        this._alias = value;
    }
    resetAlias() {
        this._alias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aliasInput() {
        return this._alias;
    }
    get exec() {
        return this._exec;
    }
    set exec(value) {
        this._exec = value;
    }
    resetExec() {
        this._exec = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get execInput() {
        return this._exec;
    }
    get experiments() {
        return this._experiments;
    }
    set experiments(value) {
        this._experiments = value;
    }
    resetExperiments() {
        this._experiments = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get experimentsInput() {
        return this._experiments;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            client_certificate: cdktf.stringToTerraform(this._clientCertificate),
            client_key: cdktf.stringToTerraform(this._clientKey),
            cluster_ca_certificate: cdktf.stringToTerraform(this._clusterCaCertificate),
            config_context: cdktf.stringToTerraform(this._configContext),
            config_context_auth_info: cdktf.stringToTerraform(this._configContextAuthInfo),
            config_context_cluster: cdktf.stringToTerraform(this._configContextCluster),
            config_path: cdktf.stringToTerraform(this._configPath),
            config_paths: cdktf.listMapper(cdktf.stringToTerraform, false)(this._configPaths),
            host: cdktf.stringToTerraform(this._host),
            ignore_annotations: cdktf.listMapper(cdktf.stringToTerraform, false)(this._ignoreAnnotations),
            ignore_labels: cdktf.listMapper(cdktf.stringToTerraform, false)(this._ignoreLabels),
            insecure: cdktf.booleanToTerraform(this._insecure),
            password: cdktf.stringToTerraform(this._password),
            proxy_url: cdktf.stringToTerraform(this._proxyUrl),
            token: cdktf.stringToTerraform(this._token),
            username: cdktf.stringToTerraform(this._username),
            alias: cdktf.stringToTerraform(this._alias),
            exec: kubernetesProviderExecToTerraform(this._exec),
            experiments: kubernetesProviderExperimentsToTerraform(this._experiments),
        };
    }
}
exports.KubernetesProvider = KubernetesProvider;
_a = JSII_RTTI_SYMBOL_1;
KubernetesProvider[_a] = { fqn: "@cdktf/provider-kubernetes.KubernetesProvider", version: "2.0.1" };
// =================
// STATIC PROPERTIES
// =================
KubernetesProvider.tfResourceType = "kubernetes";
//# sourceMappingURL=data:application/json;base64,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