import * as cdktf from 'cdktf';
import { JobSpecTemplateSpecInitContainerEnv, JobSpecTemplateSpecInitContainerEnvList, JobSpecTemplateSpecInitContainerEnvFrom, JobSpecTemplateSpecInitContainerEnvFromList, JobSpecTemplateSpecInitContainerLifecycle, JobSpecTemplateSpecInitContainerLifecycleOutputReference, JobSpecTemplateSpecInitContainerLivenessProbe, JobSpecTemplateSpecInitContainerLivenessProbeOutputReference, JobSpecTemplateSpecInitContainerPort, JobSpecTemplateSpecInitContainerPortList, JobSpecTemplateSpecInitContainerReadinessProbe, JobSpecTemplateSpecInitContainerReadinessProbeOutputReference, JobSpecTemplateSpecInitContainerResources, JobSpecTemplateSpecInitContainerResourcesOutputReference, JobSpecTemplateSpecInitContainerSecurityContext, JobSpecTemplateSpecInitContainerSecurityContextOutputReference, JobSpecTemplateSpecInitContainerStartupProbe, JobSpecTemplateSpecInitContainerStartupProbeOutputReference, JobSpecTemplateSpecAffinity, JobSpecTemplateSpecAffinityOutputReference, JobSpecTemplateSpecContainer, JobSpecTemplateSpecContainerList, JobSpecTemplateSpecDnsConfig, JobSpecTemplateSpecDnsConfigOutputReference, JobSpecTemplateSpecHostAliases, JobSpecTemplateSpecHostAliasesList, JobSpecTemplateSpecImagePullSecrets, JobSpecTemplateSpecImagePullSecretsList, JobSpecTemplateMetadata, JobSpecTemplateMetadataOutputReference, JobSpecSelector, JobSpecSelectorOutputReference } from './structs0';
export interface JobSpecTemplateSpecInitContainerVolumeMount {
    /**
    * Path within the container at which the volume should be mounted. Must not contain ':'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#mount_path Job#mount_path}
    */
    readonly mountPath: string;
    /**
    * Mount propagation mode. mount_propagation determines how mounts are propagated from the host to container and the other way around. Valid values are None (default), HostToContainer and Bidirectional.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#mount_propagation Job#mount_propagation}
    */
    readonly mountPropagation?: string;
    /**
    * This must match the Name of a Volume.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#name Job#name}
    */
    readonly name: string;
    /**
    * Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#read_only Job#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Path within the volume from which the container's volume should be mounted. Defaults to "" (volume's root).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#sub_path Job#sub_path}
    */
    readonly subPath?: string;
}
export declare function jobSpecTemplateSpecInitContainerVolumeMountToTerraform(struct?: JobSpecTemplateSpecInitContainerVolumeMount | cdktf.IResolvable): any;
export declare class JobSpecTemplateSpecInitContainerVolumeMountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobSpecTemplateSpecInitContainerVolumeMount | cdktf.IResolvable | undefined;
    set internalValue(value: JobSpecTemplateSpecInitContainerVolumeMount | cdktf.IResolvable | undefined);
    private _mountPath?;
    get mountPath(): string;
    set mountPath(value: string);
    get mountPathInput(): string | undefined;
    private _mountPropagation?;
    get mountPropagation(): string;
    set mountPropagation(value: string);
    resetMountPropagation(): void;
    get mountPropagationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _subPath?;
    get subPath(): string;
    set subPath(value: string);
    resetSubPath(): void;
    get subPathInput(): string | undefined;
}
export declare class JobSpecTemplateSpecInitContainerVolumeMountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobSpecTemplateSpecInitContainerVolumeMount[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobSpecTemplateSpecInitContainerVolumeMountOutputReference;
}
export interface JobSpecTemplateSpecInitContainer {
    /**
    * Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/containers#containers-and-commands
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#args Job#args}
    */
    readonly args?: string[];
    /**
    * Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/containers#containers-and-commands
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#command Job#command}
    */
    readonly command?: string[];
    /**
    * Docker image name. More info: http://kubernetes.io/docs/user-guide/images
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#image Job#image}
    */
    readonly image?: string;
    /**
    * Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/images#updating-images
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#image_pull_policy Job#image_pull_policy}
    */
    readonly imagePullPolicy?: string;
    /**
    * Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#name Job#name}
    */
    readonly name: string;
    /**
    * Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#stdin Job#stdin}
    */
    readonly stdin?: boolean | cdktf.IResolvable;
    /**
    * Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#stdin_once Job#stdin_once}
    */
    readonly stdinOnce?: boolean | cdktf.IResolvable;
    /**
    * Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Defaults to /dev/termination-log. Cannot be updated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#termination_message_path Job#termination_message_path}
    */
    readonly terminationMessagePath?: string;
    /**
    * Optional: Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#termination_message_policy Job#termination_message_policy}
    */
    readonly terminationMessagePolicy?: string;
    /**
    * Whether this container should allocate a TTY for itself
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#tty Job#tty}
    */
    readonly tty?: boolean | cdktf.IResolvable;
    /**
    * Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#working_dir Job#working_dir}
    */
    readonly workingDir?: string;
    /**
    * env block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#env Job#env}
    */
    readonly env?: JobSpecTemplateSpecInitContainerEnv[] | cdktf.IResolvable;
    /**
    * env_from block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#env_from Job#env_from}
    */
    readonly envFrom?: JobSpecTemplateSpecInitContainerEnvFrom[] | cdktf.IResolvable;
    /**
    * lifecycle block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#lifecycle Job#lifecycle}
    */
    readonly lifecycle?: JobSpecTemplateSpecInitContainerLifecycle;
    /**
    * liveness_probe block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#liveness_probe Job#liveness_probe}
    */
    readonly livenessProbe?: JobSpecTemplateSpecInitContainerLivenessProbe;
    /**
    * port block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#port Job#port}
    */
    readonly port?: JobSpecTemplateSpecInitContainerPort[] | cdktf.IResolvable;
    /**
    * readiness_probe block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#readiness_probe Job#readiness_probe}
    */
    readonly readinessProbe?: JobSpecTemplateSpecInitContainerReadinessProbe;
    /**
    * resources block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#resources Job#resources}
    */
    readonly resources?: JobSpecTemplateSpecInitContainerResources;
    /**
    * security_context block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#security_context Job#security_context}
    */
    readonly securityContext?: JobSpecTemplateSpecInitContainerSecurityContext;
    /**
    * startup_probe block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#startup_probe Job#startup_probe}
    */
    readonly startupProbe?: JobSpecTemplateSpecInitContainerStartupProbe;
    /**
    * volume_mount block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#volume_mount Job#volume_mount}
    */
    readonly volumeMount?: JobSpecTemplateSpecInitContainerVolumeMount[] | cdktf.IResolvable;
}
export declare function jobSpecTemplateSpecInitContainerToTerraform(struct?: JobSpecTemplateSpecInitContainer | cdktf.IResolvable): any;
export declare class JobSpecTemplateSpecInitContainerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobSpecTemplateSpecInitContainer | cdktf.IResolvable | undefined;
    set internalValue(value: JobSpecTemplateSpecInitContainer | cdktf.IResolvable | undefined);
    private _args?;
    get args(): string[];
    set args(value: string[]);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
    private _image?;
    get image(): string;
    set image(value: string);
    resetImage(): void;
    get imageInput(): string | undefined;
    private _imagePullPolicy?;
    get imagePullPolicy(): string;
    set imagePullPolicy(value: string);
    resetImagePullPolicy(): void;
    get imagePullPolicyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _stdin?;
    get stdin(): boolean | cdktf.IResolvable;
    set stdin(value: boolean | cdktf.IResolvable);
    resetStdin(): void;
    get stdinInput(): boolean | cdktf.IResolvable | undefined;
    private _stdinOnce?;
    get stdinOnce(): boolean | cdktf.IResolvable;
    set stdinOnce(value: boolean | cdktf.IResolvable);
    resetStdinOnce(): void;
    get stdinOnceInput(): boolean | cdktf.IResolvable | undefined;
    private _terminationMessagePath?;
    get terminationMessagePath(): string;
    set terminationMessagePath(value: string);
    resetTerminationMessagePath(): void;
    get terminationMessagePathInput(): string | undefined;
    private _terminationMessagePolicy?;
    get terminationMessagePolicy(): string;
    set terminationMessagePolicy(value: string);
    resetTerminationMessagePolicy(): void;
    get terminationMessagePolicyInput(): string | undefined;
    private _tty?;
    get tty(): boolean | cdktf.IResolvable;
    set tty(value: boolean | cdktf.IResolvable);
    resetTty(): void;
    get ttyInput(): boolean | cdktf.IResolvable | undefined;
    private _workingDir?;
    get workingDir(): string;
    set workingDir(value: string);
    resetWorkingDir(): void;
    get workingDirInput(): string | undefined;
    private _env;
    get env(): JobSpecTemplateSpecInitContainerEnvList;
    putEnv(value: JobSpecTemplateSpecInitContainerEnv[] | cdktf.IResolvable): void;
    resetEnv(): void;
    get envInput(): cdktf.IResolvable | JobSpecTemplateSpecInitContainerEnv[] | undefined;
    private _envFrom;
    get envFrom(): JobSpecTemplateSpecInitContainerEnvFromList;
    putEnvFrom(value: JobSpecTemplateSpecInitContainerEnvFrom[] | cdktf.IResolvable): void;
    resetEnvFrom(): void;
    get envFromInput(): cdktf.IResolvable | JobSpecTemplateSpecInitContainerEnvFrom[] | undefined;
    private _lifecycle;
    get lifecycle(): JobSpecTemplateSpecInitContainerLifecycleOutputReference;
    putLifecycle(value: JobSpecTemplateSpecInitContainerLifecycle): void;
    resetLifecycle(): void;
    get lifecycleInput(): JobSpecTemplateSpecInitContainerLifecycle | undefined;
    private _livenessProbe;
    get livenessProbe(): JobSpecTemplateSpecInitContainerLivenessProbeOutputReference;
    putLivenessProbe(value: JobSpecTemplateSpecInitContainerLivenessProbe): void;
    resetLivenessProbe(): void;
    get livenessProbeInput(): JobSpecTemplateSpecInitContainerLivenessProbe | undefined;
    private _port;
    get port(): JobSpecTemplateSpecInitContainerPortList;
    putPort(value: JobSpecTemplateSpecInitContainerPort[] | cdktf.IResolvable): void;
    resetPort(): void;
    get portInput(): cdktf.IResolvable | JobSpecTemplateSpecInitContainerPort[] | undefined;
    private _readinessProbe;
    get readinessProbe(): JobSpecTemplateSpecInitContainerReadinessProbeOutputReference;
    putReadinessProbe(value: JobSpecTemplateSpecInitContainerReadinessProbe): void;
    resetReadinessProbe(): void;
    get readinessProbeInput(): JobSpecTemplateSpecInitContainerReadinessProbe | undefined;
    private _resources;
    get resources(): JobSpecTemplateSpecInitContainerResourcesOutputReference;
    putResources(value: JobSpecTemplateSpecInitContainerResources): void;
    resetResources(): void;
    get resourcesInput(): JobSpecTemplateSpecInitContainerResources | undefined;
    private _securityContext;
    get securityContext(): JobSpecTemplateSpecInitContainerSecurityContextOutputReference;
    putSecurityContext(value: JobSpecTemplateSpecInitContainerSecurityContext): void;
    resetSecurityContext(): void;
    get securityContextInput(): JobSpecTemplateSpecInitContainerSecurityContext | undefined;
    private _startupProbe;
    get startupProbe(): JobSpecTemplateSpecInitContainerStartupProbeOutputReference;
    putStartupProbe(value: JobSpecTemplateSpecInitContainerStartupProbe): void;
    resetStartupProbe(): void;
    get startupProbeInput(): JobSpecTemplateSpecInitContainerStartupProbe | undefined;
    private _volumeMount;
    get volumeMount(): JobSpecTemplateSpecInitContainerVolumeMountList;
    putVolumeMount(value: JobSpecTemplateSpecInitContainerVolumeMount[] | cdktf.IResolvable): void;
    resetVolumeMount(): void;
    get volumeMountInput(): cdktf.IResolvable | JobSpecTemplateSpecInitContainerVolumeMount[] | undefined;
}
export declare class JobSpecTemplateSpecInitContainerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobSpecTemplateSpecInitContainer[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobSpecTemplateSpecInitContainerOutputReference;
}
export interface JobSpecTemplateSpecReadinessGate {
    /**
    * refers to a condition in the pod's condition list with matching type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#condition_type Job#condition_type}
    */
    readonly conditionType: string;
}
export declare function jobSpecTemplateSpecReadinessGateToTerraform(struct?: JobSpecTemplateSpecReadinessGate | cdktf.IResolvable): any;
export declare class JobSpecTemplateSpecReadinessGateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobSpecTemplateSpecReadinessGate | cdktf.IResolvable | undefined;
    set internalValue(value: JobSpecTemplateSpecReadinessGate | cdktf.IResolvable | undefined);
    private _conditionType?;
    get conditionType(): string;
    set conditionType(value: string);
    get conditionTypeInput(): string | undefined;
}
export declare class JobSpecTemplateSpecReadinessGateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobSpecTemplateSpecReadinessGate[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobSpecTemplateSpecReadinessGateOutputReference;
}
export interface JobSpecTemplateSpecSecurityContextSeLinuxOptions {
    /**
    * Level is SELinux level label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#level Job#level}
    */
    readonly level?: string;
    /**
    * Role is a SELinux role label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#role Job#role}
    */
    readonly role?: string;
    /**
    * Type is a SELinux type label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#type Job#type}
    */
    readonly type?: string;
    /**
    * User is a SELinux user label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#user Job#user}
    */
    readonly user?: string;
}
export declare function jobSpecTemplateSpecSecurityContextSeLinuxOptionsToTerraform(struct?: JobSpecTemplateSpecSecurityContextSeLinuxOptionsOutputReference | JobSpecTemplateSpecSecurityContextSeLinuxOptions): any;
export declare class JobSpecTemplateSpecSecurityContextSeLinuxOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecSecurityContextSeLinuxOptions | undefined;
    set internalValue(value: JobSpecTemplateSpecSecurityContextSeLinuxOptions | undefined);
    private _level?;
    get level(): string;
    set level(value: string);
    resetLevel(): void;
    get levelInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    resetRole(): void;
    get roleInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _user?;
    get user(): string;
    set user(value: string);
    resetUser(): void;
    get userInput(): string | undefined;
}
export interface JobSpecTemplateSpecSecurityContextSeccompProfile {
    /**
    * Localhost Profile indicates a profile defined in a file on the node should be used. The profile must be preconfigured on the node to work.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#localhost_profile Job#localhost_profile}
    */
    readonly localhostProfile?: string;
    /**
    * Type indicates which kind of seccomp profile will be applied. Valid options are: Localhost, RuntimeDefault, Unconfined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#type Job#type}
    */
    readonly type?: string;
}
export declare function jobSpecTemplateSpecSecurityContextSeccompProfileToTerraform(struct?: JobSpecTemplateSpecSecurityContextSeccompProfileOutputReference | JobSpecTemplateSpecSecurityContextSeccompProfile): any;
export declare class JobSpecTemplateSpecSecurityContextSeccompProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecSecurityContextSeccompProfile | undefined;
    set internalValue(value: JobSpecTemplateSpecSecurityContextSeccompProfile | undefined);
    private _localhostProfile?;
    get localhostProfile(): string;
    set localhostProfile(value: string);
    resetLocalhostProfile(): void;
    get localhostProfileInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface JobSpecTemplateSpecSecurityContextSysctl {
    /**
    * Name of a property to set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#name Job#name}
    */
    readonly name: string;
    /**
    * Value of a property to set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#value Job#value}
    */
    readonly value: string;
}
export declare function jobSpecTemplateSpecSecurityContextSysctlToTerraform(struct?: JobSpecTemplateSpecSecurityContextSysctl | cdktf.IResolvable): any;
export declare class JobSpecTemplateSpecSecurityContextSysctlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobSpecTemplateSpecSecurityContextSysctl | cdktf.IResolvable | undefined;
    set internalValue(value: JobSpecTemplateSpecSecurityContextSysctl | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class JobSpecTemplateSpecSecurityContextSysctlList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobSpecTemplateSpecSecurityContextSysctl[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobSpecTemplateSpecSecurityContextSysctlOutputReference;
}
export interface JobSpecTemplateSpecSecurityContext {
    /**
    * A special supplemental group that applies to all containers in a pod. Some volume types allow the Kubelet to change the ownership of that volume to be owned by the pod: 1. The owning GID will be the FSGroup 2. The setgid bit is set (new files created in the volume will be owned by FSGroup) 3. The permission bits are OR'd with rw-rw---- If unset, the Kubelet will not modify the ownership and permissions of any volume.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#fs_group Job#fs_group}
    */
    readonly fsGroup?: string;
    /**
    * The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in SecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#run_as_group Job#run_as_group}
    */
    readonly runAsGroup?: string;
    /**
    * Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in SecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#run_as_non_root Job#run_as_non_root}
    */
    readonly runAsNonRoot?: boolean | cdktf.IResolvable;
    /**
    * The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in SecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#run_as_user Job#run_as_user}
    */
    readonly runAsUser?: string;
    /**
    * A list of groups applied to the first process run in each container, in addition to the container's primary GID. If unspecified, no groups will be added to any container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#supplemental_groups Job#supplemental_groups}
    */
    readonly supplementalGroups?: number[];
    /**
    * se_linux_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#se_linux_options Job#se_linux_options}
    */
    readonly seLinuxOptions?: JobSpecTemplateSpecSecurityContextSeLinuxOptions;
    /**
    * seccomp_profile block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#seccomp_profile Job#seccomp_profile}
    */
    readonly seccompProfile?: JobSpecTemplateSpecSecurityContextSeccompProfile;
    /**
    * sysctl block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#sysctl Job#sysctl}
    */
    readonly sysctl?: JobSpecTemplateSpecSecurityContextSysctl[] | cdktf.IResolvable;
}
export declare function jobSpecTemplateSpecSecurityContextToTerraform(struct?: JobSpecTemplateSpecSecurityContextOutputReference | JobSpecTemplateSpecSecurityContext): any;
export declare class JobSpecTemplateSpecSecurityContextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecSecurityContext | undefined;
    set internalValue(value: JobSpecTemplateSpecSecurityContext | undefined);
    private _fsGroup?;
    get fsGroup(): string;
    set fsGroup(value: string);
    resetFsGroup(): void;
    get fsGroupInput(): string | undefined;
    private _runAsGroup?;
    get runAsGroup(): string;
    set runAsGroup(value: string);
    resetRunAsGroup(): void;
    get runAsGroupInput(): string | undefined;
    private _runAsNonRoot?;
    get runAsNonRoot(): boolean | cdktf.IResolvable;
    set runAsNonRoot(value: boolean | cdktf.IResolvable);
    resetRunAsNonRoot(): void;
    get runAsNonRootInput(): boolean | cdktf.IResolvable | undefined;
    private _runAsUser?;
    get runAsUser(): string;
    set runAsUser(value: string);
    resetRunAsUser(): void;
    get runAsUserInput(): string | undefined;
    private _supplementalGroups?;
    get supplementalGroups(): number[];
    set supplementalGroups(value: number[]);
    resetSupplementalGroups(): void;
    get supplementalGroupsInput(): number[] | undefined;
    private _seLinuxOptions;
    get seLinuxOptions(): JobSpecTemplateSpecSecurityContextSeLinuxOptionsOutputReference;
    putSeLinuxOptions(value: JobSpecTemplateSpecSecurityContextSeLinuxOptions): void;
    resetSeLinuxOptions(): void;
    get seLinuxOptionsInput(): JobSpecTemplateSpecSecurityContextSeLinuxOptions | undefined;
    private _seccompProfile;
    get seccompProfile(): JobSpecTemplateSpecSecurityContextSeccompProfileOutputReference;
    putSeccompProfile(value: JobSpecTemplateSpecSecurityContextSeccompProfile): void;
    resetSeccompProfile(): void;
    get seccompProfileInput(): JobSpecTemplateSpecSecurityContextSeccompProfile | undefined;
    private _sysctl;
    get sysctl(): JobSpecTemplateSpecSecurityContextSysctlList;
    putSysctl(value: JobSpecTemplateSpecSecurityContextSysctl[] | cdktf.IResolvable): void;
    resetSysctl(): void;
    get sysctlInput(): cdktf.IResolvable | JobSpecTemplateSpecSecurityContextSysctl[] | undefined;
}
export interface JobSpecTemplateSpecToleration {
    /**
    * Effect indicates the taint effect to match. Empty means match all taint effects. When specified, allowed values are NoSchedule, PreferNoSchedule and NoExecute.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#effect Job#effect}
    */
    readonly effect?: string;
    /**
    * Key is the taint key that the toleration applies to. Empty means match all taint keys. If the key is empty, operator must be Exists; this combination means to match all values and all keys.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#key Job#key}
    */
    readonly key?: string;
    /**
    * Operator represents a key's relationship to the value. Valid operators are Exists and Equal. Defaults to Equal. Exists is equivalent to wildcard for value, so that a pod can tolerate all taints of a particular category.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#operator Job#operator}
    */
    readonly operator?: string;
    /**
    * TolerationSeconds represents the period of time the toleration (which must be of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default, it is not set, which means tolerate the taint forever (do not evict). Zero and negative values will be treated as 0 (evict immediately) by the system.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#toleration_seconds Job#toleration_seconds}
    */
    readonly tolerationSeconds?: string;
    /**
    * Value is the taint value the toleration matches to. If the operator is Exists, the value should be empty, otherwise just a regular string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#value Job#value}
    */
    readonly value?: string;
}
export declare function jobSpecTemplateSpecTolerationToTerraform(struct?: JobSpecTemplateSpecToleration | cdktf.IResolvable): any;
export declare class JobSpecTemplateSpecTolerationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobSpecTemplateSpecToleration | cdktf.IResolvable | undefined;
    set internalValue(value: JobSpecTemplateSpecToleration | cdktf.IResolvable | undefined);
    private _effect?;
    get effect(): string;
    set effect(value: string);
    resetEffect(): void;
    get effectInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _tolerationSeconds?;
    get tolerationSeconds(): string;
    set tolerationSeconds(value: string);
    resetTolerationSeconds(): void;
    get tolerationSecondsInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class JobSpecTemplateSpecTolerationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobSpecTemplateSpecToleration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobSpecTemplateSpecTolerationOutputReference;
}
export interface JobSpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressions {
    /**
    * The label key that the selector applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#key Job#key}
    */
    readonly key?: string;
    /**
    * A key's relationship to a set of values. Valid operators ard `In`, `NotIn`, `Exists` and `DoesNotExist`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#operator Job#operator}
    */
    readonly operator?: string;
    /**
    * An array of string values. If the operator is `In` or `NotIn`, the values array must be non-empty. If the operator is `Exists` or `DoesNotExist`, the values array must be empty. This array is replaced during a strategic merge patch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#values Job#values}
    */
    readonly values?: string[];
}
export declare function jobSpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressionsToTerraform(struct?: JobSpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressions | cdktf.IResolvable): any;
export declare class JobSpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobSpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressions | cdktf.IResolvable | undefined;
    set internalValue(value: JobSpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressions | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class JobSpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobSpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobSpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressionsOutputReference;
}
export interface JobSpecTemplateSpecTopologySpreadConstraintLabelSelector {
    /**
    * A map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of `match_expressions`, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#match_labels Job#match_labels}
    */
    readonly matchLabels?: {
        [key: string]: string;
    };
    /**
    * match_expressions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#match_expressions Job#match_expressions}
    */
    readonly matchExpressions?: JobSpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressions[] | cdktf.IResolvable;
}
export declare function jobSpecTemplateSpecTopologySpreadConstraintLabelSelectorToTerraform(struct?: JobSpecTemplateSpecTopologySpreadConstraintLabelSelector | cdktf.IResolvable): any;
export declare class JobSpecTemplateSpecTopologySpreadConstraintLabelSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobSpecTemplateSpecTopologySpreadConstraintLabelSelector | cdktf.IResolvable | undefined;
    set internalValue(value: JobSpecTemplateSpecTopologySpreadConstraintLabelSelector | cdktf.IResolvable | undefined);
    private _matchLabels?;
    get matchLabels(): {
        [key: string]: string;
    };
    set matchLabels(value: {
        [key: string]: string;
    });
    resetMatchLabels(): void;
    get matchLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _matchExpressions;
    get matchExpressions(): JobSpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressionsList;
    putMatchExpressions(value: JobSpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressions[] | cdktf.IResolvable): void;
    resetMatchExpressions(): void;
    get matchExpressionsInput(): cdktf.IResolvable | JobSpecTemplateSpecTopologySpreadConstraintLabelSelectorMatchExpressions[] | undefined;
}
export declare class JobSpecTemplateSpecTopologySpreadConstraintLabelSelectorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobSpecTemplateSpecTopologySpreadConstraintLabelSelector[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobSpecTemplateSpecTopologySpreadConstraintLabelSelectorOutputReference;
}
export interface JobSpecTemplateSpecTopologySpreadConstraint {
    /**
    * describes the degree to which pods may be unevenly distributed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#max_skew Job#max_skew}
    */
    readonly maxSkew?: number;
    /**
    * the key of node labels. Nodes that have a label with this key and identical values are considered to be in the same topology.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#topology_key Job#topology_key}
    */
    readonly topologyKey?: string;
    /**
    * indicates how to deal with a pod if it doesn't satisfy the spread constraint.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#when_unsatisfiable Job#when_unsatisfiable}
    */
    readonly whenUnsatisfiable?: string;
    /**
    * label_selector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#label_selector Job#label_selector}
    */
    readonly labelSelector?: JobSpecTemplateSpecTopologySpreadConstraintLabelSelector[] | cdktf.IResolvable;
}
export declare function jobSpecTemplateSpecTopologySpreadConstraintToTerraform(struct?: JobSpecTemplateSpecTopologySpreadConstraint | cdktf.IResolvable): any;
export declare class JobSpecTemplateSpecTopologySpreadConstraintOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobSpecTemplateSpecTopologySpreadConstraint | cdktf.IResolvable | undefined;
    set internalValue(value: JobSpecTemplateSpecTopologySpreadConstraint | cdktf.IResolvable | undefined);
    private _maxSkew?;
    get maxSkew(): number;
    set maxSkew(value: number);
    resetMaxSkew(): void;
    get maxSkewInput(): number | undefined;
    private _topologyKey?;
    get topologyKey(): string;
    set topologyKey(value: string);
    resetTopologyKey(): void;
    get topologyKeyInput(): string | undefined;
    private _whenUnsatisfiable?;
    get whenUnsatisfiable(): string;
    set whenUnsatisfiable(value: string);
    resetWhenUnsatisfiable(): void;
    get whenUnsatisfiableInput(): string | undefined;
    private _labelSelector;
    get labelSelector(): JobSpecTemplateSpecTopologySpreadConstraintLabelSelectorList;
    putLabelSelector(value: JobSpecTemplateSpecTopologySpreadConstraintLabelSelector[] | cdktf.IResolvable): void;
    resetLabelSelector(): void;
    get labelSelectorInput(): cdktf.IResolvable | JobSpecTemplateSpecTopologySpreadConstraintLabelSelector[] | undefined;
}
export declare class JobSpecTemplateSpecTopologySpreadConstraintList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobSpecTemplateSpecTopologySpreadConstraint[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobSpecTemplateSpecTopologySpreadConstraintOutputReference;
}
export interface JobSpecTemplateSpecVolumeAwsElasticBlockStore {
    /**
    * Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: http://kubernetes.io/docs/user-guide/volumes#awselasticblockstore
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#fs_type Job#fs_type}
    */
    readonly fsType?: string;
    /**
    * The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#partition Job#partition}
    */
    readonly partition?: number;
    /**
    * Whether to set the read-only property in VolumeMounts to "true". If omitted, the default is "false". More info: http://kubernetes.io/docs/user-guide/volumes#awselasticblockstore
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#read_only Job#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Unique ID of the persistent disk resource in AWS (Amazon EBS volume). More info: http://kubernetes.io/docs/user-guide/volumes#awselasticblockstore
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#volume_id Job#volume_id}
    */
    readonly volumeId: string;
}
export declare function jobSpecTemplateSpecVolumeAwsElasticBlockStoreToTerraform(struct?: JobSpecTemplateSpecVolumeAwsElasticBlockStoreOutputReference | JobSpecTemplateSpecVolumeAwsElasticBlockStore): any;
export declare class JobSpecTemplateSpecVolumeAwsElasticBlockStoreOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecVolumeAwsElasticBlockStore | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeAwsElasticBlockStore | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _partition?;
    get partition(): number;
    set partition(value: number);
    resetPartition(): void;
    get partitionInput(): number | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _volumeId?;
    get volumeId(): string;
    set volumeId(value: string);
    get volumeIdInput(): string | undefined;
}
export interface JobSpecTemplateSpecVolumeAzureDisk {
    /**
    * Host Caching mode: None, Read Only, Read Write.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#caching_mode Job#caching_mode}
    */
    readonly cachingMode: string;
    /**
    * The URI the data disk in the blob storage
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#data_disk_uri Job#data_disk_uri}
    */
    readonly dataDiskUri: string;
    /**
    * The Name of the data disk in the blob storage
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#disk_name Job#disk_name}
    */
    readonly diskName: string;
    /**
    * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#fs_type Job#fs_type}
    */
    readonly fsType?: string;
    /**
    * The type for the data disk. Expected values: Shared, Dedicated, Managed. Defaults to Shared
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#kind Job#kind}
    */
    readonly kind?: string;
    /**
    * Whether to force the read-only setting in VolumeMounts. Defaults to false (read/write).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#read_only Job#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
}
export declare function jobSpecTemplateSpecVolumeAzureDiskToTerraform(struct?: JobSpecTemplateSpecVolumeAzureDiskOutputReference | JobSpecTemplateSpecVolumeAzureDisk): any;
export declare class JobSpecTemplateSpecVolumeAzureDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecVolumeAzureDisk | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeAzureDisk | undefined);
    private _cachingMode?;
    get cachingMode(): string;
    set cachingMode(value: string);
    get cachingModeInput(): string | undefined;
    private _dataDiskUri?;
    get dataDiskUri(): string;
    set dataDiskUri(value: string);
    get dataDiskUriInput(): string | undefined;
    private _diskName?;
    get diskName(): string;
    set diskName(value: string);
    get diskNameInput(): string | undefined;
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    resetKind(): void;
    get kindInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
}
export interface JobSpecTemplateSpecVolumeAzureFile {
    /**
    * Whether to force the read-only setting in VolumeMounts. Defaults to false (read/write).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#read_only Job#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * The name of secret that contains Azure Storage Account Name and Key
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#secret_name Job#secret_name}
    */
    readonly secretName: string;
    /**
    * The namespace of the secret that contains Azure Storage Account Name and Key. For Kubernetes up to 1.18.x the default is the same as the Pod. For Kubernetes 1.19.x and later the default is "default" namespace.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#secret_namespace Job#secret_namespace}
    */
    readonly secretNamespace?: string;
    /**
    * Share Name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#share_name Job#share_name}
    */
    readonly shareName: string;
}
export declare function jobSpecTemplateSpecVolumeAzureFileToTerraform(struct?: JobSpecTemplateSpecVolumeAzureFileOutputReference | JobSpecTemplateSpecVolumeAzureFile): any;
export declare class JobSpecTemplateSpecVolumeAzureFileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecVolumeAzureFile | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeAzureFile | undefined);
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _secretName?;
    get secretName(): string;
    set secretName(value: string);
    get secretNameInput(): string | undefined;
    private _secretNamespace?;
    get secretNamespace(): string;
    set secretNamespace(value: string);
    resetSecretNamespace(): void;
    get secretNamespaceInput(): string | undefined;
    private _shareName?;
    get shareName(): string;
    set shareName(value: string);
    get shareNameInput(): string | undefined;
}
export interface JobSpecTemplateSpecVolumeCephFsSecretRef {
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#name Job#name}
    */
    readonly name?: string;
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#namespace Job#namespace}
    */
    readonly namespace?: string;
}
export declare function jobSpecTemplateSpecVolumeCephFsSecretRefToTerraform(struct?: JobSpecTemplateSpecVolumeCephFsSecretRefOutputReference | JobSpecTemplateSpecVolumeCephFsSecretRef): any;
export declare class JobSpecTemplateSpecVolumeCephFsSecretRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecVolumeCephFsSecretRef | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeCephFsSecretRef | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
}
export interface JobSpecTemplateSpecVolumeCephFs {
    /**
    * Monitors is a collection of Ceph monitors More info: http://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#monitors Job#monitors}
    */
    readonly monitors: string[];
    /**
    * Used as the mounted root, rather than the full Ceph tree, default is /
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#path Job#path}
    */
    readonly path?: string;
    /**
    * Whether to force the read-only setting in VolumeMounts. Defaults to `false` (read/write). More info: http://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#read_only Job#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * The path to key ring for User, default is /etc/ceph/user.secret More info: http://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#secret_file Job#secret_file}
    */
    readonly secretFile?: string;
    /**
    * User is the rados user name, default is admin. More info: http://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#user Job#user}
    */
    readonly user?: string;
    /**
    * secret_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#secret_ref Job#secret_ref}
    */
    readonly secretRef?: JobSpecTemplateSpecVolumeCephFsSecretRef;
}
export declare function jobSpecTemplateSpecVolumeCephFsToTerraform(struct?: JobSpecTemplateSpecVolumeCephFsOutputReference | JobSpecTemplateSpecVolumeCephFs): any;
export declare class JobSpecTemplateSpecVolumeCephFsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecVolumeCephFs | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeCephFs | undefined);
    private _monitors?;
    get monitors(): string[];
    set monitors(value: string[]);
    get monitorsInput(): string[] | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _secretFile?;
    get secretFile(): string;
    set secretFile(value: string);
    resetSecretFile(): void;
    get secretFileInput(): string | undefined;
    private _user?;
    get user(): string;
    set user(value: string);
    resetUser(): void;
    get userInput(): string | undefined;
    private _secretRef;
    get secretRef(): JobSpecTemplateSpecVolumeCephFsSecretRefOutputReference;
    putSecretRef(value: JobSpecTemplateSpecVolumeCephFsSecretRef): void;
    resetSecretRef(): void;
    get secretRefInput(): JobSpecTemplateSpecVolumeCephFsSecretRef | undefined;
}
export interface JobSpecTemplateSpecVolumeCinder {
    /**
    * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: http://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#fs_type Job#fs_type}
    */
    readonly fsType?: string;
    /**
    * Whether to force the read-only setting in VolumeMounts. Defaults to false (read/write). More info: http://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#read_only Job#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Volume ID used to identify the volume in Cinder. More info: http://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#volume_id Job#volume_id}
    */
    readonly volumeId: string;
}
export declare function jobSpecTemplateSpecVolumeCinderToTerraform(struct?: JobSpecTemplateSpecVolumeCinderOutputReference | JobSpecTemplateSpecVolumeCinder): any;
export declare class JobSpecTemplateSpecVolumeCinderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecVolumeCinder | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeCinder | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _volumeId?;
    get volumeId(): string;
    set volumeId(value: string);
    get volumeIdInput(): string | undefined;
}
export interface JobSpecTemplateSpecVolumeConfigMapItems {
    /**
    * The key to project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#key Job#key}
    */
    readonly key?: string;
    /**
    * Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#mode Job#mode}
    */
    readonly mode?: string;
    /**
    * The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#path Job#path}
    */
    readonly path?: string;
}
export declare function jobSpecTemplateSpecVolumeConfigMapItemsToTerraform(struct?: JobSpecTemplateSpecVolumeConfigMapItems | cdktf.IResolvable): any;
export declare class JobSpecTemplateSpecVolumeConfigMapItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobSpecTemplateSpecVolumeConfigMapItems | cdktf.IResolvable | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeConfigMapItems | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
}
export declare class JobSpecTemplateSpecVolumeConfigMapItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobSpecTemplateSpecVolumeConfigMapItems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobSpecTemplateSpecVolumeConfigMapItemsOutputReference;
}
export interface JobSpecTemplateSpecVolumeConfigMap {
    /**
    * Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#default_mode Job#default_mode}
    */
    readonly defaultMode?: string;
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#name Job#name}
    */
    readonly name?: string;
    /**
    * Optional: Specify whether the ConfigMap or its keys must be defined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#optional Job#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#items Job#items}
    */
    readonly items?: JobSpecTemplateSpecVolumeConfigMapItems[] | cdktf.IResolvable;
}
export declare function jobSpecTemplateSpecVolumeConfigMapToTerraform(struct?: JobSpecTemplateSpecVolumeConfigMapOutputReference | JobSpecTemplateSpecVolumeConfigMap): any;
export declare class JobSpecTemplateSpecVolumeConfigMapOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecVolumeConfigMap | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeConfigMap | undefined);
    private _defaultMode?;
    get defaultMode(): string;
    set defaultMode(value: string);
    resetDefaultMode(): void;
    get defaultModeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
    private _items;
    get items(): JobSpecTemplateSpecVolumeConfigMapItemsList;
    putItems(value: JobSpecTemplateSpecVolumeConfigMapItems[] | cdktf.IResolvable): void;
    resetItems(): void;
    get itemsInput(): cdktf.IResolvable | JobSpecTemplateSpecVolumeConfigMapItems[] | undefined;
}
export interface JobSpecTemplateSpecVolumeCsiNodePublishSecretRef {
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#name Job#name}
    */
    readonly name?: string;
}
export declare function jobSpecTemplateSpecVolumeCsiNodePublishSecretRefToTerraform(struct?: JobSpecTemplateSpecVolumeCsiNodePublishSecretRefOutputReference | JobSpecTemplateSpecVolumeCsiNodePublishSecretRef): any;
export declare class JobSpecTemplateSpecVolumeCsiNodePublishSecretRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecVolumeCsiNodePublishSecretRef | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeCsiNodePublishSecretRef | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export interface JobSpecTemplateSpecVolumeCsi {
    /**
    * the name of the volume driver to use. More info: https://kubernetes.io/docs/concepts/storage/volumes/#csi
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#driver Job#driver}
    */
    readonly driver: string;
    /**
    * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#fs_type Job#fs_type}
    */
    readonly fsType?: string;
    /**
    * Whether to set the read-only property in VolumeMounts to "true". If omitted, the default is "false". More info: http://kubernetes.io/docs/user-guide/volumes#csi
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#read_only Job#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Attributes of the volume to publish.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#volume_attributes Job#volume_attributes}
    */
    readonly volumeAttributes?: {
        [key: string]: string;
    };
    /**
    * node_publish_secret_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#node_publish_secret_ref Job#node_publish_secret_ref}
    */
    readonly nodePublishSecretRef?: JobSpecTemplateSpecVolumeCsiNodePublishSecretRef;
}
export declare function jobSpecTemplateSpecVolumeCsiToTerraform(struct?: JobSpecTemplateSpecVolumeCsiOutputReference | JobSpecTemplateSpecVolumeCsi): any;
export declare class JobSpecTemplateSpecVolumeCsiOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecVolumeCsi | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeCsi | undefined);
    private _driver?;
    get driver(): string;
    set driver(value: string);
    get driverInput(): string | undefined;
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _volumeAttributes?;
    get volumeAttributes(): {
        [key: string]: string;
    };
    set volumeAttributes(value: {
        [key: string]: string;
    });
    resetVolumeAttributes(): void;
    get volumeAttributesInput(): {
        [key: string]: string;
    } | undefined;
    private _nodePublishSecretRef;
    get nodePublishSecretRef(): JobSpecTemplateSpecVolumeCsiNodePublishSecretRefOutputReference;
    putNodePublishSecretRef(value: JobSpecTemplateSpecVolumeCsiNodePublishSecretRef): void;
    resetNodePublishSecretRef(): void;
    get nodePublishSecretRefInput(): JobSpecTemplateSpecVolumeCsiNodePublishSecretRef | undefined;
}
export interface JobSpecTemplateSpecVolumeDownwardApiItemsFieldRef {
    /**
    * Version of the schema the FieldPath is written in terms of, defaults to "v1".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#api_version Job#api_version}
    */
    readonly apiVersion?: string;
    /**
    * Path of the field to select in the specified API version
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#field_path Job#field_path}
    */
    readonly fieldPath?: string;
}
export declare function jobSpecTemplateSpecVolumeDownwardApiItemsFieldRefToTerraform(struct?: JobSpecTemplateSpecVolumeDownwardApiItemsFieldRefOutputReference | JobSpecTemplateSpecVolumeDownwardApiItemsFieldRef): any;
export declare class JobSpecTemplateSpecVolumeDownwardApiItemsFieldRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecVolumeDownwardApiItemsFieldRef | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeDownwardApiItemsFieldRef | undefined);
    private _apiVersion?;
    get apiVersion(): string;
    set apiVersion(value: string);
    resetApiVersion(): void;
    get apiVersionInput(): string | undefined;
    private _fieldPath?;
    get fieldPath(): string;
    set fieldPath(value: string);
    resetFieldPath(): void;
    get fieldPathInput(): string | undefined;
}
export interface JobSpecTemplateSpecVolumeDownwardApiItemsResourceFieldRef {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#container_name Job#container_name}
    */
    readonly containerName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#divisor Job#divisor}
    */
    readonly divisor?: string;
    /**
    * Resource to select
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#resource Job#resource}
    */
    readonly resource: string;
}
export declare function jobSpecTemplateSpecVolumeDownwardApiItemsResourceFieldRefToTerraform(struct?: JobSpecTemplateSpecVolumeDownwardApiItemsResourceFieldRefOutputReference | JobSpecTemplateSpecVolumeDownwardApiItemsResourceFieldRef): any;
export declare class JobSpecTemplateSpecVolumeDownwardApiItemsResourceFieldRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecVolumeDownwardApiItemsResourceFieldRef | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeDownwardApiItemsResourceFieldRef | undefined);
    private _containerName?;
    get containerName(): string;
    set containerName(value: string);
    get containerNameInput(): string | undefined;
    private _divisor?;
    get divisor(): string;
    set divisor(value: string);
    resetDivisor(): void;
    get divisorInput(): string | undefined;
    private _resource?;
    get resource(): string;
    set resource(value: string);
    get resourceInput(): string | undefined;
}
export interface JobSpecTemplateSpecVolumeDownwardApiItems {
    /**
    * Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#mode Job#mode}
    */
    readonly mode?: string;
    /**
    * Path is the relative path name of the file to be created. Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#path Job#path}
    */
    readonly path: string;
    /**
    * field_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#field_ref Job#field_ref}
    */
    readonly fieldRef: JobSpecTemplateSpecVolumeDownwardApiItemsFieldRef;
    /**
    * resource_field_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#resource_field_ref Job#resource_field_ref}
    */
    readonly resourceFieldRef?: JobSpecTemplateSpecVolumeDownwardApiItemsResourceFieldRef;
}
export declare function jobSpecTemplateSpecVolumeDownwardApiItemsToTerraform(struct?: JobSpecTemplateSpecVolumeDownwardApiItems | cdktf.IResolvable): any;
export declare class JobSpecTemplateSpecVolumeDownwardApiItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobSpecTemplateSpecVolumeDownwardApiItems | cdktf.IResolvable | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeDownwardApiItems | cdktf.IResolvable | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _fieldRef;
    get fieldRef(): JobSpecTemplateSpecVolumeDownwardApiItemsFieldRefOutputReference;
    putFieldRef(value: JobSpecTemplateSpecVolumeDownwardApiItemsFieldRef): void;
    get fieldRefInput(): JobSpecTemplateSpecVolumeDownwardApiItemsFieldRef | undefined;
    private _resourceFieldRef;
    get resourceFieldRef(): JobSpecTemplateSpecVolumeDownwardApiItemsResourceFieldRefOutputReference;
    putResourceFieldRef(value: JobSpecTemplateSpecVolumeDownwardApiItemsResourceFieldRef): void;
    resetResourceFieldRef(): void;
    get resourceFieldRefInput(): JobSpecTemplateSpecVolumeDownwardApiItemsResourceFieldRef | undefined;
}
export declare class JobSpecTemplateSpecVolumeDownwardApiItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobSpecTemplateSpecVolumeDownwardApiItems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobSpecTemplateSpecVolumeDownwardApiItemsOutputReference;
}
export interface JobSpecTemplateSpecVolumeDownwardApi {
    /**
    * Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#default_mode Job#default_mode}
    */
    readonly defaultMode?: string;
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#items Job#items}
    */
    readonly items?: JobSpecTemplateSpecVolumeDownwardApiItems[] | cdktf.IResolvable;
}
export declare function jobSpecTemplateSpecVolumeDownwardApiToTerraform(struct?: JobSpecTemplateSpecVolumeDownwardApiOutputReference | JobSpecTemplateSpecVolumeDownwardApi): any;
export declare class JobSpecTemplateSpecVolumeDownwardApiOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecVolumeDownwardApi | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeDownwardApi | undefined);
    private _defaultMode?;
    get defaultMode(): string;
    set defaultMode(value: string);
    resetDefaultMode(): void;
    get defaultModeInput(): string | undefined;
    private _items;
    get items(): JobSpecTemplateSpecVolumeDownwardApiItemsList;
    putItems(value: JobSpecTemplateSpecVolumeDownwardApiItems[] | cdktf.IResolvable): void;
    resetItems(): void;
    get itemsInput(): cdktf.IResolvable | JobSpecTemplateSpecVolumeDownwardApiItems[] | undefined;
}
export interface JobSpecTemplateSpecVolumeEmptyDir {
    /**
    * What type of storage medium should back this directory. The default is "" which means to use the node's default medium. Must be an empty string (default) or Memory. More info: http://kubernetes.io/docs/user-guide/volumes#emptydir
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#medium Job#medium}
    */
    readonly medium?: string;
    /**
    * Total amount of local storage required for this EmptyDir volume.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#size_limit Job#size_limit}
    */
    readonly sizeLimit?: string;
}
export declare function jobSpecTemplateSpecVolumeEmptyDirToTerraform(struct?: JobSpecTemplateSpecVolumeEmptyDirOutputReference | JobSpecTemplateSpecVolumeEmptyDir): any;
export declare class JobSpecTemplateSpecVolumeEmptyDirOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecVolumeEmptyDir | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeEmptyDir | undefined);
    private _medium?;
    get medium(): string;
    set medium(value: string);
    resetMedium(): void;
    get mediumInput(): string | undefined;
    private _sizeLimit?;
    get sizeLimit(): string;
    set sizeLimit(value: string);
    resetSizeLimit(): void;
    get sizeLimitInput(): string | undefined;
}
export interface JobSpecTemplateSpecVolumeFc {
    /**
    * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#fs_type Job#fs_type}
    */
    readonly fsType?: string;
    /**
    * FC target lun number
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#lun Job#lun}
    */
    readonly lun: number;
    /**
    * Whether to force the read-only setting in VolumeMounts. Defaults to false (read/write).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#read_only Job#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * FC target worldwide names (WWNs)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#target_ww_ns Job#target_ww_ns}
    */
    readonly targetWwNs: string[];
}
export declare function jobSpecTemplateSpecVolumeFcToTerraform(struct?: JobSpecTemplateSpecVolumeFcOutputReference | JobSpecTemplateSpecVolumeFc): any;
export declare class JobSpecTemplateSpecVolumeFcOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecVolumeFc | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeFc | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _lun?;
    get lun(): number;
    set lun(value: number);
    get lunInput(): number | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _targetWwNs?;
    get targetWwNs(): string[];
    set targetWwNs(value: string[]);
    get targetWwNsInput(): string[] | undefined;
}
export interface JobSpecTemplateSpecVolumeFlexVolumeSecretRef {
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#name Job#name}
    */
    readonly name?: string;
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#namespace Job#namespace}
    */
    readonly namespace?: string;
}
export declare function jobSpecTemplateSpecVolumeFlexVolumeSecretRefToTerraform(struct?: JobSpecTemplateSpecVolumeFlexVolumeSecretRefOutputReference | JobSpecTemplateSpecVolumeFlexVolumeSecretRef): any;
export declare class JobSpecTemplateSpecVolumeFlexVolumeSecretRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecVolumeFlexVolumeSecretRef | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeFlexVolumeSecretRef | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
}
export interface JobSpecTemplateSpecVolumeFlexVolume {
    /**
    * Driver is the name of the driver to use for this volume.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#driver Job#driver}
    */
    readonly driver: string;
    /**
    * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#fs_type Job#fs_type}
    */
    readonly fsType?: string;
    /**
    * Extra command options if any.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#options Job#options}
    */
    readonly options?: {
        [key: string]: string;
    };
    /**
    * Whether to force the ReadOnly setting in VolumeMounts. Defaults to false (read/write).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#read_only Job#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * secret_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#secret_ref Job#secret_ref}
    */
    readonly secretRef?: JobSpecTemplateSpecVolumeFlexVolumeSecretRef;
}
export declare function jobSpecTemplateSpecVolumeFlexVolumeToTerraform(struct?: JobSpecTemplateSpecVolumeFlexVolumeOutputReference | JobSpecTemplateSpecVolumeFlexVolume): any;
export declare class JobSpecTemplateSpecVolumeFlexVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecVolumeFlexVolume | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeFlexVolume | undefined);
    private _driver?;
    get driver(): string;
    set driver(value: string);
    get driverInput(): string | undefined;
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _options?;
    get options(): {
        [key: string]: string;
    };
    set options(value: {
        [key: string]: string;
    });
    resetOptions(): void;
    get optionsInput(): {
        [key: string]: string;
    } | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _secretRef;
    get secretRef(): JobSpecTemplateSpecVolumeFlexVolumeSecretRefOutputReference;
    putSecretRef(value: JobSpecTemplateSpecVolumeFlexVolumeSecretRef): void;
    resetSecretRef(): void;
    get secretRefInput(): JobSpecTemplateSpecVolumeFlexVolumeSecretRef | undefined;
}
export interface JobSpecTemplateSpecVolumeFlocker {
    /**
    * Name of the dataset stored as metadata -> name on the dataset for Flocker should be considered as deprecated
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#dataset_name Job#dataset_name}
    */
    readonly datasetName?: string;
    /**
    * UUID of the dataset. This is unique identifier of a Flocker dataset
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#dataset_uuid Job#dataset_uuid}
    */
    readonly datasetUuid?: string;
}
export declare function jobSpecTemplateSpecVolumeFlockerToTerraform(struct?: JobSpecTemplateSpecVolumeFlockerOutputReference | JobSpecTemplateSpecVolumeFlocker): any;
export declare class JobSpecTemplateSpecVolumeFlockerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecVolumeFlocker | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeFlocker | undefined);
    private _datasetName?;
    get datasetName(): string;
    set datasetName(value: string);
    resetDatasetName(): void;
    get datasetNameInput(): string | undefined;
    private _datasetUuid?;
    get datasetUuid(): string;
    set datasetUuid(value: string);
    resetDatasetUuid(): void;
    get datasetUuidInput(): string | undefined;
}
export interface JobSpecTemplateSpecVolumeGcePersistentDisk {
    /**
    * Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: http://kubernetes.io/docs/user-guide/volumes#gcepersistentdisk
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#fs_type Job#fs_type}
    */
    readonly fsType?: string;
    /**
    * The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). More info: http://kubernetes.io/docs/user-guide/volumes#gcepersistentdisk
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#partition Job#partition}
    */
    readonly partition?: number;
    /**
    * Unique name of the PD resource in GCE. Used to identify the disk in GCE. More info: http://kubernetes.io/docs/user-guide/volumes#gcepersistentdisk
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#pd_name Job#pd_name}
    */
    readonly pdName: string;
    /**
    * Whether to force the ReadOnly setting in VolumeMounts. Defaults to false. More info: http://kubernetes.io/docs/user-guide/volumes#gcepersistentdisk
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#read_only Job#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
}
export declare function jobSpecTemplateSpecVolumeGcePersistentDiskToTerraform(struct?: JobSpecTemplateSpecVolumeGcePersistentDiskOutputReference | JobSpecTemplateSpecVolumeGcePersistentDisk): any;
export declare class JobSpecTemplateSpecVolumeGcePersistentDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecVolumeGcePersistentDisk | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeGcePersistentDisk | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _partition?;
    get partition(): number;
    set partition(value: number);
    resetPartition(): void;
    get partitionInput(): number | undefined;
    private _pdName?;
    get pdName(): string;
    set pdName(value: string);
    get pdNameInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
}
export interface JobSpecTemplateSpecVolumeGitRepo {
    /**
    * Target directory name. Must not contain or start with '..'. If '.' is supplied, the volume directory will be the git repository. Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#directory Job#directory}
    */
    readonly directory?: string;
    /**
    * Repository URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#repository Job#repository}
    */
    readonly repository?: string;
    /**
    * Commit hash for the specified revision.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#revision Job#revision}
    */
    readonly revision?: string;
}
export declare function jobSpecTemplateSpecVolumeGitRepoToTerraform(struct?: JobSpecTemplateSpecVolumeGitRepoOutputReference | JobSpecTemplateSpecVolumeGitRepo): any;
export declare class JobSpecTemplateSpecVolumeGitRepoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecVolumeGitRepo | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeGitRepo | undefined);
    private _directory?;
    get directory(): string;
    set directory(value: string);
    resetDirectory(): void;
    get directoryInput(): string | undefined;
    private _repository?;
    get repository(): string;
    set repository(value: string);
    resetRepository(): void;
    get repositoryInput(): string | undefined;
    private _revision?;
    get revision(): string;
    set revision(value: string);
    resetRevision(): void;
    get revisionInput(): string | undefined;
}
export interface JobSpecTemplateSpecVolumeGlusterfs {
    /**
    * The endpoint name that details Glusterfs topology. More info: http://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#endpoints_name Job#endpoints_name}
    */
    readonly endpointsName: string;
    /**
    * The Glusterfs volume path. More info: http://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#path Job#path}
    */
    readonly path: string;
    /**
    * Whether to force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: http://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#read_only Job#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
}
export declare function jobSpecTemplateSpecVolumeGlusterfsToTerraform(struct?: JobSpecTemplateSpecVolumeGlusterfsOutputReference | JobSpecTemplateSpecVolumeGlusterfs): any;
export declare class JobSpecTemplateSpecVolumeGlusterfsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecVolumeGlusterfs | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeGlusterfs | undefined);
    private _endpointsName?;
    get endpointsName(): string;
    set endpointsName(value: string);
    get endpointsNameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
}
export interface JobSpecTemplateSpecVolumeHostPath {
    /**
    * Path of the directory on the host. More info: http://kubernetes.io/docs/user-guide/volumes#hostpath
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#path Job#path}
    */
    readonly path?: string;
    /**
    * Type for HostPath volume. Allowed values are "" (default), DirectoryOrCreate, Directory, FileOrCreate, File, Socket, CharDevice and BlockDevice
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#type Job#type}
    */
    readonly type?: string;
}
export declare function jobSpecTemplateSpecVolumeHostPathToTerraform(struct?: JobSpecTemplateSpecVolumeHostPathOutputReference | JobSpecTemplateSpecVolumeHostPath): any;
export declare class JobSpecTemplateSpecVolumeHostPathOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecVolumeHostPath | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeHostPath | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface JobSpecTemplateSpecVolumeIscsi {
    /**
    * Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: http://kubernetes.io/docs/user-guide/volumes#iscsi
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#fs_type Job#fs_type}
    */
    readonly fsType?: string;
    /**
    * Target iSCSI Qualified Name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#iqn Job#iqn}
    */
    readonly iqn: string;
    /**
    * iSCSI interface name that uses an iSCSI transport. Defaults to 'default' (tcp).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#iscsi_interface Job#iscsi_interface}
    */
    readonly iscsiInterface?: string;
    /**
    * iSCSI target lun number.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#lun Job#lun}
    */
    readonly lun?: number;
    /**
    * Whether to force the read-only setting in VolumeMounts. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#read_only Job#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * iSCSI target portal. The portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#target_portal Job#target_portal}
    */
    readonly targetPortal: string;
}
export declare function jobSpecTemplateSpecVolumeIscsiToTerraform(struct?: JobSpecTemplateSpecVolumeIscsiOutputReference | JobSpecTemplateSpecVolumeIscsi): any;
export declare class JobSpecTemplateSpecVolumeIscsiOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecVolumeIscsi | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeIscsi | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _iqn?;
    get iqn(): string;
    set iqn(value: string);
    get iqnInput(): string | undefined;
    private _iscsiInterface?;
    get iscsiInterface(): string;
    set iscsiInterface(value: string);
    resetIscsiInterface(): void;
    get iscsiInterfaceInput(): string | undefined;
    private _lun?;
    get lun(): number;
    set lun(value: number);
    resetLun(): void;
    get lunInput(): number | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _targetPortal?;
    get targetPortal(): string;
    set targetPortal(value: string);
    get targetPortalInput(): string | undefined;
}
export interface JobSpecTemplateSpecVolumeLocal {
    /**
    * Path of the directory on the host. More info: http://kubernetes.io/docs/user-guide/volumes#local
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#path Job#path}
    */
    readonly path?: string;
}
export declare function jobSpecTemplateSpecVolumeLocalToTerraform(struct?: JobSpecTemplateSpecVolumeLocalOutputReference | JobSpecTemplateSpecVolumeLocal): any;
export declare class JobSpecTemplateSpecVolumeLocalOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecVolumeLocal | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeLocal | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
}
export interface JobSpecTemplateSpecVolumeNfs {
    /**
    * Path that is exported by the NFS server. More info: http://kubernetes.io/docs/user-guide/volumes#nfs
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#path Job#path}
    */
    readonly path: string;
    /**
    * Whether to force the NFS export to be mounted with read-only permissions. Defaults to false. More info: http://kubernetes.io/docs/user-guide/volumes#nfs
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#read_only Job#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Server is the hostname or IP address of the NFS server. More info: http://kubernetes.io/docs/user-guide/volumes#nfs
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#server Job#server}
    */
    readonly server: string;
}
export declare function jobSpecTemplateSpecVolumeNfsToTerraform(struct?: JobSpecTemplateSpecVolumeNfsOutputReference | JobSpecTemplateSpecVolumeNfs): any;
export declare class JobSpecTemplateSpecVolumeNfsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecVolumeNfs | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeNfs | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _server?;
    get server(): string;
    set server(value: string);
    get serverInput(): string | undefined;
}
export interface JobSpecTemplateSpecVolumePersistentVolumeClaim {
    /**
    * ClaimName is the name of a PersistentVolumeClaim in the same
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#claim_name Job#claim_name}
    */
    readonly claimName?: string;
    /**
    * Will force the ReadOnly setting in VolumeMounts.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#read_only Job#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
}
export declare function jobSpecTemplateSpecVolumePersistentVolumeClaimToTerraform(struct?: JobSpecTemplateSpecVolumePersistentVolumeClaimOutputReference | JobSpecTemplateSpecVolumePersistentVolumeClaim): any;
export declare class JobSpecTemplateSpecVolumePersistentVolumeClaimOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecVolumePersistentVolumeClaim | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumePersistentVolumeClaim | undefined);
    private _claimName?;
    get claimName(): string;
    set claimName(value: string);
    resetClaimName(): void;
    get claimNameInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
}
export interface JobSpecTemplateSpecVolumePhotonPersistentDisk {
    /**
    * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#fs_type Job#fs_type}
    */
    readonly fsType?: string;
    /**
    * ID that identifies Photon Controller persistent disk
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#pd_id Job#pd_id}
    */
    readonly pdId: string;
}
export declare function jobSpecTemplateSpecVolumePhotonPersistentDiskToTerraform(struct?: JobSpecTemplateSpecVolumePhotonPersistentDiskOutputReference | JobSpecTemplateSpecVolumePhotonPersistentDisk): any;
export declare class JobSpecTemplateSpecVolumePhotonPersistentDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecVolumePhotonPersistentDisk | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumePhotonPersistentDisk | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _pdId?;
    get pdId(): string;
    set pdId(value: string);
    get pdIdInput(): string | undefined;
}
export interface JobSpecTemplateSpecVolumeProjectedSourcesConfigMapItems {
    /**
    * The key to project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#key Job#key}
    */
    readonly key?: string;
    /**
    * Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#mode Job#mode}
    */
    readonly mode?: string;
    /**
    * The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#path Job#path}
    */
    readonly path?: string;
}
export declare function jobSpecTemplateSpecVolumeProjectedSourcesConfigMapItemsToTerraform(struct?: JobSpecTemplateSpecVolumeProjectedSourcesConfigMapItems | cdktf.IResolvable): any;
export declare class JobSpecTemplateSpecVolumeProjectedSourcesConfigMapItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobSpecTemplateSpecVolumeProjectedSourcesConfigMapItems | cdktf.IResolvable | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeProjectedSourcesConfigMapItems | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
}
export declare class JobSpecTemplateSpecVolumeProjectedSourcesConfigMapItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobSpecTemplateSpecVolumeProjectedSourcesConfigMapItems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobSpecTemplateSpecVolumeProjectedSourcesConfigMapItemsOutputReference;
}
export interface JobSpecTemplateSpecVolumeProjectedSourcesConfigMap {
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#name Job#name}
    */
    readonly name?: string;
    /**
    * Optional: Specify whether the ConfigMap or it's keys must be defined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#optional Job#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#items Job#items}
    */
    readonly items?: JobSpecTemplateSpecVolumeProjectedSourcesConfigMapItems[] | cdktf.IResolvable;
}
export declare function jobSpecTemplateSpecVolumeProjectedSourcesConfigMapToTerraform(struct?: JobSpecTemplateSpecVolumeProjectedSourcesConfigMap | cdktf.IResolvable): any;
export declare class JobSpecTemplateSpecVolumeProjectedSourcesConfigMapOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobSpecTemplateSpecVolumeProjectedSourcesConfigMap | cdktf.IResolvable | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeProjectedSourcesConfigMap | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
    private _items;
    get items(): JobSpecTemplateSpecVolumeProjectedSourcesConfigMapItemsList;
    putItems(value: JobSpecTemplateSpecVolumeProjectedSourcesConfigMapItems[] | cdktf.IResolvable): void;
    resetItems(): void;
    get itemsInput(): cdktf.IResolvable | JobSpecTemplateSpecVolumeProjectedSourcesConfigMapItems[] | undefined;
}
export declare class JobSpecTemplateSpecVolumeProjectedSourcesConfigMapList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobSpecTemplateSpecVolumeProjectedSourcesConfigMap[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobSpecTemplateSpecVolumeProjectedSourcesConfigMapOutputReference;
}
export interface JobSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsFieldRef {
    /**
    * Version of the schema the FieldPath is written in terms of, defaults to 'v1'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#api_version Job#api_version}
    */
    readonly apiVersion?: string;
    /**
    * Path of the field to select in the specified API version
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#field_path Job#field_path}
    */
    readonly fieldPath?: string;
}
export declare function jobSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsFieldRefToTerraform(struct?: JobSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsFieldRefOutputReference | JobSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsFieldRef): any;
export declare class JobSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsFieldRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsFieldRef | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsFieldRef | undefined);
    private _apiVersion?;
    get apiVersion(): string;
    set apiVersion(value: string);
    resetApiVersion(): void;
    get apiVersionInput(): string | undefined;
    private _fieldPath?;
    get fieldPath(): string;
    set fieldPath(value: string);
    resetFieldPath(): void;
    get fieldPathInput(): string | undefined;
}
export interface JobSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRef {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#container_name Job#container_name}
    */
    readonly containerName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#divisor Job#divisor}
    */
    readonly divisor?: string;
    /**
    * Resource to select
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#resource Job#resource}
    */
    readonly resource: string;
}
export declare function jobSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRefToTerraform(struct?: JobSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRefOutputReference | JobSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRef): any;
export declare class JobSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRef | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRef | undefined);
    private _containerName?;
    get containerName(): string;
    set containerName(value: string);
    get containerNameInput(): string | undefined;
    private _divisor?;
    get divisor(): string;
    set divisor(value: string);
    resetDivisor(): void;
    get divisorInput(): string | undefined;
    private _resource?;
    get resource(): string;
    set resource(value: string);
    get resourceInput(): string | undefined;
}
export interface JobSpecTemplateSpecVolumeProjectedSourcesDownwardApiItems {
    /**
    * Mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#mode Job#mode}
    */
    readonly mode?: string;
    /**
    * Path is the relative path name of the file to be created. Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#path Job#path}
    */
    readonly path: string;
    /**
    * field_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#field_ref Job#field_ref}
    */
    readonly fieldRef?: JobSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsFieldRef;
    /**
    * resource_field_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#resource_field_ref Job#resource_field_ref}
    */
    readonly resourceFieldRef?: JobSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRef;
}
export declare function jobSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsToTerraform(struct?: JobSpecTemplateSpecVolumeProjectedSourcesDownwardApiItems | cdktf.IResolvable): any;
export declare class JobSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobSpecTemplateSpecVolumeProjectedSourcesDownwardApiItems | cdktf.IResolvable | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeProjectedSourcesDownwardApiItems | cdktf.IResolvable | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _fieldRef;
    get fieldRef(): JobSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsFieldRefOutputReference;
    putFieldRef(value: JobSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsFieldRef): void;
    resetFieldRef(): void;
    get fieldRefInput(): JobSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsFieldRef | undefined;
    private _resourceFieldRef;
    get resourceFieldRef(): JobSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRefOutputReference;
    putResourceFieldRef(value: JobSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRef): void;
    resetResourceFieldRef(): void;
    get resourceFieldRefInput(): JobSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRef | undefined;
}
export declare class JobSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobSpecTemplateSpecVolumeProjectedSourcesDownwardApiItems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsOutputReference;
}
export interface JobSpecTemplateSpecVolumeProjectedSourcesDownwardApi {
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#items Job#items}
    */
    readonly items?: JobSpecTemplateSpecVolumeProjectedSourcesDownwardApiItems[] | cdktf.IResolvable;
}
export declare function jobSpecTemplateSpecVolumeProjectedSourcesDownwardApiToTerraform(struct?: JobSpecTemplateSpecVolumeProjectedSourcesDownwardApiOutputReference | JobSpecTemplateSpecVolumeProjectedSourcesDownwardApi): any;
export declare class JobSpecTemplateSpecVolumeProjectedSourcesDownwardApiOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecVolumeProjectedSourcesDownwardApi | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeProjectedSourcesDownwardApi | undefined);
    private _items;
    get items(): JobSpecTemplateSpecVolumeProjectedSourcesDownwardApiItemsList;
    putItems(value: JobSpecTemplateSpecVolumeProjectedSourcesDownwardApiItems[] | cdktf.IResolvable): void;
    resetItems(): void;
    get itemsInput(): cdktf.IResolvable | JobSpecTemplateSpecVolumeProjectedSourcesDownwardApiItems[] | undefined;
}
export interface JobSpecTemplateSpecVolumeProjectedSourcesSecretItems {
    /**
    * The key to project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#key Job#key}
    */
    readonly key?: string;
    /**
    * Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#mode Job#mode}
    */
    readonly mode?: string;
    /**
    * The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#path Job#path}
    */
    readonly path?: string;
}
export declare function jobSpecTemplateSpecVolumeProjectedSourcesSecretItemsToTerraform(struct?: JobSpecTemplateSpecVolumeProjectedSourcesSecretItems | cdktf.IResolvable): any;
export declare class JobSpecTemplateSpecVolumeProjectedSourcesSecretItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobSpecTemplateSpecVolumeProjectedSourcesSecretItems | cdktf.IResolvable | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeProjectedSourcesSecretItems | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
}
export declare class JobSpecTemplateSpecVolumeProjectedSourcesSecretItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobSpecTemplateSpecVolumeProjectedSourcesSecretItems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobSpecTemplateSpecVolumeProjectedSourcesSecretItemsOutputReference;
}
export interface JobSpecTemplateSpecVolumeProjectedSourcesSecret {
    /**
    * Name of the secret in the pod's namespace to use. More info: http://kubernetes.io/docs/user-guide/volumes#secrets
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#name Job#name}
    */
    readonly name?: string;
    /**
    * Optional: Specify whether the Secret or it's keys must be defined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#optional Job#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#items Job#items}
    */
    readonly items?: JobSpecTemplateSpecVolumeProjectedSourcesSecretItems[] | cdktf.IResolvable;
}
export declare function jobSpecTemplateSpecVolumeProjectedSourcesSecretToTerraform(struct?: JobSpecTemplateSpecVolumeProjectedSourcesSecret | cdktf.IResolvable): any;
export declare class JobSpecTemplateSpecVolumeProjectedSourcesSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobSpecTemplateSpecVolumeProjectedSourcesSecret | cdktf.IResolvable | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeProjectedSourcesSecret | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
    private _items;
    get items(): JobSpecTemplateSpecVolumeProjectedSourcesSecretItemsList;
    putItems(value: JobSpecTemplateSpecVolumeProjectedSourcesSecretItems[] | cdktf.IResolvable): void;
    resetItems(): void;
    get itemsInput(): cdktf.IResolvable | JobSpecTemplateSpecVolumeProjectedSourcesSecretItems[] | undefined;
}
export declare class JobSpecTemplateSpecVolumeProjectedSourcesSecretList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobSpecTemplateSpecVolumeProjectedSourcesSecret[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobSpecTemplateSpecVolumeProjectedSourcesSecretOutputReference;
}
export interface JobSpecTemplateSpecVolumeProjectedSourcesServiceAccountToken {
    /**
    * Audience is the intended audience of the token
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#audience Job#audience}
    */
    readonly audience?: string;
    /**
    * ExpirationSeconds is the expected duration of validity of the service account token. It defaults to 1 hour and must be at least 10 minutes (600 seconds).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#expiration_seconds Job#expiration_seconds}
    */
    readonly expirationSeconds?: number;
    /**
    * Path specifies a relative path to the mount point of the projected volume.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#path Job#path}
    */
    readonly path: string;
}
export declare function jobSpecTemplateSpecVolumeProjectedSourcesServiceAccountTokenToTerraform(struct?: JobSpecTemplateSpecVolumeProjectedSourcesServiceAccountTokenOutputReference | JobSpecTemplateSpecVolumeProjectedSourcesServiceAccountToken): any;
export declare class JobSpecTemplateSpecVolumeProjectedSourcesServiceAccountTokenOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecVolumeProjectedSourcesServiceAccountToken | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeProjectedSourcesServiceAccountToken | undefined);
    private _audience?;
    get audience(): string;
    set audience(value: string);
    resetAudience(): void;
    get audienceInput(): string | undefined;
    private _expirationSeconds?;
    get expirationSeconds(): number;
    set expirationSeconds(value: number);
    resetExpirationSeconds(): void;
    get expirationSecondsInput(): number | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
}
export interface JobSpecTemplateSpecVolumeProjectedSources {
    /**
    * config_map block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#config_map Job#config_map}
    */
    readonly configMap?: JobSpecTemplateSpecVolumeProjectedSourcesConfigMap[] | cdktf.IResolvable;
    /**
    * downward_api block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#downward_api Job#downward_api}
    */
    readonly downwardApi?: JobSpecTemplateSpecVolumeProjectedSourcesDownwardApi;
    /**
    * secret block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#secret Job#secret}
    */
    readonly secret?: JobSpecTemplateSpecVolumeProjectedSourcesSecret[] | cdktf.IResolvable;
    /**
    * service_account_token block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#service_account_token Job#service_account_token}
    */
    readonly serviceAccountToken?: JobSpecTemplateSpecVolumeProjectedSourcesServiceAccountToken;
}
export declare function jobSpecTemplateSpecVolumeProjectedSourcesToTerraform(struct?: JobSpecTemplateSpecVolumeProjectedSources | cdktf.IResolvable): any;
export declare class JobSpecTemplateSpecVolumeProjectedSourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobSpecTemplateSpecVolumeProjectedSources | cdktf.IResolvable | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeProjectedSources | cdktf.IResolvable | undefined);
    private _configMap;
    get configMap(): JobSpecTemplateSpecVolumeProjectedSourcesConfigMapList;
    putConfigMap(value: JobSpecTemplateSpecVolumeProjectedSourcesConfigMap[] | cdktf.IResolvable): void;
    resetConfigMap(): void;
    get configMapInput(): cdktf.IResolvable | JobSpecTemplateSpecVolumeProjectedSourcesConfigMap[] | undefined;
    private _downwardApi;
    get downwardApi(): JobSpecTemplateSpecVolumeProjectedSourcesDownwardApiOutputReference;
    putDownwardApi(value: JobSpecTemplateSpecVolumeProjectedSourcesDownwardApi): void;
    resetDownwardApi(): void;
    get downwardApiInput(): JobSpecTemplateSpecVolumeProjectedSourcesDownwardApi | undefined;
    private _secret;
    get secret(): JobSpecTemplateSpecVolumeProjectedSourcesSecretList;
    putSecret(value: JobSpecTemplateSpecVolumeProjectedSourcesSecret[] | cdktf.IResolvable): void;
    resetSecret(): void;
    get secretInput(): cdktf.IResolvable | JobSpecTemplateSpecVolumeProjectedSourcesSecret[] | undefined;
    private _serviceAccountToken;
    get serviceAccountToken(): JobSpecTemplateSpecVolumeProjectedSourcesServiceAccountTokenOutputReference;
    putServiceAccountToken(value: JobSpecTemplateSpecVolumeProjectedSourcesServiceAccountToken): void;
    resetServiceAccountToken(): void;
    get serviceAccountTokenInput(): JobSpecTemplateSpecVolumeProjectedSourcesServiceAccountToken | undefined;
}
export declare class JobSpecTemplateSpecVolumeProjectedSourcesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobSpecTemplateSpecVolumeProjectedSources[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobSpecTemplateSpecVolumeProjectedSourcesOutputReference;
}
export interface JobSpecTemplateSpecVolumeProjected {
    /**
    * Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#default_mode Job#default_mode}
    */
    readonly defaultMode?: string;
    /**
    * sources block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#sources Job#sources}
    */
    readonly sources: JobSpecTemplateSpecVolumeProjectedSources[] | cdktf.IResolvable;
}
export declare function jobSpecTemplateSpecVolumeProjectedToTerraform(struct?: JobSpecTemplateSpecVolumeProjected | cdktf.IResolvable): any;
export declare class JobSpecTemplateSpecVolumeProjectedOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobSpecTemplateSpecVolumeProjected | cdktf.IResolvable | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeProjected | cdktf.IResolvable | undefined);
    private _defaultMode?;
    get defaultMode(): string;
    set defaultMode(value: string);
    resetDefaultMode(): void;
    get defaultModeInput(): string | undefined;
    private _sources;
    get sources(): JobSpecTemplateSpecVolumeProjectedSourcesList;
    putSources(value: JobSpecTemplateSpecVolumeProjectedSources[] | cdktf.IResolvable): void;
    get sourcesInput(): cdktf.IResolvable | JobSpecTemplateSpecVolumeProjectedSources[] | undefined;
}
export declare class JobSpecTemplateSpecVolumeProjectedList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobSpecTemplateSpecVolumeProjected[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobSpecTemplateSpecVolumeProjectedOutputReference;
}
export interface JobSpecTemplateSpecVolumeQuobyte {
    /**
    * Group to map volume access to Default is no group
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#group Job#group}
    */
    readonly group?: string;
    /**
    * Whether to force the Quobyte volume to be mounted with read-only permissions. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#read_only Job#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Registry represents a single or multiple Quobyte Registry services specified as a string as host:port pair (multiple entries are separated with commas) which acts as the central registry for volumes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#registry Job#registry}
    */
    readonly registry: string;
    /**
    * User to map volume access to Defaults to serivceaccount user
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#user Job#user}
    */
    readonly user?: string;
    /**
    * Volume is a string that references an already created Quobyte volume by name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#volume Job#volume}
    */
    readonly volume: string;
}
export declare function jobSpecTemplateSpecVolumeQuobyteToTerraform(struct?: JobSpecTemplateSpecVolumeQuobyteOutputReference | JobSpecTemplateSpecVolumeQuobyte): any;
export declare class JobSpecTemplateSpecVolumeQuobyteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecVolumeQuobyte | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeQuobyte | undefined);
    private _group?;
    get group(): string;
    set group(value: string);
    resetGroup(): void;
    get groupInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _registry?;
    get registry(): string;
    set registry(value: string);
    get registryInput(): string | undefined;
    private _user?;
    get user(): string;
    set user(value: string);
    resetUser(): void;
    get userInput(): string | undefined;
    private _volume?;
    get volume(): string;
    set volume(value: string);
    get volumeInput(): string | undefined;
}
export interface JobSpecTemplateSpecVolumeRbdSecretRef {
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#name Job#name}
    */
    readonly name?: string;
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#namespace Job#namespace}
    */
    readonly namespace?: string;
}
export declare function jobSpecTemplateSpecVolumeRbdSecretRefToTerraform(struct?: JobSpecTemplateSpecVolumeRbdSecretRefOutputReference | JobSpecTemplateSpecVolumeRbdSecretRef): any;
export declare class JobSpecTemplateSpecVolumeRbdSecretRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecVolumeRbdSecretRef | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeRbdSecretRef | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
}
export interface JobSpecTemplateSpecVolumeRbd {
    /**
    * A collection of Ceph monitors. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#ceph_monitors Job#ceph_monitors}
    */
    readonly cephMonitors: string[];
    /**
    * Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: http://kubernetes.io/docs/user-guide/volumes#rbd
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#fs_type Job#fs_type}
    */
    readonly fsType?: string;
    /**
    * Keyring is the path to key ring for RBDUser. Default is /etc/ceph/keyring. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#keyring Job#keyring}
    */
    readonly keyring?: string;
    /**
    * The rados user name. Default is admin. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#rados_user Job#rados_user}
    */
    readonly radosUser?: string;
    /**
    * The rados image name. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#rbd_image Job#rbd_image}
    */
    readonly rbdImage: string;
    /**
    * The rados pool name. Default is rbd. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#rbd_pool Job#rbd_pool}
    */
    readonly rbdPool?: string;
    /**
    * Whether to force the read-only setting in VolumeMounts. Defaults to false. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#read_only Job#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * secret_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#secret_ref Job#secret_ref}
    */
    readonly secretRef?: JobSpecTemplateSpecVolumeRbdSecretRef;
}
export declare function jobSpecTemplateSpecVolumeRbdToTerraform(struct?: JobSpecTemplateSpecVolumeRbdOutputReference | JobSpecTemplateSpecVolumeRbd): any;
export declare class JobSpecTemplateSpecVolumeRbdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecVolumeRbd | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeRbd | undefined);
    private _cephMonitors?;
    get cephMonitors(): string[];
    set cephMonitors(value: string[]);
    get cephMonitorsInput(): string[] | undefined;
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _keyring?;
    get keyring(): string;
    set keyring(value: string);
    resetKeyring(): void;
    get keyringInput(): string | undefined;
    private _radosUser?;
    get radosUser(): string;
    set radosUser(value: string);
    resetRadosUser(): void;
    get radosUserInput(): string | undefined;
    private _rbdImage?;
    get rbdImage(): string;
    set rbdImage(value: string);
    get rbdImageInput(): string | undefined;
    private _rbdPool?;
    get rbdPool(): string;
    set rbdPool(value: string);
    resetRbdPool(): void;
    get rbdPoolInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _secretRef;
    get secretRef(): JobSpecTemplateSpecVolumeRbdSecretRefOutputReference;
    putSecretRef(value: JobSpecTemplateSpecVolumeRbdSecretRef): void;
    resetSecretRef(): void;
    get secretRefInput(): JobSpecTemplateSpecVolumeRbdSecretRef | undefined;
}
export interface JobSpecTemplateSpecVolumeSecretItems {
    /**
    * The key to project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#key Job#key}
    */
    readonly key?: string;
    /**
    * Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#mode Job#mode}
    */
    readonly mode?: string;
    /**
    * The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#path Job#path}
    */
    readonly path?: string;
}
export declare function jobSpecTemplateSpecVolumeSecretItemsToTerraform(struct?: JobSpecTemplateSpecVolumeSecretItems | cdktf.IResolvable): any;
export declare class JobSpecTemplateSpecVolumeSecretItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobSpecTemplateSpecVolumeSecretItems | cdktf.IResolvable | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeSecretItems | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
}
export declare class JobSpecTemplateSpecVolumeSecretItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobSpecTemplateSpecVolumeSecretItems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobSpecTemplateSpecVolumeSecretItemsOutputReference;
}
export interface JobSpecTemplateSpecVolumeSecret {
    /**
    * Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#default_mode Job#default_mode}
    */
    readonly defaultMode?: string;
    /**
    * Optional: Specify whether the Secret or its keys must be defined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#optional Job#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
    /**
    * Name of the secret in the pod's namespace to use. More info: http://kubernetes.io/docs/user-guide/volumes#secrets
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#secret_name Job#secret_name}
    */
    readonly secretName?: string;
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#items Job#items}
    */
    readonly items?: JobSpecTemplateSpecVolumeSecretItems[] | cdktf.IResolvable;
}
export declare function jobSpecTemplateSpecVolumeSecretToTerraform(struct?: JobSpecTemplateSpecVolumeSecretOutputReference | JobSpecTemplateSpecVolumeSecret): any;
export declare class JobSpecTemplateSpecVolumeSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecVolumeSecret | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeSecret | undefined);
    private _defaultMode?;
    get defaultMode(): string;
    set defaultMode(value: string);
    resetDefaultMode(): void;
    get defaultModeInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
    private _secretName?;
    get secretName(): string;
    set secretName(value: string);
    resetSecretName(): void;
    get secretNameInput(): string | undefined;
    private _items;
    get items(): JobSpecTemplateSpecVolumeSecretItemsList;
    putItems(value: JobSpecTemplateSpecVolumeSecretItems[] | cdktf.IResolvable): void;
    resetItems(): void;
    get itemsInput(): cdktf.IResolvable | JobSpecTemplateSpecVolumeSecretItems[] | undefined;
}
export interface JobSpecTemplateSpecVolumeVsphereVolume {
    /**
    * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#fs_type Job#fs_type}
    */
    readonly fsType?: string;
    /**
    * Path that identifies vSphere volume vmdk
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#volume_path Job#volume_path}
    */
    readonly volumePath: string;
}
export declare function jobSpecTemplateSpecVolumeVsphereVolumeToTerraform(struct?: JobSpecTemplateSpecVolumeVsphereVolumeOutputReference | JobSpecTemplateSpecVolumeVsphereVolume): any;
export declare class JobSpecTemplateSpecVolumeVsphereVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpecVolumeVsphereVolume | undefined;
    set internalValue(value: JobSpecTemplateSpecVolumeVsphereVolume | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _volumePath?;
    get volumePath(): string;
    set volumePath(value: string);
    get volumePathInput(): string | undefined;
}
export interface JobSpecTemplateSpecVolume {
    /**
    * Volume's name. Must be a DNS_LABEL and unique within the pod. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#name Job#name}
    */
    readonly name?: string;
    /**
    * aws_elastic_block_store block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#aws_elastic_block_store Job#aws_elastic_block_store}
    */
    readonly awsElasticBlockStore?: JobSpecTemplateSpecVolumeAwsElasticBlockStore;
    /**
    * azure_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#azure_disk Job#azure_disk}
    */
    readonly azureDisk?: JobSpecTemplateSpecVolumeAzureDisk;
    /**
    * azure_file block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#azure_file Job#azure_file}
    */
    readonly azureFile?: JobSpecTemplateSpecVolumeAzureFile;
    /**
    * ceph_fs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#ceph_fs Job#ceph_fs}
    */
    readonly cephFs?: JobSpecTemplateSpecVolumeCephFs;
    /**
    * cinder block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#cinder Job#cinder}
    */
    readonly cinder?: JobSpecTemplateSpecVolumeCinder;
    /**
    * config_map block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#config_map Job#config_map}
    */
    readonly configMap?: JobSpecTemplateSpecVolumeConfigMap;
    /**
    * csi block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#csi Job#csi}
    */
    readonly csi?: JobSpecTemplateSpecVolumeCsi;
    /**
    * downward_api block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#downward_api Job#downward_api}
    */
    readonly downwardApi?: JobSpecTemplateSpecVolumeDownwardApi;
    /**
    * empty_dir block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#empty_dir Job#empty_dir}
    */
    readonly emptyDir?: JobSpecTemplateSpecVolumeEmptyDir;
    /**
    * fc block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#fc Job#fc}
    */
    readonly fc?: JobSpecTemplateSpecVolumeFc;
    /**
    * flex_volume block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#flex_volume Job#flex_volume}
    */
    readonly flexVolume?: JobSpecTemplateSpecVolumeFlexVolume;
    /**
    * flocker block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#flocker Job#flocker}
    */
    readonly flocker?: JobSpecTemplateSpecVolumeFlocker;
    /**
    * gce_persistent_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#gce_persistent_disk Job#gce_persistent_disk}
    */
    readonly gcePersistentDisk?: JobSpecTemplateSpecVolumeGcePersistentDisk;
    /**
    * git_repo block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#git_repo Job#git_repo}
    */
    readonly gitRepo?: JobSpecTemplateSpecVolumeGitRepo;
    /**
    * glusterfs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#glusterfs Job#glusterfs}
    */
    readonly glusterfs?: JobSpecTemplateSpecVolumeGlusterfs;
    /**
    * host_path block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#host_path Job#host_path}
    */
    readonly hostPath?: JobSpecTemplateSpecVolumeHostPath;
    /**
    * iscsi block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#iscsi Job#iscsi}
    */
    readonly iscsi?: JobSpecTemplateSpecVolumeIscsi;
    /**
    * local block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#local Job#local}
    */
    readonly local?: JobSpecTemplateSpecVolumeLocal;
    /**
    * nfs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#nfs Job#nfs}
    */
    readonly nfs?: JobSpecTemplateSpecVolumeNfs;
    /**
    * persistent_volume_claim block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#persistent_volume_claim Job#persistent_volume_claim}
    */
    readonly persistentVolumeClaim?: JobSpecTemplateSpecVolumePersistentVolumeClaim;
    /**
    * photon_persistent_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#photon_persistent_disk Job#photon_persistent_disk}
    */
    readonly photonPersistentDisk?: JobSpecTemplateSpecVolumePhotonPersistentDisk;
    /**
    * projected block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#projected Job#projected}
    */
    readonly projected?: JobSpecTemplateSpecVolumeProjected[] | cdktf.IResolvable;
    /**
    * quobyte block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#quobyte Job#quobyte}
    */
    readonly quobyte?: JobSpecTemplateSpecVolumeQuobyte;
    /**
    * rbd block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#rbd Job#rbd}
    */
    readonly rbd?: JobSpecTemplateSpecVolumeRbd;
    /**
    * secret block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#secret Job#secret}
    */
    readonly secret?: JobSpecTemplateSpecVolumeSecret;
    /**
    * vsphere_volume block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#vsphere_volume Job#vsphere_volume}
    */
    readonly vsphereVolume?: JobSpecTemplateSpecVolumeVsphereVolume;
}
export declare function jobSpecTemplateSpecVolumeToTerraform(struct?: JobSpecTemplateSpecVolume | cdktf.IResolvable): any;
export declare class JobSpecTemplateSpecVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobSpecTemplateSpecVolume | cdktf.IResolvable | undefined;
    set internalValue(value: JobSpecTemplateSpecVolume | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _awsElasticBlockStore;
    get awsElasticBlockStore(): JobSpecTemplateSpecVolumeAwsElasticBlockStoreOutputReference;
    putAwsElasticBlockStore(value: JobSpecTemplateSpecVolumeAwsElasticBlockStore): void;
    resetAwsElasticBlockStore(): void;
    get awsElasticBlockStoreInput(): JobSpecTemplateSpecVolumeAwsElasticBlockStore | undefined;
    private _azureDisk;
    get azureDisk(): JobSpecTemplateSpecVolumeAzureDiskOutputReference;
    putAzureDisk(value: JobSpecTemplateSpecVolumeAzureDisk): void;
    resetAzureDisk(): void;
    get azureDiskInput(): JobSpecTemplateSpecVolumeAzureDisk | undefined;
    private _azureFile;
    get azureFile(): JobSpecTemplateSpecVolumeAzureFileOutputReference;
    putAzureFile(value: JobSpecTemplateSpecVolumeAzureFile): void;
    resetAzureFile(): void;
    get azureFileInput(): JobSpecTemplateSpecVolumeAzureFile | undefined;
    private _cephFs;
    get cephFs(): JobSpecTemplateSpecVolumeCephFsOutputReference;
    putCephFs(value: JobSpecTemplateSpecVolumeCephFs): void;
    resetCephFs(): void;
    get cephFsInput(): JobSpecTemplateSpecVolumeCephFs | undefined;
    private _cinder;
    get cinder(): JobSpecTemplateSpecVolumeCinderOutputReference;
    putCinder(value: JobSpecTemplateSpecVolumeCinder): void;
    resetCinder(): void;
    get cinderInput(): JobSpecTemplateSpecVolumeCinder | undefined;
    private _configMap;
    get configMap(): JobSpecTemplateSpecVolumeConfigMapOutputReference;
    putConfigMap(value: JobSpecTemplateSpecVolumeConfigMap): void;
    resetConfigMap(): void;
    get configMapInput(): JobSpecTemplateSpecVolumeConfigMap | undefined;
    private _csi;
    get csi(): JobSpecTemplateSpecVolumeCsiOutputReference;
    putCsi(value: JobSpecTemplateSpecVolumeCsi): void;
    resetCsi(): void;
    get csiInput(): JobSpecTemplateSpecVolumeCsi | undefined;
    private _downwardApi;
    get downwardApi(): JobSpecTemplateSpecVolumeDownwardApiOutputReference;
    putDownwardApi(value: JobSpecTemplateSpecVolumeDownwardApi): void;
    resetDownwardApi(): void;
    get downwardApiInput(): JobSpecTemplateSpecVolumeDownwardApi | undefined;
    private _emptyDir;
    get emptyDir(): JobSpecTemplateSpecVolumeEmptyDirOutputReference;
    putEmptyDir(value: JobSpecTemplateSpecVolumeEmptyDir): void;
    resetEmptyDir(): void;
    get emptyDirInput(): JobSpecTemplateSpecVolumeEmptyDir | undefined;
    private _fc;
    get fc(): JobSpecTemplateSpecVolumeFcOutputReference;
    putFc(value: JobSpecTemplateSpecVolumeFc): void;
    resetFc(): void;
    get fcInput(): JobSpecTemplateSpecVolumeFc | undefined;
    private _flexVolume;
    get flexVolume(): JobSpecTemplateSpecVolumeFlexVolumeOutputReference;
    putFlexVolume(value: JobSpecTemplateSpecVolumeFlexVolume): void;
    resetFlexVolume(): void;
    get flexVolumeInput(): JobSpecTemplateSpecVolumeFlexVolume | undefined;
    private _flocker;
    get flocker(): JobSpecTemplateSpecVolumeFlockerOutputReference;
    putFlocker(value: JobSpecTemplateSpecVolumeFlocker): void;
    resetFlocker(): void;
    get flockerInput(): JobSpecTemplateSpecVolumeFlocker | undefined;
    private _gcePersistentDisk;
    get gcePersistentDisk(): JobSpecTemplateSpecVolumeGcePersistentDiskOutputReference;
    putGcePersistentDisk(value: JobSpecTemplateSpecVolumeGcePersistentDisk): void;
    resetGcePersistentDisk(): void;
    get gcePersistentDiskInput(): JobSpecTemplateSpecVolumeGcePersistentDisk | undefined;
    private _gitRepo;
    get gitRepo(): JobSpecTemplateSpecVolumeGitRepoOutputReference;
    putGitRepo(value: JobSpecTemplateSpecVolumeGitRepo): void;
    resetGitRepo(): void;
    get gitRepoInput(): JobSpecTemplateSpecVolumeGitRepo | undefined;
    private _glusterfs;
    get glusterfs(): JobSpecTemplateSpecVolumeGlusterfsOutputReference;
    putGlusterfs(value: JobSpecTemplateSpecVolumeGlusterfs): void;
    resetGlusterfs(): void;
    get glusterfsInput(): JobSpecTemplateSpecVolumeGlusterfs | undefined;
    private _hostPath;
    get hostPath(): JobSpecTemplateSpecVolumeHostPathOutputReference;
    putHostPath(value: JobSpecTemplateSpecVolumeHostPath): void;
    resetHostPath(): void;
    get hostPathInput(): JobSpecTemplateSpecVolumeHostPath | undefined;
    private _iscsi;
    get iscsi(): JobSpecTemplateSpecVolumeIscsiOutputReference;
    putIscsi(value: JobSpecTemplateSpecVolumeIscsi): void;
    resetIscsi(): void;
    get iscsiInput(): JobSpecTemplateSpecVolumeIscsi | undefined;
    private _local;
    get local(): JobSpecTemplateSpecVolumeLocalOutputReference;
    putLocal(value: JobSpecTemplateSpecVolumeLocal): void;
    resetLocal(): void;
    get localInput(): JobSpecTemplateSpecVolumeLocal | undefined;
    private _nfs;
    get nfs(): JobSpecTemplateSpecVolumeNfsOutputReference;
    putNfs(value: JobSpecTemplateSpecVolumeNfs): void;
    resetNfs(): void;
    get nfsInput(): JobSpecTemplateSpecVolumeNfs | undefined;
    private _persistentVolumeClaim;
    get persistentVolumeClaim(): JobSpecTemplateSpecVolumePersistentVolumeClaimOutputReference;
    putPersistentVolumeClaim(value: JobSpecTemplateSpecVolumePersistentVolumeClaim): void;
    resetPersistentVolumeClaim(): void;
    get persistentVolumeClaimInput(): JobSpecTemplateSpecVolumePersistentVolumeClaim | undefined;
    private _photonPersistentDisk;
    get photonPersistentDisk(): JobSpecTemplateSpecVolumePhotonPersistentDiskOutputReference;
    putPhotonPersistentDisk(value: JobSpecTemplateSpecVolumePhotonPersistentDisk): void;
    resetPhotonPersistentDisk(): void;
    get photonPersistentDiskInput(): JobSpecTemplateSpecVolumePhotonPersistentDisk | undefined;
    private _projected;
    get projected(): JobSpecTemplateSpecVolumeProjectedList;
    putProjected(value: JobSpecTemplateSpecVolumeProjected[] | cdktf.IResolvable): void;
    resetProjected(): void;
    get projectedInput(): cdktf.IResolvable | JobSpecTemplateSpecVolumeProjected[] | undefined;
    private _quobyte;
    get quobyte(): JobSpecTemplateSpecVolumeQuobyteOutputReference;
    putQuobyte(value: JobSpecTemplateSpecVolumeQuobyte): void;
    resetQuobyte(): void;
    get quobyteInput(): JobSpecTemplateSpecVolumeQuobyte | undefined;
    private _rbd;
    get rbd(): JobSpecTemplateSpecVolumeRbdOutputReference;
    putRbd(value: JobSpecTemplateSpecVolumeRbd): void;
    resetRbd(): void;
    get rbdInput(): JobSpecTemplateSpecVolumeRbd | undefined;
    private _secret;
    get secret(): JobSpecTemplateSpecVolumeSecretOutputReference;
    putSecret(value: JobSpecTemplateSpecVolumeSecret): void;
    resetSecret(): void;
    get secretInput(): JobSpecTemplateSpecVolumeSecret | undefined;
    private _vsphereVolume;
    get vsphereVolume(): JobSpecTemplateSpecVolumeVsphereVolumeOutputReference;
    putVsphereVolume(value: JobSpecTemplateSpecVolumeVsphereVolume): void;
    resetVsphereVolume(): void;
    get vsphereVolumeInput(): JobSpecTemplateSpecVolumeVsphereVolume | undefined;
}
export declare class JobSpecTemplateSpecVolumeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobSpecTemplateSpecVolume[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobSpecTemplateSpecVolumeOutputReference;
}
export interface JobSpecTemplateSpec {
    /**
    * Optional duration in seconds the pod may be active on the node relative to StartTime before the system will actively try to mark it failed and kill associated containers. Value must be a positive integer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#active_deadline_seconds Job#active_deadline_seconds}
    */
    readonly activeDeadlineSeconds?: number;
    /**
    * AutomountServiceAccountToken indicates whether a service account token should be automatically mounted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#automount_service_account_token Job#automount_service_account_token}
    */
    readonly automountServiceAccountToken?: boolean | cdktf.IResolvable;
    /**
    * Set DNS policy for containers within the pod. Valid values are 'ClusterFirstWithHostNet', 'ClusterFirst', 'Default' or 'None'. DNS parameters given in DNSConfig will be merged with the policy selected with DNSPolicy. To have DNS options set along with hostNetwork, you have to specify DNS policy explicitly to 'ClusterFirstWithHostNet'. Optional: Defaults to 'ClusterFirst', see [Kubernetes reference](https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#pod-s-dns-policy).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#dns_policy Job#dns_policy}
    */
    readonly dnsPolicy?: string;
    /**
    * Enables generating environment variables for service discovery. Defaults to true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#enable_service_links Job#enable_service_links}
    */
    readonly enableServiceLinks?: boolean | cdktf.IResolvable;
    /**
    * Use the host's ipc namespace. Optional: Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#host_ipc Job#host_ipc}
    */
    readonly hostIpc?: boolean | cdktf.IResolvable;
    /**
    * Host networking requested for this pod. Use the host's network namespace. If this option is set, the ports that will be used must be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#host_network Job#host_network}
    */
    readonly hostNetwork?: boolean | cdktf.IResolvable;
    /**
    * Use the host's pid namespace.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#host_pid Job#host_pid}
    */
    readonly hostPid?: boolean | cdktf.IResolvable;
    /**
    * Specifies the hostname of the Pod If not specified, the pod's hostname will be set to a system-defined value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#hostname Job#hostname}
    */
    readonly hostname?: string;
    /**
    * NodeName is a request to schedule this pod onto a specific node. If it is non-empty, the scheduler simply schedules this pod onto that node, assuming that it fits resource requirements.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#node_name Job#node_name}
    */
    readonly nodeName?: string;
    /**
    * NodeSelector is a selector which must be true for the pod to fit on a node. Selector which must match a node's labels for the pod to be scheduled on that node. More info: http://kubernetes.io/docs/user-guide/node-selection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#node_selector Job#node_selector}
    */
    readonly nodeSelector?: {
        [key: string]: string;
    };
    /**
    * If specified, indicates the pod's priority. "system-node-critical" and "system-cluster-critical" are two special keywords which indicate the highest priorities with the former being the highest priority. Any other name must be defined by creating a PriorityClass object with that name. If not specified, the pod priority will be default or zero if there is no default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#priority_class_name Job#priority_class_name}
    */
    readonly priorityClassName?: string;
    /**
    * Restart policy for all containers within the pod. One of Always, OnFailure, Never. More info: http://kubernetes.io/docs/user-guide/pod-states#restartpolicy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#restart_policy Job#restart_policy}
    */
    readonly restartPolicy?: string;
    /**
    * ServiceAccountName is the name of the ServiceAccount to use to run this pod. More info: http://releases.k8s.io/HEAD/docs/design/service_accounts.md.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#service_account_name Job#service_account_name}
    */
    readonly serviceAccountName?: string;
    /**
    * Share a single process namespace between all of the containers in a pod. When this is set containers will be able to view and signal processes from other containers in the same pod, and the first process in each container will not be assigned PID 1. HostPID and ShareProcessNamespace cannot both be set. Optional: Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#share_process_namespace Job#share_process_namespace}
    */
    readonly shareProcessNamespace?: boolean | cdktf.IResolvable;
    /**
    * If specified, the fully qualified Pod hostname will be "...svc.". If not specified, the pod will not have a domainname at all..
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#subdomain Job#subdomain}
    */
    readonly subdomain?: string;
    /**
    * Optional duration in seconds the pod needs to terminate gracefully. May be decreased in delete request. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period will be used instead. The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#termination_grace_period_seconds Job#termination_grace_period_seconds}
    */
    readonly terminationGracePeriodSeconds?: number;
    /**
    * affinity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#affinity Job#affinity}
    */
    readonly affinity?: JobSpecTemplateSpecAffinity;
    /**
    * container block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#container Job#container}
    */
    readonly container?: JobSpecTemplateSpecContainer[] | cdktf.IResolvable;
    /**
    * dns_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#dns_config Job#dns_config}
    */
    readonly dnsConfig?: JobSpecTemplateSpecDnsConfig;
    /**
    * host_aliases block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#host_aliases Job#host_aliases}
    */
    readonly hostAliases?: JobSpecTemplateSpecHostAliases[] | cdktf.IResolvable;
    /**
    * image_pull_secrets block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#image_pull_secrets Job#image_pull_secrets}
    */
    readonly imagePullSecrets?: JobSpecTemplateSpecImagePullSecrets[] | cdktf.IResolvable;
    /**
    * init_container block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#init_container Job#init_container}
    */
    readonly initContainer?: JobSpecTemplateSpecInitContainer[] | cdktf.IResolvable;
    /**
    * readiness_gate block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#readiness_gate Job#readiness_gate}
    */
    readonly readinessGate?: JobSpecTemplateSpecReadinessGate[] | cdktf.IResolvable;
    /**
    * security_context block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#security_context Job#security_context}
    */
    readonly securityContext?: JobSpecTemplateSpecSecurityContext;
    /**
    * toleration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#toleration Job#toleration}
    */
    readonly toleration?: JobSpecTemplateSpecToleration[] | cdktf.IResolvable;
    /**
    * topology_spread_constraint block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#topology_spread_constraint Job#topology_spread_constraint}
    */
    readonly topologySpreadConstraint?: JobSpecTemplateSpecTopologySpreadConstraint[] | cdktf.IResolvable;
    /**
    * volume block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#volume Job#volume}
    */
    readonly volume?: JobSpecTemplateSpecVolume[] | cdktf.IResolvable;
}
export declare function jobSpecTemplateSpecToTerraform(struct?: JobSpecTemplateSpecOutputReference | JobSpecTemplateSpec): any;
export declare class JobSpecTemplateSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplateSpec | undefined;
    set internalValue(value: JobSpecTemplateSpec | undefined);
    private _activeDeadlineSeconds?;
    get activeDeadlineSeconds(): number;
    set activeDeadlineSeconds(value: number);
    resetActiveDeadlineSeconds(): void;
    get activeDeadlineSecondsInput(): number | undefined;
    private _automountServiceAccountToken?;
    get automountServiceAccountToken(): boolean | cdktf.IResolvable;
    set automountServiceAccountToken(value: boolean | cdktf.IResolvable);
    resetAutomountServiceAccountToken(): void;
    get automountServiceAccountTokenInput(): boolean | cdktf.IResolvable | undefined;
    private _dnsPolicy?;
    get dnsPolicy(): string;
    set dnsPolicy(value: string);
    resetDnsPolicy(): void;
    get dnsPolicyInput(): string | undefined;
    private _enableServiceLinks?;
    get enableServiceLinks(): boolean | cdktf.IResolvable;
    set enableServiceLinks(value: boolean | cdktf.IResolvable);
    resetEnableServiceLinks(): void;
    get enableServiceLinksInput(): boolean | cdktf.IResolvable | undefined;
    private _hostIpc?;
    get hostIpc(): boolean | cdktf.IResolvable;
    set hostIpc(value: boolean | cdktf.IResolvable);
    resetHostIpc(): void;
    get hostIpcInput(): boolean | cdktf.IResolvable | undefined;
    private _hostNetwork?;
    get hostNetwork(): boolean | cdktf.IResolvable;
    set hostNetwork(value: boolean | cdktf.IResolvable);
    resetHostNetwork(): void;
    get hostNetworkInput(): boolean | cdktf.IResolvable | undefined;
    private _hostPid?;
    get hostPid(): boolean | cdktf.IResolvable;
    set hostPid(value: boolean | cdktf.IResolvable);
    resetHostPid(): void;
    get hostPidInput(): boolean | cdktf.IResolvable | undefined;
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    resetHostname(): void;
    get hostnameInput(): string | undefined;
    private _nodeName?;
    get nodeName(): string;
    set nodeName(value: string);
    resetNodeName(): void;
    get nodeNameInput(): string | undefined;
    private _nodeSelector?;
    get nodeSelector(): {
        [key: string]: string;
    };
    set nodeSelector(value: {
        [key: string]: string;
    });
    resetNodeSelector(): void;
    get nodeSelectorInput(): {
        [key: string]: string;
    } | undefined;
    private _priorityClassName?;
    get priorityClassName(): string;
    set priorityClassName(value: string);
    resetPriorityClassName(): void;
    get priorityClassNameInput(): string | undefined;
    private _restartPolicy?;
    get restartPolicy(): string;
    set restartPolicy(value: string);
    resetRestartPolicy(): void;
    get restartPolicyInput(): string | undefined;
    private _serviceAccountName?;
    get serviceAccountName(): string;
    set serviceAccountName(value: string);
    resetServiceAccountName(): void;
    get serviceAccountNameInput(): string | undefined;
    private _shareProcessNamespace?;
    get shareProcessNamespace(): boolean | cdktf.IResolvable;
    set shareProcessNamespace(value: boolean | cdktf.IResolvable);
    resetShareProcessNamespace(): void;
    get shareProcessNamespaceInput(): boolean | cdktf.IResolvable | undefined;
    private _subdomain?;
    get subdomain(): string;
    set subdomain(value: string);
    resetSubdomain(): void;
    get subdomainInput(): string | undefined;
    private _terminationGracePeriodSeconds?;
    get terminationGracePeriodSeconds(): number;
    set terminationGracePeriodSeconds(value: number);
    resetTerminationGracePeriodSeconds(): void;
    get terminationGracePeriodSecondsInput(): number | undefined;
    private _affinity;
    get affinity(): JobSpecTemplateSpecAffinityOutputReference;
    putAffinity(value: JobSpecTemplateSpecAffinity): void;
    resetAffinity(): void;
    get affinityInput(): JobSpecTemplateSpecAffinity | undefined;
    private _container;
    get container(): JobSpecTemplateSpecContainerList;
    putContainer(value: JobSpecTemplateSpecContainer[] | cdktf.IResolvable): void;
    resetContainer(): void;
    get containerInput(): cdktf.IResolvable | JobSpecTemplateSpecContainer[] | undefined;
    private _dnsConfig;
    get dnsConfig(): JobSpecTemplateSpecDnsConfigOutputReference;
    putDnsConfig(value: JobSpecTemplateSpecDnsConfig): void;
    resetDnsConfig(): void;
    get dnsConfigInput(): JobSpecTemplateSpecDnsConfig | undefined;
    private _hostAliases;
    get hostAliases(): JobSpecTemplateSpecHostAliasesList;
    putHostAliases(value: JobSpecTemplateSpecHostAliases[] | cdktf.IResolvable): void;
    resetHostAliases(): void;
    get hostAliasesInput(): cdktf.IResolvable | JobSpecTemplateSpecHostAliases[] | undefined;
    private _imagePullSecrets;
    get imagePullSecrets(): JobSpecTemplateSpecImagePullSecretsList;
    putImagePullSecrets(value: JobSpecTemplateSpecImagePullSecrets[] | cdktf.IResolvable): void;
    resetImagePullSecrets(): void;
    get imagePullSecretsInput(): cdktf.IResolvable | JobSpecTemplateSpecImagePullSecrets[] | undefined;
    private _initContainer;
    get initContainer(): JobSpecTemplateSpecInitContainerList;
    putInitContainer(value: JobSpecTemplateSpecInitContainer[] | cdktf.IResolvable): void;
    resetInitContainer(): void;
    get initContainerInput(): cdktf.IResolvable | JobSpecTemplateSpecInitContainer[] | undefined;
    private _readinessGate;
    get readinessGate(): JobSpecTemplateSpecReadinessGateList;
    putReadinessGate(value: JobSpecTemplateSpecReadinessGate[] | cdktf.IResolvable): void;
    resetReadinessGate(): void;
    get readinessGateInput(): cdktf.IResolvable | JobSpecTemplateSpecReadinessGate[] | undefined;
    private _securityContext;
    get securityContext(): JobSpecTemplateSpecSecurityContextOutputReference;
    putSecurityContext(value: JobSpecTemplateSpecSecurityContext): void;
    resetSecurityContext(): void;
    get securityContextInput(): JobSpecTemplateSpecSecurityContext | undefined;
    private _toleration;
    get toleration(): JobSpecTemplateSpecTolerationList;
    putToleration(value: JobSpecTemplateSpecToleration[] | cdktf.IResolvable): void;
    resetToleration(): void;
    get tolerationInput(): cdktf.IResolvable | JobSpecTemplateSpecToleration[] | undefined;
    private _topologySpreadConstraint;
    get topologySpreadConstraint(): JobSpecTemplateSpecTopologySpreadConstraintList;
    putTopologySpreadConstraint(value: JobSpecTemplateSpecTopologySpreadConstraint[] | cdktf.IResolvable): void;
    resetTopologySpreadConstraint(): void;
    get topologySpreadConstraintInput(): cdktf.IResolvable | JobSpecTemplateSpecTopologySpreadConstraint[] | undefined;
    private _volume;
    get volume(): JobSpecTemplateSpecVolumeList;
    putVolume(value: JobSpecTemplateSpecVolume[] | cdktf.IResolvable): void;
    resetVolume(): void;
    get volumeInput(): cdktf.IResolvable | JobSpecTemplateSpecVolume[] | undefined;
}
export interface JobSpecTemplate {
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#metadata Job#metadata}
    */
    readonly metadata: JobSpecTemplateMetadata;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#spec Job#spec}
    */
    readonly spec?: JobSpecTemplateSpec;
}
export declare function jobSpecTemplateToTerraform(struct?: JobSpecTemplateOutputReference | JobSpecTemplate): any;
export declare class JobSpecTemplateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpecTemplate | undefined;
    set internalValue(value: JobSpecTemplate | undefined);
    private _metadata;
    get metadata(): JobSpecTemplateMetadataOutputReference;
    putMetadata(value: JobSpecTemplateMetadata): void;
    get metadataInput(): JobSpecTemplateMetadata | undefined;
    private _spec;
    get spec(): JobSpecTemplateSpecOutputReference;
    putSpec(value: JobSpecTemplateSpec): void;
    resetSpec(): void;
    get specInput(): JobSpecTemplateSpec | undefined;
}
export interface JobSpec {
    /**
    * Optional duration in seconds the pod may be active on the node relative to StartTime before the system will actively try to mark it failed and kill associated containers. Value must be a positive integer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#active_deadline_seconds Job#active_deadline_seconds}
    */
    readonly activeDeadlineSeconds?: number;
    /**
    * Specifies the number of retries before marking this job failed. Defaults to 6
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#backoff_limit Job#backoff_limit}
    */
    readonly backoffLimit?: number;
    /**
    * CompletionMode specifies how Pod completions are tracked.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#completion_mode Job#completion_mode}
    */
    readonly completionMode?: string;
    /**
    * Specifies the desired number of successfully finished pods the job should be run with. Setting to nil means that the success of any pod signals the success of all pods, and allows parallelism to have any positive value. Setting to 1 means that parallelism is limited to 1 and the success of that pod signals the success of the job. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#completions Job#completions}
    */
    readonly completions?: number;
    /**
    * Controls generation of pod labels and pod selectors. Leave unset unless you are certain what you are doing. When false or unset, the system pick labels unique to this job and appends those labels to the pod template. When true, the user is responsible for picking unique labels and specifying the selector. Failure to pick a unique label may cause this and other jobs to not function correctly. More info: https://git.k8s.io/community/contributors/design-proposals/selector-generation.md
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#manual_selector Job#manual_selector}
    */
    readonly manualSelector?: boolean | cdktf.IResolvable;
    /**
    * Specifies the maximum desired number of pods the job should run at any given time. The actual number of pods running in steady state will be less than this number when ((.spec.completions - .status.successful) < .spec.parallelism), i.e. when the work left to do is less than max parallelism. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#parallelism Job#parallelism}
    */
    readonly parallelism?: number;
    /**
    * ttlSecondsAfterFinished limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, ttlSecondsAfterFinished after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is unset, the Job won't be automatically deleted. If this field is set to zero, the Job becomes eligible to be deleted immediately after it finishes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#ttl_seconds_after_finished Job#ttl_seconds_after_finished}
    */
    readonly ttlSecondsAfterFinished?: string;
    /**
    * selector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#selector Job#selector}
    */
    readonly selector?: JobSpecSelector;
    /**
    * template block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#template Job#template}
    */
    readonly template: JobSpecTemplate;
}
export declare function jobSpecToTerraform(struct?: JobSpecOutputReference | JobSpec): any;
export declare class JobSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSpec | undefined;
    set internalValue(value: JobSpec | undefined);
    private _activeDeadlineSeconds?;
    get activeDeadlineSeconds(): number;
    set activeDeadlineSeconds(value: number);
    resetActiveDeadlineSeconds(): void;
    get activeDeadlineSecondsInput(): number | undefined;
    private _backoffLimit?;
    get backoffLimit(): number;
    set backoffLimit(value: number);
    resetBackoffLimit(): void;
    get backoffLimitInput(): number | undefined;
    private _completionMode?;
    get completionMode(): string;
    set completionMode(value: string);
    resetCompletionMode(): void;
    get completionModeInput(): string | undefined;
    private _completions?;
    get completions(): number;
    set completions(value: number);
    resetCompletions(): void;
    get completionsInput(): number | undefined;
    private _manualSelector?;
    get manualSelector(): boolean | cdktf.IResolvable;
    set manualSelector(value: boolean | cdktf.IResolvable);
    resetManualSelector(): void;
    get manualSelectorInput(): boolean | cdktf.IResolvable | undefined;
    private _parallelism?;
    get parallelism(): number;
    set parallelism(value: number);
    resetParallelism(): void;
    get parallelismInput(): number | undefined;
    private _ttlSecondsAfterFinished?;
    get ttlSecondsAfterFinished(): string;
    set ttlSecondsAfterFinished(value: string);
    resetTtlSecondsAfterFinished(): void;
    get ttlSecondsAfterFinishedInput(): string | undefined;
    private _selector;
    get selector(): JobSpecSelectorOutputReference;
    putSelector(value: JobSpecSelector): void;
    resetSelector(): void;
    get selectorInput(): JobSpecSelector | undefined;
    private _template;
    get template(): JobSpecTemplateOutputReference;
    putTemplate(value: JobSpecTemplate): void;
    get templateInput(): JobSpecTemplate | undefined;
}
export interface JobTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#create Job#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#delete Job#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#update Job#update}
    */
    readonly update?: string;
}
export declare function jobTimeoutsToTerraform(struct?: JobTimeoutsOutputReference | JobTimeouts | cdktf.IResolvable): any;
export declare class JobTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: JobTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
