import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataKubernetesServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/service#id DataKubernetesService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/service#metadata DataKubernetesService#metadata}
    */
    readonly metadata: DataKubernetesServiceMetadata;
}
export interface DataKubernetesServiceSpecPort {
}
export declare function dataKubernetesServiceSpecPortToTerraform(struct?: DataKubernetesServiceSpecPort): any;
export declare class DataKubernetesServiceSpecPortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesServiceSpecPort | undefined;
    set internalValue(value: DataKubernetesServiceSpecPort | undefined);
    get appProtocol(): string;
    get name(): string;
    get nodePort(): number;
    get port(): number;
    get protocol(): string;
    get targetPort(): string;
}
export declare class DataKubernetesServiceSpecPortList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesServiceSpecPortOutputReference;
}
export interface DataKubernetesServiceSpecSessionAffinityConfigClientIp {
}
export declare function dataKubernetesServiceSpecSessionAffinityConfigClientIpToTerraform(struct?: DataKubernetesServiceSpecSessionAffinityConfigClientIp): any;
export declare class DataKubernetesServiceSpecSessionAffinityConfigClientIpOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesServiceSpecSessionAffinityConfigClientIp | undefined;
    set internalValue(value: DataKubernetesServiceSpecSessionAffinityConfigClientIp | undefined);
    get timeoutSeconds(): number;
}
export declare class DataKubernetesServiceSpecSessionAffinityConfigClientIpList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesServiceSpecSessionAffinityConfigClientIpOutputReference;
}
export interface DataKubernetesServiceSpecSessionAffinityConfig {
}
export declare function dataKubernetesServiceSpecSessionAffinityConfigToTerraform(struct?: DataKubernetesServiceSpecSessionAffinityConfig): any;
export declare class DataKubernetesServiceSpecSessionAffinityConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesServiceSpecSessionAffinityConfig | undefined;
    set internalValue(value: DataKubernetesServiceSpecSessionAffinityConfig | undefined);
    private _clientIp;
    get clientIp(): DataKubernetesServiceSpecSessionAffinityConfigClientIpList;
}
export declare class DataKubernetesServiceSpecSessionAffinityConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesServiceSpecSessionAffinityConfigOutputReference;
}
export interface DataKubernetesServiceSpec {
}
export declare function dataKubernetesServiceSpecToTerraform(struct?: DataKubernetesServiceSpec): any;
export declare class DataKubernetesServiceSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesServiceSpec | undefined;
    set internalValue(value: DataKubernetesServiceSpec | undefined);
    get allocateLoadBalancerNodePorts(): cdktf.IResolvable;
    get clusterIp(): string;
    get clusterIps(): string[];
    get externalIps(): string[];
    get externalName(): string;
    get externalTrafficPolicy(): string;
    get healthCheckNodePort(): number;
    get internalTrafficPolicy(): string;
    get ipFamilies(): string[];
    get ipFamilyPolicy(): string;
    get loadBalancerClass(): string;
    get loadBalancerIp(): string;
    get loadBalancerSourceRanges(): string[];
    private _port;
    get port(): DataKubernetesServiceSpecPortList;
    get publishNotReadyAddresses(): cdktf.IResolvable;
    private _selector;
    get selector(): cdktf.StringMap;
    get sessionAffinity(): string;
    private _sessionAffinityConfig;
    get sessionAffinityConfig(): DataKubernetesServiceSpecSessionAffinityConfigList;
    get type(): string;
}
export declare class DataKubernetesServiceSpecList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesServiceSpecOutputReference;
}
export interface DataKubernetesServiceStatusLoadBalancerIngress {
}
export declare function dataKubernetesServiceStatusLoadBalancerIngressToTerraform(struct?: DataKubernetesServiceStatusLoadBalancerIngress): any;
export declare class DataKubernetesServiceStatusLoadBalancerIngressOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesServiceStatusLoadBalancerIngress | undefined;
    set internalValue(value: DataKubernetesServiceStatusLoadBalancerIngress | undefined);
    get hostname(): string;
    get ip(): string;
}
export declare class DataKubernetesServiceStatusLoadBalancerIngressList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesServiceStatusLoadBalancerIngressOutputReference;
}
export interface DataKubernetesServiceStatusLoadBalancer {
}
export declare function dataKubernetesServiceStatusLoadBalancerToTerraform(struct?: DataKubernetesServiceStatusLoadBalancer): any;
export declare class DataKubernetesServiceStatusLoadBalancerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesServiceStatusLoadBalancer | undefined;
    set internalValue(value: DataKubernetesServiceStatusLoadBalancer | undefined);
    private _ingress;
    get ingress(): DataKubernetesServiceStatusLoadBalancerIngressList;
}
export declare class DataKubernetesServiceStatusLoadBalancerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesServiceStatusLoadBalancerOutputReference;
}
export interface DataKubernetesServiceStatus {
}
export declare function dataKubernetesServiceStatusToTerraform(struct?: DataKubernetesServiceStatus): any;
export declare class DataKubernetesServiceStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesServiceStatus | undefined;
    set internalValue(value: DataKubernetesServiceStatus | undefined);
    private _loadBalancer;
    get loadBalancer(): DataKubernetesServiceStatusLoadBalancerList;
}
export declare class DataKubernetesServiceStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesServiceStatusOutputReference;
}
export interface DataKubernetesServiceMetadata {
    /**
    * An unstructured key value map stored with the service that may be used to store arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/service#annotations DataKubernetesService#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Map of string keys and values that can be used to organize and categorize (scope and select) the service. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/service#labels DataKubernetesService#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the service, must be unique. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/service#name DataKubernetesService#name}
    */
    readonly name?: string;
    /**
    * Namespace defines the space within which name of the service must be unique.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/service#namespace DataKubernetesService#namespace}
    */
    readonly namespace?: string;
}
export declare function dataKubernetesServiceMetadataToTerraform(struct?: DataKubernetesServiceMetadataOutputReference | DataKubernetesServiceMetadata): any;
export declare class DataKubernetesServiceMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataKubernetesServiceMetadata | undefined;
    set internalValue(value: DataKubernetesServiceMetadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get resourceVersion(): string;
    get uid(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/d/service kubernetes_service}
*/
export declare class DataKubernetesService extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "kubernetes_service";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/d/service kubernetes_service} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataKubernetesServiceConfig
    */
    constructor(scope: Construct, id: string, config: DataKubernetesServiceConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _spec;
    get spec(): DataKubernetesServiceSpecList;
    private _status;
    get status(): DataKubernetesServiceStatusList;
    private _metadata;
    get metadata(): DataKubernetesServiceMetadataOutputReference;
    putMetadata(value: DataKubernetesServiceMetadata): void;
    get metadataInput(): DataKubernetesServiceMetadata | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
