import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataKubernetesMutatingWebhookConfigurationV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/mutating_webhook_configuration_v1#id DataKubernetesMutatingWebhookConfigurationV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/mutating_webhook_configuration_v1#metadata DataKubernetesMutatingWebhookConfigurationV1#metadata}
    */
    readonly metadata: DataKubernetesMutatingWebhookConfigurationV1Metadata;
}
export interface DataKubernetesMutatingWebhookConfigurationV1WebhookClientConfigService {
}
export declare function dataKubernetesMutatingWebhookConfigurationV1WebhookClientConfigServiceToTerraform(struct?: DataKubernetesMutatingWebhookConfigurationV1WebhookClientConfigService): any;
export declare class DataKubernetesMutatingWebhookConfigurationV1WebhookClientConfigServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesMutatingWebhookConfigurationV1WebhookClientConfigService | undefined;
    set internalValue(value: DataKubernetesMutatingWebhookConfigurationV1WebhookClientConfigService | undefined);
    get name(): string;
    get namespace(): string;
    get path(): string;
    get port(): number;
}
export declare class DataKubernetesMutatingWebhookConfigurationV1WebhookClientConfigServiceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesMutatingWebhookConfigurationV1WebhookClientConfigServiceOutputReference;
}
export interface DataKubernetesMutatingWebhookConfigurationV1WebhookClientConfig {
}
export declare function dataKubernetesMutatingWebhookConfigurationV1WebhookClientConfigToTerraform(struct?: DataKubernetesMutatingWebhookConfigurationV1WebhookClientConfig): any;
export declare class DataKubernetesMutatingWebhookConfigurationV1WebhookClientConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesMutatingWebhookConfigurationV1WebhookClientConfig | undefined;
    set internalValue(value: DataKubernetesMutatingWebhookConfigurationV1WebhookClientConfig | undefined);
    get caBundle(): string;
    private _service;
    get service(): DataKubernetesMutatingWebhookConfigurationV1WebhookClientConfigServiceList;
    get url(): string;
}
export declare class DataKubernetesMutatingWebhookConfigurationV1WebhookClientConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesMutatingWebhookConfigurationV1WebhookClientConfigOutputReference;
}
export interface DataKubernetesMutatingWebhookConfigurationV1WebhookNamespaceSelectorMatchExpressions {
}
export declare function dataKubernetesMutatingWebhookConfigurationV1WebhookNamespaceSelectorMatchExpressionsToTerraform(struct?: DataKubernetesMutatingWebhookConfigurationV1WebhookNamespaceSelectorMatchExpressions): any;
export declare class DataKubernetesMutatingWebhookConfigurationV1WebhookNamespaceSelectorMatchExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesMutatingWebhookConfigurationV1WebhookNamespaceSelectorMatchExpressions | undefined;
    set internalValue(value: DataKubernetesMutatingWebhookConfigurationV1WebhookNamespaceSelectorMatchExpressions | undefined);
    get key(): string;
    get operator(): string;
    get values(): string[];
}
export declare class DataKubernetesMutatingWebhookConfigurationV1WebhookNamespaceSelectorMatchExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesMutatingWebhookConfigurationV1WebhookNamespaceSelectorMatchExpressionsOutputReference;
}
export interface DataKubernetesMutatingWebhookConfigurationV1WebhookNamespaceSelector {
}
export declare function dataKubernetesMutatingWebhookConfigurationV1WebhookNamespaceSelectorToTerraform(struct?: DataKubernetesMutatingWebhookConfigurationV1WebhookNamespaceSelector): any;
export declare class DataKubernetesMutatingWebhookConfigurationV1WebhookNamespaceSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesMutatingWebhookConfigurationV1WebhookNamespaceSelector | undefined;
    set internalValue(value: DataKubernetesMutatingWebhookConfigurationV1WebhookNamespaceSelector | undefined);
    private _matchExpressions;
    get matchExpressions(): DataKubernetesMutatingWebhookConfigurationV1WebhookNamespaceSelectorMatchExpressionsList;
    private _matchLabels;
    get matchLabels(): cdktf.StringMap;
}
export declare class DataKubernetesMutatingWebhookConfigurationV1WebhookNamespaceSelectorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesMutatingWebhookConfigurationV1WebhookNamespaceSelectorOutputReference;
}
export interface DataKubernetesMutatingWebhookConfigurationV1WebhookObjectSelectorMatchExpressions {
}
export declare function dataKubernetesMutatingWebhookConfigurationV1WebhookObjectSelectorMatchExpressionsToTerraform(struct?: DataKubernetesMutatingWebhookConfigurationV1WebhookObjectSelectorMatchExpressions): any;
export declare class DataKubernetesMutatingWebhookConfigurationV1WebhookObjectSelectorMatchExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesMutatingWebhookConfigurationV1WebhookObjectSelectorMatchExpressions | undefined;
    set internalValue(value: DataKubernetesMutatingWebhookConfigurationV1WebhookObjectSelectorMatchExpressions | undefined);
    get key(): string;
    get operator(): string;
    get values(): string[];
}
export declare class DataKubernetesMutatingWebhookConfigurationV1WebhookObjectSelectorMatchExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesMutatingWebhookConfigurationV1WebhookObjectSelectorMatchExpressionsOutputReference;
}
export interface DataKubernetesMutatingWebhookConfigurationV1WebhookObjectSelector {
}
export declare function dataKubernetesMutatingWebhookConfigurationV1WebhookObjectSelectorToTerraform(struct?: DataKubernetesMutatingWebhookConfigurationV1WebhookObjectSelector): any;
export declare class DataKubernetesMutatingWebhookConfigurationV1WebhookObjectSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesMutatingWebhookConfigurationV1WebhookObjectSelector | undefined;
    set internalValue(value: DataKubernetesMutatingWebhookConfigurationV1WebhookObjectSelector | undefined);
    private _matchExpressions;
    get matchExpressions(): DataKubernetesMutatingWebhookConfigurationV1WebhookObjectSelectorMatchExpressionsList;
    private _matchLabels;
    get matchLabels(): cdktf.StringMap;
}
export declare class DataKubernetesMutatingWebhookConfigurationV1WebhookObjectSelectorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesMutatingWebhookConfigurationV1WebhookObjectSelectorOutputReference;
}
export interface DataKubernetesMutatingWebhookConfigurationV1WebhookRule {
}
export declare function dataKubernetesMutatingWebhookConfigurationV1WebhookRuleToTerraform(struct?: DataKubernetesMutatingWebhookConfigurationV1WebhookRule): any;
export declare class DataKubernetesMutatingWebhookConfigurationV1WebhookRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesMutatingWebhookConfigurationV1WebhookRule | undefined;
    set internalValue(value: DataKubernetesMutatingWebhookConfigurationV1WebhookRule | undefined);
    get apiGroups(): string[];
    get apiVersions(): string[];
    get operations(): string[];
    get resources(): string[];
    get scope(): string;
}
export declare class DataKubernetesMutatingWebhookConfigurationV1WebhookRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesMutatingWebhookConfigurationV1WebhookRuleOutputReference;
}
export interface DataKubernetesMutatingWebhookConfigurationV1Webhook {
}
export declare function dataKubernetesMutatingWebhookConfigurationV1WebhookToTerraform(struct?: DataKubernetesMutatingWebhookConfigurationV1Webhook): any;
export declare class DataKubernetesMutatingWebhookConfigurationV1WebhookOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesMutatingWebhookConfigurationV1Webhook | undefined;
    set internalValue(value: DataKubernetesMutatingWebhookConfigurationV1Webhook | undefined);
    get admissionReviewVersions(): string[];
    private _clientConfig;
    get clientConfig(): DataKubernetesMutatingWebhookConfigurationV1WebhookClientConfigList;
    get failurePolicy(): string;
    get matchPolicy(): string;
    get name(): string;
    private _namespaceSelector;
    get namespaceSelector(): DataKubernetesMutatingWebhookConfigurationV1WebhookNamespaceSelectorList;
    private _objectSelector;
    get objectSelector(): DataKubernetesMutatingWebhookConfigurationV1WebhookObjectSelectorList;
    get reinvocationPolicy(): string;
    private _rule;
    get rule(): DataKubernetesMutatingWebhookConfigurationV1WebhookRuleList;
    get sideEffects(): string;
    get timeoutSeconds(): number;
}
export declare class DataKubernetesMutatingWebhookConfigurationV1WebhookList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesMutatingWebhookConfigurationV1WebhookOutputReference;
}
export interface DataKubernetesMutatingWebhookConfigurationV1Metadata {
    /**
    * An unstructured key value map stored with the mutating webhook configuration that may be used to store arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/mutating_webhook_configuration_v1#annotations DataKubernetesMutatingWebhookConfigurationV1#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Map of string keys and values that can be used to organize and categorize (scope and select) the mutating webhook configuration. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/mutating_webhook_configuration_v1#labels DataKubernetesMutatingWebhookConfigurationV1#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the mutating webhook configuration, must be unique. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/mutating_webhook_configuration_v1#name DataKubernetesMutatingWebhookConfigurationV1#name}
    */
    readonly name?: string;
}
export declare function dataKubernetesMutatingWebhookConfigurationV1MetadataToTerraform(struct?: DataKubernetesMutatingWebhookConfigurationV1MetadataOutputReference | DataKubernetesMutatingWebhookConfigurationV1Metadata): any;
export declare class DataKubernetesMutatingWebhookConfigurationV1MetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataKubernetesMutatingWebhookConfigurationV1Metadata | undefined;
    set internalValue(value: DataKubernetesMutatingWebhookConfigurationV1Metadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get resourceVersion(): string;
    get uid(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/d/mutating_webhook_configuration_v1 kubernetes_mutating_webhook_configuration_v1}
*/
export declare class DataKubernetesMutatingWebhookConfigurationV1 extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "kubernetes_mutating_webhook_configuration_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/d/mutating_webhook_configuration_v1 kubernetes_mutating_webhook_configuration_v1} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataKubernetesMutatingWebhookConfigurationV1Config
    */
    constructor(scope: Construct, id: string, config: DataKubernetesMutatingWebhookConfigurationV1Config);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _webhook;
    get webhook(): DataKubernetesMutatingWebhookConfigurationV1WebhookList;
    private _metadata;
    get metadata(): DataKubernetesMutatingWebhookConfigurationV1MetadataOutputReference;
    putMetadata(value: DataKubernetesMutatingWebhookConfigurationV1Metadata): void;
    get metadataInput(): DataKubernetesMutatingWebhookConfigurationV1Metadata | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
