import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataKubernetesIngressConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/ingress#id DataKubernetesIngress#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/ingress#metadata DataKubernetesIngress#metadata}
    */
    readonly metadata: DataKubernetesIngressMetadata;
}
export interface DataKubernetesIngressSpecBackend {
}
export declare function dataKubernetesIngressSpecBackendToTerraform(struct?: DataKubernetesIngressSpecBackend): any;
export declare class DataKubernetesIngressSpecBackendOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesIngressSpecBackend | undefined;
    set internalValue(value: DataKubernetesIngressSpecBackend | undefined);
    get serviceName(): string;
    get servicePort(): string;
}
export declare class DataKubernetesIngressSpecBackendList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesIngressSpecBackendOutputReference;
}
export interface DataKubernetesIngressSpecRuleHttpPathBackend {
}
export declare function dataKubernetesIngressSpecRuleHttpPathBackendToTerraform(struct?: DataKubernetesIngressSpecRuleHttpPathBackend): any;
export declare class DataKubernetesIngressSpecRuleHttpPathBackendOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesIngressSpecRuleHttpPathBackend | undefined;
    set internalValue(value: DataKubernetesIngressSpecRuleHttpPathBackend | undefined);
    get serviceName(): string;
    get servicePort(): string;
}
export declare class DataKubernetesIngressSpecRuleHttpPathBackendList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesIngressSpecRuleHttpPathBackendOutputReference;
}
export interface DataKubernetesIngressSpecRuleHttpPath {
}
export declare function dataKubernetesIngressSpecRuleHttpPathToTerraform(struct?: DataKubernetesIngressSpecRuleHttpPath): any;
export declare class DataKubernetesIngressSpecRuleHttpPathOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesIngressSpecRuleHttpPath | undefined;
    set internalValue(value: DataKubernetesIngressSpecRuleHttpPath | undefined);
    private _backend;
    get backend(): DataKubernetesIngressSpecRuleHttpPathBackendList;
    get path(): string;
}
export declare class DataKubernetesIngressSpecRuleHttpPathList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesIngressSpecRuleHttpPathOutputReference;
}
export interface DataKubernetesIngressSpecRuleHttp {
}
export declare function dataKubernetesIngressSpecRuleHttpToTerraform(struct?: DataKubernetesIngressSpecRuleHttp): any;
export declare class DataKubernetesIngressSpecRuleHttpOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesIngressSpecRuleHttp | undefined;
    set internalValue(value: DataKubernetesIngressSpecRuleHttp | undefined);
    private _path;
    get path(): DataKubernetesIngressSpecRuleHttpPathList;
}
export declare class DataKubernetesIngressSpecRuleHttpList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesIngressSpecRuleHttpOutputReference;
}
export interface DataKubernetesIngressSpecRule {
}
export declare function dataKubernetesIngressSpecRuleToTerraform(struct?: DataKubernetesIngressSpecRule): any;
export declare class DataKubernetesIngressSpecRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesIngressSpecRule | undefined;
    set internalValue(value: DataKubernetesIngressSpecRule | undefined);
    get host(): string;
    private _http;
    get http(): DataKubernetesIngressSpecRuleHttpList;
}
export declare class DataKubernetesIngressSpecRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesIngressSpecRuleOutputReference;
}
export interface DataKubernetesIngressSpecTls {
}
export declare function dataKubernetesIngressSpecTlsToTerraform(struct?: DataKubernetesIngressSpecTls): any;
export declare class DataKubernetesIngressSpecTlsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesIngressSpecTls | undefined;
    set internalValue(value: DataKubernetesIngressSpecTls | undefined);
    get hosts(): string[];
    get secretName(): string;
}
export declare class DataKubernetesIngressSpecTlsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesIngressSpecTlsOutputReference;
}
export interface DataKubernetesIngressSpec {
}
export declare function dataKubernetesIngressSpecToTerraform(struct?: DataKubernetesIngressSpec): any;
export declare class DataKubernetesIngressSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesIngressSpec | undefined;
    set internalValue(value: DataKubernetesIngressSpec | undefined);
    private _backend;
    get backend(): DataKubernetesIngressSpecBackendList;
    get ingressClassName(): string;
    private _rule;
    get rule(): DataKubernetesIngressSpecRuleList;
    private _tls;
    get tls(): DataKubernetesIngressSpecTlsList;
}
export declare class DataKubernetesIngressSpecList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesIngressSpecOutputReference;
}
export interface DataKubernetesIngressStatusLoadBalancerIngress {
}
export declare function dataKubernetesIngressStatusLoadBalancerIngressToTerraform(struct?: DataKubernetesIngressStatusLoadBalancerIngress): any;
export declare class DataKubernetesIngressStatusLoadBalancerIngressOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesIngressStatusLoadBalancerIngress | undefined;
    set internalValue(value: DataKubernetesIngressStatusLoadBalancerIngress | undefined);
    get hostname(): string;
    get ip(): string;
}
export declare class DataKubernetesIngressStatusLoadBalancerIngressList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesIngressStatusLoadBalancerIngressOutputReference;
}
export interface DataKubernetesIngressStatusLoadBalancer {
}
export declare function dataKubernetesIngressStatusLoadBalancerToTerraform(struct?: DataKubernetesIngressStatusLoadBalancer): any;
export declare class DataKubernetesIngressStatusLoadBalancerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesIngressStatusLoadBalancer | undefined;
    set internalValue(value: DataKubernetesIngressStatusLoadBalancer | undefined);
    private _ingress;
    get ingress(): DataKubernetesIngressStatusLoadBalancerIngressList;
}
export declare class DataKubernetesIngressStatusLoadBalancerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesIngressStatusLoadBalancerOutputReference;
}
export interface DataKubernetesIngressStatus {
}
export declare function dataKubernetesIngressStatusToTerraform(struct?: DataKubernetesIngressStatus): any;
export declare class DataKubernetesIngressStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesIngressStatus | undefined;
    set internalValue(value: DataKubernetesIngressStatus | undefined);
    private _loadBalancer;
    get loadBalancer(): DataKubernetesIngressStatusLoadBalancerList;
}
export declare class DataKubernetesIngressStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesIngressStatusOutputReference;
}
export interface DataKubernetesIngressMetadata {
    /**
    * An unstructured key value map stored with the ingress that may be used to store arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/ingress#annotations DataKubernetesIngress#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Map of string keys and values that can be used to organize and categorize (scope and select) the ingress. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/ingress#labels DataKubernetesIngress#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the ingress, must be unique. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/ingress#name DataKubernetesIngress#name}
    */
    readonly name?: string;
    /**
    * Namespace defines the space within which name of the ingress must be unique.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/ingress#namespace DataKubernetesIngress#namespace}
    */
    readonly namespace?: string;
}
export declare function dataKubernetesIngressMetadataToTerraform(struct?: DataKubernetesIngressMetadataOutputReference | DataKubernetesIngressMetadata): any;
export declare class DataKubernetesIngressMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataKubernetesIngressMetadata | undefined;
    set internalValue(value: DataKubernetesIngressMetadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get resourceVersion(): string;
    get uid(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/d/ingress kubernetes_ingress}
*/
export declare class DataKubernetesIngress extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "kubernetes_ingress";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/d/ingress kubernetes_ingress} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataKubernetesIngressConfig
    */
    constructor(scope: Construct, id: string, config: DataKubernetesIngressConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _spec;
    get spec(): DataKubernetesIngressSpecList;
    private _status;
    get status(): DataKubernetesIngressStatusList;
    private _metadata;
    get metadata(): DataKubernetesIngressMetadataOutputReference;
    putMetadata(value: DataKubernetesIngressMetadata): void;
    get metadataInput(): DataKubernetesIngressMetadata | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
