# ============================================================================
# AUTO-GENERATED FILE - DO NOT EDIT DIRECTLY
#
# Generated by: src/aidb/dap/_util/_gen_protocol.py
# From spec:    src/aidb/dap/_util/_spec.json
# Spec hash:    f4feadc09927d22d
# Generated:    2025-12-07T01:35:14Z
# ============================================================================

"""DAP Protocol - DAP data type classes and enums."""

from __future__ import annotations

from dataclasses import dataclass
from enum import Enum
from typing import Any, Dict, List, Optional, Union
from .base import DAPDataclass


@dataclass
class Breakpoint(DAPDataclass):
    """Information about a breakpoint created in `setBreakpoints`,
    `setFunctionBreakpoints`, `setInstructionBreakpoints`, or
    `setDataBreakpoints` requests."""

    # _spec.json#3920

    verified: bool
    column: Optional[int] = None
    endColumn: Optional[int] = None
    endLine: Optional[int] = None
    id: Optional[int] = None
    instructionReference: Optional[str] = None
    line: Optional[int] = None
    message: Optional[str] = None
    offset: Optional[int] = None
    reason: Optional[str] = None
    source: Optional['Source'] = None


@dataclass
class BreakpointLocation(DAPDataclass):
    """Properties of a breakpoint location returned from the
    `breakpointLocations` request."""

    # _spec.json#3786

    line: int
    column: Optional[int] = None
    endColumn: Optional[int] = None
    endLine: Optional[int] = None


@dataclass
class BreakpointMode(DAPDataclass):
    """A `BreakpointMode` is provided as a option when setting breakpoints on
    sources or instructions."""

    # _spec.json#4330

    appliesTo: List['BreakpointModeApplicability']
    label: str
    mode: str
    description: Optional[str] = None


@dataclass
class BreakpointModeApplicability(DAPDataclass):
    """Describes one or more type of breakpoint a `BreakpointMode` applies
    to. This is a non-exhaustive enumeration and may expand as future
    breakpoint types are added."""

    # _spec.json#4356

    pass


@dataclass
class Capabilities(DAPDataclass):
    """Information about the capabilities of a debug adapter."""

    # _spec.json#3168

    additionalModuleColumns: Optional[List['ColumnDescriptor']] = None
    breakpointModes: Optional[List['BreakpointMode']] = None
    completionTriggerCharacters: Optional[List[str]] = None
    exceptionBreakpointFilters: Optional[List['ExceptionBreakpointsFilter']] = None
    supportSuspendDebuggee: Optional[bool] = None
    supportTerminateDebuggee: Optional[bool] = None
    supportedChecksumAlgorithms: Optional[List['ChecksumAlgorithm']] = None
    supportsANSIStyling: Optional[bool] = None
    supportsBreakpointLocationsRequest: Optional[bool] = None
    supportsCancelRequest: Optional[bool] = None
    supportsClipboardContext: Optional[bool] = None
    supportsCompletionsRequest: Optional[bool] = None
    supportsConditionalBreakpoints: Optional[bool] = None
    supportsConfigurationDoneRequest: Optional[bool] = None
    supportsDataBreakpointBytes: Optional[bool] = None
    supportsDataBreakpoints: Optional[bool] = None
    supportsDelayedStackTraceLoading: Optional[bool] = None
    supportsDisassembleRequest: Optional[bool] = None
    supportsEvaluateForHovers: Optional[bool] = None
    supportsExceptionFilterOptions: Optional[bool] = None
    supportsExceptionInfoRequest: Optional[bool] = None
    supportsExceptionOptions: Optional[bool] = None
    supportsFunctionBreakpoints: Optional[bool] = None
    supportsGotoTargetsRequest: Optional[bool] = None
    supportsHitConditionalBreakpoints: Optional[bool] = None
    supportsInstructionBreakpoints: Optional[bool] = None
    supportsLoadedSourcesRequest: Optional[bool] = None
    supportsLogPoints: Optional[bool] = None
    supportsModulesRequest: Optional[bool] = None
    supportsReadMemoryRequest: Optional[bool] = None
    supportsRestartFrame: Optional[bool] = None
    supportsRestartRequest: Optional[bool] = None
    supportsSetExpression: Optional[bool] = None
    supportsSetVariable: Optional[bool] = None
    supportsSingleThreadExecutionRequests: Optional[bool] = None
    supportsStepBack: Optional[bool] = None
    supportsStepInTargetsRequest: Optional[bool] = None
    supportsSteppingGranularity: Optional[bool] = None
    supportsTerminateRequest: Optional[bool] = None
    supportsTerminateThreadsRequest: Optional[bool] = None
    supportsValueFormattingOptions: Optional[bool] = None
    supportsWriteMemoryRequest: Optional[bool] = None


@dataclass
class Checksum(DAPDataclass):
    """The checksum of an item calculated by the specified algorithm."""

    # _spec.json#4108

    algorithm: 'ChecksumAlgorithm'
    checksum: str


class ChecksumAlgorithm(str, Enum):
    """Names of checksum algorithms that may be supported by a debug adapter."""

    # _spec.json#4102

    M_D5 = "MD5"
    S_H_A1 = "SHA1"
    S_H_A256 = "SHA256"
    TIMESTAMP = "timestamp"


@dataclass
class ColumnDescriptor(DAPDataclass):
    """A `ColumnDescriptor` specifies what module attribute to show in a
    column of the modules view, how to format it, and what the column's
    label should be. It is only used if the underlying UI actually
    supports this level of customization."""

    # _spec.json#3479

    attributeName: str
    label: str
    format: Optional[str] = None
    type: Optional[str] = None
    width: Optional[int] = None


@dataclass
class CompletionItem(DAPDataclass):
    """`CompletionItems` are the suggestions returned from the `completions`
    request."""

    # _spec.json#4052

    label: str
    detail: Optional[str] = None
    length: Optional[int] = None
    selectionLength: Optional[int] = None
    selectionStart: Optional[int] = None
    sortText: Optional[str] = None
    start: Optional[int] = None
    text: Optional[str] = None
    type: Optional['CompletionItemType'] = None


class CompletionItemType(str, Enum):
    """Some predefined types for the CompletionItem. Please note that not all
    clients have specific icons for all of them."""

    # _spec.json#4096

    METHOD = "method"
    FUNCTION = "function"
    CONSTRUCTOR = "constructor"
    FIELD = "field"
    VARIABLE = "variable"
    CLASS = "class"
    INTERFACE = "interface"
    MODULE = "module"
    PROPERTY = "property"
    UNIT = "unit"
    VALUE = "value"
    ENUM = "enum"
    KEYWORD = "keyword"
    SNIPPET = "snippet"
    TEXT = "text"
    COLOR = "color"
    FILE = "file"
    REFERENCE = "reference"
    CUSTOMCOLOR = "customcolor"


@dataclass
class DataBreakpoint(DAPDataclass):
    """Properties of a data breakpoint passed to the `setDataBreakpoints`
    request."""

    # _spec.json#3868

    dataId: str
    accessType: Optional['DataBreakpointAccessType'] = None
    condition: Optional[str] = None
    hitCondition: Optional[str] = None


class DataBreakpointAccessType(str, Enum):
    """This enumeration defines all possible access types for data
    breakpoints."""

    # _spec.json#3862

    READ = "read"
    WRITE = "write"
    READ_WRITE = "readWrite"


@dataclass
class DisassembledInstruction(DAPDataclass):
    """Represents a single disassembled instruction."""

    # _spec.json#4270

    address: str
    instruction: str
    column: Optional[int] = None
    endColumn: Optional[int] = None
    endLine: Optional[int] = None
    instructionBytes: Optional[str] = None
    line: Optional[int] = None
    location: Optional['Source'] = None
    presentationHint: Optional[str] = None
    symbol: Optional[str] = None


class ExceptionBreakMode(str, Enum):
    """This enumeration defines all possible conditions when a thrown
    exception should result in a break. never: never breaks, always:
    always breaks, unhandled: breaks when exception unhandled,
    userUnhandled: breaks if the exception is not handled by user code."""

    # _spec.json#4211

    NEVER = "never"
    ALWAYS = "always"
    UNHANDLED = "unhandled"
    USER_UNHANDLED = "userUnhandled"


@dataclass
class ExceptionBreakpointsFilter(DAPDataclass):
    """An `ExceptionBreakpointsFilter` is shown in the UI as an filter option
    for configuring how exceptions are dealt with."""

    # _spec.json#3359

    filter: str
    label: str
    conditionDescription: Optional[str] = None
    default: Optional[bool] = None
    description: Optional[str] = None
    supportsCondition: Optional[bool] = None


@dataclass
class ExceptionDetails(DAPDataclass):
    """Detailed information about an exception that has occurred."""

    # _spec.json#4236

    evaluateName: Optional[str] = None
    fullTypeName: Optional[str] = None
    innerException: Optional[List['ExceptionDetails']] = None
    message: Optional[str] = None
    stackTrace: Optional[str] = None
    typeName: Optional[str] = None


@dataclass
class ExceptionFilterOptions(DAPDataclass):
    """An `ExceptionFilterOptions` is used to specify an exception filter
    together with a condition for the `setExceptionBreakpoints` request."""

    # _spec.json#4172

    filterId: str
    condition: Optional[str] = None
    mode: Optional[str] = None


@dataclass
class ExceptionOptions(DAPDataclass):
    """An `ExceptionOptions` assigns configuration options to a set of
    exceptions."""

    # _spec.json#4192

    breakMode: 'ExceptionBreakMode'
    path: Optional[List['ExceptionPathSegment']] = None


@dataclass
class ExceptionPathSegment(DAPDataclass):
    """An `ExceptionPathSegment` represents a segment in a path that is used
    to match leafs or nodes in a tree of exceptions. If a segment consists
    of more than one name, it matches the names provided if `negate` is
    false or missing, or it matches anything except the names provided if
    `negate` is true."""

    # _spec.json#4217

    names: List[str]
    negate: Optional[bool] = None


@dataclass
class FunctionBreakpoint(DAPDataclass):
    """Properties of a breakpoint passed to the `setFunctionBreakpoints`
    request."""

    # _spec.json#3842

    name: str
    condition: Optional[str] = None
    hitCondition: Optional[str] = None


@dataclass
class GotoTarget(DAPDataclass):
    """A `GotoTarget` describes a code location that can be used as a target
    in the `goto` request. The possible goto targets can be determined via
    the `gotoTargets` request."""

    # _spec.json#4016

    id: int
    label: str
    line: int
    column: Optional[int] = None
    endColumn: Optional[int] = None
    endLine: Optional[int] = None
    instructionPointerReference: Optional[str] = None


@dataclass
class InstructionBreakpoint(DAPDataclass):
    """Properties of a breakpoint passed to the `setInstructionBreakpoints`
    request"""

    # _spec.json#3892

    instructionReference: str
    condition: Optional[str] = None
    hitCondition: Optional[str] = None
    mode: Optional[str] = None
    offset: Optional[int] = None


@dataclass
class InvalidatedAreas(DAPDataclass):
    """Logical areas that can be invalidated by the `invalidated` event."""

    # _spec.json#4319

    pass


@dataclass
class Message(DAPDataclass):
    """A structured message object. Used to return errors from requests."""

    # _spec.json#3391

    format: str
    id: int
    sendTelemetry: Optional[bool] = None
    showUser: Optional[bool] = None
    url: Optional[str] = None
    urlLabel: Optional[str] = None
    variables: Optional[Dict[str, Any]] = None


@dataclass
class Module(DAPDataclass):
    """A Module object represents a row in the modules view. The `id`
    attribute identifies a module in the modules view and is used in a
    `module` event for identifying a module for adding, updating or
    deleting. The `name` attribute is used to minimally render the module
    in the UI. Additional attributes can be added to the module. They show
    up in the module view if they have a corresponding `ColumnDescriptor`.
    To avoid an unnecessary proliferation of additional attributes with
    similar semantics but different names, we recommend to re-use
    attributes from the 'recommended' list below first, and only introduce
    new attributes if nothing appropriate could be found."""

    # _spec.json#3431

    id: Union[int, str]
    name: str
    addressRange: Optional[str] = None
    dateTimeStamp: Optional[str] = None
    isOptimized: Optional[bool] = None
    isUserCode: Optional[bool] = None
    path: Optional[str] = None
    symbolFilePath: Optional[str] = None
    symbolStatus: Optional[str] = None
    version: Optional[str] = None


@dataclass
class Scope(DAPDataclass):
    """A `Scope` is a named container for variables. Optionally a scope can
    map to a source or a range within a source."""

    # _spec.json#3623

    expensive: bool
    name: str
    variablesReference: int
    column: Optional[int] = None
    endColumn: Optional[int] = None
    endLine: Optional[int] = None
    indexedVariables: Optional[int] = None
    line: Optional[int] = None
    namedVariables: Optional[int] = None
    presentationHint: Optional[str] = None
    source: Optional['Source'] = None


@dataclass
class Source(DAPDataclass):
    """A `Source` is a descriptor for source code. It is returned from the
    debug adapter as part of a `StackFrame` and it is used by clients when
    specifying breakpoints."""

    # _spec.json#3524

    adapterData: Optional[Union[List[Any], bool, int, float, Dict[str, Any], str]] = None
    checksums: Optional[List['Checksum']] = None
    name: Optional[str] = None
    origin: Optional[str] = None
    path: Optional[str] = None
    presentationHint: Optional[str] = None
    sourceReference: Optional[int] = None
    sources: Optional[List['Source']] = None


@dataclass
class SourceBreakpoint(DAPDataclass):
    """Properties of a breakpoint or logpoint passed to the `setBreakpoints`
    request."""

    # _spec.json#3810

    line: int
    column: Optional[int] = None
    condition: Optional[str] = None
    hitCondition: Optional[str] = None
    logMessage: Optional[str] = None
    mode: Optional[str] = None


@dataclass
class StackFrame(DAPDataclass):
    """A Stackframe contains the source location."""

    # _spec.json#3570

    column: int
    id: int
    line: int
    name: str
    canRestart: Optional[bool] = None
    endColumn: Optional[int] = None
    endLine: Optional[int] = None
    instructionPointerReference: Optional[str] = None
    moduleId: Optional[Union[int, str]] = None
    presentationHint: Optional[str] = None
    source: Optional['Source'] = None


@dataclass
class StepInTarget(DAPDataclass):
    """A `StepInTarget` can be used in the `stepIn` request and determines
    into which single target the `stepIn` request should step."""

    # _spec.json#3984

    id: int
    label: str
    column: Optional[int] = None
    endColumn: Optional[int] = None
    endLine: Optional[int] = None
    line: Optional[int] = None


class SteppingGranularity(str, Enum):
    """The granularity of one 'step' in the stepping requests `next`,
    `stepIn`, `stepOut`, and `stepBack`."""

    # _spec.json#3973

    STATEMENT = "statement"
    LINE = "line"
    INSTRUCTION = "instruction"


@dataclass
class Thread(DAPDataclass):
    """A Thread"""

    # _spec.json#3508

    id: int
    name: str


@dataclass
class ValueFormat(DAPDataclass):
    """Provides formatting information for a value."""

    # _spec.json#4124

    hex: Optional[bool] = None


@dataclass
class StackFrameFormat(ValueFormat):
    """Provides formatting information for a stack frame."""

    # _spec.json#4135

    includeAll: Optional[bool] = None
    line: Optional[bool] = None
    module: Optional[bool] = None
    parameterNames: Optional[bool] = None
    parameterTypes: Optional[bool] = None
    parameterValues: Optional[bool] = None
    parameters: Optional[bool] = None


@dataclass
class Variable(DAPDataclass):
    """A Variable is a name/value pair. The `type` attribute is shown if
    space permits or when hovering over the variable's name. The `kind`
    attribute is used to render additional properties of the variable,
    e.g. different icons can be used to indicate that a variable is public
    or private. If the value is structured (has children), a handle is
    provided to retrieve the children with the `variables` request. If the
    number of named or indexed children is large, the numbers should be
    returned via the `namedVariables` and `indexedVariables` attributes.
    The client can use this information to present the children in a paged
    UI and fetch them in chunks."""

    # _spec.json#3682

    name: str
    value: str
    variablesReference: int
    declarationLocationReference: Optional[int] = None
    evaluateName: Optional[str] = None
    indexedVariables: Optional[int] = None
    memoryReference: Optional[str] = None
    namedVariables: Optional[int] = None
    presentationHint: Optional['VariablePresentationHint'] = None
    type: Optional[str] = None
    valueLocationReference: Optional[int] = None


@dataclass
class VariablePresentationHint(DAPDataclass):
    """Properties of a variable that can be used to determine how to render
    the variable in the UI."""

    # _spec.json#3734

    attributes: Optional[List[str]] = None
    kind: Optional[str] = None
    lazy: Optional[bool] = None
    visibility: Optional[str] = None