# ============================================================================
# AUTO-GENERATED FILE - DO NOT EDIT DIRECTLY
#
# Generated by: src/aidb/dap/_util/_gen_protocol.py
# From spec:    src/aidb/dap/_util/_spec.json
# Spec hash:    f4feadc09927d22d
# Generated:    2025-12-07T01:35:14Z
# ============================================================================

"""DAP Protocol - DAP event message classes."""

from dataclasses import dataclass
from typing import TYPE_CHECKING, Optional
from .base import Event

if TYPE_CHECKING:
    from .bodies import (
        BreakpointEventBody,
        CapabilitiesEventBody,
        ContinuedEventBody,
        ExitedEventBody,
        InvalidatedEventBody,
        LoadedSourceEventBody,
        MemoryEventBody,
        ModuleEventBody,
        OutputEventBody,
        ProcessEventBody,
        ProgressEndEventBody,
        ProgressStartEventBody,
        ProgressUpdateEventBody,
        StoppedEventBody,
        TerminatedEventBody,
        ThreadEventBody,
    )


@dataclass
class BreakpointEvent(Event):
    """The event indicates that some information about a breakpoint has
    changed. While debug adapters may notify the clients of `changed`
    breakpoints using this event, clients should continue to use the
    breakpoint's original properties when updating a source's breakpoints
    in the `breakpoint` request."""

    # _spec.json#408

    body: Optional['BreakpointEventBody'] = None
    event: str = "breakpoint"


@dataclass
class CapabilitiesEvent(Event):
    """The event indicates that one or more capabilities have changed. Since
    the capabilities are dependent on the client and its UI, it might not
    be possible to change that at random times (or too late). Consequently
    this event has a hint characteristic: a client can only be expected to
    make a 'best effort' in honoring individual capabilities but there are
    no guarantees. Only changed capabilities need to be included, all
    other capabilities keep their values."""

    # _spec.json#544

    body: Optional['CapabilitiesEventBody'] = None
    event: str = "capabilities"


@dataclass
class ContinuedEvent(Event):
    """The event indicates that the execution of the debuggee has continued.
    Please note: a debug adapter is not expected to send this event in
    response to a request that implies that execution continues, e.g.
    `launch` or `continue`. It is only necessary to send a `continued`
    event if there was no previous request that implied this."""

    # _spec.json#234

    body: Optional['ContinuedEventBody'] = None
    event: str = "continued"


@dataclass
class ExitedEvent(Event):
    """The event indicates that the debuggee has exited and returns its exit
    code."""

    # _spec.json#262

    body: Optional['ExitedEventBody'] = None
    event: str = "exited"


@dataclass
class InitializedEvent(Event):
    """This event indicates that the debug adapter is ready to accept
    configuration requests (e.g. `setBreakpoints`,
    `setExceptionBreakpoints`). A debug adapter is expected to send this
    event when it is ready to accept configuration requests (but not
    before the `initialize` request has finished). The sequence of
    events/requests is as follows: - adapters sends `initialized` event
    (after the `initialize` request has returned) - client sends zero or
    more `setBreakpoints` requests - client sends one
    `setFunctionBreakpoints` request (if corresponding capability
    `supportsFunctionBreakpoints` is true) - client sends a
    `setExceptionBreakpoints` request if one or more
    `exceptionBreakpointFilters` have been defined (or if
    `supportsConfigurationDoneRequest` is not true) - client sends other
    future configuration requests - client sends one `configurationDone`
    request to indicate the end of the configuration."""

    # _spec.json#167

    event: str = "initialized"


@dataclass
class InvalidatedEvent(Event):
    """This event signals that some state in the debug adapter has changed
    and requires that the client needs to re-render the data snapshot
    previously requested. Debug adapters do not have to emit this event
    for runtime changes like stopped or thread events because in that case
    the client refetches the new state anyway. But the event can be used
    for example to refresh the UI after rendering formatting has changed
    in the debug adapter. This event should only be sent if the
    corresponding capability `supportsInvalidatedEvent` is true."""

    # _spec.json#672

    body: Optional['InvalidatedEventBody'] = None
    event: str = "invalidated"


@dataclass
class LoadedSourceEvent(Event):
    """The event indicates that some source has been added, changed, or
    removed from the set of all loaded sources."""

    # _spec.json#466

    body: Optional['LoadedSourceEventBody'] = None
    event: str = "loadedSource"


@dataclass
class MemoryEvent(Event):
    """This event indicates that some memory range has been updated. It
    should only be sent if the corresponding capability
    `supportsMemoryEvent` is true. Clients typically react to the event by
    re-issuing a `readMemory` request if they show the memory identified
    by the `memoryReference` and if the updated memory range overlaps the
    displayed range. Clients should not make assumptions how individual
    memory references relate to each other, so they should not assume that
    they are part of a single continuous address range and might overlap.
    Debug adapters can use this event to indicate that the contents of a
    memory range has changed due to some other request like `setVariable`
    or `setExpression`. Debug adapters are not expected to emit this event
    for each and every memory change of a running program, because that
    information is typically not available from debuggers and it would
    flood clients with too many events."""

    # _spec.json#706

    body: Optional['MemoryEventBody'] = None
    event: str = "memory"


@dataclass
class ModuleEvent(Event):
    """The event indicates that some information about a module has changed."""

    # _spec.json#437

    body: Optional['ModuleEventBody'] = None
    event: str = "module"


@dataclass
class OutputEvent(Event):
    """The event indicates that the target has produced some output."""

    # _spec.json#338

    body: Optional['OutputEventBody'] = None
    event: str = "output"


@dataclass
class ProcessEvent(Event):
    """The event indicates that the debugger has begun debugging a new
    process. Either one that it has launched, or one that it has attached
    to."""

    # _spec.json#495

    body: Optional['ProcessEventBody'] = None
    event: str = "process"


@dataclass
class ProgressEndEvent(Event):
    """The event signals the end of the progress reporting with a final
    message. This event should only be sent if the corresponding
    capability `supportsProgressReporting` is true."""

    # _spec.json#644

    body: Optional['ProgressEndEventBody'] = None
    event: str = "progressEnd"


@dataclass
class ProgressStartEvent(Event):
    """The event signals that a long running operation is about to start and
    provides additional information for the client to set up a
    corresponding progress and cancellation UI. The client is free to
    delay the showing of the UI in order to reduce flicker. This event
    should only be sent if the corresponding capability
    `supportsProgressReporting` is true."""

    # _spec.json#568

    body: Optional['ProgressStartEventBody'] = None
    event: str = "progressStart"


@dataclass
class ProgressUpdateEvent(Event):
    """The event signals that the progress reporting needs to be updated with
    a new message and/or percentage. The client does not have to update
    the UI immediately, but the clients needs to keep track of the message
    and/or percentage values. This event should only be sent if the
    corresponding capability `supportsProgressReporting` is true."""

    # _spec.json#612

    body: Optional['ProgressUpdateEventBody'] = None
    event: str = "progressUpdate"


@dataclass
class StoppedEvent(Event):
    """The event indicates that the execution of the debuggee has stopped due
    to some condition. This can be caused by a breakpoint previously set,
    a stepping request has completed, by executing a debugger statement
    etc."""

    # _spec.json#182

    body: Optional['StoppedEventBody'] = None
    event: str = "stopped"


@dataclass
class TerminatedEvent(Event):
    """The event indicates that debugging of the debuggee has terminated.
    This does **not** mean that the debuggee itself has exited."""

    # _spec.json#286

    body: Optional['TerminatedEventBody'] = None
    event: str = "terminated"


@dataclass
class ThreadEvent(Event):
    """The event indicates that a thread has started or exited."""

    # _spec.json#309

    body: Optional['ThreadEventBody'] = None
    event: str = "thread"