# Generated by Django 3.1.3 on 2020-11-09 19:24

import ckeditor_uploader.fields
from django.db import migrations, models
import django.db.models.deletion
import taggit.managers


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('taggit', '0003_taggeditem_add_unique_index'),
    ]

    operations = [
        migrations.CreateModel(
            name='Category',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=255)),
                ('slug', models.SlugField(unique=True)),
                ('is_active', models.BooleanField(db_index=True)),
                ('cover', models.ImageField(blank=True, null=True, upload_to='category_cover/%Y/%m/%d/')),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated', models.DateTimeField(auto_now=True, null=True)),
            ],
            options={
                'verbose_name': 'Category',
                'verbose_name_plural': 'Categories',
                'ordering': ('title',),
            },
        ),
        migrations.CreateModel(
            name='Post',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=255)),
                ('slug', models.SlugField(unique=True)),
                ('intro', models.TextField(blank=True, null=True)),
                ('is_active', models.BooleanField(db_index=True)),
                ('is_on_main_page', models.BooleanField(db_index=True, default=True)),
                ('is_popular', models.BooleanField(default=False)),
                ('image', models.ImageField(blank=True, null=True, upload_to='post/%Y/%m/%d/')),
                ('content', ckeditor_uploader.fields.RichTextUploadingField(blank=True, default='')),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated', models.DateTimeField(auto_now=True, null=True)),
                ('category', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dfsaas_blog.category')),
                ('tags', taggit.managers.TaggableManager(blank=True, help_text='A comma-separated list of tags.', through='taggit.TaggedItem', to='taggit.Tag', verbose_name='Tags')),
            ],
            options={
                'verbose_name': 'Post',
                'verbose_name_plural': 'Posts',
                'ordering': ('title',),
            },
        ),
    ]
