import os

from flask_unchained import BundleConfig


class Config(BundleConfig):
    """
    Default configuration options for the Webpack Bundle.
    """

    WEBPACK_MANIFEST_PATH = (
        None if not BundleConfig.current_app.static_folder
        else os.path.join(BundleConfig.current_app.static_folder,
                          'assets', 'manifest.json'))
    """
    The full path to the ``manifest.json`` file generated by Webpack Manifest Plugin.
    """


class ProdConfig(Config):
    """
    Default production configuration options for the Webpack Bundle.
    """

    # use relative paths by default, ie, the same host as the backend
    WEBPACK_ASSETS_HOST = ''
    """
    The host where Webpack assets are served from. Defaults to the same server as the
    backend.
    """


class StagingConfig(ProdConfig):
    """
    Inherit production settings.
    """
