from typing import Any, List, Optional, Tuple, Union

class CWrapper:
    ctype: Any = ...
    deinit: Any = ...
    def __init__(self, *args: Any, **kwargs: Any) -> None: ...
    def __del__(self) -> None: ...

class X509NameMeta(type):
    long_names: Any = ...
    def __new__(cls, name: Any, bases: Any, dic: Any): ...
    def add_property(instance: Any, name: Any, short_name: Any): ...

class X509Name(str, metaclass=X509NameMeta):
    def __init__(self, dname: Any) -> None: ...
    def __setattr__(self, name: Any, value: Any) -> None: ...

class AlternativeNames:
    def __init__(self, names: Any) -> None: ...

class X509TrustList(CWrapper):
    def __new__(cls, *args: Any, **kwargs: Any): ...
    def __init__(self) -> None: ...
    def __del__(self) -> None: ...
    def add_ca(self, cert: X509Certificate, flags: int=...) -> Any: ...
    def add_certificate(self, cert: X509Certificate, flags: int=...) -> Any: ...

class X509Dn(CWrapper):
    ctype: Any = ...
    deinit: Any = ...
    def __init__(self, data: Optional[Any] = ...) -> None: ...

class Pkcs7SignatureInfo(CWrapper):
    ctype: Any = ...
    deinit: Any = ...
    def __init__(self) -> None: ...
    @property
    def issuer_dn(self) -> X509Dn: ...
    @property
    def signing_time(self) -> int: ...
    @property
    def algo(self) -> int: ...
    @property
    def signer_serial(self) -> Optional[str]: ...
    @property
    def issuer_keyid(self) -> Optional[str]: ...

class Pkcs7(CWrapper):
    def __new__(cls, *args: Any, **kwargs: Any): ...
    def __init__(self) -> None: ...
    def __del__(self) -> None: ...
    def import_signature(self, buf: bytes, format: int=...) -> None: ...
    def sign(self, cert: Any, privkey: Union[X509PrivateKey, PrivateKey], buf: bytes, hash_algo: int=..., flags: int=...) -> None: ...
    def get_signature_count(self) -> int: ...
    def get_signature_info(self) -> List[Pkcs7SignatureInfo]: ...
    def verify_direct(self, cert: X509Certificate, buf: bytes, idx: int=..., flags: int=...) -> Any: ...
    def verify(self, tl: X509TrustList, buf: bytes, idx: int=..., flags: int=...) -> None: ...
    def export(self, format: int=...) -> Union[str, bytes]: ...

class PrivateKey:
    KEY_TYPE_NONE: int = ...
    KEY_TYPE_RSA: int = ...
    KEY_TYPE_DSA: int = ...
    KEY_TYPE_EC: int = ...
    def __new__(cls, *args: Any, **kwargs: Any): ...
    pk: Any = ...
    uri: Any = ...
    keytype: Any = ...
    srk_password: Any = ...
    key_password: Any = ...
    def __init__(self, pk: Optional[Any] = ..., uri: Optional[Any] = ..., keytype: Any = ...) -> None: ...
    def __get__(self, obj: Any, type_: Optional[Any] = ...): ...
    def __set__(self, obj: Any, value: Any) -> None: ...
    def __del__(self) -> None: ...
    def is_pkcs11(self) -> bool: ...
    def get_uri(self) -> str: ...
    def import_x509(self, x509_privkey: X509PrivateKey, flags: int=...) -> None: ...
    @staticmethod
    def upcast(algo: Any, pk: Any): ...
    @staticmethod
    def generate(algo: Any = ..., bits: int = ..., flags: int = ...): ...
    @classmethod
    def pk_algorithm_to_keytype(cls: Any, algo: int) -> Any: ...
    @staticmethod
    def import_uri(uri: Any, flags: int = ..., srk_password: Optional[Any] = ..., key_password: Optional[Any] = ...): ...
    def sign_data(self, hash_algo: Any, flags: Any, buf: Any): ...
    def sign_hash(self, hash_algo: Any, flags: Any, buf: Any): ...
    def decrypt_data(self, flags: Any, ciphertext: Any): ...

class RSAPrivateKey(PrivateKey):
    srk_password: Any = ...
    def __init__(self, pk: Any) -> None: ...
    def get_public_key(self): ...

class DSAPrivateKey(PrivateKey):
    def __init__(self, pk: Any) -> None: ...
    def get_public_key(self): ...
    @staticmethod
    def generate(algo: Any = ..., bits: int = ..., flags: int = ...): ...

class PublicKey:
    def __new__(cls, *args: Any, **kwargs: Any): ...
    pubkey: Any = ...
    def __init__(self, pubkey: Optional[Any] = ...) -> None: ...
    def __get__(self, obj: Any, type_: Optional[Any] = ...): ...
    def __set__(self, obj: Any, value: Any) -> None: ...
    def __del__(self) -> None: ...
    def import_x509(self, x509_cert: Any, flags: int = ...) -> None: ...
    def get_preferred_hash_algorithm(self): ...
    @staticmethod
    def upcast(algo: int, pubkey: PublicKey) -> Union[PublicKey, RSAPublicKey, DSAPublicKey]: ...
    @staticmethod
    def import_uri(uri: str, flags: int=..., srk_password: str=...) -> Any: ...
    def verify_data2(self, sign_algo: int, flags: int, buf: bytes, signature: Any) -> Any: ...
    def verify_hash2(self, sign_algo: int, flags: int, hashbuf: bytes, signature: bytes) -> Any: ...
    def encrypt_data(self, flags: int, plaintext: bytes) -> str: ...

class RSAPublicKey(PublicKey):
    def __init__(self, pubkey: Any) -> None: ...
    @staticmethod
    def import_rsa_raw(m: bytes, e: bytes) -> RSAPublicKey: ...
    def export_rsa_raw(self) -> Tuple[str, str]: ...

class DSAPublicKey(PublicKey):
    def __init__(self, pubkey: Any) -> None: ...
    @staticmethod
    def import_dsa_raw(p: bytes, q: bytes, g: bytes, y: bytes) -> Any: ...
    def export_dsa_raw(self) -> Tuple[str, str, str, str]: ...

class X509Certificate(CWrapper):
    def __new__(cls, *args: Any, **kwargs: Any): ...
    def __init__(self, buf: bytes, format: int=...) -> None: ...
    def __del__(self) -> None: ...
    @property
    def subject(self) -> X509Name: ...
    @property
    def issuer(self) -> X509Name: ...
    @property
    def alternative_names(self) -> AlternativeNames: ...
    @property
    def serial_number(self) -> str: ...
    @property
    def activation_time(self) -> int: ...
    @property
    def expiration_time(self) -> int: ...
    @property
    def version(self) -> int: ...
    def has_issuer(self, issuer: X509Certificate) -> bool: ...
    def has_hostname(self, hostname: str) -> bool: ...
    def check_issuer(self, issuer: X509Certificate) -> None: ...
    def check_hostname(self, hostname: str) -> None: ...
    def export(self, format: int=...) -> bytes: ...

class X509PrivateKey(CWrapper):
    def __new__(cls, *args: Any, **kwargs: Any): ...
    def __init__(self, buf: Any, format: Any = ...) -> None: ...
    def __del__(self) -> None: ...
    def export(self, format: int=...) -> bytes: ...

class X509Identity:
    cert: Any = ...
    key: Any = ...
    def __init__(self, cert: Any, key: Any) -> None: ...
    def __setattr__(self, name: Any, value: Any) -> None: ...
    def __delattr__(self, name: Any) -> None: ...

class X509CRL(CWrapper):
    def __new__(cls, *args: Any, **kwargs: Any): ...
    def __init__(self, buf: Any, format: Any = ...) -> None: ...
    def __del__(self) -> None: ...
    @property
    def count(self) -> int: ...
    @property
    def version(self) -> int: ...
    @property
    def issuer(self) -> X509Name: ...
    def is_revoked(self, cert: X509Certificate) -> bool: ...
    def check_revocation(self, cert: X509Certificate, cert_name: str=...) -> Any: ...
    def export(self, format: int=...) -> Any: ...

class DHParams(CWrapper):
    def __new__(cls, *args: Any, **kwargs: Any): ...
    def __init__(self, bits: int=...) -> None: ...
    def __get__(self, obj: Any, type_: Optional[Any] = ...): ...
    def __set__(self, obj: Any, value: Any) -> None: ...
    def __del__(self) -> None: ...

class Cipher(CWrapper):
    ctype: Any = ...
    algorithm: Any = ...
    deinit: Any = ...
    def __init__(self, algo: Any, key: Any, iv: Any) -> None: ...
    def set_iv(self, iv: bytes) -> Any: ...
    def add_auth(self, auth: bytes) -> Any: ...
    def decrypt(self, cipher_text: bytes) -> bytes: ...
    def encrypt(self, plain_text: bytes) -> bytes: ...
    def cipher_tag(self, tag_size: int) -> Any: ...

class AEADCipher(CWrapper):
    ctype: Any = ...
    deinit: Any = ...
    def __init__(self, algo: Any, key: Any) -> None: ...
    def encrypt(self, nonce: bytes, auth: bytes, tag_size: int, plain_text: bytes) -> bytes: ...
    def decrypt(self, nonce: bytes, auth: bytes, tag_size: int, cipher_text: bytes) -> bytes: ...
