# coding: utf-8

"""
    Selling Partner API for Finances

    The Selling Partner API for Finances helps you obtain financial information relevant to a seller's business. You can obtain financial events for a given order, financial event group, or date range without having to wait until a statement period closes. You can also obtain financial event groups for a given date range.  # noqa: E501

    OpenAPI spec version: v0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six


class AdjustmentItem(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'quantity': 'str',
        'per_unit_amount': 'Currency',
        'total_amount': 'Currency',
        'seller_sku': 'str',
        'fn_sku': 'str',
        'product_description': 'str',
        'asin': 'str'
    }

    attribute_map = {
        'quantity': 'Quantity',
        'per_unit_amount': 'PerUnitAmount',
        'total_amount': 'TotalAmount',
        'seller_sku': 'SellerSKU',
        'fn_sku': 'FnSKU',
        'product_description': 'ProductDescription',
        'asin': 'ASIN'
    }

    def __init__(self, quantity=None, per_unit_amount=None, total_amount=None, seller_sku=None, fn_sku=None, product_description=None, asin=None):  # noqa: E501
        """AdjustmentItem - a model defined in Swagger"""  # noqa: E501
        self._quantity = None
        self._per_unit_amount = None
        self._total_amount = None
        self._seller_sku = None
        self._fn_sku = None
        self._product_description = None
        self._asin = None
        self.discriminator = None
        if quantity is not None:
            self.quantity = quantity
        if per_unit_amount is not None:
            self.per_unit_amount = per_unit_amount
        if total_amount is not None:
            self.total_amount = total_amount
        if seller_sku is not None:
            self.seller_sku = seller_sku
        if fn_sku is not None:
            self.fn_sku = fn_sku
        if product_description is not None:
            self.product_description = product_description
        if asin is not None:
            self.asin = asin

    @property
    def quantity(self):
        """Gets the quantity of this AdjustmentItem.  # noqa: E501

        Represents the number of units in the seller's inventory when the AdustmentType is FBAInventoryReimbursement.  # noqa: E501

        :return: The quantity of this AdjustmentItem.  # noqa: E501
        :rtype: str
        """
        return self._quantity

    @quantity.setter
    def quantity(self, quantity):
        """Sets the quantity of this AdjustmentItem.

        Represents the number of units in the seller's inventory when the AdustmentType is FBAInventoryReimbursement.  # noqa: E501

        :param quantity: The quantity of this AdjustmentItem.  # noqa: E501
        :type: str
        """

        self._quantity = quantity

    @property
    def per_unit_amount(self):
        """Gets the per_unit_amount of this AdjustmentItem.  # noqa: E501


        :return: The per_unit_amount of this AdjustmentItem.  # noqa: E501
        :rtype: Currency
        """
        return self._per_unit_amount

    @per_unit_amount.setter
    def per_unit_amount(self, per_unit_amount):
        """Sets the per_unit_amount of this AdjustmentItem.


        :param per_unit_amount: The per_unit_amount of this AdjustmentItem.  # noqa: E501
        :type: Currency
        """

        self._per_unit_amount = per_unit_amount

    @property
    def total_amount(self):
        """Gets the total_amount of this AdjustmentItem.  # noqa: E501


        :return: The total_amount of this AdjustmentItem.  # noqa: E501
        :rtype: Currency
        """
        return self._total_amount

    @total_amount.setter
    def total_amount(self, total_amount):
        """Sets the total_amount of this AdjustmentItem.


        :param total_amount: The total_amount of this AdjustmentItem.  # noqa: E501
        :type: Currency
        """

        self._total_amount = total_amount

    @property
    def seller_sku(self):
        """Gets the seller_sku of this AdjustmentItem.  # noqa: E501

        The seller SKU of the item. The seller SKU is qualified by the seller's seller ID, which is included with every call to the Selling Partner API.  # noqa: E501

        :return: The seller_sku of this AdjustmentItem.  # noqa: E501
        :rtype: str
        """
        return self._seller_sku

    @seller_sku.setter
    def seller_sku(self, seller_sku):
        """Sets the seller_sku of this AdjustmentItem.

        The seller SKU of the item. The seller SKU is qualified by the seller's seller ID, which is included with every call to the Selling Partner API.  # noqa: E501

        :param seller_sku: The seller_sku of this AdjustmentItem.  # noqa: E501
        :type: str
        """

        self._seller_sku = seller_sku

    @property
    def fn_sku(self):
        """Gets the fn_sku of this AdjustmentItem.  # noqa: E501

        A unique identifier assigned to products stored in and fulfilled from a fulfillment center.  # noqa: E501

        :return: The fn_sku of this AdjustmentItem.  # noqa: E501
        :rtype: str
        """
        return self._fn_sku

    @fn_sku.setter
    def fn_sku(self, fn_sku):
        """Sets the fn_sku of this AdjustmentItem.

        A unique identifier assigned to products stored in and fulfilled from a fulfillment center.  # noqa: E501

        :param fn_sku: The fn_sku of this AdjustmentItem.  # noqa: E501
        :type: str
        """

        self._fn_sku = fn_sku

    @property
    def product_description(self):
        """Gets the product_description of this AdjustmentItem.  # noqa: E501

        A short description of the item.  # noqa: E501

        :return: The product_description of this AdjustmentItem.  # noqa: E501
        :rtype: str
        """
        return self._product_description

    @product_description.setter
    def product_description(self, product_description):
        """Sets the product_description of this AdjustmentItem.

        A short description of the item.  # noqa: E501

        :param product_description: The product_description of this AdjustmentItem.  # noqa: E501
        :type: str
        """

        self._product_description = product_description

    @property
    def asin(self):
        """Gets the asin of this AdjustmentItem.  # noqa: E501

        The Amazon Standard Identification Number (ASIN) of the item.  # noqa: E501

        :return: The asin of this AdjustmentItem.  # noqa: E501
        :rtype: str
        """
        return self._asin

    @asin.setter
    def asin(self, asin):
        """Sets the asin of this AdjustmentItem.

        The Amazon Standard Identification Number (ASIN) of the item.  # noqa: E501

        :param asin: The asin of this AdjustmentItem.  # noqa: E501
        :type: str
        """

        self._asin = asin

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AdjustmentItem, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AdjustmentItem):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
