# generated by datamodel-codegen:
#   filename:  entity/services/connections/metadata/atlasConnection.json
#   timestamp: 2023-01-20T20:34:56+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import AnyUrl, BaseModel, Extra, Field

from metadata.ingestion.models.custom_pydantic import CustomSecretStr

from .. import connectionBasicType


class AtlasType(Enum):
    Atlas = 'Atlas'


class AtlasConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[AtlasType] = Field(AtlasType.Atlas, description='Service Type')
    username: Optional[str] = Field(
        None,
        description='username to connect  to the Atlas. This user should have privileges to read all the metadata in Atlas.',
    )
    password: Optional[CustomSecretStr] = Field(
        None, description='password to connect  to the Atlas.'
    )
    hostPort: Optional[AnyUrl] = Field(
        None, description='Host and port of the Atlas service.', title='Host and Port'
    )
    databaseServiceName: Optional[List[str]] = Field(
        None, description='service type of the data source.'
    )
    messagingServiceName: Optional[List[str]] = Field(
        None, description='service type of the messaging source'
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = None
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = None
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = None
