# generated by datamodel-codegen:
#   filename:  entity/services/connections/dashboard/tableauConnection.json
#   timestamp: 2023-01-20T20:34:56+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, BaseModel, Extra, Field

from metadata.ingestion.models.custom_pydantic import CustomSecretStr

from .....security.ssl import verifySSLConfig
from .. import connectionBasicType


class TableauType(Enum):
    Tableau = 'Tableau'


class TableauConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[TableauType] = Field(
        TableauType.Tableau, description='Service Type', title='Service Type'
    )
    hostPort: Optional[AnyUrl] = Field(
        None, description='Tableau Server.', title='Host and Port'
    )
    username: Optional[str] = Field(
        None, description='Username for Tableau.', title='Username'
    )
    password: Optional[CustomSecretStr] = Field(
        None, description='Password for Tableau.', title='Password'
    )
    apiVersion: str = Field(
        ..., description='Tableau API version.', title='API Version'
    )
    siteName: Optional[str] = Field(
        None, description='Tableau Site Name.', title='Site Name'
    )
    siteUrl: Optional[str] = Field(
        None, description='Tableau Site Url.', title='Site Url'
    )
    personalAccessTokenName: Optional[str] = Field(
        None, description='Personal Access Token Name.', title='Personal Access Token'
    )
    personalAccessTokenSecret: Optional[CustomSecretStr] = Field(
        None,
        description='Personal Access Token Secret.',
        title='Personal Access Token Secret',
    )
    env: str = Field(
        ..., description='Tableau Environment Name.', title='Tableau Environment'
    )
    verifySSL: Optional[verifySSLConfig.VerifySSL] = verifySSLConfig.VerifySSL.no_ssl
    sslConfig: Optional[verifySSLConfig.SslConfig] = None
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
