# generated by datamodel-codegen:
#   filename:  entity/events/webhook.json
#   timestamp: 2023-01-20T20:34:56+00:00

from __future__ import annotations

from typing import Optional

from pydantic import AnyUrl, BaseModel, Extra, Field

from ...type import basic


class Webhook(BaseModel):
    class Config:
        extra = Extra.forbid

    name: basic.EntityName = Field(
        ..., description='Unique name of the application receiving webhook events.'
    )
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this webhook.'
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of the application.'
    )
    endpoint: AnyUrl = Field(
        ..., description='Endpoint to receive the webhook events over POST requests.'
    )
    secretKey: Optional[str] = Field(
        None,
        description='Secret set by the webhook client used for computing HMAC SHA256 signature of webhook payload and sent in `X-OM-Signature` header in POST requests to publish the events.',
    )
