# generated by datamodel-codegen:
#   filename:  alerts/alertAction.json
#   timestamp: 2023-01-20T20:34:56+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import BaseModel, Extra, Field

from ..entity.events import webhook
from ..type import basic, entityHistory, entityReference
from . import emailAlertConfig


class AlertActionType(Enum):
    GenericWebhook = 'GenericWebhook'
    SlackWebhook = 'SlackWebhook'
    MsTeamsWebhook = 'MsTeamsWebhook'
    Email = 'Email'
    ActivityFeed = 'ActivityFeed'


class Status(Enum):
    disabled = 'disabled'
    failed = 'failed'
    retryLimitReached = 'retryLimitReached'
    awaitingRetry = 'awaitingRetry'
    active = 'active'


class ActivityFeedAlertActionConfig(BaseModel):
    name: Optional[str] = Field(None, description='Name')
    description: Optional[str] = Field(None, description='Description')


class FailureDetails(BaseModel):
    class Config:
        extra = Extra.forbid

    lastFailedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last non-successful callback time in UNIX UTC epoch time in milliseconds.',
    )
    lastFailedStatusCode: Optional[int] = Field(
        None,
        description='Last non-successful activity response code received during callback.',
    )
    lastFailedReason: Optional[str] = Field(
        None,
        description='Last non-successful activity response reason received during callback.',
    )
    nextAttempt: Optional[basic.Timestamp] = Field(
        None,
        description='Next retry will be done at this time in Unix epoch time milliseconds. Only valid is `status` is `awaitingRetry`.',
    )


class AlertActionStatus(BaseModel):
    class Config:
        extra = Extra.forbid

    status: Optional[Status] = None
    failureDetails: Optional[FailureDetails] = None
    lastSuccessfulAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last non-successful callback time in UNIX UTC epoch time in milliseconds.',
    )
    timestamp: Optional[basic.Timestamp] = None


class AlertAction(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[basic.Uuid] = Field(
        None, description='Unique identifier that identifies this Alert.'
    )
    name: basic.EntityName = Field(
        ..., description='Name that uniquely identifies this Alert.'
    )
    fullyQualifiedName: Optional[basic.EntityName] = Field(
        None, description='Name that uniquely identifies a Alert.'
    )
    displayName: Optional[str] = Field(None, description='Display name for this Alert.')
    description: Optional[basic.Markdown] = Field(
        None,
        description='A short description of the Alert, comprehensible to regular users.',
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this Alert.'
    )
    href: Optional[basic.Href] = Field(
        None, description='Link to the resource corresponding to this entity.'
    )
    enabled: Optional[bool] = Field(True, description='Is the alert enabled.')
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the Alert.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the Alert in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that led to this version of the Alert.'
    )
    alertActionType: AlertActionType
    batchSize: Optional[int] = Field(
        10, description='Maximum number of events sent in a batch (Default 10).'
    )
    timeout: Optional[int] = Field(
        10, description='Connection timeout in seconds. (Default 10s).'
    )
    readTimeout: Optional[int] = Field(
        12, description='Read timeout in seconds. (Default 12s).'
    )
    statusDetails: Optional[AlertActionStatus] = None
    alertActionConfig: Union[
        webhook.Webhook,
        emailAlertConfig.EmailAlertConfig,
        ActivityFeedAlertActionConfig,
    ]
    deleted: Optional[bool] = Field(
        False, description='When `true` indicates the entity has been soft deleted.'
    )
    provider: Optional[basic.ProviderType] = basic.ProviderType.user
