from secml_malware.attack.whitebox import CFormatExploitEvasion
from secml_malware.models import CClassifierEnd2EndMalware


class CContentShiftingEvasion(CFormatExploitEvasion):
	"""
	Content shifting attack
	"""
	def __init__(self,
			end2end_model : CClassifierEnd2EndMalware,
			preferable_extension_amount=0x200,
			iterations : int =100,
			is_debug: bool = False,
			random_init: bool = False,
			threshold: float = 0.5,
			penalty_regularizer: float = 0,
			chunk_hyper_parameter : int = None,
	):
		"""
		Create the content shifting attack

		Parameters
		----------
		end2end_model : CClassifierEnd2EndMalware
			the target end-to-end model
		preferable_extension_amount: int, optional, default 512
			how many bytes to inject, modulo the file alignment
		iterations : int, optional, default 100
			the number of iterations of the optimizer
		is_debug : bool, optional, default False
			if True, prints debug information during the optimization
		random_init : bool, optional, default False
			if True, it randomizes the locations set by index_to_perturb before starting the optimization
		threshold : float, optional, default 0
			the detection threshold to bypass. Default is 0
		penalty_regularizer : float
			the reularization parameter, Default is 0
		chunk_hyper_parameter : int, optional, default 256
			how many bytes to optimize at each round. Default is 256
		"""
		super(CContentShiftingEvasion, self).__init__(
			end2end_model=end2end_model,
			pe_header_extension=0,
			preferable_extension_amount=preferable_extension_amount,
			iterations=iterations,
			is_debug=is_debug,
			random_init=random_init,
			threshold=threshold,
			penalty_regularizer=penalty_regularizer,
			chunk_hyper_parameter=chunk_hyper_parameter
		)