# coding: utf-8

"""
    Apache NiFi Registry REST API

    The REST API provides an interface to a registry with operations for saving, versioning, reading NiFi flows and components.

    OpenAPI spec version: 1.17.0
    Contact: dev@nifi.apache.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class DynamicProperty(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'value': 'str',
        'description': 'str',
        'expression_language_scope': 'str',
        'expression_language_supported': 'bool'
    }

    attribute_map = {
        'name': 'name',
        'value': 'value',
        'description': 'description',
        'expression_language_scope': 'expressionLanguageScope',
        'expression_language_supported': 'expressionLanguageSupported'
    }

    def __init__(self, name=None, value=None, description=None, expression_language_scope=None, expression_language_supported=None):
        """
        DynamicProperty - a model defined in Swagger
        """

        self._name = None
        self._value = None
        self._description = None
        self._expression_language_scope = None
        self._expression_language_supported = None

        if name is not None:
          self.name = name
        if value is not None:
          self.value = value
        if description is not None:
          self.description = description
        if expression_language_scope is not None:
          self.expression_language_scope = expression_language_scope
        if expression_language_supported is not None:
          self.expression_language_supported = expression_language_supported

    @property
    def name(self):
        """
        Gets the name of this DynamicProperty.
        The description of the dynamic property name

        :return: The name of this DynamicProperty.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this DynamicProperty.
        The description of the dynamic property name

        :param name: The name of this DynamicProperty.
        :type: str
        """

        self._name = name

    @property
    def value(self):
        """
        Gets the value of this DynamicProperty.
        The description of the dynamic property value

        :return: The value of this DynamicProperty.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this DynamicProperty.
        The description of the dynamic property value

        :param value: The value of this DynamicProperty.
        :type: str
        """

        self._value = value

    @property
    def description(self):
        """
        Gets the description of this DynamicProperty.
        The description of the dynamic property

        :return: The description of this DynamicProperty.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this DynamicProperty.
        The description of the dynamic property

        :param description: The description of this DynamicProperty.
        :type: str
        """

        self._description = description

    @property
    def expression_language_scope(self):
        """
        Gets the expression_language_scope of this DynamicProperty.
        The scope of the expression language support

        :return: The expression_language_scope of this DynamicProperty.
        :rtype: str
        """
        return self._expression_language_scope

    @expression_language_scope.setter
    def expression_language_scope(self, expression_language_scope):
        """
        Sets the expression_language_scope of this DynamicProperty.
        The scope of the expression language support

        :param expression_language_scope: The expression_language_scope of this DynamicProperty.
        :type: str
        """
        allowed_values = ["NONE", "VARIABLE_REGISTRY", "FLOWFILE_ATTRIBUTES"]
        if expression_language_scope not in allowed_values:
            raise ValueError(
                "Invalid value for `expression_language_scope` ({0}), must be one of {1}"
                .format(expression_language_scope, allowed_values)
            )

        self._expression_language_scope = expression_language_scope

    @property
    def expression_language_supported(self):
        """
        Gets the expression_language_supported of this DynamicProperty.
        Whether or not expression language is supported

        :return: The expression_language_supported of this DynamicProperty.
        :rtype: bool
        """
        return self._expression_language_supported

    @expression_language_supported.setter
    def expression_language_supported(self, expression_language_supported):
        """
        Sets the expression_language_supported of this DynamicProperty.
        Whether or not expression language is supported

        :param expression_language_supported: The expression_language_supported of this DynamicProperty.
        :type: bool
        """

        self._expression_language_supported = expression_language_supported

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, DynamicProperty):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
