# coding: utf-8

"""
    Apache NiFi Registry REST API

    The REST API provides an interface to a registry with operations for saving, versioning, reading NiFi flows and components.

    OpenAPI spec version: 1.17.0
    Contact: dev@nifi.apache.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class ExtensionRepositoryApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def get_extension_repo_artifacts(self, bucket_name, group_id, **kwargs):
        """
        Get extension repo artifacts
        Gets the artifacts in the extension repository in the given bucket and group.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_extension_repo_artifacts(bucket_name, group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_name: The bucket name (required)
        :param str group_id: The group id (required)
        :return: list[ExtensionRepoArtifact]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_extension_repo_artifacts_with_http_info(bucket_name, group_id, **kwargs)
        else:
            (data) = self.get_extension_repo_artifacts_with_http_info(bucket_name, group_id, **kwargs)
            return data

    def get_extension_repo_artifacts_with_http_info(self, bucket_name, group_id, **kwargs):
        """
        Get extension repo artifacts
        Gets the artifacts in the extension repository in the given bucket and group.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_extension_repo_artifacts_with_http_info(bucket_name, group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_name: The bucket name (required)
        :param str group_id: The group id (required)
        :return: list[ExtensionRepoArtifact]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bucket_name', 'group_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_extension_repo_artifacts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bucket_name' is set
        if ('bucket_name' not in params) or (params['bucket_name'] is None):
            raise ValueError("Missing the required parameter `bucket_name` when calling `get_extension_repo_artifacts`")
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `get_extension_repo_artifacts`")


        collection_formats = {}

        path_params = {}
        if 'bucket_name' in params:
            path_params['bucketName'] = params['bucket_name']
        if 'group_id' in params:
            path_params['groupId'] = params['group_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/extension-repository/{bucketName}/{groupId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[ExtensionRepoArtifact]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_extension_repo_buckets(self, **kwargs):
        """
        Get extension repo buckets
        Gets the names of the buckets the current user is authorized for in order to browse the repo by bucket.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_extension_repo_buckets(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: list[ExtensionRepoBucket]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_extension_repo_buckets_with_http_info(**kwargs)
        else:
            (data) = self.get_extension_repo_buckets_with_http_info(**kwargs)
            return data

    def get_extension_repo_buckets_with_http_info(self, **kwargs):
        """
        Get extension repo buckets
        Gets the names of the buckets the current user is authorized for in order to browse the repo by bucket.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_extension_repo_buckets_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: list[ExtensionRepoBucket]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_extension_repo_buckets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/extension-repository', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[ExtensionRepoBucket]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_extension_repo_groups(self, bucket_name, **kwargs):
        """
        Get extension repo groups
        Gets the groups in the extension repository in the given bucket.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_extension_repo_groups(bucket_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_name: The bucket name (required)
        :return: list[ExtensionRepoGroup]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_extension_repo_groups_with_http_info(bucket_name, **kwargs)
        else:
            (data) = self.get_extension_repo_groups_with_http_info(bucket_name, **kwargs)
            return data

    def get_extension_repo_groups_with_http_info(self, bucket_name, **kwargs):
        """
        Get extension repo groups
        Gets the groups in the extension repository in the given bucket.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_extension_repo_groups_with_http_info(bucket_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_name: The bucket name (required)
        :return: list[ExtensionRepoGroup]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bucket_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_extension_repo_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bucket_name' is set
        if ('bucket_name' not in params) or (params['bucket_name'] is None):
            raise ValueError("Missing the required parameter `bucket_name` when calling `get_extension_repo_groups`")


        collection_formats = {}

        path_params = {}
        if 'bucket_name' in params:
            path_params['bucketName'] = params['bucket_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/extension-repository/{bucketName}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[ExtensionRepoGroup]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_extension_repo_version(self, bucket_name, group_id, artifact_id, version, **kwargs):
        """
        Get extension repo version
        Gets information about the version in the given bucket, group, and artifact.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_extension_repo_version(bucket_name, group_id, artifact_id, version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_name: The bucket name (required)
        :param str group_id: The group identifier (required)
        :param str artifact_id: The artifact identifier (required)
        :param str version: The version (required)
        :return: ExtensionRepoVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_extension_repo_version_with_http_info(bucket_name, group_id, artifact_id, version, **kwargs)
        else:
            (data) = self.get_extension_repo_version_with_http_info(bucket_name, group_id, artifact_id, version, **kwargs)
            return data

    def get_extension_repo_version_with_http_info(self, bucket_name, group_id, artifact_id, version, **kwargs):
        """
        Get extension repo version
        Gets information about the version in the given bucket, group, and artifact.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_extension_repo_version_with_http_info(bucket_name, group_id, artifact_id, version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_name: The bucket name (required)
        :param str group_id: The group identifier (required)
        :param str artifact_id: The artifact identifier (required)
        :param str version: The version (required)
        :return: ExtensionRepoVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bucket_name', 'group_id', 'artifact_id', 'version']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_extension_repo_version" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bucket_name' is set
        if ('bucket_name' not in params) or (params['bucket_name'] is None):
            raise ValueError("Missing the required parameter `bucket_name` when calling `get_extension_repo_version`")
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `get_extension_repo_version`")
        # verify the required parameter 'artifact_id' is set
        if ('artifact_id' not in params) or (params['artifact_id'] is None):
            raise ValueError("Missing the required parameter `artifact_id` when calling `get_extension_repo_version`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `get_extension_repo_version`")


        collection_formats = {}

        path_params = {}
        if 'bucket_name' in params:
            path_params['bucketName'] = params['bucket_name']
        if 'group_id' in params:
            path_params['groupId'] = params['group_id']
        if 'artifact_id' in params:
            path_params['artifactId'] = params['artifact_id']
        if 'version' in params:
            path_params['version'] = params['version']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/extension-repository/{bucketName}/{groupId}/{artifactId}/{version}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ExtensionRepoVersion',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_extension_repo_version_content(self, bucket_name, group_id, artifact_id, version, **kwargs):
        """
        Get extension repo version content
        Gets the binary content of the bundle with the given bucket, group, artifact, and version.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_extension_repo_version_content(bucket_name, group_id, artifact_id, version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_name: The bucket name (required)
        :param str group_id: The group identifier (required)
        :param str artifact_id: The artifact identifier (required)
        :param str version: The version (required)
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_extension_repo_version_content_with_http_info(bucket_name, group_id, artifact_id, version, **kwargs)
        else:
            (data) = self.get_extension_repo_version_content_with_http_info(bucket_name, group_id, artifact_id, version, **kwargs)
            return data

    def get_extension_repo_version_content_with_http_info(self, bucket_name, group_id, artifact_id, version, **kwargs):
        """
        Get extension repo version content
        Gets the binary content of the bundle with the given bucket, group, artifact, and version.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_extension_repo_version_content_with_http_info(bucket_name, group_id, artifact_id, version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_name: The bucket name (required)
        :param str group_id: The group identifier (required)
        :param str artifact_id: The artifact identifier (required)
        :param str version: The version (required)
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bucket_name', 'group_id', 'artifact_id', 'version']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_extension_repo_version_content" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bucket_name' is set
        if ('bucket_name' not in params) or (params['bucket_name'] is None):
            raise ValueError("Missing the required parameter `bucket_name` when calling `get_extension_repo_version_content`")
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `get_extension_repo_version_content`")
        # verify the required parameter 'artifact_id' is set
        if ('artifact_id' not in params) or (params['artifact_id'] is None):
            raise ValueError("Missing the required parameter `artifact_id` when calling `get_extension_repo_version_content`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `get_extension_repo_version_content`")


        collection_formats = {}

        path_params = {}
        if 'bucket_name' in params:
            path_params['bucketName'] = params['bucket_name']
        if 'group_id' in params:
            path_params['groupId'] = params['group_id']
        if 'artifact_id' in params:
            path_params['artifactId'] = params['artifact_id']
        if 'version' in params:
            path_params['version'] = params['version']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/octet-stream'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/extension-repository/{bucketName}/{groupId}/{artifactId}/{version}/content', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[str]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_extension_repo_version_extension(self, bucket_name, group_id, artifact_id, version, name, **kwargs):
        """
        Get extension repo extension
        Gets information about the extension with the given name in the given bucket, group, artifact, and version.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_extension_repo_version_extension(bucket_name, group_id, artifact_id, version, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_name: The bucket name (required)
        :param str group_id: The group identifier (required)
        :param str artifact_id: The artifact identifier (required)
        :param str version: The version (required)
        :param str name: The fully qualified name of the extension (required)
        :return: Extension
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_extension_repo_version_extension_with_http_info(bucket_name, group_id, artifact_id, version, name, **kwargs)
        else:
            (data) = self.get_extension_repo_version_extension_with_http_info(bucket_name, group_id, artifact_id, version, name, **kwargs)
            return data

    def get_extension_repo_version_extension_with_http_info(self, bucket_name, group_id, artifact_id, version, name, **kwargs):
        """
        Get extension repo extension
        Gets information about the extension with the given name in the given bucket, group, artifact, and version.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_extension_repo_version_extension_with_http_info(bucket_name, group_id, artifact_id, version, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_name: The bucket name (required)
        :param str group_id: The group identifier (required)
        :param str artifact_id: The artifact identifier (required)
        :param str version: The version (required)
        :param str name: The fully qualified name of the extension (required)
        :return: Extension
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bucket_name', 'group_id', 'artifact_id', 'version', 'name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_extension_repo_version_extension" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bucket_name' is set
        if ('bucket_name' not in params) or (params['bucket_name'] is None):
            raise ValueError("Missing the required parameter `bucket_name` when calling `get_extension_repo_version_extension`")
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `get_extension_repo_version_extension`")
        # verify the required parameter 'artifact_id' is set
        if ('artifact_id' not in params) or (params['artifact_id'] is None):
            raise ValueError("Missing the required parameter `artifact_id` when calling `get_extension_repo_version_extension`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `get_extension_repo_version_extension`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_extension_repo_version_extension`")


        collection_formats = {}

        path_params = {}
        if 'bucket_name' in params:
            path_params['bucketName'] = params['bucket_name']
        if 'group_id' in params:
            path_params['groupId'] = params['group_id']
        if 'artifact_id' in params:
            path_params['artifactId'] = params['artifact_id']
        if 'version' in params:
            path_params['version'] = params['version']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/extension-repository/{bucketName}/{groupId}/{artifactId}/{version}/extensions/{name}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Extension',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_extension_repo_version_extension_additional_details_docs(self, bucket_name, group_id, artifact_id, version, name, **kwargs):
        """
        Get extension repo extension details
        Gets the additional details documentation for the extension with the given name in the given bucket, group, artifact, and version.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_extension_repo_version_extension_additional_details_docs(bucket_name, group_id, artifact_id, version, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_name: The bucket name (required)
        :param str group_id: The group identifier (required)
        :param str artifact_id: The artifact identifier (required)
        :param str version: The version (required)
        :param str name: The fully qualified name of the extension (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_extension_repo_version_extension_additional_details_docs_with_http_info(bucket_name, group_id, artifact_id, version, name, **kwargs)
        else:
            (data) = self.get_extension_repo_version_extension_additional_details_docs_with_http_info(bucket_name, group_id, artifact_id, version, name, **kwargs)
            return data

    def get_extension_repo_version_extension_additional_details_docs_with_http_info(self, bucket_name, group_id, artifact_id, version, name, **kwargs):
        """
        Get extension repo extension details
        Gets the additional details documentation for the extension with the given name in the given bucket, group, artifact, and version.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_extension_repo_version_extension_additional_details_docs_with_http_info(bucket_name, group_id, artifact_id, version, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_name: The bucket name (required)
        :param str group_id: The group identifier (required)
        :param str artifact_id: The artifact identifier (required)
        :param str version: The version (required)
        :param str name: The fully qualified name of the extension (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bucket_name', 'group_id', 'artifact_id', 'version', 'name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_extension_repo_version_extension_additional_details_docs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bucket_name' is set
        if ('bucket_name' not in params) or (params['bucket_name'] is None):
            raise ValueError("Missing the required parameter `bucket_name` when calling `get_extension_repo_version_extension_additional_details_docs`")
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `get_extension_repo_version_extension_additional_details_docs`")
        # verify the required parameter 'artifact_id' is set
        if ('artifact_id' not in params) or (params['artifact_id'] is None):
            raise ValueError("Missing the required parameter `artifact_id` when calling `get_extension_repo_version_extension_additional_details_docs`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `get_extension_repo_version_extension_additional_details_docs`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_extension_repo_version_extension_additional_details_docs`")


        collection_formats = {}

        path_params = {}
        if 'bucket_name' in params:
            path_params['bucketName'] = params['bucket_name']
        if 'group_id' in params:
            path_params['groupId'] = params['group_id']
        if 'artifact_id' in params:
            path_params['artifactId'] = params['artifact_id']
        if 'version' in params:
            path_params['version'] = params['version']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/html'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/extension-repository/{bucketName}/{groupId}/{artifactId}/{version}/extensions/{name}/docs/additional-details', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_extension_repo_version_extension_docs(self, bucket_name, group_id, artifact_id, version, name, **kwargs):
        """
        Get extension repo extension docs
        Gets the documentation for the extension with the given name in the given bucket, group, artifact, and version.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_extension_repo_version_extension_docs(bucket_name, group_id, artifact_id, version, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_name: The bucket name (required)
        :param str group_id: The group identifier (required)
        :param str artifact_id: The artifact identifier (required)
        :param str version: The version (required)
        :param str name: The fully qualified name of the extension (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_extension_repo_version_extension_docs_with_http_info(bucket_name, group_id, artifact_id, version, name, **kwargs)
        else:
            (data) = self.get_extension_repo_version_extension_docs_with_http_info(bucket_name, group_id, artifact_id, version, name, **kwargs)
            return data

    def get_extension_repo_version_extension_docs_with_http_info(self, bucket_name, group_id, artifact_id, version, name, **kwargs):
        """
        Get extension repo extension docs
        Gets the documentation for the extension with the given name in the given bucket, group, artifact, and version.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_extension_repo_version_extension_docs_with_http_info(bucket_name, group_id, artifact_id, version, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_name: The bucket name (required)
        :param str group_id: The group identifier (required)
        :param str artifact_id: The artifact identifier (required)
        :param str version: The version (required)
        :param str name: The fully qualified name of the extension (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bucket_name', 'group_id', 'artifact_id', 'version', 'name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_extension_repo_version_extension_docs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bucket_name' is set
        if ('bucket_name' not in params) or (params['bucket_name'] is None):
            raise ValueError("Missing the required parameter `bucket_name` when calling `get_extension_repo_version_extension_docs`")
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `get_extension_repo_version_extension_docs`")
        # verify the required parameter 'artifact_id' is set
        if ('artifact_id' not in params) or (params['artifact_id'] is None):
            raise ValueError("Missing the required parameter `artifact_id` when calling `get_extension_repo_version_extension_docs`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `get_extension_repo_version_extension_docs`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_extension_repo_version_extension_docs`")


        collection_formats = {}

        path_params = {}
        if 'bucket_name' in params:
            path_params['bucketName'] = params['bucket_name']
        if 'group_id' in params:
            path_params['groupId'] = params['group_id']
        if 'artifact_id' in params:
            path_params['artifactId'] = params['artifact_id']
        if 'version' in params:
            path_params['version'] = params['version']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/html'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/extension-repository/{bucketName}/{groupId}/{artifactId}/{version}/extensions/{name}/docs', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_extension_repo_version_extensions(self, bucket_name, group_id, artifact_id, version, **kwargs):
        """
        Get extension repo extensions
        Gets information about the extensions in the given bucket, group, artifact, and version.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_extension_repo_version_extensions(bucket_name, group_id, artifact_id, version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_name: The bucket name (required)
        :param str group_id: The group identifier (required)
        :param str artifact_id: The artifact identifier (required)
        :param str version: The version (required)
        :return: list[ExtensionMetadata]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_extension_repo_version_extensions_with_http_info(bucket_name, group_id, artifact_id, version, **kwargs)
        else:
            (data) = self.get_extension_repo_version_extensions_with_http_info(bucket_name, group_id, artifact_id, version, **kwargs)
            return data

    def get_extension_repo_version_extensions_with_http_info(self, bucket_name, group_id, artifact_id, version, **kwargs):
        """
        Get extension repo extensions
        Gets information about the extensions in the given bucket, group, artifact, and version.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_extension_repo_version_extensions_with_http_info(bucket_name, group_id, artifact_id, version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_name: The bucket name (required)
        :param str group_id: The group identifier (required)
        :param str artifact_id: The artifact identifier (required)
        :param str version: The version (required)
        :return: list[ExtensionMetadata]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bucket_name', 'group_id', 'artifact_id', 'version']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_extension_repo_version_extensions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bucket_name' is set
        if ('bucket_name' not in params) or (params['bucket_name'] is None):
            raise ValueError("Missing the required parameter `bucket_name` when calling `get_extension_repo_version_extensions`")
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `get_extension_repo_version_extensions`")
        # verify the required parameter 'artifact_id' is set
        if ('artifact_id' not in params) or (params['artifact_id'] is None):
            raise ValueError("Missing the required parameter `artifact_id` when calling `get_extension_repo_version_extensions`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `get_extension_repo_version_extensions`")


        collection_formats = {}

        path_params = {}
        if 'bucket_name' in params:
            path_params['bucketName'] = params['bucket_name']
        if 'group_id' in params:
            path_params['groupId'] = params['group_id']
        if 'artifact_id' in params:
            path_params['artifactId'] = params['artifact_id']
        if 'version' in params:
            path_params['version'] = params['version']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/extension-repository/{bucketName}/{groupId}/{artifactId}/{version}/extensions', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[ExtensionMetadata]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_extension_repo_version_sha256(self, bucket_name, group_id, artifact_id, version, **kwargs):
        """
        Get extension repo version checksum
        Gets the hex representation of the SHA-256 digest for the binary content of the bundle with the given bucket, group, artifact, and version.  NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_extension_repo_version_sha256(bucket_name, group_id, artifact_id, version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_name: The bucket name (required)
        :param str group_id: The group identifier (required)
        :param str artifact_id: The artifact identifier (required)
        :param str version: The version (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_extension_repo_version_sha256_with_http_info(bucket_name, group_id, artifact_id, version, **kwargs)
        else:
            (data) = self.get_extension_repo_version_sha256_with_http_info(bucket_name, group_id, artifact_id, version, **kwargs)
            return data

    def get_extension_repo_version_sha256_with_http_info(self, bucket_name, group_id, artifact_id, version, **kwargs):
        """
        Get extension repo version checksum
        Gets the hex representation of the SHA-256 digest for the binary content of the bundle with the given bucket, group, artifact, and version.  NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_extension_repo_version_sha256_with_http_info(bucket_name, group_id, artifact_id, version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_name: The bucket name (required)
        :param str group_id: The group identifier (required)
        :param str artifact_id: The artifact identifier (required)
        :param str version: The version (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bucket_name', 'group_id', 'artifact_id', 'version']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_extension_repo_version_sha256" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bucket_name' is set
        if ('bucket_name' not in params) or (params['bucket_name'] is None):
            raise ValueError("Missing the required parameter `bucket_name` when calling `get_extension_repo_version_sha256`")
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `get_extension_repo_version_sha256`")
        # verify the required parameter 'artifact_id' is set
        if ('artifact_id' not in params) or (params['artifact_id'] is None):
            raise ValueError("Missing the required parameter `artifact_id` when calling `get_extension_repo_version_sha256`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `get_extension_repo_version_sha256`")


        collection_formats = {}

        path_params = {}
        if 'bucket_name' in params:
            path_params['bucketName'] = params['bucket_name']
        if 'group_id' in params:
            path_params['groupId'] = params['group_id']
        if 'artifact_id' in params:
            path_params['artifactId'] = params['artifact_id']
        if 'version' in params:
            path_params['version'] = params['version']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/extension-repository/{bucketName}/{groupId}/{artifactId}/{version}/sha256', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_extension_repo_versions(self, bucket_name, group_id, artifact_id, **kwargs):
        """
        Get extension repo versions
        Gets the versions in the extension repository for the given bucket, group, and artifact.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_extension_repo_versions(bucket_name, group_id, artifact_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_name: The bucket name (required)
        :param str group_id: The group identifier (required)
        :param str artifact_id: The artifact identifier (required)
        :return: list[ExtensionRepoVersionSummary]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_extension_repo_versions_with_http_info(bucket_name, group_id, artifact_id, **kwargs)
        else:
            (data) = self.get_extension_repo_versions_with_http_info(bucket_name, group_id, artifact_id, **kwargs)
            return data

    def get_extension_repo_versions_with_http_info(self, bucket_name, group_id, artifact_id, **kwargs):
        """
        Get extension repo versions
        Gets the versions in the extension repository for the given bucket, group, and artifact.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_extension_repo_versions_with_http_info(bucket_name, group_id, artifact_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_name: The bucket name (required)
        :param str group_id: The group identifier (required)
        :param str artifact_id: The artifact identifier (required)
        :return: list[ExtensionRepoVersionSummary]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bucket_name', 'group_id', 'artifact_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_extension_repo_versions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bucket_name' is set
        if ('bucket_name' not in params) or (params['bucket_name'] is None):
            raise ValueError("Missing the required parameter `bucket_name` when calling `get_extension_repo_versions`")
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `get_extension_repo_versions`")
        # verify the required parameter 'artifact_id' is set
        if ('artifact_id' not in params) or (params['artifact_id'] is None):
            raise ValueError("Missing the required parameter `artifact_id` when calling `get_extension_repo_versions`")


        collection_formats = {}

        path_params = {}
        if 'bucket_name' in params:
            path_params['bucketName'] = params['bucket_name']
        if 'group_id' in params:
            path_params['groupId'] = params['group_id']
        if 'artifact_id' in params:
            path_params['artifactId'] = params['artifact_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/extension-repository/{bucketName}/{groupId}/{artifactId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[ExtensionRepoVersionSummary]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_global_extension_repo_version_sha256(self, group_id, artifact_id, version, **kwargs):
        """
        Get global extension repo version checksum
        Gets the hex representation of the SHA-256 digest for the binary content with the given bucket, group, artifact, and version. Since the same group-artifact-version can exist in multiple buckets, this will return the checksum of the first one returned. This will be consistent since the checksum must be the same when existing in multiple buckets.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_global_extension_repo_version_sha256(group_id, artifact_id, version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: The group identifier (required)
        :param str artifact_id: The artifact identifier (required)
        :param str version: The version (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_global_extension_repo_version_sha256_with_http_info(group_id, artifact_id, version, **kwargs)
        else:
            (data) = self.get_global_extension_repo_version_sha256_with_http_info(group_id, artifact_id, version, **kwargs)
            return data

    def get_global_extension_repo_version_sha256_with_http_info(self, group_id, artifact_id, version, **kwargs):
        """
        Get global extension repo version checksum
        Gets the hex representation of the SHA-256 digest for the binary content with the given bucket, group, artifact, and version. Since the same group-artifact-version can exist in multiple buckets, this will return the checksum of the first one returned. This will be consistent since the checksum must be the same when existing in multiple buckets.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_global_extension_repo_version_sha256_with_http_info(group_id, artifact_id, version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: The group identifier (required)
        :param str artifact_id: The artifact identifier (required)
        :param str version: The version (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'artifact_id', 'version']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_global_extension_repo_version_sha256" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `get_global_extension_repo_version_sha256`")
        # verify the required parameter 'artifact_id' is set
        if ('artifact_id' not in params) or (params['artifact_id'] is None):
            raise ValueError("Missing the required parameter `artifact_id` when calling `get_global_extension_repo_version_sha256`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `get_global_extension_repo_version_sha256`")


        collection_formats = {}

        path_params = {}
        if 'group_id' in params:
            path_params['groupId'] = params['group_id']
        if 'artifact_id' in params:
            path_params['artifactId'] = params['artifact_id']
        if 'version' in params:
            path_params['version'] = params['version']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/extension-repository/{groupId}/{artifactId}/{version}/sha256', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
