# coding: utf-8

"""
    Apache NiFi Registry REST API

    The REST API provides an interface to a registry with operations for saving, versioning, reading NiFi flows and components.

    OpenAPI spec version: 1.17.0
    Contact: dev@nifi.apache.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class BucketFlowsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def create_flow(self, bucket_id, body, **kwargs):
        """
        Create flow
        Creates a flow in the given bucket. The flow id is created by the server and populated in the returned entity.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_flow(bucket_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_id: The bucket identifier (required)
        :param VersionedFlow body: The details of the flow to create. (required)
        :return: VersionedFlow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_flow_with_http_info(bucket_id, body, **kwargs)
        else:
            (data) = self.create_flow_with_http_info(bucket_id, body, **kwargs)
            return data

    def create_flow_with_http_info(self, bucket_id, body, **kwargs):
        """
        Create flow
        Creates a flow in the given bucket. The flow id is created by the server and populated in the returned entity.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_flow_with_http_info(bucket_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_id: The bucket identifier (required)
        :param VersionedFlow body: The details of the flow to create. (required)
        :return: VersionedFlow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bucket_id', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_flow" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in params) or (params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `create_flow`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_flow`")


        collection_formats = {}

        path_params = {}
        if 'bucket_id' in params:
            path_params['bucketId'] = params['bucket_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/buckets/{bucketId}/flows', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='VersionedFlow',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_flow_version(self, bucket_id, flow_id, body, **kwargs):
        """
        Create flow version
        Creates the next version of a flow. The version number of the object being created must be the next available version integer. Flow versions are immutable after they are created.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_flow_version(bucket_id, flow_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_id: The bucket identifier (required)
        :param str flow_id: The flow identifier (required)
        :param VersionedFlowSnapshot body: The new versioned flow snapshot. (required)
        :return: VersionedFlowSnapshot
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_flow_version_with_http_info(bucket_id, flow_id, body, **kwargs)
        else:
            (data) = self.create_flow_version_with_http_info(bucket_id, flow_id, body, **kwargs)
            return data

    def create_flow_version_with_http_info(self, bucket_id, flow_id, body, **kwargs):
        """
        Create flow version
        Creates the next version of a flow. The version number of the object being created must be the next available version integer. Flow versions are immutable after they are created.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_flow_version_with_http_info(bucket_id, flow_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_id: The bucket identifier (required)
        :param str flow_id: The flow identifier (required)
        :param VersionedFlowSnapshot body: The new versioned flow snapshot. (required)
        :return: VersionedFlowSnapshot
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bucket_id', 'flow_id', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_flow_version" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in params) or (params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `create_flow_version`")
        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `create_flow_version`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_flow_version`")


        collection_formats = {}

        path_params = {}
        if 'bucket_id' in params:
            path_params['bucketId'] = params['bucket_id']
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/buckets/{bucketId}/flows/{flowId}/versions', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='VersionedFlowSnapshot',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_flow(self, version, bucket_id, flow_id, **kwargs):
        """
        Delete bucket flow
        Deletes a flow, including all saved versions of that flow.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_flow(version, bucket_id, flow_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str version: The version is used to verify the client is working with the latest version of the entity. (required)
        :param str bucket_id: The bucket identifier (required)
        :param str flow_id: The flow identifier (required)
        :param str client_id: If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.
        :return: VersionedFlow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_flow_with_http_info(version, bucket_id, flow_id, **kwargs)
        else:
            (data) = self.delete_flow_with_http_info(version, bucket_id, flow_id, **kwargs)
            return data

    def delete_flow_with_http_info(self, version, bucket_id, flow_id, **kwargs):
        """
        Delete bucket flow
        Deletes a flow, including all saved versions of that flow.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_flow_with_http_info(version, bucket_id, flow_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str version: The version is used to verify the client is working with the latest version of the entity. (required)
        :param str bucket_id: The bucket identifier (required)
        :param str flow_id: The flow identifier (required)
        :param str client_id: If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.
        :return: VersionedFlow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['version', 'bucket_id', 'flow_id', 'client_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_flow" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `delete_flow`")
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in params) or (params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `delete_flow`")
        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `delete_flow`")


        collection_formats = {}

        path_params = {}
        if 'bucket_id' in params:
            path_params['bucketId'] = params['bucket_id']
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']

        query_params = []
        if 'version' in params:
            query_params.append(('version', params['version']))
        if 'client_id' in params:
            query_params.append(('clientId', params['client_id']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/buckets/{bucketId}/flows/{flowId}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='VersionedFlow',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def export_versioned_flow(self, bucket_id, flow_id, version_number, **kwargs):
        """
        Exports specified bucket flow version content
        Exports the specified version of a flow, including the metadata and content of the flow.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.export_versioned_flow(bucket_id, flow_id, version_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_id: The bucket identifier (required)
        :param str flow_id: The flow identifier (required)
        :param int version_number: The version number (required)
        :return: VersionedFlowSnapshot
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.export_versioned_flow_with_http_info(bucket_id, flow_id, version_number, **kwargs)
        else:
            (data) = self.export_versioned_flow_with_http_info(bucket_id, flow_id, version_number, **kwargs)
            return data

    def export_versioned_flow_with_http_info(self, bucket_id, flow_id, version_number, **kwargs):
        """
        Exports specified bucket flow version content
        Exports the specified version of a flow, including the metadata and content of the flow.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.export_versioned_flow_with_http_info(bucket_id, flow_id, version_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_id: The bucket identifier (required)
        :param str flow_id: The flow identifier (required)
        :param int version_number: The version number (required)
        :return: VersionedFlowSnapshot
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bucket_id', 'flow_id', 'version_number']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_versioned_flow" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in params) or (params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `export_versioned_flow`")
        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `export_versioned_flow`")
        # verify the required parameter 'version_number' is set
        if ('version_number' not in params) or (params['version_number'] is None):
            raise ValueError("Missing the required parameter `version_number` when calling `export_versioned_flow`")

        if 'version_number' in params and not re.search('\\d+', params['version_number']):
            raise ValueError("Invalid value for parameter `version_number` when calling `export_versioned_flow`, must conform to the pattern `/\\d+/`")

        collection_formats = {}

        path_params = {}
        if 'bucket_id' in params:
            path_params['bucketId'] = params['bucket_id']
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']
        if 'version_number' in params:
            path_params['versionNumber'] = params['version_number']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/buckets/{bucketId}/flows/{flowId}/versions/{versionNumber}/export', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='VersionedFlowSnapshot',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_flow(self, bucket_id, flow_id, **kwargs):
        """
        Get bucket flow
        Retrieves the flow with the given id in the given bucket.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flow(bucket_id, flow_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_id: The bucket identifier (required)
        :param str flow_id: The flow identifier (required)
        :return: VersionedFlow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_flow_with_http_info(bucket_id, flow_id, **kwargs)
        else:
            (data) = self.get_flow_with_http_info(bucket_id, flow_id, **kwargs)
            return data

    def get_flow_with_http_info(self, bucket_id, flow_id, **kwargs):
        """
        Get bucket flow
        Retrieves the flow with the given id in the given bucket.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flow_with_http_info(bucket_id, flow_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_id: The bucket identifier (required)
        :param str flow_id: The flow identifier (required)
        :return: VersionedFlow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bucket_id', 'flow_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flow" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in params) or (params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `get_flow`")
        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `get_flow`")


        collection_formats = {}

        path_params = {}
        if 'bucket_id' in params:
            path_params['bucketId'] = params['bucket_id']
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/buckets/{bucketId}/flows/{flowId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='VersionedFlow',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_flow_diff(self, bucket_id, flow_id, version_a, version_b, **kwargs):
        """
        Get bucket flow diff
        Computes the differences between two given versions of a flow.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flow_diff(bucket_id, flow_id, version_a, version_b, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_id: The bucket identifier (required)
        :param str flow_id: The flow identifier (required)
        :param int version_a: The first version number (required)
        :param int version_b: The second version number (required)
        :return: VersionedFlowDifference
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_flow_diff_with_http_info(bucket_id, flow_id, version_a, version_b, **kwargs)
        else:
            (data) = self.get_flow_diff_with_http_info(bucket_id, flow_id, version_a, version_b, **kwargs)
            return data

    def get_flow_diff_with_http_info(self, bucket_id, flow_id, version_a, version_b, **kwargs):
        """
        Get bucket flow diff
        Computes the differences between two given versions of a flow.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flow_diff_with_http_info(bucket_id, flow_id, version_a, version_b, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_id: The bucket identifier (required)
        :param str flow_id: The flow identifier (required)
        :param int version_a: The first version number (required)
        :param int version_b: The second version number (required)
        :return: VersionedFlowDifference
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bucket_id', 'flow_id', 'version_a', 'version_b']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flow_diff" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in params) or (params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `get_flow_diff`")
        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `get_flow_diff`")
        # verify the required parameter 'version_a' is set
        if ('version_a' not in params) or (params['version_a'] is None):
            raise ValueError("Missing the required parameter `version_a` when calling `get_flow_diff`")
        # verify the required parameter 'version_b' is set
        if ('version_b' not in params) or (params['version_b'] is None):
            raise ValueError("Missing the required parameter `version_b` when calling `get_flow_diff`")

        if 'version_a' in params and not re.search('\\d+', params['version_a']):
            raise ValueError("Invalid value for parameter `version_a` when calling `get_flow_diff`, must conform to the pattern `/\\d+/`")
        if 'version_b' in params and not re.search('\\d+', params['version_b']):
            raise ValueError("Invalid value for parameter `version_b` when calling `get_flow_diff`, must conform to the pattern `/\\d+/`")

        collection_formats = {}

        path_params = {}
        if 'bucket_id' in params:
            path_params['bucketId'] = params['bucket_id']
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']
        if 'version_a' in params:
            path_params['versionA'] = params['version_a']
        if 'version_b' in params:
            path_params['versionB'] = params['version_b']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/buckets/{bucketId}/flows/{flowId}/diff/{versionA}/{versionB}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='VersionedFlowDifference',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_flow_version(self, bucket_id, flow_id, version_number, **kwargs):
        """
        Get bucket flow version
        Gets the given version of a flow, including the metadata and content for the version.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flow_version(bucket_id, flow_id, version_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_id: The bucket identifier (required)
        :param str flow_id: The flow identifier (required)
        :param int version_number: The version number (required)
        :return: VersionedFlowSnapshot
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_flow_version_with_http_info(bucket_id, flow_id, version_number, **kwargs)
        else:
            (data) = self.get_flow_version_with_http_info(bucket_id, flow_id, version_number, **kwargs)
            return data

    def get_flow_version_with_http_info(self, bucket_id, flow_id, version_number, **kwargs):
        """
        Get bucket flow version
        Gets the given version of a flow, including the metadata and content for the version.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flow_version_with_http_info(bucket_id, flow_id, version_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_id: The bucket identifier (required)
        :param str flow_id: The flow identifier (required)
        :param int version_number: The version number (required)
        :return: VersionedFlowSnapshot
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bucket_id', 'flow_id', 'version_number']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flow_version" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in params) or (params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `get_flow_version`")
        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `get_flow_version`")
        # verify the required parameter 'version_number' is set
        if ('version_number' not in params) or (params['version_number'] is None):
            raise ValueError("Missing the required parameter `version_number` when calling `get_flow_version`")

        if 'version_number' in params and not re.search('\\d+', params['version_number']):
            raise ValueError("Invalid value for parameter `version_number` when calling `get_flow_version`, must conform to the pattern `/\\d+/`")

        collection_formats = {}

        path_params = {}
        if 'bucket_id' in params:
            path_params['bucketId'] = params['bucket_id']
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']
        if 'version_number' in params:
            path_params['versionNumber'] = params['version_number']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/buckets/{bucketId}/flows/{flowId}/versions/{versionNumber}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='VersionedFlowSnapshot',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_flow_versions(self, bucket_id, flow_id, **kwargs):
        """
        Get bucket flow versions
        Gets summary information for all versions of a flow. Versions are ordered newest->oldest.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flow_versions(bucket_id, flow_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_id: The bucket identifier (required)
        :param str flow_id: The flow identifier (required)
        :return: list[VersionedFlowSnapshotMetadata]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_flow_versions_with_http_info(bucket_id, flow_id, **kwargs)
        else:
            (data) = self.get_flow_versions_with_http_info(bucket_id, flow_id, **kwargs)
            return data

    def get_flow_versions_with_http_info(self, bucket_id, flow_id, **kwargs):
        """
        Get bucket flow versions
        Gets summary information for all versions of a flow. Versions are ordered newest->oldest.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flow_versions_with_http_info(bucket_id, flow_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_id: The bucket identifier (required)
        :param str flow_id: The flow identifier (required)
        :return: list[VersionedFlowSnapshotMetadata]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bucket_id', 'flow_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flow_versions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in params) or (params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `get_flow_versions`")
        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `get_flow_versions`")


        collection_formats = {}

        path_params = {}
        if 'bucket_id' in params:
            path_params['bucketId'] = params['bucket_id']
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/buckets/{bucketId}/flows/{flowId}/versions', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[VersionedFlowSnapshotMetadata]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_flows(self, bucket_id, **kwargs):
        """
        Get bucket flows
        Retrieves all flows in the given bucket.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows(bucket_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_id: The bucket identifier (required)
        :return: list[VersionedFlow]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_flows_with_http_info(bucket_id, **kwargs)
        else:
            (data) = self.get_flows_with_http_info(bucket_id, **kwargs)
            return data

    def get_flows_with_http_info(self, bucket_id, **kwargs):
        """
        Get bucket flows
        Retrieves all flows in the given bucket.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_with_http_info(bucket_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_id: The bucket identifier (required)
        :return: list[VersionedFlow]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bucket_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in params) or (params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `get_flows`")


        collection_formats = {}

        path_params = {}
        if 'bucket_id' in params:
            path_params['bucketId'] = params['bucket_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/buckets/{bucketId}/flows', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[VersionedFlow]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_latest_flow_version(self, bucket_id, flow_id, **kwargs):
        """
        Get latest bucket flow version content
        Gets the latest version of a flow, including the metadata and content of the flow.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_latest_flow_version(bucket_id, flow_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_id: The bucket identifier (required)
        :param str flow_id: The flow identifier (required)
        :return: VersionedFlowSnapshot
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_latest_flow_version_with_http_info(bucket_id, flow_id, **kwargs)
        else:
            (data) = self.get_latest_flow_version_with_http_info(bucket_id, flow_id, **kwargs)
            return data

    def get_latest_flow_version_with_http_info(self, bucket_id, flow_id, **kwargs):
        """
        Get latest bucket flow version content
        Gets the latest version of a flow, including the metadata and content of the flow.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_latest_flow_version_with_http_info(bucket_id, flow_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_id: The bucket identifier (required)
        :param str flow_id: The flow identifier (required)
        :return: VersionedFlowSnapshot
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bucket_id', 'flow_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_latest_flow_version" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in params) or (params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `get_latest_flow_version`")
        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `get_latest_flow_version`")


        collection_formats = {}

        path_params = {}
        if 'bucket_id' in params:
            path_params['bucketId'] = params['bucket_id']
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/buckets/{bucketId}/flows/{flowId}/versions/latest', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='VersionedFlowSnapshot',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_latest_flow_version_metadata(self, bucket_id, flow_id, **kwargs):
        """
        Get latest bucket flow version metadata
        Gets the metadata for the latest version of a flow.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_latest_flow_version_metadata(bucket_id, flow_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_id: The bucket identifier (required)
        :param str flow_id: The flow identifier (required)
        :return: VersionedFlowSnapshotMetadata
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_latest_flow_version_metadata_with_http_info(bucket_id, flow_id, **kwargs)
        else:
            (data) = self.get_latest_flow_version_metadata_with_http_info(bucket_id, flow_id, **kwargs)
            return data

    def get_latest_flow_version_metadata_with_http_info(self, bucket_id, flow_id, **kwargs):
        """
        Get latest bucket flow version metadata
        Gets the metadata for the latest version of a flow.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_latest_flow_version_metadata_with_http_info(bucket_id, flow_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_id: The bucket identifier (required)
        :param str flow_id: The flow identifier (required)
        :return: VersionedFlowSnapshotMetadata
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bucket_id', 'flow_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_latest_flow_version_metadata" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in params) or (params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `get_latest_flow_version_metadata`")
        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `get_latest_flow_version_metadata`")


        collection_formats = {}

        path_params = {}
        if 'bucket_id' in params:
            path_params['bucketId'] = params['bucket_id']
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/buckets/{bucketId}/flows/{flowId}/versions/latest/metadata', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='VersionedFlowSnapshotMetadata',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def import_versioned_flow(self, bucket_id, flow_id, **kwargs):
        """
        Import flow version
        Import the next version of a flow. The version number of the object being created will be the next available version integer. Flow versions are immutable after they are created.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.import_versioned_flow(bucket_id, flow_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_id: The bucket identifier (required)
        :param str flow_id: The flow identifier (required)
        :param VersionedFlowSnapshot body: file
        :param str comments:
        :return: VersionedFlowSnapshot
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.import_versioned_flow_with_http_info(bucket_id, flow_id, **kwargs)
        else:
            (data) = self.import_versioned_flow_with_http_info(bucket_id, flow_id, **kwargs)
            return data

    def import_versioned_flow_with_http_info(self, bucket_id, flow_id, **kwargs):
        """
        Import flow version
        Import the next version of a flow. The version number of the object being created will be the next available version integer. Flow versions are immutable after they are created.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.import_versioned_flow_with_http_info(bucket_id, flow_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_id: The bucket identifier (required)
        :param str flow_id: The flow identifier (required)
        :param VersionedFlowSnapshot body: file
        :param str comments:
        :return: VersionedFlowSnapshot
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bucket_id', 'flow_id', 'body', 'comments']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_versioned_flow" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in params) or (params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `import_versioned_flow`")
        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `import_versioned_flow`")


        collection_formats = {}

        path_params = {}
        if 'bucket_id' in params:
            path_params['bucketId'] = params['bucket_id']
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']

        query_params = []

        header_params = {}
        if 'comments' in params:
            header_params['Comments'] = params['comments']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/buckets/{bucketId}/flows/{flowId}/versions/import', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='VersionedFlowSnapshot',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_flow(self, bucket_id, flow_id, body, **kwargs):
        """
        Update bucket flow
        Updates the flow with the given id in the given bucket.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_flow(bucket_id, flow_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_id: The bucket identifier (required)
        :param str flow_id: The flow identifier (required)
        :param VersionedFlow body: The updated flow (required)
        :return: VersionedFlow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_flow_with_http_info(bucket_id, flow_id, body, **kwargs)
        else:
            (data) = self.update_flow_with_http_info(bucket_id, flow_id, body, **kwargs)
            return data

    def update_flow_with_http_info(self, bucket_id, flow_id, body, **kwargs):
        """
        Update bucket flow
        Updates the flow with the given id in the given bucket.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_flow_with_http_info(bucket_id, flow_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_id: The bucket identifier (required)
        :param str flow_id: The flow identifier (required)
        :param VersionedFlow body: The updated flow (required)
        :return: VersionedFlow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bucket_id', 'flow_id', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_flow" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in params) or (params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `update_flow`")
        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `update_flow`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_flow`")


        collection_formats = {}

        path_params = {}
        if 'bucket_id' in params:
            path_params['bucketId'] = params['bucket_id']
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/buckets/{bucketId}/flows/{flowId}', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='VersionedFlow',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
