# coding: utf-8

"""
    NiFi Rest API

    The Rest API provides programmatic access to command and control a NiFi instance in real time. Start and                                             stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.

    OpenAPI spec version: 1.17.0
    Contact: dev@nifi.apache.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class SchedulingDefaults(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'default_scheduling_strategy': 'str',
        'default_scheduling_period_millis': 'int',
        'penalization_period_millis': 'int',
        'yield_duration_millis': 'int',
        'default_run_duration_nanos': 'int',
        'default_max_concurrent_tasks': 'str',
        'default_concurrent_tasks_by_scheduling_strategy': 'dict(str, int)',
        'default_scheduling_periods_by_scheduling_strategy': 'dict(str, str)'
    }

    attribute_map = {
        'default_scheduling_strategy': 'defaultSchedulingStrategy',
        'default_scheduling_period_millis': 'defaultSchedulingPeriodMillis',
        'penalization_period_millis': 'penalizationPeriodMillis',
        'yield_duration_millis': 'yieldDurationMillis',
        'default_run_duration_nanos': 'defaultRunDurationNanos',
        'default_max_concurrent_tasks': 'defaultMaxConcurrentTasks',
        'default_concurrent_tasks_by_scheduling_strategy': 'defaultConcurrentTasksBySchedulingStrategy',
        'default_scheduling_periods_by_scheduling_strategy': 'defaultSchedulingPeriodsBySchedulingStrategy'
    }

    def __init__(self, default_scheduling_strategy=None, default_scheduling_period_millis=None, penalization_period_millis=None, yield_duration_millis=None, default_run_duration_nanos=None, default_max_concurrent_tasks=None, default_concurrent_tasks_by_scheduling_strategy=None, default_scheduling_periods_by_scheduling_strategy=None):
        """
        SchedulingDefaults - a model defined in Swagger
        """

        self._default_scheduling_strategy = None
        self._default_scheduling_period_millis = None
        self._penalization_period_millis = None
        self._yield_duration_millis = None
        self._default_run_duration_nanos = None
        self._default_max_concurrent_tasks = None
        self._default_concurrent_tasks_by_scheduling_strategy = None
        self._default_scheduling_periods_by_scheduling_strategy = None

        if default_scheduling_strategy is not None:
          self.default_scheduling_strategy = default_scheduling_strategy
        if default_scheduling_period_millis is not None:
          self.default_scheduling_period_millis = default_scheduling_period_millis
        if penalization_period_millis is not None:
          self.penalization_period_millis = penalization_period_millis
        if yield_duration_millis is not None:
          self.yield_duration_millis = yield_duration_millis
        if default_run_duration_nanos is not None:
          self.default_run_duration_nanos = default_run_duration_nanos
        if default_max_concurrent_tasks is not None:
          self.default_max_concurrent_tasks = default_max_concurrent_tasks
        if default_concurrent_tasks_by_scheduling_strategy is not None:
          self.default_concurrent_tasks_by_scheduling_strategy = default_concurrent_tasks_by_scheduling_strategy
        if default_scheduling_periods_by_scheduling_strategy is not None:
          self.default_scheduling_periods_by_scheduling_strategy = default_scheduling_periods_by_scheduling_strategy

    @property
    def default_scheduling_strategy(self):
        """
        Gets the default_scheduling_strategy of this SchedulingDefaults.
        The name of the default scheduling strategy

        :return: The default_scheduling_strategy of this SchedulingDefaults.
        :rtype: str
        """
        return self._default_scheduling_strategy

    @default_scheduling_strategy.setter
    def default_scheduling_strategy(self, default_scheduling_strategy):
        """
        Sets the default_scheduling_strategy of this SchedulingDefaults.
        The name of the default scheduling strategy

        :param default_scheduling_strategy: The default_scheduling_strategy of this SchedulingDefaults.
        :type: str
        """
        allowed_values = ["EVENT_DRIVEN", "TIMER_DRIVEN", "PRIMARY_NODE_ONLY", "CRON_DRIVEN"]
        if default_scheduling_strategy not in allowed_values:
            raise ValueError(
                "Invalid value for `default_scheduling_strategy` ({0}), must be one of {1}"
                .format(default_scheduling_strategy, allowed_values)
            )

        self._default_scheduling_strategy = default_scheduling_strategy

    @property
    def default_scheduling_period_millis(self):
        """
        Gets the default_scheduling_period_millis of this SchedulingDefaults.
        The default scheduling period in milliseconds

        :return: The default_scheduling_period_millis of this SchedulingDefaults.
        :rtype: int
        """
        return self._default_scheduling_period_millis

    @default_scheduling_period_millis.setter
    def default_scheduling_period_millis(self, default_scheduling_period_millis):
        """
        Sets the default_scheduling_period_millis of this SchedulingDefaults.
        The default scheduling period in milliseconds

        :param default_scheduling_period_millis: The default_scheduling_period_millis of this SchedulingDefaults.
        :type: int
        """

        self._default_scheduling_period_millis = default_scheduling_period_millis

    @property
    def penalization_period_millis(self):
        """
        Gets the penalization_period_millis of this SchedulingDefaults.
        The default penalization period in milliseconds

        :return: The penalization_period_millis of this SchedulingDefaults.
        :rtype: int
        """
        return self._penalization_period_millis

    @penalization_period_millis.setter
    def penalization_period_millis(self, penalization_period_millis):
        """
        Sets the penalization_period_millis of this SchedulingDefaults.
        The default penalization period in milliseconds

        :param penalization_period_millis: The penalization_period_millis of this SchedulingDefaults.
        :type: int
        """

        self._penalization_period_millis = penalization_period_millis

    @property
    def yield_duration_millis(self):
        """
        Gets the yield_duration_millis of this SchedulingDefaults.
        The default yield duration in milliseconds

        :return: The yield_duration_millis of this SchedulingDefaults.
        :rtype: int
        """
        return self._yield_duration_millis

    @yield_duration_millis.setter
    def yield_duration_millis(self, yield_duration_millis):
        """
        Sets the yield_duration_millis of this SchedulingDefaults.
        The default yield duration in milliseconds

        :param yield_duration_millis: The yield_duration_millis of this SchedulingDefaults.
        :type: int
        """

        self._yield_duration_millis = yield_duration_millis

    @property
    def default_run_duration_nanos(self):
        """
        Gets the default_run_duration_nanos of this SchedulingDefaults.
        The default run duration in nano-seconds

        :return: The default_run_duration_nanos of this SchedulingDefaults.
        :rtype: int
        """
        return self._default_run_duration_nanos

    @default_run_duration_nanos.setter
    def default_run_duration_nanos(self, default_run_duration_nanos):
        """
        Sets the default_run_duration_nanos of this SchedulingDefaults.
        The default run duration in nano-seconds

        :param default_run_duration_nanos: The default_run_duration_nanos of this SchedulingDefaults.
        :type: int
        """

        self._default_run_duration_nanos = default_run_duration_nanos

    @property
    def default_max_concurrent_tasks(self):
        """
        Gets the default_max_concurrent_tasks of this SchedulingDefaults.
        The default concurrent tasks

        :return: The default_max_concurrent_tasks of this SchedulingDefaults.
        :rtype: str
        """
        return self._default_max_concurrent_tasks

    @default_max_concurrent_tasks.setter
    def default_max_concurrent_tasks(self, default_max_concurrent_tasks):
        """
        Sets the default_max_concurrent_tasks of this SchedulingDefaults.
        The default concurrent tasks

        :param default_max_concurrent_tasks: The default_max_concurrent_tasks of this SchedulingDefaults.
        :type: str
        """

        self._default_max_concurrent_tasks = default_max_concurrent_tasks

    @property
    def default_concurrent_tasks_by_scheduling_strategy(self):
        """
        Gets the default_concurrent_tasks_by_scheduling_strategy of this SchedulingDefaults.
        The default concurrent tasks for each scheduling strategy

        :return: The default_concurrent_tasks_by_scheduling_strategy of this SchedulingDefaults.
        :rtype: dict(str, int)
        """
        return self._default_concurrent_tasks_by_scheduling_strategy

    @default_concurrent_tasks_by_scheduling_strategy.setter
    def default_concurrent_tasks_by_scheduling_strategy(self, default_concurrent_tasks_by_scheduling_strategy):
        """
        Sets the default_concurrent_tasks_by_scheduling_strategy of this SchedulingDefaults.
        The default concurrent tasks for each scheduling strategy

        :param default_concurrent_tasks_by_scheduling_strategy: The default_concurrent_tasks_by_scheduling_strategy of this SchedulingDefaults.
        :type: dict(str, int)
        """

        self._default_concurrent_tasks_by_scheduling_strategy = default_concurrent_tasks_by_scheduling_strategy

    @property
    def default_scheduling_periods_by_scheduling_strategy(self):
        """
        Gets the default_scheduling_periods_by_scheduling_strategy of this SchedulingDefaults.
        The default scheduling period for each scheduling strategy

        :return: The default_scheduling_periods_by_scheduling_strategy of this SchedulingDefaults.
        :rtype: dict(str, str)
        """
        return self._default_scheduling_periods_by_scheduling_strategy

    @default_scheduling_periods_by_scheduling_strategy.setter
    def default_scheduling_periods_by_scheduling_strategy(self, default_scheduling_periods_by_scheduling_strategy):
        """
        Sets the default_scheduling_periods_by_scheduling_strategy of this SchedulingDefaults.
        The default scheduling period for each scheduling strategy

        :param default_scheduling_periods_by_scheduling_strategy: The default_scheduling_periods_by_scheduling_strategy of this SchedulingDefaults.
        :type: dict(str, str)
        """

        self._default_scheduling_periods_by_scheduling_strategy = default_scheduling_periods_by_scheduling_strategy

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, SchedulingDefaults):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
