# coding: utf-8

"""
    NiFi Rest API

    The Rest API provides programmatic access to command and control a NiFi instance in real time. Start and                                             stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.

    OpenAPI spec version: 1.17.0
    Contact: dev@nifi.apache.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class RuntimeManifest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'identifier': 'str',
        'agent_type': 'str',
        'version': 'str',
        'build_info': 'BuildInfo',
        'bundles': 'list[Bundle]',
        'scheduling_defaults': 'SchedulingDefaults'
    }

    attribute_map = {
        'identifier': 'identifier',
        'agent_type': 'agentType',
        'version': 'version',
        'build_info': 'buildInfo',
        'bundles': 'bundles',
        'scheduling_defaults': 'schedulingDefaults'
    }

    def __init__(self, identifier=None, agent_type=None, version=None, build_info=None, bundles=None, scheduling_defaults=None):
        """
        RuntimeManifest - a model defined in Swagger
        """

        self._identifier = None
        self._agent_type = None
        self._version = None
        self._build_info = None
        self._bundles = None
        self._scheduling_defaults = None

        if identifier is not None:
          self.identifier = identifier
        if agent_type is not None:
          self.agent_type = agent_type
        if version is not None:
          self.version = version
        if build_info is not None:
          self.build_info = build_info
        if bundles is not None:
          self.bundles = bundles
        if scheduling_defaults is not None:
          self.scheduling_defaults = scheduling_defaults

    @property
    def identifier(self):
        """
        Gets the identifier of this RuntimeManifest.
        A unique identifier for the manifest

        :return: The identifier of this RuntimeManifest.
        :rtype: str
        """
        return self._identifier

    @identifier.setter
    def identifier(self, identifier):
        """
        Sets the identifier of this RuntimeManifest.
        A unique identifier for the manifest

        :param identifier: The identifier of this RuntimeManifest.
        :type: str
        """

        self._identifier = identifier

    @property
    def agent_type(self):
        """
        Gets the agent_type of this RuntimeManifest.
        The type of the runtime binary, e.g., 'minifi-java' or 'minifi-cpp'

        :return: The agent_type of this RuntimeManifest.
        :rtype: str
        """
        return self._agent_type

    @agent_type.setter
    def agent_type(self, agent_type):
        """
        Sets the agent_type of this RuntimeManifest.
        The type of the runtime binary, e.g., 'minifi-java' or 'minifi-cpp'

        :param agent_type: The agent_type of this RuntimeManifest.
        :type: str
        """

        self._agent_type = agent_type

    @property
    def version(self):
        """
        Gets the version of this RuntimeManifest.
        The version of the runtime binary, e.g., '1.0.1'

        :return: The version of this RuntimeManifest.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this RuntimeManifest.
        The version of the runtime binary, e.g., '1.0.1'

        :param version: The version of this RuntimeManifest.
        :type: str
        """

        self._version = version

    @property
    def build_info(self):
        """
        Gets the build_info of this RuntimeManifest.
        Build summary for this runtime binary

        :return: The build_info of this RuntimeManifest.
        :rtype: BuildInfo
        """
        return self._build_info

    @build_info.setter
    def build_info(self, build_info):
        """
        Sets the build_info of this RuntimeManifest.
        Build summary for this runtime binary

        :param build_info: The build_info of this RuntimeManifest.
        :type: BuildInfo
        """

        self._build_info = build_info

    @property
    def bundles(self):
        """
        Gets the bundles of this RuntimeManifest.
        All extension bundles included with this runtime

        :return: The bundles of this RuntimeManifest.
        :rtype: list[Bundle]
        """
        return self._bundles

    @bundles.setter
    def bundles(self, bundles):
        """
        Sets the bundles of this RuntimeManifest.
        All extension bundles included with this runtime

        :param bundles: The bundles of this RuntimeManifest.
        :type: list[Bundle]
        """

        self._bundles = bundles

    @property
    def scheduling_defaults(self):
        """
        Gets the scheduling_defaults of this RuntimeManifest.
        Scheduling defaults for components defined in this manifest

        :return: The scheduling_defaults of this RuntimeManifest.
        :rtype: SchedulingDefaults
        """
        return self._scheduling_defaults

    @scheduling_defaults.setter
    def scheduling_defaults(self, scheduling_defaults):
        """
        Sets the scheduling_defaults of this RuntimeManifest.
        Scheduling defaults for components defined in this manifest

        :param scheduling_defaults: The scheduling_defaults of this RuntimeManifest.
        :type: SchedulingDefaults
        """

        self._scheduling_defaults = scheduling_defaults

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, RuntimeManifest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
