# coding: utf-8

"""
    NiFi Rest API

    The Rest API provides programmatic access to command and control a NiFi instance in real time. Start and                                             stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.

    OpenAPI spec version: 1.17.0
    Contact: dev@nifi.apache.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Restriction(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'required_permission': 'str',
        'explanation': 'str'
    }

    attribute_map = {
        'required_permission': 'requiredPermission',
        'explanation': 'explanation'
    }

    def __init__(self, required_permission=None, explanation=None):
        """
        Restriction - a model defined in Swagger
        """

        self._required_permission = None
        self._explanation = None

        if required_permission is not None:
          self.required_permission = required_permission
        if explanation is not None:
          self.explanation = explanation

    @property
    def required_permission(self):
        """
        Gets the required_permission of this Restriction.
        The permission required for this restriction

        :return: The required_permission of this Restriction.
        :rtype: str
        """
        return self._required_permission

    @required_permission.setter
    def required_permission(self, required_permission):
        """
        Sets the required_permission of this Restriction.
        The permission required for this restriction

        :param required_permission: The required_permission of this Restriction.
        :type: str
        """

        self._required_permission = required_permission

    @property
    def explanation(self):
        """
        Gets the explanation of this Restriction.
        The explanation of this restriction

        :return: The explanation of this Restriction.
        :rtype: str
        """
        return self._explanation

    @explanation.setter
    def explanation(self, explanation):
        """
        Sets the explanation of this Restriction.
        The explanation of this restriction

        :param explanation: The explanation of this Restriction.
        :type: str
        """

        self._explanation = explanation

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Restriction):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
