# coding: utf-8

"""
    NiFi Rest API

    The Rest API provides programmatic access to command and control a NiFi instance in real time. Start and                                             stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.

    OpenAPI spec version: 1.17.0
    Contact: dev@nifi.apache.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class JVMDiagnosticsDTO(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'clustered': 'bool',
        'connected': 'bool',
        'aggregate_snapshot': 'JVMDiagnosticsSnapshotDTO',
        'node_snapshots': 'list[NodeJVMDiagnosticsSnapshotDTO]'
    }

    attribute_map = {
        'clustered': 'clustered',
        'connected': 'connected',
        'aggregate_snapshot': 'aggregateSnapshot',
        'node_snapshots': 'nodeSnapshots'
    }

    def __init__(self, clustered=None, connected=None, aggregate_snapshot=None, node_snapshots=None):
        """
        JVMDiagnosticsDTO - a model defined in Swagger
        """

        self._clustered = None
        self._connected = None
        self._aggregate_snapshot = None
        self._node_snapshots = None

        if clustered is not None:
          self.clustered = clustered
        if connected is not None:
          self.connected = connected
        if aggregate_snapshot is not None:
          self.aggregate_snapshot = aggregate_snapshot
        if node_snapshots is not None:
          self.node_snapshots = node_snapshots

    @property
    def clustered(self):
        """
        Gets the clustered of this JVMDiagnosticsDTO.
        Whether or not the NiFi instance is clustered

        :return: The clustered of this JVMDiagnosticsDTO.
        :rtype: bool
        """
        return self._clustered

    @clustered.setter
    def clustered(self, clustered):
        """
        Sets the clustered of this JVMDiagnosticsDTO.
        Whether or not the NiFi instance is clustered

        :param clustered: The clustered of this JVMDiagnosticsDTO.
        :type: bool
        """

        self._clustered = clustered

    @property
    def connected(self):
        """
        Gets the connected of this JVMDiagnosticsDTO.
        Whether or not the node is connected to the cluster

        :return: The connected of this JVMDiagnosticsDTO.
        :rtype: bool
        """
        return self._connected

    @connected.setter
    def connected(self, connected):
        """
        Sets the connected of this JVMDiagnosticsDTO.
        Whether or not the node is connected to the cluster

        :param connected: The connected of this JVMDiagnosticsDTO.
        :type: bool
        """

        self._connected = connected

    @property
    def aggregate_snapshot(self):
        """
        Gets the aggregate_snapshot of this JVMDiagnosticsDTO.
        Aggregate JVM diagnostic information about the entire cluster

        :return: The aggregate_snapshot of this JVMDiagnosticsDTO.
        :rtype: JVMDiagnosticsSnapshotDTO
        """
        return self._aggregate_snapshot

    @aggregate_snapshot.setter
    def aggregate_snapshot(self, aggregate_snapshot):
        """
        Sets the aggregate_snapshot of this JVMDiagnosticsDTO.
        Aggregate JVM diagnostic information about the entire cluster

        :param aggregate_snapshot: The aggregate_snapshot of this JVMDiagnosticsDTO.
        :type: JVMDiagnosticsSnapshotDTO
        """

        self._aggregate_snapshot = aggregate_snapshot

    @property
    def node_snapshots(self):
        """
        Gets the node_snapshots of this JVMDiagnosticsDTO.
        Node-wise breakdown of JVM diagnostic information

        :return: The node_snapshots of this JVMDiagnosticsDTO.
        :rtype: list[NodeJVMDiagnosticsSnapshotDTO]
        """
        return self._node_snapshots

    @node_snapshots.setter
    def node_snapshots(self, node_snapshots):
        """
        Sets the node_snapshots of this JVMDiagnosticsDTO.
        Node-wise breakdown of JVM diagnostic information

        :param node_snapshots: The node_snapshots of this JVMDiagnosticsDTO.
        :type: list[NodeJVMDiagnosticsSnapshotDTO]
        """

        self._node_snapshots = node_snapshots

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, JVMDiagnosticsDTO):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
