# coding: utf-8

"""
    NiFi Rest API

    The Rest API provides programmatic access to command and control a NiFi instance in real time. Start and                                             stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.

    OpenAPI spec version: 1.17.0
    Contact: dev@nifi.apache.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ComponentManifest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'apis': 'list[DefinedType]',
        'controller_services': 'list[ControllerServiceDefinition]',
        'processors': 'list[ProcessorDefinition]',
        'reporting_tasks': 'list[ReportingTaskDefinition]'
    }

    attribute_map = {
        'apis': 'apis',
        'controller_services': 'controllerServices',
        'processors': 'processors',
        'reporting_tasks': 'reportingTasks'
    }

    def __init__(self, apis=None, controller_services=None, processors=None, reporting_tasks=None):
        """
        ComponentManifest - a model defined in Swagger
        """

        self._apis = None
        self._controller_services = None
        self._processors = None
        self._reporting_tasks = None

        if apis is not None:
          self.apis = apis
        if controller_services is not None:
          self.controller_services = controller_services
        if processors is not None:
          self.processors = processors
        if reporting_tasks is not None:
          self.reporting_tasks = reporting_tasks

    @property
    def apis(self):
        """
        Gets the apis of this ComponentManifest.
        Public interfaces defined in this bundle

        :return: The apis of this ComponentManifest.
        :rtype: list[DefinedType]
        """
        return self._apis

    @apis.setter
    def apis(self, apis):
        """
        Sets the apis of this ComponentManifest.
        Public interfaces defined in this bundle

        :param apis: The apis of this ComponentManifest.
        :type: list[DefinedType]
        """

        self._apis = apis

    @property
    def controller_services(self):
        """
        Gets the controller_services of this ComponentManifest.
        Controller Services provided in this bundle

        :return: The controller_services of this ComponentManifest.
        :rtype: list[ControllerServiceDefinition]
        """
        return self._controller_services

    @controller_services.setter
    def controller_services(self, controller_services):
        """
        Sets the controller_services of this ComponentManifest.
        Controller Services provided in this bundle

        :param controller_services: The controller_services of this ComponentManifest.
        :type: list[ControllerServiceDefinition]
        """

        self._controller_services = controller_services

    @property
    def processors(self):
        """
        Gets the processors of this ComponentManifest.
        Processors provided in this bundle

        :return: The processors of this ComponentManifest.
        :rtype: list[ProcessorDefinition]
        """
        return self._processors

    @processors.setter
    def processors(self, processors):
        """
        Sets the processors of this ComponentManifest.
        Processors provided in this bundle

        :param processors: The processors of this ComponentManifest.
        :type: list[ProcessorDefinition]
        """

        self._processors = processors

    @property
    def reporting_tasks(self):
        """
        Gets the reporting_tasks of this ComponentManifest.
        Reporting Tasks provided in this bundle

        :return: The reporting_tasks of this ComponentManifest.
        :rtype: list[ReportingTaskDefinition]
        """
        return self._reporting_tasks

    @reporting_tasks.setter
    def reporting_tasks(self, reporting_tasks):
        """
        Sets the reporting_tasks of this ComponentManifest.
        Reporting Tasks provided in this bundle

        :param reporting_tasks: The reporting_tasks of this ComponentManifest.
        :type: list[ReportingTaskDefinition]
        """

        self._reporting_tasks = reporting_tasks

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ComponentManifest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
