# coding: utf-8

"""
    NiFi Rest API

    The Rest API provides programmatic access to command and control a NiFi instance in real time. Start and                                             stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.

    OpenAPI spec version: 1.17.0
    Contact: dev@nifi.apache.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class ParameterContextsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def create_parameter_context(self, body, **kwargs):
        """
        Create a Parameter Context
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_parameter_context(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ParameterContextEntity body: The Parameter Context. (required)
        :return: ParameterContextEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_parameter_context_with_http_info(body, **kwargs)
        else:
            (data) = self.create_parameter_context_with_http_info(body, **kwargs)
            return data

    def create_parameter_context_with_http_info(self, body, **kwargs):
        """
        Create a Parameter Context
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_parameter_context_with_http_info(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ParameterContextEntity body: The Parameter Context. (required)
        :return: ParameterContextEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_parameter_context" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_parameter_context`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['tokenAuth']

        return self.api_client.call_api('/parameter-contexts', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ParameterContextEntity',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_parameter_context(self, id, **kwargs):
        """
        Deletes the Parameter Context with the given ID
        Deletes the Parameter Context with the given ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_parameter_context(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The Parameter Context ID. (required)
        :param str version: The version is used to verify the client is working with the latest version of the flow.
        :param str client_id: If the client id is not specified, a new one will be generated. This value (whether specified or generated) is included in the response.
        :param bool disconnected_node_acknowledged: Acknowledges that this node is disconnected to allow for mutable requests to proceed.
        :return: ParameterContextEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_parameter_context_with_http_info(id, **kwargs)
        else:
            (data) = self.delete_parameter_context_with_http_info(id, **kwargs)
            return data

    def delete_parameter_context_with_http_info(self, id, **kwargs):
        """
        Deletes the Parameter Context with the given ID
        Deletes the Parameter Context with the given ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_parameter_context_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The Parameter Context ID. (required)
        :param str version: The version is used to verify the client is working with the latest version of the flow.
        :param str client_id: If the client id is not specified, a new one will be generated. This value (whether specified or generated) is included in the response.
        :param bool disconnected_node_acknowledged: Acknowledges that this node is disconnected to allow for mutable requests to proceed.
        :return: ParameterContextEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'version', 'client_id', 'disconnected_node_acknowledged']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_parameter_context" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_parameter_context`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []
        if 'version' in params:
            query_params.append(('version', params['version']))
        if 'client_id' in params:
            query_params.append(('clientId', params['client_id']))
        if 'disconnected_node_acknowledged' in params:
            query_params.append(('disconnectedNodeAcknowledged', params['disconnected_node_acknowledged']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth']

        return self.api_client.call_api('/parameter-contexts/{id}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ParameterContextEntity',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_update_request(self, context_id, request_id, **kwargs):
        """
        Deletes the Update Request with the given ID
        Deletes the Update Request with the given ID. After a request is created via a POST to /nifi-api/parameter-contexts/update-requests, it is expected that the client will properly clean up the request by DELETE'ing it, once the Update process has completed. If the request is deleted before the request completes, then the Update request will finish the step that it is currently performing and then will cancel any subsequent steps.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_update_request(context_id, request_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str context_id: The ID of the ParameterContext (required)
        :param str request_id: The ID of the Update Request (required)
        :param bool disconnected_node_acknowledged: Acknowledges that this node is disconnected to allow for mutable requests to proceed.
        :return: ParameterContextUpdateRequestEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_update_request_with_http_info(context_id, request_id, **kwargs)
        else:
            (data) = self.delete_update_request_with_http_info(context_id, request_id, **kwargs)
            return data

    def delete_update_request_with_http_info(self, context_id, request_id, **kwargs):
        """
        Deletes the Update Request with the given ID
        Deletes the Update Request with the given ID. After a request is created via a POST to /nifi-api/parameter-contexts/update-requests, it is expected that the client will properly clean up the request by DELETE'ing it, once the Update process has completed. If the request is deleted before the request completes, then the Update request will finish the step that it is currently performing and then will cancel any subsequent steps.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_update_request_with_http_info(context_id, request_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str context_id: The ID of the ParameterContext (required)
        :param str request_id: The ID of the Update Request (required)
        :param bool disconnected_node_acknowledged: Acknowledges that this node is disconnected to allow for mutable requests to proceed.
        :return: ParameterContextUpdateRequestEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['context_id', 'request_id', 'disconnected_node_acknowledged']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_update_request" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'context_id' is set
        if ('context_id' not in params) or (params['context_id'] is None):
            raise ValueError("Missing the required parameter `context_id` when calling `delete_update_request`")
        # verify the required parameter 'request_id' is set
        if ('request_id' not in params) or (params['request_id'] is None):
            raise ValueError("Missing the required parameter `request_id` when calling `delete_update_request`")


        collection_formats = {}

        path_params = {}
        if 'context_id' in params:
            path_params['contextId'] = params['context_id']
        if 'request_id' in params:
            path_params['requestId'] = params['request_id']

        query_params = []
        if 'disconnected_node_acknowledged' in params:
            query_params.append(('disconnectedNodeAcknowledged', params['disconnected_node_acknowledged']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth']

        return self.api_client.call_api('/parameter-contexts/{contextId}/update-requests/{requestId}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ParameterContextUpdateRequestEntity',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_validation_request(self, context_id, id, **kwargs):
        """
        Deletes the Validation Request with the given ID
        Deletes the Validation Request with the given ID. After a request is created via a POST to /nifi-api/validation-contexts, it is expected that the client will properly clean up the request by DELETE'ing it, once the validation process has completed. If the request is deleted before the request completes, then the Validation request will finish the step that it is currently performing and then will cancel any subsequent steps.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_validation_request(context_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str context_id: The ID of the Parameter Context (required)
        :param str id: The ID of the Update Request (required)
        :param bool disconnected_node_acknowledged: Acknowledges that this node is disconnected to allow for mutable requests to proceed.
        :return: ParameterContextValidationRequestEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_validation_request_with_http_info(context_id, id, **kwargs)
        else:
            (data) = self.delete_validation_request_with_http_info(context_id, id, **kwargs)
            return data

    def delete_validation_request_with_http_info(self, context_id, id, **kwargs):
        """
        Deletes the Validation Request with the given ID
        Deletes the Validation Request with the given ID. After a request is created via a POST to /nifi-api/validation-contexts, it is expected that the client will properly clean up the request by DELETE'ing it, once the validation process has completed. If the request is deleted before the request completes, then the Validation request will finish the step that it is currently performing and then will cancel any subsequent steps.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_validation_request_with_http_info(context_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str context_id: The ID of the Parameter Context (required)
        :param str id: The ID of the Update Request (required)
        :param bool disconnected_node_acknowledged: Acknowledges that this node is disconnected to allow for mutable requests to proceed.
        :return: ParameterContextValidationRequestEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['context_id', 'id', 'disconnected_node_acknowledged']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_validation_request" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'context_id' is set
        if ('context_id' not in params) or (params['context_id'] is None):
            raise ValueError("Missing the required parameter `context_id` when calling `delete_validation_request`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_validation_request`")


        collection_formats = {}

        path_params = {}
        if 'context_id' in params:
            path_params['contextId'] = params['context_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []
        if 'disconnected_node_acknowledged' in params:
            query_params.append(('disconnectedNodeAcknowledged', params['disconnected_node_acknowledged']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth']

        return self.api_client.call_api('/parameter-contexts/{contextId}/validation-requests/{id}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ParameterContextValidationRequestEntity',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_parameter_context(self, id, **kwargs):
        """
        Returns the Parameter Context with the given ID
        Returns the Parameter Context with the given ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_parameter_context(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The ID of the Parameter Context (required)
        :param bool include_inherited_parameters: Whether or not to include inherited parameters from other parameter contexts, and therefore also overridden values.  If true, the result will be the 'effective' parameter context.
        :return: ParameterContextEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_parameter_context_with_http_info(id, **kwargs)
        else:
            (data) = self.get_parameter_context_with_http_info(id, **kwargs)
            return data

    def get_parameter_context_with_http_info(self, id, **kwargs):
        """
        Returns the Parameter Context with the given ID
        Returns the Parameter Context with the given ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_parameter_context_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The ID of the Parameter Context (required)
        :param bool include_inherited_parameters: Whether or not to include inherited parameters from other parameter contexts, and therefore also overridden values.  If true, the result will be the 'effective' parameter context.
        :return: ParameterContextEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'include_inherited_parameters']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_parameter_context" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_parameter_context`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []
        if 'include_inherited_parameters' in params:
            query_params.append(('includeInheritedParameters', params['include_inherited_parameters']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth']

        return self.api_client.call_api('/parameter-contexts/{id}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ParameterContextEntity',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_parameter_context_update(self, context_id, request_id, **kwargs):
        """
        Returns the Update Request with the given ID
        Returns the Update Request with the given ID. Once an Update Request has been created by performing a POST to /nifi-api/parameter-contexts, that request can subsequently be retrieved via this endpoint, and the request that is fetched will contain the updated state, such as percent complete, the current state of the request, and any failures. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_parameter_context_update(context_id, request_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str context_id: The ID of the Parameter Context (required)
        :param str request_id: The ID of the Update Request (required)
        :return: ParameterContextUpdateRequestEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_parameter_context_update_with_http_info(context_id, request_id, **kwargs)
        else:
            (data) = self.get_parameter_context_update_with_http_info(context_id, request_id, **kwargs)
            return data

    def get_parameter_context_update_with_http_info(self, context_id, request_id, **kwargs):
        """
        Returns the Update Request with the given ID
        Returns the Update Request with the given ID. Once an Update Request has been created by performing a POST to /nifi-api/parameter-contexts, that request can subsequently be retrieved via this endpoint, and the request that is fetched will contain the updated state, such as percent complete, the current state of the request, and any failures. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_parameter_context_update_with_http_info(context_id, request_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str context_id: The ID of the Parameter Context (required)
        :param str request_id: The ID of the Update Request (required)
        :return: ParameterContextUpdateRequestEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['context_id', 'request_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_parameter_context_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'context_id' is set
        if ('context_id' not in params) or (params['context_id'] is None):
            raise ValueError("Missing the required parameter `context_id` when calling `get_parameter_context_update`")
        # verify the required parameter 'request_id' is set
        if ('request_id' not in params) or (params['request_id'] is None):
            raise ValueError("Missing the required parameter `request_id` when calling `get_parameter_context_update`")


        collection_formats = {}

        path_params = {}
        if 'context_id' in params:
            path_params['contextId'] = params['context_id']
        if 'request_id' in params:
            path_params['requestId'] = params['request_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth']

        return self.api_client.call_api('/parameter-contexts/{contextId}/update-requests/{requestId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ParameterContextUpdateRequestEntity',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_validation_request(self, context_id, id, **kwargs):
        """
        Returns the Validation Request with the given ID
        Returns the Validation Request with the given ID. Once a Validation Request has been created by performing a POST to /nifi-api/validation-contexts, that request can subsequently be retrieved via this endpoint, and the request that is fetched will contain the updated state, such as percent complete, the current state of the request, and any failures. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_validation_request(context_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str context_id: The ID of the Parameter Context (required)
        :param str id: The ID of the Validation Request (required)
        :return: ParameterContextValidationRequestEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_validation_request_with_http_info(context_id, id, **kwargs)
        else:
            (data) = self.get_validation_request_with_http_info(context_id, id, **kwargs)
            return data

    def get_validation_request_with_http_info(self, context_id, id, **kwargs):
        """
        Returns the Validation Request with the given ID
        Returns the Validation Request with the given ID. Once a Validation Request has been created by performing a POST to /nifi-api/validation-contexts, that request can subsequently be retrieved via this endpoint, and the request that is fetched will contain the updated state, such as percent complete, the current state of the request, and any failures. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_validation_request_with_http_info(context_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str context_id: The ID of the Parameter Context (required)
        :param str id: The ID of the Validation Request (required)
        :return: ParameterContextValidationRequestEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['context_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_validation_request" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'context_id' is set
        if ('context_id' not in params) or (params['context_id'] is None):
            raise ValueError("Missing the required parameter `context_id` when calling `get_validation_request`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_validation_request`")


        collection_formats = {}

        path_params = {}
        if 'context_id' in params:
            path_params['contextId'] = params['context_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth']

        return self.api_client.call_api('/parameter-contexts/{contextId}/validation-requests/{id}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ParameterContextValidationRequestEntity',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def submit_parameter_context_update(self, context_id, body, **kwargs):
        """
        Initiate the Update Request of a Parameter Context
        This will initiate the process of updating a Parameter Context. Changing the value of a Parameter may require that one or more components be stopped and restarted, so this action may take significantly more time than many other REST API actions. As a result, this endpoint will immediately return a ParameterContextUpdateRequestEntity, and the process of updating the necessary components will occur asynchronously in the background. The client may then periodically poll the status of the request by issuing a GET request to /parameter-contexts/update-requests/{requestId}. Once the request is completed, the client is expected to issue a DELETE request to /parameter-contexts/update-requests/{requestId}.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.submit_parameter_context_update(context_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str context_id: (required)
        :param ParameterContextEntity body: The updated version of the parameter context. (required)
        :return: ParameterContextUpdateRequestEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.submit_parameter_context_update_with_http_info(context_id, body, **kwargs)
        else:
            (data) = self.submit_parameter_context_update_with_http_info(context_id, body, **kwargs)
            return data

    def submit_parameter_context_update_with_http_info(self, context_id, body, **kwargs):
        """
        Initiate the Update Request of a Parameter Context
        This will initiate the process of updating a Parameter Context. Changing the value of a Parameter may require that one or more components be stopped and restarted, so this action may take significantly more time than many other REST API actions. As a result, this endpoint will immediately return a ParameterContextUpdateRequestEntity, and the process of updating the necessary components will occur asynchronously in the background. The client may then periodically poll the status of the request by issuing a GET request to /parameter-contexts/update-requests/{requestId}. Once the request is completed, the client is expected to issue a DELETE request to /parameter-contexts/update-requests/{requestId}.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.submit_parameter_context_update_with_http_info(context_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str context_id: (required)
        :param ParameterContextEntity body: The updated version of the parameter context. (required)
        :return: ParameterContextUpdateRequestEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['context_id', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method submit_parameter_context_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'context_id' is set
        if ('context_id' not in params) or (params['context_id'] is None):
            raise ValueError("Missing the required parameter `context_id` when calling `submit_parameter_context_update`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `submit_parameter_context_update`")


        collection_formats = {}

        path_params = {}
        if 'context_id' in params:
            path_params['contextId'] = params['context_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['tokenAuth']

        return self.api_client.call_api('/parameter-contexts/{contextId}/update-requests', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ParameterContextUpdateRequestEntity',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def submit_validation_request(self, context_id, body, **kwargs):
        """
        Initiate a Validation Request to determine how the validity of components will change if a Parameter Context were to be updated
        This will initiate the process of validating all components whose Process Group is bound to the specified Parameter Context. Performing validation against an arbitrary number of components may be expect and take significantly more time than many other REST API actions. As a result, this endpoint will immediately return a ParameterContextValidationRequestEntity, and the process of validating the necessary components will occur asynchronously in the background. The client may then periodically poll the status of the request by issuing a GET request to /parameter-contexts/validation-requests/{requestId}. Once the request is completed, the client is expected to issue a DELETE request to /parameter-contexts/validation-requests/{requestId}.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.submit_validation_request(context_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str context_id: (required)
        :param ParameterContextValidationRequestEntity body: The validation request (required)
        :return: ParameterContextValidationRequestEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.submit_validation_request_with_http_info(context_id, body, **kwargs)
        else:
            (data) = self.submit_validation_request_with_http_info(context_id, body, **kwargs)
            return data

    def submit_validation_request_with_http_info(self, context_id, body, **kwargs):
        """
        Initiate a Validation Request to determine how the validity of components will change if a Parameter Context were to be updated
        This will initiate the process of validating all components whose Process Group is bound to the specified Parameter Context. Performing validation against an arbitrary number of components may be expect and take significantly more time than many other REST API actions. As a result, this endpoint will immediately return a ParameterContextValidationRequestEntity, and the process of validating the necessary components will occur asynchronously in the background. The client may then periodically poll the status of the request by issuing a GET request to /parameter-contexts/validation-requests/{requestId}. Once the request is completed, the client is expected to issue a DELETE request to /parameter-contexts/validation-requests/{requestId}.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.submit_validation_request_with_http_info(context_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str context_id: (required)
        :param ParameterContextValidationRequestEntity body: The validation request (required)
        :return: ParameterContextValidationRequestEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['context_id', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method submit_validation_request" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'context_id' is set
        if ('context_id' not in params) or (params['context_id'] is None):
            raise ValueError("Missing the required parameter `context_id` when calling `submit_validation_request`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `submit_validation_request`")


        collection_formats = {}

        path_params = {}
        if 'context_id' in params:
            path_params['contextId'] = params['context_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['tokenAuth']

        return self.api_client.call_api('/parameter-contexts/{contextId}/validation-requests', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ParameterContextValidationRequestEntity',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_parameter_context(self, id, body, **kwargs):
        """
        Modifies a Parameter Context
        This endpoint will update a Parameter Context to match the provided entity. However, this request will fail if any component is running and is referencing a Parameter in the Parameter Context. Generally, this endpoint is not called directly. Instead, an update request should be submitted by making a POST to the /parameter-contexts/update-requests endpoint. That endpoint will, in turn, call this endpoint.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_parameter_context(id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: (required)
        :param ParameterContextEntity body: The updated Parameter Context (required)
        :return: ParameterContextEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_parameter_context_with_http_info(id, body, **kwargs)
        else:
            (data) = self.update_parameter_context_with_http_info(id, body, **kwargs)
            return data

    def update_parameter_context_with_http_info(self, id, body, **kwargs):
        """
        Modifies a Parameter Context
        This endpoint will update a Parameter Context to match the provided entity. However, this request will fail if any component is running and is referencing a Parameter in the Parameter Context. Generally, this endpoint is not called directly. Instead, an update request should be submitted by making a POST to the /parameter-contexts/update-requests endpoint. That endpoint will, in turn, call this endpoint.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_parameter_context_with_http_info(id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: (required)
        :param ParameterContextEntity body: The updated Parameter Context (required)
        :return: ParameterContextEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_parameter_context" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_parameter_context`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_parameter_context`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['tokenAuth']

        return self.api_client.call_api('/parameter-contexts/{id}', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ParameterContextEntity',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
