"use strict";
var _a, _b, _c, _d, _e, _f, _g;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VehicleModel = exports.CanDefinition = exports.NetworkFileDefinition = exports.CanVehicleSignal = exports.VehicleSignal = exports.CanVehicleInterface = exports.VehicleInterface = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class VehicleInterface {
    constructor() {
        this.intf = {};
    }
    toObject() {
        return (this.intf);
    }
}
exports.VehicleInterface = VehicleInterface;
_a = JSII_RTTI_SYMBOL_1;
VehicleInterface[_a] = { fqn: "cdk-aws-iotfleetwise.VehicleInterface", version: "0.2.9" };
class CanVehicleInterface extends VehicleInterface {
    constructor(interfaceId, name) {
        super();
        this.intf = {
            type: 'CAN_INTERFACE',
            interfaceId,
            canInterface: {
                canInterfaceName: name,
                protocolName: 'CAN',
                protocolVersion: '2.0b',
            },
        };
    }
}
exports.CanVehicleInterface = CanVehicleInterface;
_b = JSII_RTTI_SYMBOL_1;
CanVehicleInterface[_b] = { fqn: "cdk-aws-iotfleetwise.CanVehicleInterface", version: "0.2.9" };
class VehicleSignal {
    constructor() {
        this.signal = {};
    }
    toObject() {
        return (this.signal);
    }
}
exports.VehicleSignal = VehicleSignal;
_c = JSII_RTTI_SYMBOL_1;
VehicleSignal[_c] = { fqn: "cdk-aws-iotfleetwise.VehicleSignal", version: "0.2.9" };
class CanVehicleSignal extends VehicleSignal {
    constructor(name, fullyQualifiedName, interfaceId, messageId, factor, isBigEndian, isSigned, length, offset, startBit) {
        super();
        this.signal = {
            type: 'CAN_SIGNAL',
            fullyQualifiedName,
            interfaceId,
            canSignal: {
                canSignalName: name,
                factor,
                isBigEndian,
                isSigned,
                length,
                messageId,
                offset,
                startBit,
            },
        };
    }
}
exports.CanVehicleSignal = CanVehicleSignal;
_d = JSII_RTTI_SYMBOL_1;
CanVehicleSignal[_d] = { fqn: "cdk-aws-iotfleetwise.CanVehicleSignal", version: "0.2.9" };
class NetworkFileDefinition {
    constructor() {
        this.definition = {};
    }
    toObject() {
        return (this.definition);
    }
}
exports.NetworkFileDefinition = NetworkFileDefinition;
_e = JSII_RTTI_SYMBOL_1;
NetworkFileDefinition[_e] = { fqn: "cdk-aws-iotfleetwise.NetworkFileDefinition", version: "0.2.9" };
class CanDefinition extends NetworkFileDefinition {
    constructor(networkInterface, signalsMap, canDbcFiles) {
        super();
        this.definition = {
            networkFileType: 'CAN_DBC',
            canDbc: {
                canDbcFiles: canDbcFiles.map(file => Buffer.from(file).toString('base64')),
                networkInterface,
                signalsMap,
            },
        };
    }
}
exports.CanDefinition = CanDefinition;
_f = JSII_RTTI_SYMBOL_1;
CanDefinition[_f] = { fqn: "cdk-aws-iotfleetwise.CanDefinition", version: "0.2.9" };
class VehicleModel extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.name = '';
        this.signalCatalog = {};
        this.name = props.name || '';
        this.signalCatalog = props.signalCatalog;
        const onEventHandler = new aws_cdk_lib_1.aws_lambda.Function(this, 'Lambda', {
            code: aws_cdk_lib_1.aws_lambda.AssetCode.fromAsset(path.join(__dirname, '/../src/handlers')),
            handler: 'vehiclemodelhandler.on_event',
            timeout: cdk.Duration.seconds(300),
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9,
            layers: [this.signalCatalog.lambdaLayer],
            role: this.signalCatalog.lambdaRole,
            logRetention: this.signalCatalog.logRetention,
        });
        const provider = new aws_cdk_lib_1.custom_resources.Provider(this, 'Provider', {
            onEventHandler: onEventHandler,
            logRetention: this.signalCatalog.logRetention,
        });
        const resource = new cdk.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            properties: {
                name: this.name,
                signal_catalog_arn: props.signalCatalog.arn,
                model_manifest_arn: `arn:aws:iotfleetwise:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:model-manifest/${this.name}`,
                description: props.description,
                network_interfaces: JSON.stringify(props.networkInterfaces.map(i => i.toObject())),
                signals: (props.signals) ? JSON.stringify(props.signals.map(s => s.toObject())) : '{}',
                network_file_definitions: (props.networkFileDefinitions) ? JSON.stringify(props.networkFileDefinitions.map(s => s.toObject())) : '{}',
            },
        });
        resource.node.addDependency(this.signalCatalog);
    }
}
exports.VehicleModel = VehicleModel;
_g = JSII_RTTI_SYMBOL_1;
VehicleModel[_g] = { fqn: "cdk-aws-iotfleetwise.VehicleModel", version: "0.2.9" };
//# sourceMappingURL=data:application/json;base64,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