"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SignalCatalog = exports.SignalCatalogSensor = exports.SignalCatalogBranch = exports.SignalCatalogNode = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class SignalCatalogNode {
    constructor() {
        this.node = {};
    }
    toObject() {
        return (this.node);
    }
}
exports.SignalCatalogNode = SignalCatalogNode;
_a = JSII_RTTI_SYMBOL_1;
SignalCatalogNode[_a] = { fqn: "cdk-aws-iotfleetwise.SignalCatalogNode", version: "0.2.9" };
class SignalCatalogBranch extends SignalCatalogNode {
    constructor(name, fullyQualifiedName, description) {
        super();
        this.node = {
            type: 'Branch',
            branch: {
                name: name,
                fullyQualifiedName: fullyQualifiedName,
                ...description && { description },
            },
        };
    }
}
exports.SignalCatalogBranch = SignalCatalogBranch;
_b = JSII_RTTI_SYMBOL_1;
SignalCatalogBranch[_b] = { fqn: "cdk-aws-iotfleetwise.SignalCatalogBranch", version: "0.2.9" };
class SignalCatalogSensor extends SignalCatalogNode {
    constructor(name, fullyQualifiedName, dataType, unit, min, max, description) {
        super();
        this.node = {
            type: 'Sensor',
            sensor: {
                name,
                fullyQualifiedName,
                dataType,
                ...unit && { unit },
                ...min && { min },
                ...max && { max },
                ...description && { description },
            },
        };
    }
}
exports.SignalCatalogSensor = SignalCatalogSensor;
_c = JSII_RTTI_SYMBOL_1;
SignalCatalogSensor[_c] = { fqn: "cdk-aws-iotfleetwise.SignalCatalogSensor", version: "0.2.9" };
/**
 * The Signal Catalog represents the list of all signals that you want to collect from all
 * the vehicles.
 *
 *
 * The AWS IoT Fleetwise preview can only support a single Signal Catalog per account.
 *
 */
class SignalCatalog extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.name = props.name || 'default';
        this.description = props.description;
        this.arn = `arn:aws:iotfleetwise:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:signal-catalog/${this.name}`;
        this.lambdaRole = new aws_cdk_lib_1.aws_iam.Role(this, 'Role', {
            assumedBy: new aws_cdk_lib_1.aws_iam.ServicePrincipal('lambda.amazonaws.com'),
            managedPolicies: [
                aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSLambdaBasicExecutionRole'),
                aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AdministratorAccess'),
            ],
        });
        this.lambdaLayer = new aws_cdk_lib_1.aws_lambda.LayerVersion(this, 'Boto3', {
            description: 'Boto3 Library with Iot Fleetwise Support',
            compatibleRuntimes: [aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9],
            code: aws_cdk_lib_1.aws_lambda.AssetCode.fromAsset(path.join(__dirname, '/../layer.zip')),
        });
        const code = aws_cdk_lib_1.aws_lambda.AssetCode.fromAsset(path.join(__dirname, '/../src/handlers'));
        this.logRetention = aws_cdk_lib_1.aws_logs.RetentionDays.ONE_DAY;
        const onEventHandlerService = new aws_cdk_lib_1.aws_lambda.Function(this, 'Service', {
            code,
            handler: 'servicehandler.on_event',
            timeout: cdk.Duration.seconds(300),
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9,
            layers: [this.lambdaLayer],
            role: this.lambdaRole,
            logRetention: this.logRetention,
        });
        const isCompleteHandlerService = new aws_cdk_lib_1.aws_lambda.Function(this, 'ServiceComplete', {
            code,
            handler: 'servicehandler.is_complete',
            timeout: cdk.Duration.seconds(300),
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9,
            layers: [this.lambdaLayer],
            role: this.lambdaRole,
            logRetention: this.logRetention,
        });
        const providerService = new aws_cdk_lib_1.custom_resources.Provider(this, 'ServiceProvider', {
            onEventHandler: onEventHandlerService,
            isCompleteHandler: isCompleteHandlerService,
            logRetention: this.logRetention,
        });
        const serviceResource = new cdk.CustomResource(this, 'ServiceResource', {
            serviceToken: providerService.serviceToken,
            properties: {
                role_arn: props.role.roleArn,
                database_name: props.database.databaseName,
                table_name: props.table.tableName,
            },
        });
        const onEventHandlerCatalog = new aws_cdk_lib_1.aws_lambda.Function(this, 'Catalog', {
            code,
            handler: 'signalcataloghandler.on_event',
            timeout: cdk.Duration.seconds(300),
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9,
            layers: [this.lambdaLayer],
            role: this.lambdaRole,
            logRetention: this.logRetention,
        });
        const providerCatalog = new aws_cdk_lib_1.custom_resources.Provider(this, 'CatalogProvider', {
            onEventHandler: onEventHandlerCatalog,
            logRetention: this.logRetention,
        });
        const resourceCatalog = new cdk.CustomResource(this, 'CatalogResource', {
            serviceToken: providerCatalog.serviceToken,
            properties: {
                name: this.name,
                description: this.description,
                nodes: JSON.stringify(props.nodes.map(node => node.toObject())),
            },
        });
        resourceCatalog.node.addDependency(serviceResource);
    }
}
exports.SignalCatalog = SignalCatalog;
_d = JSII_RTTI_SYMBOL_1;
SignalCatalog[_d] = { fqn: "cdk-aws-iotfleetwise.SignalCatalog", version: "0.2.9" };
//# sourceMappingURL=data:application/json;base64,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