"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoadBalancerV2Origin = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const http_origin_1 = require("./http-origin");
/**
 * An Origin for a v2 load balancer.
 */
class LoadBalancerV2Origin extends http_origin_1.HttpOrigin {
    constructor(loadBalancer, props = {}) {
        super(loadBalancer.loadBalancerDnsName, { ...props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cloudfront_origins_LoadBalancerV2OriginProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, LoadBalancerV2Origin);
            }
            throw error;
        }
    }
}
exports.LoadBalancerV2Origin = LoadBalancerV2Origin;
_a = JSII_RTTI_SYMBOL_1;
LoadBalancerV2Origin[_a] = { fqn: "@aws-cdk/aws-cloudfront-origins.LoadBalancerV2Origin", version: "1.181.1" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibG9hZC1iYWxhbmNlci1vcmlnaW4uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJsb2FkLWJhbGFuY2VyLW9yaWdpbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFDQSwrQ0FBNEQ7QUFPNUQ7O0dBRUc7QUFDSCxNQUFhLG9CQUFxQixTQUFRLHdCQUFVO0lBRWxELFlBQVksWUFBbUMsRUFBRSxRQUFtQyxFQUFFO1FBQ3BGLEtBQUssQ0FBQyxZQUFZLENBQUMsbUJBQW1CLEVBQUUsRUFBRSxHQUFHLEtBQUssRUFBRSxDQUFDLENBQUM7Ozs7OzsrQ0FIN0Msb0JBQW9COzs7O0tBSTlCOztBQUpILG9EQU1DIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgZWxidjIgZnJvbSAnQGF3cy1jZGsvYXdzLWVsYXN0aWNsb2FkYmFsYW5jaW5ndjInO1xuaW1wb3J0IHsgSHR0cE9yaWdpbiwgSHR0cE9yaWdpblByb3BzIH0gZnJvbSAnLi9odHRwLW9yaWdpbic7XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgYW4gT3JpZ2luIGJhY2tlZCBieSBhIHYyIGxvYWQgYmFsYW5jZXIuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgTG9hZEJhbGFuY2VyVjJPcmlnaW5Qcm9wcyBleHRlbmRzIEh0dHBPcmlnaW5Qcm9wcyB7IH1cblxuLyoqXG4gKiBBbiBPcmlnaW4gZm9yIGEgdjIgbG9hZCBiYWxhbmNlci5cbiAqL1xuZXhwb3J0IGNsYXNzIExvYWRCYWxhbmNlclYyT3JpZ2luIGV4dGVuZHMgSHR0cE9yaWdpbiB7XG5cbiAgY29uc3RydWN0b3IobG9hZEJhbGFuY2VyOiBlbGJ2Mi5JTG9hZEJhbGFuY2VyVjIsIHByb3BzOiBMb2FkQmFsYW5jZXJWMk9yaWdpblByb3BzID0ge30pIHtcbiAgICBzdXBlcihsb2FkQmFsYW5jZXIubG9hZEJhbGFuY2VyRG5zTmFtZSwgeyAuLi5wcm9wcyB9KTtcbiAgfVxuXG59XG4iXX0=