# DOMINO

DOMINO: Discovery of Modules In Networks using Omic.

DOMINO is an active module identification (AMI) algorithm.  It recieves a gene network and nodes' activity scores as input and report sub-networks (modules) that are putatively biologically meaningful in the context of the activity data.


In extensive evaluation conducted on gene expression and genome-wide association study data we discovered that AMI algorithms tended to over-reporting of enrichment: GO terms enriched in the modules on real data were often also enriched when the algorithms were run on randomly permuted activity scores.

In constrast, modules retrieved by DOMINO had high rate of empirically validated GO terms.

A preprint version of the study is available at https://www.biorxiv.org/content/10.1101/2020.03.10.984963v3.

- [Requirements](#requirements)
- [Installation](#installation)
- [Input File Formats](#input-file-formats)
- [Basic Usage](#basic-usage)
- [Main output files](#main-output-files)
- [Advanced usage](#advanced-usage)
- [Example files](#example-files)



## Requirements
DOMINO was tested under the following settings:
- Python 3.6, Python 3.7 (Note that for further versions of python some dependency packages are currently not available via pip)
- Linux OS (Ubuntu 14.04 LTS, Ubuntu 18.04.4 LTS)

## Installation

### From sources
Download the sources and install according to the following:

Clone the repo from Github:
```
git clone https://github.com/Shamir-Lab/DOMINO.git
cd DOMINO
```

DOMINO is written in Python3. The necessary libraries will all be installed by the `setup.py` script.
We recommend using a virtual environment. For example, in Linux, before running `setup.py`:
```
python3 -m venv domino-env
source domino-env/bin/activate
```
Then, run setup.py:
```
python setup.py install
```

## Input File Formats

- A network file should be in a simplified sif format:
  * Only single node should appear in the first and last column. 
  * The First row is headers

- An active gene file contains the gene ids in Ensemble format, separated by a newline char  

- The slices file format is automatically generated by the `slicer` command.


For examples, see files in "examples" folder

## Basic Usage

To run preprocessing step 0 (partitioning network using Louvain algorithm):
```
slicer --network_file </path/to/network.sif> --output_file </path/to/output_file>
```

To run DOMINO:
```
domino --active_genes_files </path/to/dataset1,/path/to/dataset2...> --network_file </path/to/network.sif> --slices_file <slices_file.txt> --output_folder </path/to/output_folder> [-sth <slices_threshold> -mth <putative_modules_threshold>]
```

The common command line options are:

`-a/--active_genes_files`: list of files of active genes. gene ids are Enseble id, separated by new line.

`-n/--network_file`: path to network file (sif format).

`-s/--slices_file`: path to slices file (i.e. the output of "slicer" script).


## Main output files

`output_folder/active_gene_file_name/modules.out`: list of final modules
`output_folder/active_gene_file_name/module_i.html`: visualization of the i'th module

## Advanced usage

`-sth/--slices_threshold`: threshold for considering a slice as relevant

`-mth/--module_threshold`: threshold for considering a putative module as final module.

## Example files

Example files of networks in simplified sif format and an active gene file are available under "examples" folder  
