# generated by datamodel-codegen:
#   filename:  type/tableUsageCount.json
#   timestamp: 2022-10-26T07:12:43+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ..entity.data import table


class TableColumn(BaseModel):
    class Config:
        extra = Extra.forbid

    table: Optional[str] = Field(None, description='Name of the table')
    column: Optional[str] = Field(None, description='Name of the column')


class TableColumnJoin(BaseModel):
    class Config:
        extra = Extra.forbid

    tableColumn: Optional[TableColumn] = Field(None, description='Source table column')
    joinedWith: Optional[List[TableColumn]] = Field(
        None, description='List of table columns with which the table is joined with'
    )


class TableUsageCount(BaseModel):
    class Config:
        extra = Extra.forbid

    table: str = Field(..., description='Name of the table')
    date: str = Field(..., description='Date of execution of SQL query')
    databaseName: str = Field(
        ..., description='Database associated with the table in the query'
    )
    count: Optional[int] = Field(1, description='Usage count of table')
    databaseSchema: Optional[str] = Field(
        None, description='Database schema of the associated with table'
    )
    sqlQueries: Optional[List[table.SqlQuery]] = Field(
        None, description='List of SQL Queries associated with table'
    )
    joins: Optional[List[TableColumnJoin]] = Field(
        None, description='List of joins associated with table'
    )
    serviceName: str = Field(
        ..., description='Name that identifies this database service.'
    )
