# generated by datamodel-codegen:
#   filename:  entity/services/connections/dashboard/modeConnection.json
#   timestamp: 2022-10-26T07:12:43+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, BaseModel, Extra, Field, SecretStr

from .. import connectionBasicType


class ModeType(Enum):
    Mode = 'Mode'


class ModeConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[ModeType] = Field(
        ModeType.Mode, description='Service Type', title='Service Type'
    )
    hostPort: Optional[AnyUrl] = Field(
        'https://app.mode.com',
        description='URL for the mode instance.',
        title='Host and Port',
    )
    accessToken: str = Field(
        ..., description='Access Token for Mode Dashboard', title='Access Token'
    )
    accessTokenPassword: SecretStr = Field(
        ...,
        description='Access Token Password for Mode Dashboard',
        title='Access Token Password',
    )
    workspaceName: str = Field(
        ..., description='Mode Workspace Name', title='Workspace Name'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
