# generated by datamodel-codegen:
#   filename:  api/events/createWebhook.json
#   timestamp: 2022-10-26T07:12:43+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import AnyUrl, BaseModel, Extra, Field

from ...entity.events import webhook
from ...type import basic, changeEvent


class CreateWebhook(BaseModel):
    class Config:
        extra = Extra.forbid

    name: basic.EntityName = Field(
        ..., description='Unique name of the application receiving webhook events.'
    )
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this webhook.'
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of the application'
    )
    endpoint: AnyUrl = Field(
        ..., description='Endpoint to receive the webhook events over POST requests.'
    )
    eventFilters: List[changeEvent.EventFilter] = Field(
        ..., description='Event filters to filter for desired events.'
    )
    batchSize: Optional[int] = Field(
        10, description='Maximum number of events sent in a batch (Default 10).'
    )
    timeout: Optional[int] = Field(
        10, description='Connection timeout in seconds. (Default = 10s)'
    )
    enabled: Optional[bool] = Field(
        True,
        description='When set to `true`, the webhook event notification is enabled. Set it to `false` to disable the subscription. (Default `true`)',
    )
    secretKey: Optional[str] = Field(
        None,
        description='Secret set by the webhook client used for computing HMAC SHA256 signature of webhook payload and sent in `X-OM-Signature` header in POST requests to publish the events.',
    )
    webhookType: Optional[webhook.WebhookType] = Field(
        None, description='Type of webhook slack,generic,msteams etc'
    )
