# MAL Toolbox overview

MAL Toolbox is a collection of python modules to help developers create and work with
MAL ([Meta Attack Language](https://mal-lang.org/)) models and attack graphs.

Attack graphs can be used to run simulations (see MAL Simulator) or analysis.

[Documentation](https://mal-lang.org/mal-toolbox/index.html)(Work in progress)

## The Language Module

The language module provides various tools to process MAL languages.

### The Language Specification Submodule

The language specification submodule provides functions to load the
specification from a .mar archive(`load_language_specification_from_mar`) or a
JSON file(`load_language_specification_from_json`). This specification will
then be used to generate python classes representing the assets and
associations of the language and to determine the attack steps for each asset
when generating the attack graph.

## The Model Module

With a MAL language a Model (a MAL instance model) can be created either
from a model file or empty.

The model class will store all of the relevant information to the MAL
instance model, most importantly the assets and their associations.

Model objects can be used to generate attack graphs with the AttackGraph module.

## The Attack Graph Module

The attack graph module contains tools used to generate attack graphs from
existing MAL instance models and analyse MAL attack graphs. The function used
to generate the attack graph is `generate_graph` and it requires the instance
model and language specification. The resulting attack graph will contain
nodes for each of the attack steps. The structure of the attack node data
class can be seen in `attackgraph/node.py` file. Of note are the lists of
children and parents which allow for easy reference to the other attack step
nodes related and the asset field which will contain the object in the model
instance to which this attack step belongs to, if this information is
available.

## Ingestors Module

The ingestors module contains various tools that can make use of the instance
model or attack graph. Currently the Neo4J ingestor is the only one available
and it can be used to visualise the instance model and the attack graph.


# Usage

## Installation

```
pip install mal-toolbox
```

## Configuration
You can use a `maltoolbox.yml` file in the current working directory to
configure the toolbox.

The config should look like this:
```yml
logging:
  log_level: INFO
  log_file: "logs/log.txt"
  attackgraph_file: "logs/attackgraph.json"
  model_file: "logs/model.yml"
  langspec_file: "logs/langspec_file.yml"
  langgraph_file: "logs/langspec_file.yml"
```

Alternatively, you can use the `MALTOOLBOX_CONFIG`
environment variable to set a custom config file location.

```bash
# in your shell, e.g. bash do:
export MALTOOLBOX_CONFIG=path/to/yml/config/file
```

The default configuration can be found here:

https://github.com/mal-lang/mal-toolbox/blob/main/maltoolbox/__init__.py#L39-L53

## Command Line Client

You can use the maltoolbox cli to:

- Generate attack graphs from model files
- Compile MAL languages
- Upgrade model files from older versions

```
Command-line interface for MAL toolbox operations

Usage:
    maltoolbox attack-graph generate [options] <model_file> <lang_file>
    maltoolbox compile <lang_file> <output_file>
    maltoolbox upgrade-model <model_file> <lang_file> <output_file>

Arguments:
    <model_file>    Path to JSON instance model file.
    <lang_file>     Path to .mar or .mal file containing MAL spec.
    <output_file>   Path to write the result of the compilation (yml/json).

Notes:
    - <lang_file> can be either a .mar file (generated by the older MAL
      compiler) or a .mal file containing the DSL written in MAL.
```

## Code examples / Tutorial

To find code examples and tutorials, visit the
[MAL Toolbox Tutorial](https://github.com/mal-lang/mal-toolbox-tutorial/tree/main) repository.

# Tests
There are unit tests inside of ./tests.
Before running the tests, make sure to install the requirements in ./tests/requirements.txt with `python -m pip install -r ./tests/requirements.txt`.

To run all tests, use the `pytest` command. To run just a specific file or test function use `pytest tests/<filename>` or `pytest -k <function_name>`.
