# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/02_wSAA.ipynb.

# %% ../nbs/02_wSAA.ipynb 5
from __future__ import annotations
from fastcore.docments import *
from fastcore.test import *
from fastcore.utils import *

import pandas as pd
import numpy as np

from sklearn.ensemble import RandomForestRegressor
from sklearn.base import MetaEstimatorMixin
from .baseClasses import BaseWeightsBasedEstimator
from .utils import restructureWeightsDataList

# %% auto 0
__all__ = ['RandomForestWSAA', 'SAA']

# %% ../nbs/02_wSAA.ipynb 9
class RandomForestWSAA(RandomForestRegressor, BaseWeightsBasedEstimator):
    
    def fit(self, 
            X, 
            y,
            **kwargs):

        super().fit(X = X, 
                    y = y, 
                    **kwargs)
        
        self.y = y
        self.leafIndicesTrain = self.apply(X)
    
    #---
    
    def getWeights(self: RandomForestWSAA, 
                   X: np.ndarray, # Feature matrix of samples for which conditional density estimates are computed.
                   outputType: 'all' | # Specifies structure of output.
                               'onlyPositiveWeights' | 
                               'summarized' | 
                               'cumulativeDistribution' | 
                               'cumulativeDistributionSummarized' = 'onlyPositiveWeights', 
                   scalingList: list | np.ndarray | None = None, # List or array with same size as self.y containing floats being multiplied with self.y.
                   ):

        leafIndicesDf = self.apply(X)

        weightsDataList = list()

        for leafIndices in leafIndicesDf:
            leafComparisonMatrix = (self.leafIndicesTrain == leafIndices) * 1
            nObsInSameLeaf = np.sum(leafComparisonMatrix, axis = 0)

            # It can happen that RF decides that the best strategy is to fit no tree at
            # all and simply average all results (happens when min_child_sample is too high, for example).
            # In this case 'leafComparisonMatrix' mustn't be averaged because there has been only a single tree.
            if len(leafComparisonMatrix.shape) == 1:
                weights = leafComparisonMatrix / nObsInSameLeaf
            else:
                weights = np.mean(leafComparisonMatrix / nObsInSameLeaf, axis = 1)

            weightsPosIndex = np.where(weights > 0)[0]

            weightsDataList.append((weights[weightsPosIndex], weightsPosIndex))

        #---

        weightsDataList = restructureWeightsDataList(weightsDataList = weightsDataList, 
                                                     outputType = outputType, 
                                                     y = self.y, 
                                                     scalingList = scalingList,
                                                     equalWeights = False)

        return weightsDataList
    
    #---
    
    def predict(self, 
                X,
                probs = [0.1, 0.5, 0.9], 
                outputAsDf = True, 
                scalingList = None):
        
        return super(MetaEstimatorMixin, self).predict(X = X,
                                                       probs = probs, 
                                                       outputAsDf = outputAsDf,
                                                       scalingList = scalingList)
    
    #---
    
    def pointPredict(self,
                     X,
                     **kwargs):
        
        return super().predict(X = X,
                               **kwargs)


# %% ../nbs/02_wSAA.ipynb 14
class SAA(BaseWeightsBasedEstimator):
    """SAA is a featureless approach that assumes the density of the target variable is given
    by assigning equal probability to each historical observation of said target variable."""
    
    def __init__(self):
        
        self.y = None
        
    #---
        
    def __str__(self):
        return "SAA()"
    __repr__ = __str__ 
    
    #---
    
    def fit(self: SAA, 
            y: np.ndarray, # Target values which form the estimated density function based on the SAA algorithm.
            ):
        self.y = y
    
    #---
    
    def getWeights(self: SAA, 
                   X: np.ndarray, # Feature matrix for whose rows conditional density estimates are computed.
                   outputType: 'all' | # Specifies structure of output.
                               'onlyPositiveWeights' | 
                               'summarized' | 
                               'cumulativeDistribution' | 
                               'cumulativeDistributionSummarized' = 'onlyPositiveWeights', 
                   scalingList: list | np.ndarray | None = None, # List or array with same size as self.y containing floats being multiplied with self.y.
                   ):

        if X is None:
            neighborsList = [np.arange(len(self.y))]
        else:
            neighborsList = [np.arange(len(self.y)) for i in range(X.shape[0])]

        # weightsDataList is a list whose elements correspond to one test prediction each. 
        weightsDataList = [(np.repeat(1 / len(neighbors), len(neighbors)), np.array(neighbors)) for neighbors in neighborsList]

        weightsDataList = restructureWeightsDataList(weightsDataList = weightsDataList, 
                                                     outputType = outputType, 
                                                     y = self.y,
                                                     scalingList = scalingList,
                                                     equalWeights = True)

        return weightsDataList
    
