"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cache = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_s3_1 = require("aws-cdk-lib/aws-s3");
const constructs_1 = require("constructs");
/**
 * A GitLab Runner cache consisting of an Amazon S3 bucket.
 *
 * The bucket is encrypted with a KMS managed master key, it has public access blocked and will be cleared and deleted on CFN stack deletion.
 */
class Cache extends constructs_1.Construct {
    constructor(scope, id, props = {}) {
        var _b;
        super(scope, id);
        const bucketName = props.bucketName || "runner-cache";
        const uniqueCacheBucketName = `${scope.stackName}-${bucketName}-${scope.account}-${scope.region}`
            .slice(-63)
            .toLocaleLowerCase();
        /* Enabled if not 0. If 0 - cache doesn't expire. If undefined - expiration sets to expire in 30 days */
        const expiration = (_b = props.expiration) !== null && _b !== void 0 ? _b : aws_cdk_lib_1.Duration.days(30);
        const lifeCycleRuleEnabled = expiration.toDays() !== 0;
        this.bucket = new aws_s3_1.Bucket(scope, "CacheBucket", {
            bucketName: uniqueCacheBucketName,
            lifecycleRules: [
                {
                    enabled: lifeCycleRuleEnabled,
                    expiration: expiration,
                },
            ],
            encryption: aws_s3_1.BucketEncryption.KMS_MANAGED,
            blockPublicAccess: aws_s3_1.BlockPublicAccess.BLOCK_ALL,
            autoDeleteObjects: true,
            removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
        });
    }
}
exports.Cache = Cache;
_a = JSII_RTTI_SYMBOL_1;
Cache[_a] = { fqn: "@pepperize/cdk-autoscaling-gitlab-runner.Cache", version: "0.0.175" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2FjaGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvcnVubmVyL2NhY2hlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsNkNBQTZEO0FBQzdELCtDQUEwRjtBQUMxRiwyQ0FBdUM7QUFnQnZDOzs7O0dBSUc7QUFDSCxNQUFhLEtBQU0sU0FBUSxzQkFBUztJQUdsQyxZQUFZLEtBQVksRUFBRSxFQUFVLEVBQUUsUUFBb0IsRUFBRTs7UUFDMUQsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixNQUFNLFVBQVUsR0FBRyxLQUFLLENBQUMsVUFBVSxJQUFJLGNBQWMsQ0FBQztRQUN0RCxNQUFNLHFCQUFxQixHQUFHLEdBQUcsS0FBSyxDQUFDLFNBQVMsSUFBSSxVQUFVLElBQUksS0FBSyxDQUFDLE9BQU8sSUFBSSxLQUFLLENBQUMsTUFBTSxFQUFFO2FBQzlGLEtBQUssQ0FBQyxDQUFDLEVBQUUsQ0FBQzthQUNWLGlCQUFpQixFQUFFLENBQUM7UUFFdkIsd0dBQXdHO1FBQ3hHLE1BQU0sVUFBVSxTQUFHLEtBQUssQ0FBQyxVQUFVLG1DQUFJLHNCQUFRLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxDQUFDO1FBQ3pELE1BQU0sb0JBQW9CLEdBQUcsVUFBVSxDQUFDLE1BQU0sRUFBRSxLQUFLLENBQUMsQ0FBQztRQUV2RCxJQUFJLENBQUMsTUFBTSxHQUFHLElBQUksZUFBTSxDQUFDLEtBQUssRUFBRSxhQUFhLEVBQUU7WUFDN0MsVUFBVSxFQUFFLHFCQUFxQjtZQUNqQyxjQUFjLEVBQUU7Z0JBQ2Q7b0JBQ0UsT0FBTyxFQUFFLG9CQUFvQjtvQkFDN0IsVUFBVSxFQUFFLFVBQVU7aUJBQ3ZCO2FBQ0Y7WUFDRCxVQUFVLEVBQUUseUJBQWdCLENBQUMsV0FBVztZQUN4QyxpQkFBaUIsRUFBRSwwQkFBaUIsQ0FBQyxTQUFTO1lBQzlDLGlCQUFpQixFQUFFLElBQUk7WUFDdkIsYUFBYSxFQUFFLDJCQUFhLENBQUMsT0FBTztTQUNyQyxDQUFDLENBQUM7SUFDTCxDQUFDOztBQTVCSCxzQkE2QkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBEdXJhdGlvbiwgUmVtb3ZhbFBvbGljeSwgU3RhY2sgfSBmcm9tIFwiYXdzLWNkay1saWJcIjtcbmltcG9ydCB7IEJsb2NrUHVibGljQWNjZXNzLCBCdWNrZXQsIEJ1Y2tldEVuY3J5cHRpb24sIElCdWNrZXQgfSBmcm9tIFwiYXdzLWNkay1saWIvYXdzLXMzXCI7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tIFwiY29uc3RydWN0c1wiO1xuXG5leHBvcnQgaW50ZXJmYWNlIENhY2hlUHJvcHMge1xuICAvKipcbiAgICogVGhlIGluZml4IG9mIHRoZSBwaHlzaWNhbCBjYWNoZSBidWNrZXQgbmFtZS5cbiAgICpcbiAgICogQGRlZmF1bHQgXCJydW5uZXItY2FjaGVcIlxuICAgKi9cbiAgcmVhZG9ubHkgYnVja2V0TmFtZT86IHN0cmluZztcbiAgLyoqXG4gICAqIFRoZSBudW1iZXIgb2YgZGF5cyBhZnRlciB3aGljaCB0aGUgY3JlYXRlZCBjYWNoZSBvYmplY3RzIGFyZSBkZWxldGVkIGZyb20gUzMuXG4gICAqIEBkZWZhdWx0IDMwIGRheXNcbiAgICovXG4gIHJlYWRvbmx5IGV4cGlyYXRpb24/OiBEdXJhdGlvbjtcbn1cblxuLyoqXG4gKiBBIEdpdExhYiBSdW5uZXIgY2FjaGUgY29uc2lzdGluZyBvZiBhbiBBbWF6b24gUzMgYnVja2V0LlxuICpcbiAqIFRoZSBidWNrZXQgaXMgZW5jcnlwdGVkIHdpdGggYSBLTVMgbWFuYWdlZCBtYXN0ZXIga2V5LCBpdCBoYXMgcHVibGljIGFjY2VzcyBibG9ja2VkIGFuZCB3aWxsIGJlIGNsZWFyZWQgYW5kIGRlbGV0ZWQgb24gQ0ZOIHN0YWNrIGRlbGV0aW9uLlxuICovXG5leHBvcnQgY2xhc3MgQ2FjaGUgZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuICByZWFkb25seSBidWNrZXQ6IElCdWNrZXQ7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IFN0YWNrLCBpZDogc3RyaW5nLCBwcm9wczogQ2FjaGVQcm9wcyA9IHt9KSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIGNvbnN0IGJ1Y2tldE5hbWUgPSBwcm9wcy5idWNrZXROYW1lIHx8IFwicnVubmVyLWNhY2hlXCI7XG4gICAgY29uc3QgdW5pcXVlQ2FjaGVCdWNrZXROYW1lID0gYCR7c2NvcGUuc3RhY2tOYW1lfS0ke2J1Y2tldE5hbWV9LSR7c2NvcGUuYWNjb3VudH0tJHtzY29wZS5yZWdpb259YFxuICAgICAgLnNsaWNlKC02MylcbiAgICAgIC50b0xvY2FsZUxvd2VyQ2FzZSgpO1xuXG4gICAgLyogRW5hYmxlZCBpZiBub3QgMC4gSWYgMCAtIGNhY2hlIGRvZXNuJ3QgZXhwaXJlLiBJZiB1bmRlZmluZWQgLSBleHBpcmF0aW9uIHNldHMgdG8gZXhwaXJlIGluIDMwIGRheXMgKi9cbiAgICBjb25zdCBleHBpcmF0aW9uID0gcHJvcHMuZXhwaXJhdGlvbiA/PyBEdXJhdGlvbi5kYXlzKDMwKTtcbiAgICBjb25zdCBsaWZlQ3ljbGVSdWxlRW5hYmxlZCA9IGV4cGlyYXRpb24udG9EYXlzKCkgIT09IDA7XG5cbiAgICB0aGlzLmJ1Y2tldCA9IG5ldyBCdWNrZXQoc2NvcGUsIFwiQ2FjaGVCdWNrZXRcIiwge1xuICAgICAgYnVja2V0TmFtZTogdW5pcXVlQ2FjaGVCdWNrZXROYW1lLFxuICAgICAgbGlmZWN5Y2xlUnVsZXM6IFtcbiAgICAgICAge1xuICAgICAgICAgIGVuYWJsZWQ6IGxpZmVDeWNsZVJ1bGVFbmFibGVkLFxuICAgICAgICAgIGV4cGlyYXRpb246IGV4cGlyYXRpb24sXG4gICAgICAgIH0sXG4gICAgICBdLFxuICAgICAgZW5jcnlwdGlvbjogQnVja2V0RW5jcnlwdGlvbi5LTVNfTUFOQUdFRCxcbiAgICAgIGJsb2NrUHVibGljQWNjZXNzOiBCbG9ja1B1YmxpY0FjY2Vzcy5CTE9DS19BTEwsXG4gICAgICBhdXRvRGVsZXRlT2JqZWN0czogdHJ1ZSxcbiAgICAgIHJlbW92YWxQb2xpY3k6IFJlbW92YWxQb2xpY3kuREVTVFJPWSxcbiAgICB9KTtcbiAgfVxufVxuIl19