import { JsonMap } from "@iarna/toml";
import { AutoscalingConfiguration } from "./autoscaling-configuration";
import { CacheConfiguration } from "./cache-configuration";
import { DockerConfiguration } from "./docker-configuration";
import { GlobalConfiguration } from "./global-configuration";
import { MachineConfiguration } from "./machine-configuration";
import { RunnerConfiguration } from "./runner-configuration";
export interface ConfigurationMapperProps {
    readonly globalConfiguration: GlobalConfiguration;
    readonly runnerConfiguration: RunnerConfiguration;
    readonly dockerConfiguration: DockerConfiguration;
    readonly machineConfiguration: MachineConfiguration;
    readonly autoscalingConfigurations: AutoscalingConfiguration[];
    readonly cacheConfiguration: CacheConfiguration;
}
export declare class ConfigurationMapper {
    readonly props: ConfigurationMapperProps;
    static withDefaults(props: ConfigurationMapperProps): ConfigurationMapper;
    static fromProps(props: ConfigurationMapperProps): ConfigurationMapper;
    private constructor();
    toToml(): string;
    /**
     * @internal
     */
    _toJsonMap(): JsonMap;
}
