"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DBCluster = exports.DBClusterProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const adb_generated_1 = require("./adb.generated");
Object.defineProperty(exports, "DBClusterProperty", { enumerable: true, get: function () { return adb_generated_1.RosDBCluster; } });
/**
 * A ROS resource type:  `ALIYUN::ADB::DBCluster`
 */
class DBCluster extends ros.Resource {
    /**
     * Create a new `ALIYUN::ADB::DBCluster`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDBCluster = new adb_generated_1.RosDBCluster(this, id, {
            dbNodeStorage: props.dbNodeStorage,
            periodType: props.periodType,
            dbClusterCategory: props.dbClusterCategory,
            zoneId: props.zoneId,
            resourceGroupId: props.resourceGroupId,
            vpcId: props.vpcId,
            vSwitchId: props.vSwitchId,
            mode: props.mode,
            dbClusterDescription: props.dbClusterDescription,
            computeResource: props.computeResource,
            period: props.period,
            payType: props.payType,
            elasticIoResource: props.elasticIoResource,
            dbClusterVersion: props.dbClusterVersion === undefined || props.dbClusterVersion === null ? '3.0' : props.dbClusterVersion,
            dbNodeGroupCount: props.dbNodeGroupCount,
            executorCount: props.executorCount,
            dbClusterClass: props.dbClusterClass,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDBCluster;
        this.attrConnectionString = rosDBCluster.attrConnectionString;
        this.attrDbClusterId = rosDBCluster.attrDbClusterId;
        this.attrOrderId = rosDBCluster.attrOrderId;
    }
}
exports.DBCluster = DBCluster;
//# sourceMappingURL=data:application/json;base64,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