import { aws_ec2, aws_rds, aws_secretsmanager } from "aws-cdk-lib";
import { Construct } from "constructs";
/**
 * Bootstraps a database instance, installing pgSTAC onto the database.
 */
export declare class BootstrapPgStac extends Construct {
    secret: aws_secretsmanager.ISecret;
    constructor(scope: Construct, id: string, props: BootstrapPgStacProps);
}
export interface BootstrapPgStacProps {
    /**
     * VPC in which the database resides.
     *
     * Note - Must be explicitely set if the `database` only conforms to the
     * `aws_rds.IDatabaseInstace` interface (ie it is a reference to a database instance
     * rather than a database instance.)
     *
     * @default - `vpc` property of the `database` instance provided.
     */
    readonly vpc?: aws_ec2.IVpc;
    /**
     * Database onto which pgSTAC should be installed.
     */
    readonly database: aws_rds.DatabaseInstance | aws_rds.IDatabaseInstance;
    /**
     * Secret containing valid connection details for the database instance. Secret must
     * conform to the format of CDK's `DatabaseInstance` (i.e. a JSON object containing a
     * `username`, `password`, `host`, `port`, and optionally a `dbname`). If a `dbname`
     * property is not specified within the secret, the bootstrapper will attempt to
     * connect to a database with the name of `"postgres"`.
     */
    readonly dbSecret: aws_secretsmanager.ISecret;
    /**
     * Name of database that is to be created and onto which pgSTAC will be installed.
     *
     * @default pgstac
     */
    readonly pgstacDbName?: string;
    /**
     * Name of user that will be generated for connecting to the pgSTAC database.
     *
     * @default pgstac_user
     */
    readonly pgstacUsername?: string;
    /**
     * pgSTAC version to be installed.
     *
     * @default 0.6.8
     */
    readonly pgstacVersion?: string;
    /**
     * Prefix to assign to the generated `secrets_manager.Secret`
     *
     * @default pgstac
     */
    readonly secretsPrefix?: string;
}
