# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'BucketAccessControlProjectTeamResponse',
    'BucketAccessControlResponse',
    'BucketAutoclassResponse',
    'BucketBillingResponse',
    'BucketCorsItemResponse',
    'BucketCustomPlacementConfigResponse',
    'BucketEncryptionResponse',
    'BucketIamConfigurationBucketPolicyOnlyResponse',
    'BucketIamConfigurationResponse',
    'BucketIamConfigurationUniformBucketLevelAccessResponse',
    'BucketIamPolicyBindingsItemResponse',
    'BucketLifecycleResponse',
    'BucketLifecycleRuleItemActionResponse',
    'BucketLifecycleRuleItemConditionResponse',
    'BucketLifecycleRuleItemResponse',
    'BucketLoggingResponse',
    'BucketObjectCustomerEncryptionResponse',
    'BucketObjectOwnerResponse',
    'BucketOwnerResponse',
    'BucketRetentionPolicyResponse',
    'BucketVersioningResponse',
    'BucketWebsiteResponse',
    'DefaultObjectAccessControlProjectTeamResponse',
    'ExprResponse',
    'ObjectAccessControlProjectTeamResponse',
    'ObjectAccessControlResponse',
    'ObjectIamPolicyBindingsItemResponse',
]

@pulumi.output_type
class BucketAccessControlProjectTeamResponse(dict):
    """
    The project team associated with the entity, if any.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectNumber":
            suggest = "project_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketAccessControlProjectTeamResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketAccessControlProjectTeamResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketAccessControlProjectTeamResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 project_number: str,
                 team: str):
        """
        The project team associated with the entity, if any.
        :param str project_number: The project number.
        :param str team: The team.
        """
        pulumi.set(__self__, "project_number", project_number)
        pulumi.set(__self__, "team", team)

    @property
    @pulumi.getter(name="projectNumber")
    def project_number(self) -> str:
        """
        The project number.
        """
        return pulumi.get(self, "project_number")

    @property
    @pulumi.getter
    def team(self) -> str:
        """
        The team.
        """
        return pulumi.get(self, "team")


@pulumi.output_type
class BucketAccessControlResponse(dict):
    """
    An access-control entry.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entityId":
            suggest = "entity_id"
        elif key == "projectTeam":
            suggest = "project_team"
        elif key == "selfLink":
            suggest = "self_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketAccessControlResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketAccessControlResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketAccessControlResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 domain: str,
                 email: str,
                 entity: str,
                 entity_id: str,
                 etag: str,
                 kind: str,
                 project_team: 'outputs.BucketAccessControlProjectTeamResponse',
                 role: str,
                 self_link: str):
        """
        An access-control entry.
        :param str bucket: The name of the bucket.
        :param str domain: The domain associated with the entity, if any.
        :param str email: The email address associated with the entity, if any.
        :param str entity: The entity holding the permission, in one of the following forms: 
               - user-userId 
               - user-email 
               - group-groupId 
               - group-email 
               - domain-domain 
               - project-team-projectId 
               - allUsers 
               - allAuthenticatedUsers Examples: 
               - The user liz@example.com would be user-liz@example.com. 
               - The group example@googlegroups.com would be group-example@googlegroups.com. 
               - To refer to all members of the Google Apps for Business domain example.com, the entity would be domain-example.com.
        :param str entity_id: The ID for the entity, if any.
        :param str etag: HTTP 1.1 Entity tag for the access-control entry.
        :param str kind: The kind of item this is. For bucket access control entries, this is always storage#bucketAccessControl.
        :param 'BucketAccessControlProjectTeamResponse' project_team: The project team associated with the entity, if any.
        :param str role: The access permission for the entity.
        :param str self_link: The link to this access-control entry.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "entity", entity)
        pulumi.set(__self__, "entity_id", entity_id)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "project_team", project_team)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "self_link", self_link)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        The domain associated with the entity, if any.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        The email address associated with the entity, if any.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def entity(self) -> str:
        """
        The entity holding the permission, in one of the following forms: 
        - user-userId 
        - user-email 
        - group-groupId 
        - group-email 
        - domain-domain 
        - project-team-projectId 
        - allUsers 
        - allAuthenticatedUsers Examples: 
        - The user liz@example.com would be user-liz@example.com. 
        - The group example@googlegroups.com would be group-example@googlegroups.com. 
        - To refer to all members of the Google Apps for Business domain example.com, the entity would be domain-example.com.
        """
        return pulumi.get(self, "entity")

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> str:
        """
        The ID for the entity, if any.
        """
        return pulumi.get(self, "entity_id")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        HTTP 1.1 Entity tag for the access-control entry.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        The kind of item this is. For bucket access control entries, this is always storage#bucketAccessControl.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="projectTeam")
    def project_team(self) -> 'outputs.BucketAccessControlProjectTeamResponse':
        """
        The project team associated with the entity, if any.
        """
        return pulumi.get(self, "project_team")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        The access permission for the entity.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> str:
        """
        The link to this access-control entry.
        """
        return pulumi.get(self, "self_link")


@pulumi.output_type
class BucketAutoclassResponse(dict):
    """
    The bucket's Autoclass configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "toggleTime":
            suggest = "toggle_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketAutoclassResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketAutoclassResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketAutoclassResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 toggle_time: str):
        """
        The bucket's Autoclass configuration.
        :param bool enabled: Whether or not Autoclass is enabled on this bucket
        :param str toggle_time: A date and time in RFC 3339 format representing the instant at which "enabled" was last toggled.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "toggle_time", toggle_time)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether or not Autoclass is enabled on this bucket
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="toggleTime")
    def toggle_time(self) -> str:
        """
        A date and time in RFC 3339 format representing the instant at which "enabled" was last toggled.
        """
        return pulumi.get(self, "toggle_time")


@pulumi.output_type
class BucketBillingResponse(dict):
    """
    The bucket's billing configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "requesterPays":
            suggest = "requester_pays"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketBillingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketBillingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketBillingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 requester_pays: bool):
        """
        The bucket's billing configuration.
        :param bool requester_pays: When set to true, Requester Pays is enabled for this bucket.
        """
        pulumi.set(__self__, "requester_pays", requester_pays)

    @property
    @pulumi.getter(name="requesterPays")
    def requester_pays(self) -> bool:
        """
        When set to true, Requester Pays is enabled for this bucket.
        """
        return pulumi.get(self, "requester_pays")


@pulumi.output_type
class BucketCorsItemResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxAgeSeconds":
            suggest = "max_age_seconds"
        elif key == "responseHeader":
            suggest = "response_header"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketCorsItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketCorsItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketCorsItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_age_seconds: int,
                 method: Sequence[str],
                 origin: Sequence[str],
                 response_header: Sequence[str]):
        """
        :param int max_age_seconds: The value, in seconds, to return in the  Access-Control-Max-Age header used in preflight responses.
        :param Sequence[str] method: The list of HTTP methods on which to include CORS response headers, (GET, OPTIONS, POST, etc) Note: "*" is permitted in the list of methods, and means "any method".
        :param Sequence[str] origin: The list of Origins eligible to receive CORS response headers. Note: "*" is permitted in the list of origins, and means "any Origin".
        :param Sequence[str] response_header: The list of HTTP headers other than the simple response headers to give permission for the user-agent to share across domains.
        """
        pulumi.set(__self__, "max_age_seconds", max_age_seconds)
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "origin", origin)
        pulumi.set(__self__, "response_header", response_header)

    @property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> int:
        """
        The value, in seconds, to return in the  Access-Control-Max-Age header used in preflight responses.
        """
        return pulumi.get(self, "max_age_seconds")

    @property
    @pulumi.getter
    def method(self) -> Sequence[str]:
        """
        The list of HTTP methods on which to include CORS response headers, (GET, OPTIONS, POST, etc) Note: "*" is permitted in the list of methods, and means "any method".
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def origin(self) -> Sequence[str]:
        """
        The list of Origins eligible to receive CORS response headers. Note: "*" is permitted in the list of origins, and means "any Origin".
        """
        return pulumi.get(self, "origin")

    @property
    @pulumi.getter(name="responseHeader")
    def response_header(self) -> Sequence[str]:
        """
        The list of HTTP headers other than the simple response headers to give permission for the user-agent to share across domains.
        """
        return pulumi.get(self, "response_header")


@pulumi.output_type
class BucketCustomPlacementConfigResponse(dict):
    """
    The bucket's custom placement configuration for Custom Dual Regions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataLocations":
            suggest = "data_locations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketCustomPlacementConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketCustomPlacementConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketCustomPlacementConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_locations: Sequence[str]):
        """
        The bucket's custom placement configuration for Custom Dual Regions.
        :param Sequence[str] data_locations: The list of regional locations in which data is placed.
        """
        pulumi.set(__self__, "data_locations", data_locations)

    @property
    @pulumi.getter(name="dataLocations")
    def data_locations(self) -> Sequence[str]:
        """
        The list of regional locations in which data is placed.
        """
        return pulumi.get(self, "data_locations")


@pulumi.output_type
class BucketEncryptionResponse(dict):
    """
    Encryption configuration for a bucket.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultKmsKeyName":
            suggest = "default_kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketEncryptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketEncryptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketEncryptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_kms_key_name: str):
        """
        Encryption configuration for a bucket.
        :param str default_kms_key_name: A Cloud KMS key that will be used to encrypt objects inserted into this bucket, if no encryption method is specified.
        """
        pulumi.set(__self__, "default_kms_key_name", default_kms_key_name)

    @property
    @pulumi.getter(name="defaultKmsKeyName")
    def default_kms_key_name(self) -> str:
        """
        A Cloud KMS key that will be used to encrypt objects inserted into this bucket, if no encryption method is specified.
        """
        return pulumi.get(self, "default_kms_key_name")


@pulumi.output_type
class BucketIamConfigurationBucketPolicyOnlyResponse(dict):
    """
    The bucket's uniform bucket-level access configuration. The feature was formerly known as Bucket Policy Only. For backward compatibility, this field will be populated with identical information as the uniformBucketLevelAccess field. We recommend using the uniformBucketLevelAccess field to enable and disable the feature.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lockedTime":
            suggest = "locked_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketIamConfigurationBucketPolicyOnlyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketIamConfigurationBucketPolicyOnlyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketIamConfigurationBucketPolicyOnlyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 locked_time: str):
        """
        The bucket's uniform bucket-level access configuration. The feature was formerly known as Bucket Policy Only. For backward compatibility, this field will be populated with identical information as the uniformBucketLevelAccess field. We recommend using the uniformBucketLevelAccess field to enable and disable the feature.
        :param bool enabled: If set, access is controlled only by bucket-level or above IAM policies.
        :param str locked_time: The deadline for changing iamConfiguration.bucketPolicyOnly.enabled from true to false in RFC 3339 format. iamConfiguration.bucketPolicyOnly.enabled may be changed from true to false until the locked time, after which the field is immutable.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "locked_time", locked_time)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        If set, access is controlled only by bucket-level or above IAM policies.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="lockedTime")
    def locked_time(self) -> str:
        """
        The deadline for changing iamConfiguration.bucketPolicyOnly.enabled from true to false in RFC 3339 format. iamConfiguration.bucketPolicyOnly.enabled may be changed from true to false until the locked time, after which the field is immutable.
        """
        return pulumi.get(self, "locked_time")


@pulumi.output_type
class BucketIamConfigurationResponse(dict):
    """
    The bucket's IAM configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketPolicyOnly":
            suggest = "bucket_policy_only"
        elif key == "publicAccessPrevention":
            suggest = "public_access_prevention"
        elif key == "uniformBucketLevelAccess":
            suggest = "uniform_bucket_level_access"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketIamConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketIamConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketIamConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_policy_only: 'outputs.BucketIamConfigurationBucketPolicyOnlyResponse',
                 public_access_prevention: str,
                 uniform_bucket_level_access: 'outputs.BucketIamConfigurationUniformBucketLevelAccessResponse'):
        """
        The bucket's IAM configuration.
        :param 'BucketIamConfigurationBucketPolicyOnlyResponse' bucket_policy_only: The bucket's uniform bucket-level access configuration. The feature was formerly known as Bucket Policy Only. For backward compatibility, this field will be populated with identical information as the uniformBucketLevelAccess field. We recommend using the uniformBucketLevelAccess field to enable and disable the feature.
        :param str public_access_prevention: The bucket's Public Access Prevention configuration. Currently, 'inherited' and 'enforced' are supported.
        :param 'BucketIamConfigurationUniformBucketLevelAccessResponse' uniform_bucket_level_access: The bucket's uniform bucket-level access configuration.
        """
        pulumi.set(__self__, "bucket_policy_only", bucket_policy_only)
        pulumi.set(__self__, "public_access_prevention", public_access_prevention)
        pulumi.set(__self__, "uniform_bucket_level_access", uniform_bucket_level_access)

    @property
    @pulumi.getter(name="bucketPolicyOnly")
    def bucket_policy_only(self) -> 'outputs.BucketIamConfigurationBucketPolicyOnlyResponse':
        """
        The bucket's uniform bucket-level access configuration. The feature was formerly known as Bucket Policy Only. For backward compatibility, this field will be populated with identical information as the uniformBucketLevelAccess field. We recommend using the uniformBucketLevelAccess field to enable and disable the feature.
        """
        return pulumi.get(self, "bucket_policy_only")

    @property
    @pulumi.getter(name="publicAccessPrevention")
    def public_access_prevention(self) -> str:
        """
        The bucket's Public Access Prevention configuration. Currently, 'inherited' and 'enforced' are supported.
        """
        return pulumi.get(self, "public_access_prevention")

    @property
    @pulumi.getter(name="uniformBucketLevelAccess")
    def uniform_bucket_level_access(self) -> 'outputs.BucketIamConfigurationUniformBucketLevelAccessResponse':
        """
        The bucket's uniform bucket-level access configuration.
        """
        return pulumi.get(self, "uniform_bucket_level_access")


@pulumi.output_type
class BucketIamConfigurationUniformBucketLevelAccessResponse(dict):
    """
    The bucket's uniform bucket-level access configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lockedTime":
            suggest = "locked_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketIamConfigurationUniformBucketLevelAccessResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketIamConfigurationUniformBucketLevelAccessResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketIamConfigurationUniformBucketLevelAccessResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 locked_time: str):
        """
        The bucket's uniform bucket-level access configuration.
        :param bool enabled: If set, access is controlled only by bucket-level or above IAM policies.
        :param str locked_time: The deadline for changing iamConfiguration.uniformBucketLevelAccess.enabled from true to false in RFC 3339  format. iamConfiguration.uniformBucketLevelAccess.enabled may be changed from true to false until the locked time, after which the field is immutable.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "locked_time", locked_time)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        If set, access is controlled only by bucket-level or above IAM policies.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="lockedTime")
    def locked_time(self) -> str:
        """
        The deadline for changing iamConfiguration.uniformBucketLevelAccess.enabled from true to false in RFC 3339  format. iamConfiguration.uniformBucketLevelAccess.enabled may be changed from true to false until the locked time, after which the field is immutable.
        """
        return pulumi.get(self, "locked_time")


@pulumi.output_type
class BucketIamPolicyBindingsItemResponse(dict):
    def __init__(__self__, *,
                 condition: 'outputs.ExprResponse',
                 members: Sequence[str],
                 role: str):
        """
        :param 'ExprResponse' condition: The condition that is associated with this binding. NOTE: an unsatisfied condition will not allow user access via current binding. Different bindings, including their conditions, are examined independently.
        :param Sequence[str] members: A collection of identifiers for members who may assume the provided role. Recognized identifiers are as follows:  
               - allUsers — A special identifier that represents anyone on the internet; with or without a Google account.  
               - allAuthenticatedUsers — A special identifier that represents anyone who is authenticated with a Google account or a service account.  
               - user:emailid — An email address that represents a specific account. For example, user:alice@gmail.com or user:joe@example.com.  
               - serviceAccount:emailid — An email address that represents a service account. For example,  serviceAccount:my-other-app@appspot.gserviceaccount.com .  
               - group:emailid — An email address that represents a Google group. For example, group:admins@example.com.  
               - domain:domain — A Google Apps domain name that represents all the users of that domain. For example, domain:google.com or domain:example.com.  
               - projectOwner:projectid — Owners of the given project. For example, projectOwner:my-example-project  
               - projectEditor:projectid — Editors of the given project. For example, projectEditor:my-example-project  
               - projectViewer:projectid — Viewers of the given project. For example, projectViewer:my-example-project
        :param str role: The role to which members belong. Two types of roles are supported: new IAM roles, which grant permissions that do not map directly to those provided by ACLs, and legacy IAM roles, which do map directly to ACL permissions. All roles are of the format roles/storage.specificRole.
               The new IAM roles are:  
               - roles/storage.admin — Full control of Google Cloud Storage resources.  
               - roles/storage.objectViewer — Read-Only access to Google Cloud Storage objects.  
               - roles/storage.objectCreator — Access to create objects in Google Cloud Storage.  
               - roles/storage.objectAdmin — Full control of Google Cloud Storage objects.   The legacy IAM roles are:  
               - roles/storage.legacyObjectReader — Read-only access to objects without listing. Equivalent to an ACL entry on an object with the READER role.  
               - roles/storage.legacyObjectOwner — Read/write access to existing objects without listing. Equivalent to an ACL entry on an object with the OWNER role.  
               - roles/storage.legacyBucketReader — Read access to buckets with object listing. Equivalent to an ACL entry on a bucket with the READER role.  
               - roles/storage.legacyBucketWriter — Read access to buckets with object listing/creation/deletion. Equivalent to an ACL entry on a bucket with the WRITER role.  
               - roles/storage.legacyBucketOwner — Read and write access to existing buckets with object listing/creation/deletion. Equivalent to an ACL entry on a bucket with the OWNER role.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.ExprResponse':
        """
        The condition that is associated with this binding. NOTE: an unsatisfied condition will not allow user access via current binding. Different bindings, including their conditions, are examined independently.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        A collection of identifiers for members who may assume the provided role. Recognized identifiers are as follows:  
        - allUsers — A special identifier that represents anyone on the internet; with or without a Google account.  
        - allAuthenticatedUsers — A special identifier that represents anyone who is authenticated with a Google account or a service account.  
        - user:emailid — An email address that represents a specific account. For example, user:alice@gmail.com or user:joe@example.com.  
        - serviceAccount:emailid — An email address that represents a service account. For example,  serviceAccount:my-other-app@appspot.gserviceaccount.com .  
        - group:emailid — An email address that represents a Google group. For example, group:admins@example.com.  
        - domain:domain — A Google Apps domain name that represents all the users of that domain. For example, domain:google.com or domain:example.com.  
        - projectOwner:projectid — Owners of the given project. For example, projectOwner:my-example-project  
        - projectEditor:projectid — Editors of the given project. For example, projectEditor:my-example-project  
        - projectViewer:projectid — Viewers of the given project. For example, projectViewer:my-example-project
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        The role to which members belong. Two types of roles are supported: new IAM roles, which grant permissions that do not map directly to those provided by ACLs, and legacy IAM roles, which do map directly to ACL permissions. All roles are of the format roles/storage.specificRole.
        The new IAM roles are:  
        - roles/storage.admin — Full control of Google Cloud Storage resources.  
        - roles/storage.objectViewer — Read-Only access to Google Cloud Storage objects.  
        - roles/storage.objectCreator — Access to create objects in Google Cloud Storage.  
        - roles/storage.objectAdmin — Full control of Google Cloud Storage objects.   The legacy IAM roles are:  
        - roles/storage.legacyObjectReader — Read-only access to objects without listing. Equivalent to an ACL entry on an object with the READER role.  
        - roles/storage.legacyObjectOwner — Read/write access to existing objects without listing. Equivalent to an ACL entry on an object with the OWNER role.  
        - roles/storage.legacyBucketReader — Read access to buckets with object listing. Equivalent to an ACL entry on a bucket with the READER role.  
        - roles/storage.legacyBucketWriter — Read access to buckets with object listing/creation/deletion. Equivalent to an ACL entry on a bucket with the WRITER role.  
        - roles/storage.legacyBucketOwner — Read and write access to existing buckets with object listing/creation/deletion. Equivalent to an ACL entry on a bucket with the OWNER role.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class BucketLifecycleResponse(dict):
    """
    The bucket's lifecycle configuration. See lifecycle management for more information.
    """
    def __init__(__self__, *,
                 rule: Sequence['outputs.BucketLifecycleRuleItemResponse']):
        """
        The bucket's lifecycle configuration. See lifecycle management for more information.
        :param Sequence['BucketLifecycleRuleItemResponse'] rule: A lifecycle management rule, which is made of an action to take and the condition(s) under which the action will be taken.
        """
        pulumi.set(__self__, "rule", rule)

    @property
    @pulumi.getter
    def rule(self) -> Sequence['outputs.BucketLifecycleRuleItemResponse']:
        """
        A lifecycle management rule, which is made of an action to take and the condition(s) under which the action will be taken.
        """
        return pulumi.get(self, "rule")


@pulumi.output_type
class BucketLifecycleRuleItemActionResponse(dict):
    """
    The action to take.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageClass":
            suggest = "storage_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleRuleItemActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleRuleItemActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleRuleItemActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_class: str,
                 type: str):
        """
        The action to take.
        :param str storage_class: Target storage class. Required iff the type of the action is SetStorageClass.
        :param str type: Type of the action. Currently, only Delete and SetStorageClass are supported.
        """
        pulumi.set(__self__, "storage_class", storage_class)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> str:
        """
        Target storage class. Required iff the type of the action is SetStorageClass.
        """
        return pulumi.get(self, "storage_class")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the action. Currently, only Delete and SetStorageClass are supported.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class BucketLifecycleRuleItemConditionResponse(dict):
    """
    The condition(s) under which the action will be taken.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdBefore":
            suggest = "created_before"
        elif key == "customTimeBefore":
            suggest = "custom_time_before"
        elif key == "daysSinceCustomTime":
            suggest = "days_since_custom_time"
        elif key == "daysSinceNoncurrentTime":
            suggest = "days_since_noncurrent_time"
        elif key == "isLive":
            suggest = "is_live"
        elif key == "matchesPattern":
            suggest = "matches_pattern"
        elif key == "matchesStorageClass":
            suggest = "matches_storage_class"
        elif key == "noncurrentTimeBefore":
            suggest = "noncurrent_time_before"
        elif key == "numNewerVersions":
            suggest = "num_newer_versions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleRuleItemConditionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleRuleItemConditionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleRuleItemConditionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 age: int,
                 created_before: str,
                 custom_time_before: str,
                 days_since_custom_time: int,
                 days_since_noncurrent_time: int,
                 is_live: bool,
                 matches_pattern: str,
                 matches_storage_class: Sequence[str],
                 noncurrent_time_before: str,
                 num_newer_versions: int):
        """
        The condition(s) under which the action will be taken.
        :param int age: Age of an object (in days). This condition is satisfied when an object reaches the specified age.
        :param str created_before: A date in RFC 3339 format with only the date part (for instance, "2013-01-15"). This condition is satisfied when an object is created before midnight of the specified date in UTC.
        :param str custom_time_before: A date in RFC 3339 format with only the date part (for instance, "2013-01-15"). This condition is satisfied when the custom time on an object is before this date in UTC.
        :param int days_since_custom_time: Number of days elapsed since the user-specified timestamp set on an object. The condition is satisfied if the days elapsed is at least this number. If no custom timestamp is specified on an object, the condition does not apply.
        :param int days_since_noncurrent_time: Number of days elapsed since the noncurrent timestamp of an object. The condition is satisfied if the days elapsed is at least this number. This condition is relevant only for versioned objects. The value of the field must be a nonnegative integer. If it's zero, the object version will become eligible for Lifecycle action as soon as it becomes noncurrent.
        :param bool is_live: Relevant only for versioned objects. If the value is true, this condition matches live objects; if the value is false, it matches archived objects.
        :param str matches_pattern: A regular expression that satisfies the RE2 syntax. This condition is satisfied when the name of the object matches the RE2 pattern. Note: This feature is currently in the "Early Access" launch stage and is only available to a whitelisted set of users; that means that this feature may be changed in backward-incompatible ways and that it is not guaranteed to be released.
        :param Sequence[str] matches_storage_class: Objects having any of the storage classes specified by this condition will be matched. Values include MULTI_REGIONAL, REGIONAL, NEARLINE, COLDLINE, ARCHIVE, STANDARD, and DURABLE_REDUCED_AVAILABILITY.
        :param str noncurrent_time_before: A date in RFC 3339 format with only the date part (for instance, "2013-01-15"). This condition is satisfied when the noncurrent time on an object is before this date in UTC. This condition is relevant only for versioned objects.
        :param int num_newer_versions: Relevant only for versioned objects. If the value is N, this condition is satisfied when there are at least N versions (including the live version) newer than this version of the object.
        """
        pulumi.set(__self__, "age", age)
        pulumi.set(__self__, "created_before", created_before)
        pulumi.set(__self__, "custom_time_before", custom_time_before)
        pulumi.set(__self__, "days_since_custom_time", days_since_custom_time)
        pulumi.set(__self__, "days_since_noncurrent_time", days_since_noncurrent_time)
        pulumi.set(__self__, "is_live", is_live)
        pulumi.set(__self__, "matches_pattern", matches_pattern)
        pulumi.set(__self__, "matches_storage_class", matches_storage_class)
        pulumi.set(__self__, "noncurrent_time_before", noncurrent_time_before)
        pulumi.set(__self__, "num_newer_versions", num_newer_versions)

    @property
    @pulumi.getter
    def age(self) -> int:
        """
        Age of an object (in days). This condition is satisfied when an object reaches the specified age.
        """
        return pulumi.get(self, "age")

    @property
    @pulumi.getter(name="createdBefore")
    def created_before(self) -> str:
        """
        A date in RFC 3339 format with only the date part (for instance, "2013-01-15"). This condition is satisfied when an object is created before midnight of the specified date in UTC.
        """
        return pulumi.get(self, "created_before")

    @property
    @pulumi.getter(name="customTimeBefore")
    def custom_time_before(self) -> str:
        """
        A date in RFC 3339 format with only the date part (for instance, "2013-01-15"). This condition is satisfied when the custom time on an object is before this date in UTC.
        """
        return pulumi.get(self, "custom_time_before")

    @property
    @pulumi.getter(name="daysSinceCustomTime")
    def days_since_custom_time(self) -> int:
        """
        Number of days elapsed since the user-specified timestamp set on an object. The condition is satisfied if the days elapsed is at least this number. If no custom timestamp is specified on an object, the condition does not apply.
        """
        return pulumi.get(self, "days_since_custom_time")

    @property
    @pulumi.getter(name="daysSinceNoncurrentTime")
    def days_since_noncurrent_time(self) -> int:
        """
        Number of days elapsed since the noncurrent timestamp of an object. The condition is satisfied if the days elapsed is at least this number. This condition is relevant only for versioned objects. The value of the field must be a nonnegative integer. If it's zero, the object version will become eligible for Lifecycle action as soon as it becomes noncurrent.
        """
        return pulumi.get(self, "days_since_noncurrent_time")

    @property
    @pulumi.getter(name="isLive")
    def is_live(self) -> bool:
        """
        Relevant only for versioned objects. If the value is true, this condition matches live objects; if the value is false, it matches archived objects.
        """
        return pulumi.get(self, "is_live")

    @property
    @pulumi.getter(name="matchesPattern")
    def matches_pattern(self) -> str:
        """
        A regular expression that satisfies the RE2 syntax. This condition is satisfied when the name of the object matches the RE2 pattern. Note: This feature is currently in the "Early Access" launch stage and is only available to a whitelisted set of users; that means that this feature may be changed in backward-incompatible ways and that it is not guaranteed to be released.
        """
        return pulumi.get(self, "matches_pattern")

    @property
    @pulumi.getter(name="matchesStorageClass")
    def matches_storage_class(self) -> Sequence[str]:
        """
        Objects having any of the storage classes specified by this condition will be matched. Values include MULTI_REGIONAL, REGIONAL, NEARLINE, COLDLINE, ARCHIVE, STANDARD, and DURABLE_REDUCED_AVAILABILITY.
        """
        return pulumi.get(self, "matches_storage_class")

    @property
    @pulumi.getter(name="noncurrentTimeBefore")
    def noncurrent_time_before(self) -> str:
        """
        A date in RFC 3339 format with only the date part (for instance, "2013-01-15"). This condition is satisfied when the noncurrent time on an object is before this date in UTC. This condition is relevant only for versioned objects.
        """
        return pulumi.get(self, "noncurrent_time_before")

    @property
    @pulumi.getter(name="numNewerVersions")
    def num_newer_versions(self) -> int:
        """
        Relevant only for versioned objects. If the value is N, this condition is satisfied when there are at least N versions (including the live version) newer than this version of the object.
        """
        return pulumi.get(self, "num_newer_versions")


@pulumi.output_type
class BucketLifecycleRuleItemResponse(dict):
    def __init__(__self__, *,
                 action: 'outputs.BucketLifecycleRuleItemActionResponse',
                 condition: 'outputs.BucketLifecycleRuleItemConditionResponse'):
        """
        :param 'BucketLifecycleRuleItemActionResponse' action: The action to take.
        :param 'BucketLifecycleRuleItemConditionResponse' condition: The condition(s) under which the action will be taken.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "condition", condition)

    @property
    @pulumi.getter
    def action(self) -> 'outputs.BucketLifecycleRuleItemActionResponse':
        """
        The action to take.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.BucketLifecycleRuleItemConditionResponse':
        """
        The condition(s) under which the action will be taken.
        """
        return pulumi.get(self, "condition")


@pulumi.output_type
class BucketLoggingResponse(dict):
    """
    The bucket's logging configuration, which defines the destination bucket and optional name prefix for the current bucket's logs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logBucket":
            suggest = "log_bucket"
        elif key == "logObjectPrefix":
            suggest = "log_object_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLoggingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLoggingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLoggingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_bucket: str,
                 log_object_prefix: str):
        """
        The bucket's logging configuration, which defines the destination bucket and optional name prefix for the current bucket's logs.
        :param str log_bucket: The destination bucket where the current bucket's logs should be placed.
        :param str log_object_prefix: A prefix for log object names.
        """
        pulumi.set(__self__, "log_bucket", log_bucket)
        pulumi.set(__self__, "log_object_prefix", log_object_prefix)

    @property
    @pulumi.getter(name="logBucket")
    def log_bucket(self) -> str:
        """
        The destination bucket where the current bucket's logs should be placed.
        """
        return pulumi.get(self, "log_bucket")

    @property
    @pulumi.getter(name="logObjectPrefix")
    def log_object_prefix(self) -> str:
        """
        A prefix for log object names.
        """
        return pulumi.get(self, "log_object_prefix")


@pulumi.output_type
class BucketObjectCustomerEncryptionResponse(dict):
    """
    Metadata of customer-supplied encryption key, if the object is encrypted by such a key.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionAlgorithm":
            suggest = "encryption_algorithm"
        elif key == "keySha256":
            suggest = "key_sha256"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketObjectCustomerEncryptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketObjectCustomerEncryptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketObjectCustomerEncryptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_algorithm: str,
                 key_sha256: str):
        """
        Metadata of customer-supplied encryption key, if the object is encrypted by such a key.
        :param str encryption_algorithm: The encryption algorithm.
        :param str key_sha256: SHA256 hash value of the encryption key.
        """
        pulumi.set(__self__, "encryption_algorithm", encryption_algorithm)
        pulumi.set(__self__, "key_sha256", key_sha256)

    @property
    @pulumi.getter(name="encryptionAlgorithm")
    def encryption_algorithm(self) -> str:
        """
        The encryption algorithm.
        """
        return pulumi.get(self, "encryption_algorithm")

    @property
    @pulumi.getter(name="keySha256")
    def key_sha256(self) -> str:
        """
        SHA256 hash value of the encryption key.
        """
        return pulumi.get(self, "key_sha256")


@pulumi.output_type
class BucketObjectOwnerResponse(dict):
    """
    The owner of the object. This will always be the uploader of the object.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entityId":
            suggest = "entity_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketObjectOwnerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketObjectOwnerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketObjectOwnerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 entity: str,
                 entity_id: str):
        """
        The owner of the object. This will always be the uploader of the object.
        :param str entity: The entity, in the form user-userId.
        :param str entity_id: The ID for the entity.
        """
        pulumi.set(__self__, "entity", entity)
        pulumi.set(__self__, "entity_id", entity_id)

    @property
    @pulumi.getter
    def entity(self) -> str:
        """
        The entity, in the form user-userId.
        """
        return pulumi.get(self, "entity")

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> str:
        """
        The ID for the entity.
        """
        return pulumi.get(self, "entity_id")


@pulumi.output_type
class BucketOwnerResponse(dict):
    """
    The owner of the bucket. This is always the project team's owner group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entityId":
            suggest = "entity_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketOwnerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketOwnerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketOwnerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 entity: str,
                 entity_id: str):
        """
        The owner of the bucket. This is always the project team's owner group.
        :param str entity: The entity, in the form project-owner-projectId.
        :param str entity_id: The ID for the entity.
        """
        pulumi.set(__self__, "entity", entity)
        pulumi.set(__self__, "entity_id", entity_id)

    @property
    @pulumi.getter
    def entity(self) -> str:
        """
        The entity, in the form project-owner-projectId.
        """
        return pulumi.get(self, "entity")

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> str:
        """
        The ID for the entity.
        """
        return pulumi.get(self, "entity_id")


@pulumi.output_type
class BucketRetentionPolicyResponse(dict):
    """
    The bucket's retention policy. The retention policy enforces a minimum retention time for all objects contained in the bucket, based on their creation time. Any attempt to overwrite or delete objects younger than the retention period will result in a PERMISSION_DENIED error. An unlocked retention policy can be modified or removed from the bucket via a storage.buckets.update operation. A locked retention policy cannot be removed or shortened in duration for the lifetime of the bucket. Attempting to remove or decrease period of a locked retention policy will result in a PERMISSION_DENIED error.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "effectiveTime":
            suggest = "effective_time"
        elif key == "isLocked":
            suggest = "is_locked"
        elif key == "retentionPeriod":
            suggest = "retention_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketRetentionPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketRetentionPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketRetentionPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 effective_time: str,
                 is_locked: bool,
                 retention_period: str):
        """
        The bucket's retention policy. The retention policy enforces a minimum retention time for all objects contained in the bucket, based on their creation time. Any attempt to overwrite or delete objects younger than the retention period will result in a PERMISSION_DENIED error. An unlocked retention policy can be modified or removed from the bucket via a storage.buckets.update operation. A locked retention policy cannot be removed or shortened in duration for the lifetime of the bucket. Attempting to remove or decrease period of a locked retention policy will result in a PERMISSION_DENIED error.
        :param str effective_time: Server-determined value that indicates the time from which policy was enforced and effective. This value is in RFC 3339 format.
        :param bool is_locked: Once locked, an object retention policy cannot be modified.
        :param str retention_period: The duration in seconds that objects need to be retained. Retention duration must be greater than zero and less than 100 years. Note that enforcement of retention periods less than a day is not guaranteed. Such periods should only be used for testing purposes.
        """
        pulumi.set(__self__, "effective_time", effective_time)
        pulumi.set(__self__, "is_locked", is_locked)
        pulumi.set(__self__, "retention_period", retention_period)

    @property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> str:
        """
        Server-determined value that indicates the time from which policy was enforced and effective. This value is in RFC 3339 format.
        """
        return pulumi.get(self, "effective_time")

    @property
    @pulumi.getter(name="isLocked")
    def is_locked(self) -> bool:
        """
        Once locked, an object retention policy cannot be modified.
        """
        return pulumi.get(self, "is_locked")

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> str:
        """
        The duration in seconds that objects need to be retained. Retention duration must be greater than zero and less than 100 years. Note that enforcement of retention periods less than a day is not guaranteed. Such periods should only be used for testing purposes.
        """
        return pulumi.get(self, "retention_period")


@pulumi.output_type
class BucketVersioningResponse(dict):
    """
    The bucket's versioning configuration.
    """
    def __init__(__self__, *,
                 enabled: bool):
        """
        The bucket's versioning configuration.
        :param bool enabled: While set to true, versioning is fully enabled for this bucket.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        While set to true, versioning is fully enabled for this bucket.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class BucketWebsiteResponse(dict):
    """
    The bucket's website configuration, controlling how the service behaves when accessing bucket contents as a web site. See the Static Website Examples for more information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mainPageSuffix":
            suggest = "main_page_suffix"
        elif key == "notFoundPage":
            suggest = "not_found_page"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketWebsiteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketWebsiteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketWebsiteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 main_page_suffix: str,
                 not_found_page: str):
        """
        The bucket's website configuration, controlling how the service behaves when accessing bucket contents as a web site. See the Static Website Examples for more information.
        :param str main_page_suffix: If the requested object path is missing, the service will ensure the path has a trailing '/', append this suffix, and attempt to retrieve the resulting object. This allows the creation of index.html objects to represent directory pages.
        :param str not_found_page: If the requested object path is missing, and any mainPageSuffix object is missing, if applicable, the service will return the named object from this bucket as the content for a 404 Not Found result.
        """
        pulumi.set(__self__, "main_page_suffix", main_page_suffix)
        pulumi.set(__self__, "not_found_page", not_found_page)

    @property
    @pulumi.getter(name="mainPageSuffix")
    def main_page_suffix(self) -> str:
        """
        If the requested object path is missing, the service will ensure the path has a trailing '/', append this suffix, and attempt to retrieve the resulting object. This allows the creation of index.html objects to represent directory pages.
        """
        return pulumi.get(self, "main_page_suffix")

    @property
    @pulumi.getter(name="notFoundPage")
    def not_found_page(self) -> str:
        """
        If the requested object path is missing, and any mainPageSuffix object is missing, if applicable, the service will return the named object from this bucket as the content for a 404 Not Found result.
        """
        return pulumi.get(self, "not_found_page")


@pulumi.output_type
class DefaultObjectAccessControlProjectTeamResponse(dict):
    """
    The project team associated with the entity, if any.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectNumber":
            suggest = "project_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DefaultObjectAccessControlProjectTeamResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DefaultObjectAccessControlProjectTeamResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DefaultObjectAccessControlProjectTeamResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 project_number: str,
                 team: str):
        """
        The project team associated with the entity, if any.
        :param str project_number: The project number.
        :param str team: The team.
        """
        pulumi.set(__self__, "project_number", project_number)
        pulumi.set(__self__, "team", team)

    @property
    @pulumi.getter(name="projectNumber")
    def project_number(self) -> str:
        """
        The project number.
        """
        return pulumi.get(self, "project_number")

    @property
    @pulumi.getter
    def team(self) -> str:
        """
        The team.
        """
        return pulumi.get(self, "team")


@pulumi.output_type
class ExprResponse(dict):
    """
    Represents an expression text. Example: title: "User account presence" description: "Determines whether the request has a user account" expression: "size(request.user) > 0"
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents an expression text. Example: title: "User account presence" description: "Determines whether the request has a user account" expression: "size(request.user) > 0"
        :param str description: An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax. The application context of the containing message determines which well-known feature set of CEL is supported.
        :param str location: An optional string indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: An optional title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax. The application context of the containing message determines which well-known feature set of CEL is supported.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        An optional string indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        An optional title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class ObjectAccessControlProjectTeamResponse(dict):
    """
    The project team associated with the entity, if any.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectNumber":
            suggest = "project_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectAccessControlProjectTeamResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectAccessControlProjectTeamResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectAccessControlProjectTeamResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 project_number: str,
                 team: str):
        """
        The project team associated with the entity, if any.
        :param str project_number: The project number.
        :param str team: The team.
        """
        pulumi.set(__self__, "project_number", project_number)
        pulumi.set(__self__, "team", team)

    @property
    @pulumi.getter(name="projectNumber")
    def project_number(self) -> str:
        """
        The project number.
        """
        return pulumi.get(self, "project_number")

    @property
    @pulumi.getter
    def team(self) -> str:
        """
        The team.
        """
        return pulumi.get(self, "team")


@pulumi.output_type
class ObjectAccessControlResponse(dict):
    """
    An access-control entry.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entityId":
            suggest = "entity_id"
        elif key == "projectTeam":
            suggest = "project_team"
        elif key == "selfLink":
            suggest = "self_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectAccessControlResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectAccessControlResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectAccessControlResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 domain: str,
                 email: str,
                 entity: str,
                 entity_id: str,
                 etag: str,
                 generation: str,
                 kind: str,
                 object: str,
                 project_team: 'outputs.ObjectAccessControlProjectTeamResponse',
                 role: str,
                 self_link: str):
        """
        An access-control entry.
        :param str bucket: The name of the bucket.
        :param str domain: The domain associated with the entity, if any.
        :param str email: The email address associated with the entity, if any.
        :param str entity: The entity holding the permission, in one of the following forms: 
               - user-userId 
               - user-email 
               - group-groupId 
               - group-email 
               - domain-domain 
               - project-team-projectId 
               - allUsers 
               - allAuthenticatedUsers Examples: 
               - The user liz@example.com would be user-liz@example.com. 
               - The group example@googlegroups.com would be group-example@googlegroups.com. 
               - To refer to all members of the Google Apps for Business domain example.com, the entity would be domain-example.com.
        :param str entity_id: The ID for the entity, if any.
        :param str etag: HTTP 1.1 Entity tag for the access-control entry.
        :param str generation: The content generation of the object, if applied to an object.
        :param str kind: The kind of item this is. For object access control entries, this is always storage#objectAccessControl.
        :param str object: The name of the object, if applied to an object.
        :param 'ObjectAccessControlProjectTeamResponse' project_team: The project team associated with the entity, if any.
        :param str role: The access permission for the entity.
        :param str self_link: The link to this access-control entry.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "entity", entity)
        pulumi.set(__self__, "entity_id", entity_id)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "generation", generation)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "object", object)
        pulumi.set(__self__, "project_team", project_team)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "self_link", self_link)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        The domain associated with the entity, if any.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        The email address associated with the entity, if any.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def entity(self) -> str:
        """
        The entity holding the permission, in one of the following forms: 
        - user-userId 
        - user-email 
        - group-groupId 
        - group-email 
        - domain-domain 
        - project-team-projectId 
        - allUsers 
        - allAuthenticatedUsers Examples: 
        - The user liz@example.com would be user-liz@example.com. 
        - The group example@googlegroups.com would be group-example@googlegroups.com. 
        - To refer to all members of the Google Apps for Business domain example.com, the entity would be domain-example.com.
        """
        return pulumi.get(self, "entity")

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> str:
        """
        The ID for the entity, if any.
        """
        return pulumi.get(self, "entity_id")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        HTTP 1.1 Entity tag for the access-control entry.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def generation(self) -> str:
        """
        The content generation of the object, if applied to an object.
        """
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        The kind of item this is. For object access control entries, this is always storage#objectAccessControl.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The name of the object, if applied to an object.
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="projectTeam")
    def project_team(self) -> 'outputs.ObjectAccessControlProjectTeamResponse':
        """
        The project team associated with the entity, if any.
        """
        return pulumi.get(self, "project_team")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        The access permission for the entity.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> str:
        """
        The link to this access-control entry.
        """
        return pulumi.get(self, "self_link")


@pulumi.output_type
class ObjectIamPolicyBindingsItemResponse(dict):
    def __init__(__self__, *,
                 condition: 'outputs.ExprResponse',
                 members: Sequence[str],
                 role: str):
        """
        :param 'ExprResponse' condition: The condition that is associated with this binding. NOTE: an unsatisfied condition will not allow user access via current binding. Different bindings, including their conditions, are examined independently.
        :param Sequence[str] members: A collection of identifiers for members who may assume the provided role. Recognized identifiers are as follows:  
               - allUsers — A special identifier that represents anyone on the internet; with or without a Google account.  
               - allAuthenticatedUsers — A special identifier that represents anyone who is authenticated with a Google account or a service account.  
               - user:emailid — An email address that represents a specific account. For example, user:alice@gmail.com or user:joe@example.com.  
               - serviceAccount:emailid — An email address that represents a service account. For example,  serviceAccount:my-other-app@appspot.gserviceaccount.com .  
               - group:emailid — An email address that represents a Google group. For example, group:admins@example.com.  
               - domain:domain — A Google Apps domain name that represents all the users of that domain. For example, domain:google.com or domain:example.com.  
               - projectOwner:projectid — Owners of the given project. For example, projectOwner:my-example-project  
               - projectEditor:projectid — Editors of the given project. For example, projectEditor:my-example-project  
               - projectViewer:projectid — Viewers of the given project. For example, projectViewer:my-example-project
        :param str role: The role to which members belong. Two types of roles are supported: new IAM roles, which grant permissions that do not map directly to those provided by ACLs, and legacy IAM roles, which do map directly to ACL permissions. All roles are of the format roles/storage.specificRole.
               The new IAM roles are:  
               - roles/storage.admin — Full control of Google Cloud Storage resources.  
               - roles/storage.objectViewer — Read-Only access to Google Cloud Storage objects.  
               - roles/storage.objectCreator — Access to create objects in Google Cloud Storage.  
               - roles/storage.objectAdmin — Full control of Google Cloud Storage objects.   The legacy IAM roles are:  
               - roles/storage.legacyObjectReader — Read-only access to objects without listing. Equivalent to an ACL entry on an object with the READER role.  
               - roles/storage.legacyObjectOwner — Read/write access to existing objects without listing. Equivalent to an ACL entry on an object with the OWNER role.  
               - roles/storage.legacyBucketReader — Read access to buckets with object listing. Equivalent to an ACL entry on a bucket with the READER role.  
               - roles/storage.legacyBucketWriter — Read access to buckets with object listing/creation/deletion. Equivalent to an ACL entry on a bucket with the WRITER role.  
               - roles/storage.legacyBucketOwner — Read and write access to existing buckets with object listing/creation/deletion. Equivalent to an ACL entry on a bucket with the OWNER role.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.ExprResponse':
        """
        The condition that is associated with this binding. NOTE: an unsatisfied condition will not allow user access via current binding. Different bindings, including their conditions, are examined independently.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        A collection of identifiers for members who may assume the provided role. Recognized identifiers are as follows:  
        - allUsers — A special identifier that represents anyone on the internet; with or without a Google account.  
        - allAuthenticatedUsers — A special identifier that represents anyone who is authenticated with a Google account or a service account.  
        - user:emailid — An email address that represents a specific account. For example, user:alice@gmail.com or user:joe@example.com.  
        - serviceAccount:emailid — An email address that represents a service account. For example,  serviceAccount:my-other-app@appspot.gserviceaccount.com .  
        - group:emailid — An email address that represents a Google group. For example, group:admins@example.com.  
        - domain:domain — A Google Apps domain name that represents all the users of that domain. For example, domain:google.com or domain:example.com.  
        - projectOwner:projectid — Owners of the given project. For example, projectOwner:my-example-project  
        - projectEditor:projectid — Editors of the given project. For example, projectEditor:my-example-project  
        - projectViewer:projectid — Viewers of the given project. For example, projectViewer:my-example-project
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        The role to which members belong. Two types of roles are supported: new IAM roles, which grant permissions that do not map directly to those provided by ACLs, and legacy IAM roles, which do map directly to ACL permissions. All roles are of the format roles/storage.specificRole.
        The new IAM roles are:  
        - roles/storage.admin — Full control of Google Cloud Storage resources.  
        - roles/storage.objectViewer — Read-Only access to Google Cloud Storage objects.  
        - roles/storage.objectCreator — Access to create objects in Google Cloud Storage.  
        - roles/storage.objectAdmin — Full control of Google Cloud Storage objects.   The legacy IAM roles are:  
        - roles/storage.legacyObjectReader — Read-only access to objects without listing. Equivalent to an ACL entry on an object with the READER role.  
        - roles/storage.legacyObjectOwner — Read/write access to existing objects without listing. Equivalent to an ACL entry on an object with the OWNER role.  
        - roles/storage.legacyBucketReader — Read access to buckets with object listing. Equivalent to an ACL entry on a bucket with the READER role.  
        - roles/storage.legacyBucketWriter — Read access to buckets with object listing/creation/deletion. Equivalent to an ACL entry on a bucket with the WRITER role.  
        - roles/storage.legacyBucketOwner — Read and write access to existing buckets with object listing/creation/deletion. Equivalent to an ACL entry on a bucket with the OWNER role.
        """
        return pulumi.get(self, "role")


