# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BucketArgs', 'Bucket']

@pulumi.input_type
class BucketArgs:
    def __init__(__self__, *,
                 acl: Optional[pulumi.Input[Sequence[pulumi.Input['BucketAccessControlArgs']]]] = None,
                 autoclass: Optional[pulumi.Input['BucketAutoclassArgs']] = None,
                 billing: Optional[pulumi.Input['BucketBillingArgs']] = None,
                 cors: Optional[pulumi.Input[Sequence[pulumi.Input['BucketCorsItemArgs']]]] = None,
                 custom_placement_config: Optional[pulumi.Input['BucketCustomPlacementConfigArgs']] = None,
                 default_event_based_hold: Optional[pulumi.Input[bool]] = None,
                 default_object_acl: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectAccessControlArgs']]]] = None,
                 encryption: Optional[pulumi.Input['BucketEncryptionArgs']] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 iam_configuration: Optional[pulumi.Input['BucketIamConfigurationArgs']] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 lifecycle: Optional[pulumi.Input['BucketLifecycleArgs']] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 location_type: Optional[pulumi.Input[str]] = None,
                 logging: Optional[pulumi.Input['BucketLoggingArgs']] = None,
                 metageneration: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 owner: Optional[pulumi.Input['BucketOwnerArgs']] = None,
                 predefined_acl: Optional[pulumi.Input[str]] = None,
                 predefined_default_object_acl: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 project_number: Optional[pulumi.Input[str]] = None,
                 projection: Optional[pulumi.Input[str]] = None,
                 provisional_user_project: Optional[pulumi.Input[str]] = None,
                 retention_policy: Optional[pulumi.Input['BucketRetentionPolicyArgs']] = None,
                 rpo: Optional[pulumi.Input[str]] = None,
                 satisfies_pzs: Optional[pulumi.Input[bool]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 storage_class: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 updated: Optional[pulumi.Input[str]] = None,
                 user_project: Optional[pulumi.Input[str]] = None,
                 versioning: Optional[pulumi.Input['BucketVersioningArgs']] = None,
                 website: Optional[pulumi.Input['BucketWebsiteArgs']] = None):
        """
        The set of arguments for constructing a Bucket resource.
        :param pulumi.Input[Sequence[pulumi.Input['BucketAccessControlArgs']]] acl: Access controls on the bucket.
        :param pulumi.Input['BucketAutoclassArgs'] autoclass: The bucket's Autoclass configuration.
        :param pulumi.Input['BucketBillingArgs'] billing: The bucket's billing configuration.
        :param pulumi.Input[Sequence[pulumi.Input['BucketCorsItemArgs']]] cors: The bucket's Cross-Origin Resource Sharing (CORS) configuration.
        :param pulumi.Input['BucketCustomPlacementConfigArgs'] custom_placement_config: The bucket's custom placement configuration for Custom Dual Regions.
        :param pulumi.Input[bool] default_event_based_hold: The default value for event-based hold on newly created objects in this bucket. Event-based hold is a way to retain objects indefinitely until an event occurs, signified by the hold's release. After being released, such objects will be subject to bucket-level retention (if any). One sample use case of this flag is for banks to hold loan documents for at least 3 years after loan is paid in full. Here, bucket-level retention is 3 years and the event is loan being paid in full. In this example, these objects will be held intact for any number of years until the event has occurred (event-based hold on the object is released) and then 3 more years after that. That means retention duration of the objects begins from the moment event-based hold transitioned from true to false. Objects under event-based hold cannot be deleted, overwritten or archived until the hold is removed.
        :param pulumi.Input[Sequence[pulumi.Input['ObjectAccessControlArgs']]] default_object_acl: Default access controls to apply to new objects when no ACL is provided.
        :param pulumi.Input['BucketEncryptionArgs'] encryption: Encryption configuration for a bucket.
        :param pulumi.Input[str] etag: HTTP 1.1 Entity tag for the bucket.
        :param pulumi.Input['BucketIamConfigurationArgs'] iam_configuration: The bucket's IAM configuration.
        :param pulumi.Input[str] id: The ID of the bucket. For buckets, the id and name properties are the same.
        :param pulumi.Input[str] kind: The kind of item this is. For buckets, this is always storage#bucket.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: User-provided labels, in key/value pairs.
        :param pulumi.Input['BucketLifecycleArgs'] lifecycle: The bucket's lifecycle configuration. See lifecycle management for more information.
        :param pulumi.Input[str] location: The location of the bucket. Object data for objects in the bucket resides in physical storage within this region. Defaults to US. See the developer's guide for the authoritative list.
        :param pulumi.Input[str] location_type: The type of the bucket location.
        :param pulumi.Input['BucketLoggingArgs'] logging: The bucket's logging configuration, which defines the destination bucket and optional name prefix for the current bucket's logs.
        :param pulumi.Input[str] metageneration: The metadata generation of this bucket.
        :param pulumi.Input[str] name: The name of the bucket.
        :param pulumi.Input['BucketOwnerArgs'] owner: The owner of the bucket. This is always the project team's owner group.
        :param pulumi.Input[str] project_number: The project number of the project the bucket belongs to.
        :param pulumi.Input['BucketRetentionPolicyArgs'] retention_policy: The bucket's retention policy. The retention policy enforces a minimum retention time for all objects contained in the bucket, based on their creation time. Any attempt to overwrite or delete objects younger than the retention period will result in a PERMISSION_DENIED error. An unlocked retention policy can be modified or removed from the bucket via a storage.buckets.update operation. A locked retention policy cannot be removed or shortened in duration for the lifetime of the bucket. Attempting to remove or decrease period of a locked retention policy will result in a PERMISSION_DENIED error.
        :param pulumi.Input[str] rpo: The Recovery Point Objective (RPO) of this bucket. Set to ASYNC_TURBO to turn on Turbo Replication on a bucket.
        :param pulumi.Input[bool] satisfies_pzs: Reserved for future use.
        :param pulumi.Input[str] self_link: The URI of this bucket.
        :param pulumi.Input[str] storage_class: The bucket's default storage class, used whenever no storageClass is specified for a newly-created object. This defines how objects in the bucket are stored and determines the SLA and the cost of storage. Values include MULTI_REGIONAL, REGIONAL, STANDARD, NEARLINE, COLDLINE, ARCHIVE, and DURABLE_REDUCED_AVAILABILITY. If this value is not specified when the bucket is created, it will default to STANDARD. For more information, see storage classes.
        :param pulumi.Input[str] time_created: The creation time of the bucket in RFC 3339 format.
        :param pulumi.Input[str] updated: The modification time of the bucket in RFC 3339 format.
        :param pulumi.Input['BucketVersioningArgs'] versioning: The bucket's versioning configuration.
        :param pulumi.Input['BucketWebsiteArgs'] website: The bucket's website configuration, controlling how the service behaves when accessing bucket contents as a web site. See the Static Website Examples for more information.
        """
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if autoclass is not None:
            pulumi.set(__self__, "autoclass", autoclass)
        if billing is not None:
            pulumi.set(__self__, "billing", billing)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if custom_placement_config is not None:
            pulumi.set(__self__, "custom_placement_config", custom_placement_config)
        if default_event_based_hold is not None:
            pulumi.set(__self__, "default_event_based_hold", default_event_based_hold)
        if default_object_acl is not None:
            pulumi.set(__self__, "default_object_acl", default_object_acl)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if iam_configuration is not None:
            pulumi.set(__self__, "iam_configuration", iam_configuration)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if lifecycle is not None:
            pulumi.set(__self__, "lifecycle", lifecycle)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if location_type is not None:
            pulumi.set(__self__, "location_type", location_type)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if metageneration is not None:
            pulumi.set(__self__, "metageneration", metageneration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if predefined_acl is not None:
            pulumi.set(__self__, "predefined_acl", predefined_acl)
        if predefined_default_object_acl is not None:
            pulumi.set(__self__, "predefined_default_object_acl", predefined_default_object_acl)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if project_number is not None:
            pulumi.set(__self__, "project_number", project_number)
        if projection is not None:
            pulumi.set(__self__, "projection", projection)
        if provisional_user_project is not None:
            pulumi.set(__self__, "provisional_user_project", provisional_user_project)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)
        if rpo is not None:
            pulumi.set(__self__, "rpo", rpo)
        if satisfies_pzs is not None:
            pulumi.set(__self__, "satisfies_pzs", satisfies_pzs)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if updated is not None:
            pulumi.set(__self__, "updated", updated)
        if user_project is not None:
            pulumi.set(__self__, "user_project", user_project)
        if versioning is not None:
            pulumi.set(__self__, "versioning", versioning)
        if website is not None:
            pulumi.set(__self__, "website", website)

    @property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketAccessControlArgs']]]]:
        """
        Access controls on the bucket.
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketAccessControlArgs']]]]):
        pulumi.set(self, "acl", value)

    @property
    @pulumi.getter
    def autoclass(self) -> Optional[pulumi.Input['BucketAutoclassArgs']]:
        """
        The bucket's Autoclass configuration.
        """
        return pulumi.get(self, "autoclass")

    @autoclass.setter
    def autoclass(self, value: Optional[pulumi.Input['BucketAutoclassArgs']]):
        pulumi.set(self, "autoclass", value)

    @property
    @pulumi.getter
    def billing(self) -> Optional[pulumi.Input['BucketBillingArgs']]:
        """
        The bucket's billing configuration.
        """
        return pulumi.get(self, "billing")

    @billing.setter
    def billing(self, value: Optional[pulumi.Input['BucketBillingArgs']]):
        pulumi.set(self, "billing", value)

    @property
    @pulumi.getter
    def cors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketCorsItemArgs']]]]:
        """
        The bucket's Cross-Origin Resource Sharing (CORS) configuration.
        """
        return pulumi.get(self, "cors")

    @cors.setter
    def cors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketCorsItemArgs']]]]):
        pulumi.set(self, "cors", value)

    @property
    @pulumi.getter(name="customPlacementConfig")
    def custom_placement_config(self) -> Optional[pulumi.Input['BucketCustomPlacementConfigArgs']]:
        """
        The bucket's custom placement configuration for Custom Dual Regions.
        """
        return pulumi.get(self, "custom_placement_config")

    @custom_placement_config.setter
    def custom_placement_config(self, value: Optional[pulumi.Input['BucketCustomPlacementConfigArgs']]):
        pulumi.set(self, "custom_placement_config", value)

    @property
    @pulumi.getter(name="defaultEventBasedHold")
    def default_event_based_hold(self) -> Optional[pulumi.Input[bool]]:
        """
        The default value for event-based hold on newly created objects in this bucket. Event-based hold is a way to retain objects indefinitely until an event occurs, signified by the hold's release. After being released, such objects will be subject to bucket-level retention (if any). One sample use case of this flag is for banks to hold loan documents for at least 3 years after loan is paid in full. Here, bucket-level retention is 3 years and the event is loan being paid in full. In this example, these objects will be held intact for any number of years until the event has occurred (event-based hold on the object is released) and then 3 more years after that. That means retention duration of the objects begins from the moment event-based hold transitioned from true to false. Objects under event-based hold cannot be deleted, overwritten or archived until the hold is removed.
        """
        return pulumi.get(self, "default_event_based_hold")

    @default_event_based_hold.setter
    def default_event_based_hold(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "default_event_based_hold", value)

    @property
    @pulumi.getter(name="defaultObjectAcl")
    def default_object_acl(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ObjectAccessControlArgs']]]]:
        """
        Default access controls to apply to new objects when no ACL is provided.
        """
        return pulumi.get(self, "default_object_acl")

    @default_object_acl.setter
    def default_object_acl(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectAccessControlArgs']]]]):
        pulumi.set(self, "default_object_acl", value)

    @property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input['BucketEncryptionArgs']]:
        """
        Encryption configuration for a bucket.
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input['BucketEncryptionArgs']]):
        pulumi.set(self, "encryption", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        HTTP 1.1 Entity tag for the bucket.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="iamConfiguration")
    def iam_configuration(self) -> Optional[pulumi.Input['BucketIamConfigurationArgs']]:
        """
        The bucket's IAM configuration.
        """
        return pulumi.get(self, "iam_configuration")

    @iam_configuration.setter
    def iam_configuration(self, value: Optional[pulumi.Input['BucketIamConfigurationArgs']]):
        pulumi.set(self, "iam_configuration", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the bucket. For buckets, the id and name properties are the same.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        The kind of item this is. For buckets, this is always storage#bucket.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        User-provided labels, in key/value pairs.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def lifecycle(self) -> Optional[pulumi.Input['BucketLifecycleArgs']]:
        """
        The bucket's lifecycle configuration. See lifecycle management for more information.
        """
        return pulumi.get(self, "lifecycle")

    @lifecycle.setter
    def lifecycle(self, value: Optional[pulumi.Input['BucketLifecycleArgs']]):
        pulumi.set(self, "lifecycle", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location of the bucket. Object data for objects in the bucket resides in physical storage within this region. Defaults to US. See the developer's guide for the authoritative list.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="locationType")
    def location_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the bucket location.
        """
        return pulumi.get(self, "location_type")

    @location_type.setter
    def location_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location_type", value)

    @property
    @pulumi.getter
    def logging(self) -> Optional[pulumi.Input['BucketLoggingArgs']]:
        """
        The bucket's logging configuration, which defines the destination bucket and optional name prefix for the current bucket's logs.
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input['BucketLoggingArgs']]):
        pulumi.set(self, "logging", value)

    @property
    @pulumi.getter
    def metageneration(self) -> Optional[pulumi.Input[str]]:
        """
        The metadata generation of this bucket.
        """
        return pulumi.get(self, "metageneration")

    @metageneration.setter
    def metageneration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metageneration", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input['BucketOwnerArgs']]:
        """
        The owner of the bucket. This is always the project team's owner group.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input['BucketOwnerArgs']]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter(name="predefinedAcl")
    def predefined_acl(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "predefined_acl")

    @predefined_acl.setter
    def predefined_acl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "predefined_acl", value)

    @property
    @pulumi.getter(name="predefinedDefaultObjectAcl")
    def predefined_default_object_acl(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "predefined_default_object_acl")

    @predefined_default_object_acl.setter
    def predefined_default_object_acl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "predefined_default_object_acl", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="projectNumber")
    def project_number(self) -> Optional[pulumi.Input[str]]:
        """
        The project number of the project the bucket belongs to.
        """
        return pulumi.get(self, "project_number")

    @project_number.setter
    def project_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_number", value)

    @property
    @pulumi.getter
    def projection(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "projection")

    @projection.setter
    def projection(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "projection", value)

    @property
    @pulumi.getter(name="provisionalUserProject")
    def provisional_user_project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "provisional_user_project")

    @provisional_user_project.setter
    def provisional_user_project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provisional_user_project", value)

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional[pulumi.Input['BucketRetentionPolicyArgs']]:
        """
        The bucket's retention policy. The retention policy enforces a minimum retention time for all objects contained in the bucket, based on their creation time. Any attempt to overwrite or delete objects younger than the retention period will result in a PERMISSION_DENIED error. An unlocked retention policy can be modified or removed from the bucket via a storage.buckets.update operation. A locked retention policy cannot be removed or shortened in duration for the lifetime of the bucket. Attempting to remove or decrease period of a locked retention policy will result in a PERMISSION_DENIED error.
        """
        return pulumi.get(self, "retention_policy")

    @retention_policy.setter
    def retention_policy(self, value: Optional[pulumi.Input['BucketRetentionPolicyArgs']]):
        pulumi.set(self, "retention_policy", value)

    @property
    @pulumi.getter
    def rpo(self) -> Optional[pulumi.Input[str]]:
        """
        The Recovery Point Objective (RPO) of this bucket. Set to ASYNC_TURBO to turn on Turbo Replication on a bucket.
        """
        return pulumi.get(self, "rpo")

    @rpo.setter
    def rpo(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rpo", value)

    @property
    @pulumi.getter(name="satisfiesPZS")
    def satisfies_pzs(self) -> Optional[pulumi.Input[bool]]:
        """
        Reserved for future use.
        """
        return pulumi.get(self, "satisfies_pzs")

    @satisfies_pzs.setter
    def satisfies_pzs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "satisfies_pzs", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of this bucket.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[pulumi.Input[str]]:
        """
        The bucket's default storage class, used whenever no storageClass is specified for a newly-created object. This defines how objects in the bucket are stored and determines the SLA and the cost of storage. Values include MULTI_REGIONAL, REGIONAL, STANDARD, NEARLINE, COLDLINE, ARCHIVE, and DURABLE_REDUCED_AVAILABILITY. If this value is not specified when the bucket is created, it will default to STANDARD. For more information, see storage classes.
        """
        return pulumi.get(self, "storage_class")

    @storage_class.setter
    def storage_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_class", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The creation time of the bucket in RFC 3339 format.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter
    def updated(self) -> Optional[pulumi.Input[str]]:
        """
        The modification time of the bucket in RFC 3339 format.
        """
        return pulumi.get(self, "updated")

    @updated.setter
    def updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated", value)

    @property
    @pulumi.getter(name="userProject")
    def user_project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "user_project")

    @user_project.setter
    def user_project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_project", value)

    @property
    @pulumi.getter
    def versioning(self) -> Optional[pulumi.Input['BucketVersioningArgs']]:
        """
        The bucket's versioning configuration.
        """
        return pulumi.get(self, "versioning")

    @versioning.setter
    def versioning(self, value: Optional[pulumi.Input['BucketVersioningArgs']]):
        pulumi.set(self, "versioning", value)

    @property
    @pulumi.getter
    def website(self) -> Optional[pulumi.Input['BucketWebsiteArgs']]:
        """
        The bucket's website configuration, controlling how the service behaves when accessing bucket contents as a web site. See the Static Website Examples for more information.
        """
        return pulumi.get(self, "website")

    @website.setter
    def website(self, value: Optional[pulumi.Input['BucketWebsiteArgs']]):
        pulumi.set(self, "website", value)


class Bucket(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketAccessControlArgs']]]]] = None,
                 autoclass: Optional[pulumi.Input[pulumi.InputType['BucketAutoclassArgs']]] = None,
                 billing: Optional[pulumi.Input[pulumi.InputType['BucketBillingArgs']]] = None,
                 cors: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketCorsItemArgs']]]]] = None,
                 custom_placement_config: Optional[pulumi.Input[pulumi.InputType['BucketCustomPlacementConfigArgs']]] = None,
                 default_event_based_hold: Optional[pulumi.Input[bool]] = None,
                 default_object_acl: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ObjectAccessControlArgs']]]]] = None,
                 encryption: Optional[pulumi.Input[pulumi.InputType['BucketEncryptionArgs']]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 iam_configuration: Optional[pulumi.Input[pulumi.InputType['BucketIamConfigurationArgs']]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 lifecycle: Optional[pulumi.Input[pulumi.InputType['BucketLifecycleArgs']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 location_type: Optional[pulumi.Input[str]] = None,
                 logging: Optional[pulumi.Input[pulumi.InputType['BucketLoggingArgs']]] = None,
                 metageneration: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 owner: Optional[pulumi.Input[pulumi.InputType['BucketOwnerArgs']]] = None,
                 predefined_acl: Optional[pulumi.Input[str]] = None,
                 predefined_default_object_acl: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 project_number: Optional[pulumi.Input[str]] = None,
                 projection: Optional[pulumi.Input[str]] = None,
                 provisional_user_project: Optional[pulumi.Input[str]] = None,
                 retention_policy: Optional[pulumi.Input[pulumi.InputType['BucketRetentionPolicyArgs']]] = None,
                 rpo: Optional[pulumi.Input[str]] = None,
                 satisfies_pzs: Optional[pulumi.Input[bool]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 storage_class: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 updated: Optional[pulumi.Input[str]] = None,
                 user_project: Optional[pulumi.Input[str]] = None,
                 versioning: Optional[pulumi.Input[pulumi.InputType['BucketVersioningArgs']]] = None,
                 website: Optional[pulumi.Input[pulumi.InputType['BucketWebsiteArgs']]] = None,
                 __props__=None):
        """
        Creates a new bucket.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketAccessControlArgs']]]] acl: Access controls on the bucket.
        :param pulumi.Input[pulumi.InputType['BucketAutoclassArgs']] autoclass: The bucket's Autoclass configuration.
        :param pulumi.Input[pulumi.InputType['BucketBillingArgs']] billing: The bucket's billing configuration.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketCorsItemArgs']]]] cors: The bucket's Cross-Origin Resource Sharing (CORS) configuration.
        :param pulumi.Input[pulumi.InputType['BucketCustomPlacementConfigArgs']] custom_placement_config: The bucket's custom placement configuration for Custom Dual Regions.
        :param pulumi.Input[bool] default_event_based_hold: The default value for event-based hold on newly created objects in this bucket. Event-based hold is a way to retain objects indefinitely until an event occurs, signified by the hold's release. After being released, such objects will be subject to bucket-level retention (if any). One sample use case of this flag is for banks to hold loan documents for at least 3 years after loan is paid in full. Here, bucket-level retention is 3 years and the event is loan being paid in full. In this example, these objects will be held intact for any number of years until the event has occurred (event-based hold on the object is released) and then 3 more years after that. That means retention duration of the objects begins from the moment event-based hold transitioned from true to false. Objects under event-based hold cannot be deleted, overwritten or archived until the hold is removed.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ObjectAccessControlArgs']]]] default_object_acl: Default access controls to apply to new objects when no ACL is provided.
        :param pulumi.Input[pulumi.InputType['BucketEncryptionArgs']] encryption: Encryption configuration for a bucket.
        :param pulumi.Input[str] etag: HTTP 1.1 Entity tag for the bucket.
        :param pulumi.Input[pulumi.InputType['BucketIamConfigurationArgs']] iam_configuration: The bucket's IAM configuration.
        :param pulumi.Input[str] id: The ID of the bucket. For buckets, the id and name properties are the same.
        :param pulumi.Input[str] kind: The kind of item this is. For buckets, this is always storage#bucket.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: User-provided labels, in key/value pairs.
        :param pulumi.Input[pulumi.InputType['BucketLifecycleArgs']] lifecycle: The bucket's lifecycle configuration. See lifecycle management for more information.
        :param pulumi.Input[str] location: The location of the bucket. Object data for objects in the bucket resides in physical storage within this region. Defaults to US. See the developer's guide for the authoritative list.
        :param pulumi.Input[str] location_type: The type of the bucket location.
        :param pulumi.Input[pulumi.InputType['BucketLoggingArgs']] logging: The bucket's logging configuration, which defines the destination bucket and optional name prefix for the current bucket's logs.
        :param pulumi.Input[str] metageneration: The metadata generation of this bucket.
        :param pulumi.Input[str] name: The name of the bucket.
        :param pulumi.Input[pulumi.InputType['BucketOwnerArgs']] owner: The owner of the bucket. This is always the project team's owner group.
        :param pulumi.Input[str] project_number: The project number of the project the bucket belongs to.
        :param pulumi.Input[pulumi.InputType['BucketRetentionPolicyArgs']] retention_policy: The bucket's retention policy. The retention policy enforces a minimum retention time for all objects contained in the bucket, based on their creation time. Any attempt to overwrite or delete objects younger than the retention period will result in a PERMISSION_DENIED error. An unlocked retention policy can be modified or removed from the bucket via a storage.buckets.update operation. A locked retention policy cannot be removed or shortened in duration for the lifetime of the bucket. Attempting to remove or decrease period of a locked retention policy will result in a PERMISSION_DENIED error.
        :param pulumi.Input[str] rpo: The Recovery Point Objective (RPO) of this bucket. Set to ASYNC_TURBO to turn on Turbo Replication on a bucket.
        :param pulumi.Input[bool] satisfies_pzs: Reserved for future use.
        :param pulumi.Input[str] self_link: The URI of this bucket.
        :param pulumi.Input[str] storage_class: The bucket's default storage class, used whenever no storageClass is specified for a newly-created object. This defines how objects in the bucket are stored and determines the SLA and the cost of storage. Values include MULTI_REGIONAL, REGIONAL, STANDARD, NEARLINE, COLDLINE, ARCHIVE, and DURABLE_REDUCED_AVAILABILITY. If this value is not specified when the bucket is created, it will default to STANDARD. For more information, see storage classes.
        :param pulumi.Input[str] time_created: The creation time of the bucket in RFC 3339 format.
        :param pulumi.Input[str] updated: The modification time of the bucket in RFC 3339 format.
        :param pulumi.Input[pulumi.InputType['BucketVersioningArgs']] versioning: The bucket's versioning configuration.
        :param pulumi.Input[pulumi.InputType['BucketWebsiteArgs']] website: The bucket's website configuration, controlling how the service behaves when accessing bucket contents as a web site. See the Static Website Examples for more information.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[BucketArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new bucket.

        :param str resource_name: The name of the resource.
        :param BucketArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BucketArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketAccessControlArgs']]]]] = None,
                 autoclass: Optional[pulumi.Input[pulumi.InputType['BucketAutoclassArgs']]] = None,
                 billing: Optional[pulumi.Input[pulumi.InputType['BucketBillingArgs']]] = None,
                 cors: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketCorsItemArgs']]]]] = None,
                 custom_placement_config: Optional[pulumi.Input[pulumi.InputType['BucketCustomPlacementConfigArgs']]] = None,
                 default_event_based_hold: Optional[pulumi.Input[bool]] = None,
                 default_object_acl: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ObjectAccessControlArgs']]]]] = None,
                 encryption: Optional[pulumi.Input[pulumi.InputType['BucketEncryptionArgs']]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 iam_configuration: Optional[pulumi.Input[pulumi.InputType['BucketIamConfigurationArgs']]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 lifecycle: Optional[pulumi.Input[pulumi.InputType['BucketLifecycleArgs']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 location_type: Optional[pulumi.Input[str]] = None,
                 logging: Optional[pulumi.Input[pulumi.InputType['BucketLoggingArgs']]] = None,
                 metageneration: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 owner: Optional[pulumi.Input[pulumi.InputType['BucketOwnerArgs']]] = None,
                 predefined_acl: Optional[pulumi.Input[str]] = None,
                 predefined_default_object_acl: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 project_number: Optional[pulumi.Input[str]] = None,
                 projection: Optional[pulumi.Input[str]] = None,
                 provisional_user_project: Optional[pulumi.Input[str]] = None,
                 retention_policy: Optional[pulumi.Input[pulumi.InputType['BucketRetentionPolicyArgs']]] = None,
                 rpo: Optional[pulumi.Input[str]] = None,
                 satisfies_pzs: Optional[pulumi.Input[bool]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 storage_class: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 updated: Optional[pulumi.Input[str]] = None,
                 user_project: Optional[pulumi.Input[str]] = None,
                 versioning: Optional[pulumi.Input[pulumi.InputType['BucketVersioningArgs']]] = None,
                 website: Optional[pulumi.Input[pulumi.InputType['BucketWebsiteArgs']]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BucketArgs.__new__(BucketArgs)

            __props__.__dict__["acl"] = acl
            __props__.__dict__["autoclass"] = autoclass
            __props__.__dict__["billing"] = billing
            __props__.__dict__["cors"] = cors
            __props__.__dict__["custom_placement_config"] = custom_placement_config
            __props__.__dict__["default_event_based_hold"] = default_event_based_hold
            __props__.__dict__["default_object_acl"] = default_object_acl
            __props__.__dict__["encryption"] = encryption
            __props__.__dict__["etag"] = etag
            __props__.__dict__["iam_configuration"] = iam_configuration
            __props__.__dict__["id"] = id
            __props__.__dict__["kind"] = kind
            __props__.__dict__["labels"] = labels
            __props__.__dict__["lifecycle"] = lifecycle
            __props__.__dict__["location"] = location
            __props__.__dict__["location_type"] = location_type
            __props__.__dict__["logging"] = logging
            __props__.__dict__["metageneration"] = metageneration
            __props__.__dict__["name"] = name
            __props__.__dict__["owner"] = owner
            __props__.__dict__["predefined_acl"] = predefined_acl
            __props__.__dict__["predefined_default_object_acl"] = predefined_default_object_acl
            __props__.__dict__["project"] = project
            __props__.__dict__["project_number"] = project_number
            __props__.__dict__["projection"] = projection
            __props__.__dict__["provisional_user_project"] = provisional_user_project
            __props__.__dict__["retention_policy"] = retention_policy
            __props__.__dict__["rpo"] = rpo
            __props__.__dict__["satisfies_pzs"] = satisfies_pzs
            __props__.__dict__["self_link"] = self_link
            __props__.__dict__["storage_class"] = storage_class
            __props__.__dict__["time_created"] = time_created
            __props__.__dict__["updated"] = updated
            __props__.__dict__["user_project"] = user_project
            __props__.__dict__["versioning"] = versioning
            __props__.__dict__["website"] = website
        super(Bucket, __self__).__init__(
            'google-native:storage/v1:Bucket',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Bucket':
        """
        Get an existing Bucket resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = BucketArgs.__new__(BucketArgs)

        __props__.__dict__["acl"] = None
        __props__.__dict__["autoclass"] = None
        __props__.__dict__["billing"] = None
        __props__.__dict__["cors"] = None
        __props__.__dict__["custom_placement_config"] = None
        __props__.__dict__["default_event_based_hold"] = None
        __props__.__dict__["default_object_acl"] = None
        __props__.__dict__["encryption"] = None
        __props__.__dict__["etag"] = None
        __props__.__dict__["iam_configuration"] = None
        __props__.__dict__["kind"] = None
        __props__.__dict__["labels"] = None
        __props__.__dict__["lifecycle"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["location_type"] = None
        __props__.__dict__["logging"] = None
        __props__.__dict__["metageneration"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["owner"] = None
        __props__.__dict__["project_number"] = None
        __props__.__dict__["retention_policy"] = None
        __props__.__dict__["rpo"] = None
        __props__.__dict__["satisfies_pzs"] = None
        __props__.__dict__["self_link"] = None
        __props__.__dict__["storage_class"] = None
        __props__.__dict__["time_created"] = None
        __props__.__dict__["updated"] = None
        __props__.__dict__["versioning"] = None
        __props__.__dict__["website"] = None
        return Bucket(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def acl(self) -> pulumi.Output[Sequence['outputs.BucketAccessControlResponse']]:
        """
        Access controls on the bucket.
        """
        return pulumi.get(self, "acl")

    @property
    @pulumi.getter
    def autoclass(self) -> pulumi.Output['outputs.BucketAutoclassResponse']:
        """
        The bucket's Autoclass configuration.
        """
        return pulumi.get(self, "autoclass")

    @property
    @pulumi.getter
    def billing(self) -> pulumi.Output['outputs.BucketBillingResponse']:
        """
        The bucket's billing configuration.
        """
        return pulumi.get(self, "billing")

    @property
    @pulumi.getter
    def cors(self) -> pulumi.Output[Sequence['outputs.BucketCorsItemResponse']]:
        """
        The bucket's Cross-Origin Resource Sharing (CORS) configuration.
        """
        return pulumi.get(self, "cors")

    @property
    @pulumi.getter(name="customPlacementConfig")
    def custom_placement_config(self) -> pulumi.Output['outputs.BucketCustomPlacementConfigResponse']:
        """
        The bucket's custom placement configuration for Custom Dual Regions.
        """
        return pulumi.get(self, "custom_placement_config")

    @property
    @pulumi.getter(name="defaultEventBasedHold")
    def default_event_based_hold(self) -> pulumi.Output[bool]:
        """
        The default value for event-based hold on newly created objects in this bucket. Event-based hold is a way to retain objects indefinitely until an event occurs, signified by the hold's release. After being released, such objects will be subject to bucket-level retention (if any). One sample use case of this flag is for banks to hold loan documents for at least 3 years after loan is paid in full. Here, bucket-level retention is 3 years and the event is loan being paid in full. In this example, these objects will be held intact for any number of years until the event has occurred (event-based hold on the object is released) and then 3 more years after that. That means retention duration of the objects begins from the moment event-based hold transitioned from true to false. Objects under event-based hold cannot be deleted, overwritten or archived until the hold is removed.
        """
        return pulumi.get(self, "default_event_based_hold")

    @property
    @pulumi.getter(name="defaultObjectAcl")
    def default_object_acl(self) -> pulumi.Output[Sequence['outputs.ObjectAccessControlResponse']]:
        """
        Default access controls to apply to new objects when no ACL is provided.
        """
        return pulumi.get(self, "default_object_acl")

    @property
    @pulumi.getter
    def encryption(self) -> pulumi.Output['outputs.BucketEncryptionResponse']:
        """
        Encryption configuration for a bucket.
        """
        return pulumi.get(self, "encryption")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        HTTP 1.1 Entity tag for the bucket.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="iamConfiguration")
    def iam_configuration(self) -> pulumi.Output['outputs.BucketIamConfigurationResponse']:
        """
        The bucket's IAM configuration.
        """
        return pulumi.get(self, "iam_configuration")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[str]:
        """
        The kind of item this is. For buckets, this is always storage#bucket.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        User-provided labels, in key/value pairs.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def lifecycle(self) -> pulumi.Output['outputs.BucketLifecycleResponse']:
        """
        The bucket's lifecycle configuration. See lifecycle management for more information.
        """
        return pulumi.get(self, "lifecycle")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The location of the bucket. Object data for objects in the bucket resides in physical storage within this region. Defaults to US. See the developer's guide for the authoritative list.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="locationType")
    def location_type(self) -> pulumi.Output[str]:
        """
        The type of the bucket location.
        """
        return pulumi.get(self, "location_type")

    @property
    @pulumi.getter
    def logging(self) -> pulumi.Output['outputs.BucketLoggingResponse']:
        """
        The bucket's logging configuration, which defines the destination bucket and optional name prefix for the current bucket's logs.
        """
        return pulumi.get(self, "logging")

    @property
    @pulumi.getter
    def metageneration(self) -> pulumi.Output[str]:
        """
        The metadata generation of this bucket.
        """
        return pulumi.get(self, "metageneration")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def owner(self) -> pulumi.Output['outputs.BucketOwnerResponse']:
        """
        The owner of the bucket. This is always the project team's owner group.
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter(name="projectNumber")
    def project_number(self) -> pulumi.Output[str]:
        """
        The project number of the project the bucket belongs to.
        """
        return pulumi.get(self, "project_number")

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> pulumi.Output['outputs.BucketRetentionPolicyResponse']:
        """
        The bucket's retention policy. The retention policy enforces a minimum retention time for all objects contained in the bucket, based on their creation time. Any attempt to overwrite or delete objects younger than the retention period will result in a PERMISSION_DENIED error. An unlocked retention policy can be modified or removed from the bucket via a storage.buckets.update operation. A locked retention policy cannot be removed or shortened in duration for the lifetime of the bucket. Attempting to remove or decrease period of a locked retention policy will result in a PERMISSION_DENIED error.
        """
        return pulumi.get(self, "retention_policy")

    @property
    @pulumi.getter
    def rpo(self) -> pulumi.Output[str]:
        """
        The Recovery Point Objective (RPO) of this bucket. Set to ASYNC_TURBO to turn on Turbo Replication on a bucket.
        """
        return pulumi.get(self, "rpo")

    @property
    @pulumi.getter(name="satisfiesPZS")
    def satisfies_pzs(self) -> pulumi.Output[bool]:
        """
        Reserved for future use.
        """
        return pulumi.get(self, "satisfies_pzs")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        The URI of this bucket.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> pulumi.Output[str]:
        """
        The bucket's default storage class, used whenever no storageClass is specified for a newly-created object. This defines how objects in the bucket are stored and determines the SLA and the cost of storage. Values include MULTI_REGIONAL, REGIONAL, STANDARD, NEARLINE, COLDLINE, ARCHIVE, and DURABLE_REDUCED_AVAILABILITY. If this value is not specified when the bucket is created, it will default to STANDARD. For more information, see storage classes.
        """
        return pulumi.get(self, "storage_class")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The creation time of the bucket in RFC 3339 format.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def updated(self) -> pulumi.Output[str]:
        """
        The modification time of the bucket in RFC 3339 format.
        """
        return pulumi.get(self, "updated")

    @property
    @pulumi.getter
    def versioning(self) -> pulumi.Output['outputs.BucketVersioningResponse']:
        """
        The bucket's versioning configuration.
        """
        return pulumi.get(self, "versioning")

    @property
    @pulumi.getter
    def website(self) -> pulumi.Output['outputs.BucketWebsiteResponse']:
        """
        The bucket's website configuration, controlling how the service behaves when accessing bucket contents as a web site. See the Static Website Examples for more information.
        """
        return pulumi.get(self, "website")

