# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetSubscriptionResult',
    'AwaitableGetSubscriptionResult',
    'get_subscription',
    'get_subscription_output',
]

@pulumi.output_type
class GetSubscriptionResult:
    def __init__(__self__, delivery_config=None, name=None, topic=None):
        if delivery_config and not isinstance(delivery_config, dict):
            raise TypeError("Expected argument 'delivery_config' to be a dict")
        pulumi.set(__self__, "delivery_config", delivery_config)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if topic and not isinstance(topic, str):
            raise TypeError("Expected argument 'topic' to be a str")
        pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter(name="deliveryConfig")
    def delivery_config(self) -> 'outputs.DeliveryConfigResponse':
        """
        The settings for this subscription's message delivery.
        """
        return pulumi.get(self, "delivery_config")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the subscription. Structured like: projects/{project_number}/locations/{location}/subscriptions/{subscription_id}
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def topic(self) -> str:
        """
        The name of the topic this subscription is attached to. Structured like: projects/{project_number}/locations/{location}/topics/{topic_id}
        """
        return pulumi.get(self, "topic")


class AwaitableGetSubscriptionResult(GetSubscriptionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubscriptionResult(
            delivery_config=self.delivery_config,
            name=self.name,
            topic=self.topic)


def get_subscription(location: Optional[str] = None,
                     project: Optional[str] = None,
                     subscription_id: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubscriptionResult:
    """
    Returns the subscription configuration.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['subscriptionId'] = subscription_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:pubsublite/v1:getSubscription', __args__, opts=opts, typ=GetSubscriptionResult).value

    return AwaitableGetSubscriptionResult(
        delivery_config=__ret__.delivery_config,
        name=__ret__.name,
        topic=__ret__.topic)


@_utilities.lift_output_func(get_subscription)
def get_subscription_output(location: Optional[pulumi.Input[str]] = None,
                            project: Optional[pulumi.Input[Optional[str]]] = None,
                            subscription_id: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSubscriptionResult]:
    """
    Returns the subscription configuration.
    """
    ...
