# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AptSettingsResponse',
    'ExecStepConfigResponse',
    'ExecStepResponse',
    'FixedOrPercentResponse',
    'GcsObjectResponse',
    'GooSettingsResponse',
    'MonthlyScheduleResponse',
    'OSPolicyAssignmentInstanceFilterInventoryResponse',
    'OSPolicyAssignmentInstanceFilterResponse',
    'OSPolicyAssignmentLabelSetResponse',
    'OSPolicyAssignmentRolloutResponse',
    'OSPolicyInventoryFilterResponse',
    'OSPolicyResourceExecResourceExecResponse',
    'OSPolicyResourceExecResourceResponse',
    'OSPolicyResourceFileGcsResponse',
    'OSPolicyResourceFileRemoteResponse',
    'OSPolicyResourceFileResourceResponse',
    'OSPolicyResourceFileResponse',
    'OSPolicyResourceGroupResponse',
    'OSPolicyResourcePackageResourceAPTResponse',
    'OSPolicyResourcePackageResourceDebResponse',
    'OSPolicyResourcePackageResourceGooGetResponse',
    'OSPolicyResourcePackageResourceMSIResponse',
    'OSPolicyResourcePackageResourceRPMResponse',
    'OSPolicyResourcePackageResourceResponse',
    'OSPolicyResourcePackageResourceYUMResponse',
    'OSPolicyResourcePackageResourceZypperResponse',
    'OSPolicyResourceRepositoryResourceAptRepositoryResponse',
    'OSPolicyResourceRepositoryResourceGooRepositoryResponse',
    'OSPolicyResourceRepositoryResourceResponse',
    'OSPolicyResourceRepositoryResourceYumRepositoryResponse',
    'OSPolicyResourceRepositoryResourceZypperRepositoryResponse',
    'OSPolicyResourceResponse',
    'OSPolicyResponse',
    'OneTimeScheduleResponse',
    'PatchConfigResponse',
    'PatchInstanceFilterGroupLabelResponse',
    'PatchInstanceFilterResponse',
    'PatchRolloutResponse',
    'RecurringScheduleResponse',
    'TimeOfDayResponse',
    'TimeZoneResponse',
    'WeekDayOfMonthResponse',
    'WeeklyScheduleResponse',
    'WindowsUpdateSettingsResponse',
    'YumSettingsResponse',
    'ZypperSettingsResponse',
]

@pulumi.output_type
class AptSettingsResponse(dict):
    """
    Apt patching is completed by executing `apt-get update && apt-get upgrade`. Additional options can be set to control how this is executed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exclusivePackages":
            suggest = "exclusive_packages"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AptSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AptSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AptSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 excludes: Sequence[str],
                 exclusive_packages: Sequence[str],
                 type: str):
        """
        Apt patching is completed by executing `apt-get update && apt-get upgrade`. Additional options can be set to control how this is executed.
        :param Sequence[str] excludes: List of packages to exclude from update. These packages will be excluded
        :param Sequence[str] exclusive_packages: An exclusive list of packages to be updated. These are the only packages that will be updated. If these packages are not installed, they will be ignored. This field cannot be specified with any other patch configuration fields.
        :param str type: By changing the type to DIST, the patching is performed using `apt-get dist-upgrade` instead.
        """
        pulumi.set(__self__, "excludes", excludes)
        pulumi.set(__self__, "exclusive_packages", exclusive_packages)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def excludes(self) -> Sequence[str]:
        """
        List of packages to exclude from update. These packages will be excluded
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter(name="exclusivePackages")
    def exclusive_packages(self) -> Sequence[str]:
        """
        An exclusive list of packages to be updated. These are the only packages that will be updated. If these packages are not installed, they will be ignored. This field cannot be specified with any other patch configuration fields.
        """
        return pulumi.get(self, "exclusive_packages")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        By changing the type to DIST, the patching is performed using `apt-get dist-upgrade` instead.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ExecStepConfigResponse(dict):
    """
    Common configurations for an ExecStep.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedSuccessCodes":
            suggest = "allowed_success_codes"
        elif key == "gcsObject":
            suggest = "gcs_object"
        elif key == "localPath":
            suggest = "local_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExecStepConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExecStepConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExecStepConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_success_codes: Sequence[int],
                 gcs_object: 'outputs.GcsObjectResponse',
                 interpreter: str,
                 local_path: str):
        """
        Common configurations for an ExecStep.
        :param Sequence[int] allowed_success_codes: Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
        :param 'GcsObjectResponse' gcs_object: A Cloud Storage object containing the executable.
        :param str interpreter: The script interpreter to use to run the script. If no interpreter is specified the script will be executed directly, which will likely only succeed for scripts with [shebang lines] (https://en.wikipedia.org/wiki/Shebang_\(Unix\)).
        :param str local_path: An absolute path to the executable on the VM.
        """
        pulumi.set(__self__, "allowed_success_codes", allowed_success_codes)
        pulumi.set(__self__, "gcs_object", gcs_object)
        pulumi.set(__self__, "interpreter", interpreter)
        pulumi.set(__self__, "local_path", local_path)

    @property
    @pulumi.getter(name="allowedSuccessCodes")
    def allowed_success_codes(self) -> Sequence[int]:
        """
        Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
        """
        return pulumi.get(self, "allowed_success_codes")

    @property
    @pulumi.getter(name="gcsObject")
    def gcs_object(self) -> 'outputs.GcsObjectResponse':
        """
        A Cloud Storage object containing the executable.
        """
        return pulumi.get(self, "gcs_object")

    @property
    @pulumi.getter
    def interpreter(self) -> str:
        """
        The script interpreter to use to run the script. If no interpreter is specified the script will be executed directly, which will likely only succeed for scripts with [shebang lines] (https://en.wikipedia.org/wiki/Shebang_\(Unix\)).
        """
        return pulumi.get(self, "interpreter")

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> str:
        """
        An absolute path to the executable on the VM.
        """
        return pulumi.get(self, "local_path")


@pulumi.output_type
class ExecStepResponse(dict):
    """
    A step that runs an executable for a PatchJob.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linuxExecStepConfig":
            suggest = "linux_exec_step_config"
        elif key == "windowsExecStepConfig":
            suggest = "windows_exec_step_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExecStepResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExecStepResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExecStepResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linux_exec_step_config: 'outputs.ExecStepConfigResponse',
                 windows_exec_step_config: 'outputs.ExecStepConfigResponse'):
        """
        A step that runs an executable for a PatchJob.
        :param 'ExecStepConfigResponse' linux_exec_step_config: The ExecStepConfig for all Linux VMs targeted by the PatchJob.
        :param 'ExecStepConfigResponse' windows_exec_step_config: The ExecStepConfig for all Windows VMs targeted by the PatchJob.
        """
        pulumi.set(__self__, "linux_exec_step_config", linux_exec_step_config)
        pulumi.set(__self__, "windows_exec_step_config", windows_exec_step_config)

    @property
    @pulumi.getter(name="linuxExecStepConfig")
    def linux_exec_step_config(self) -> 'outputs.ExecStepConfigResponse':
        """
        The ExecStepConfig for all Linux VMs targeted by the PatchJob.
        """
        return pulumi.get(self, "linux_exec_step_config")

    @property
    @pulumi.getter(name="windowsExecStepConfig")
    def windows_exec_step_config(self) -> 'outputs.ExecStepConfigResponse':
        """
        The ExecStepConfig for all Windows VMs targeted by the PatchJob.
        """
        return pulumi.get(self, "windows_exec_step_config")


@pulumi.output_type
class FixedOrPercentResponse(dict):
    """
    Message encapsulating a value that can be either absolute ("fixed") or relative ("percent") to a value.
    """
    def __init__(__self__, *,
                 fixed: int,
                 percent: int):
        """
        Message encapsulating a value that can be either absolute ("fixed") or relative ("percent") to a value.
        :param int fixed: Specifies a fixed value.
        :param int percent: Specifies the relative value defined as a percentage, which will be multiplied by a reference value.
        """
        pulumi.set(__self__, "fixed", fixed)
        pulumi.set(__self__, "percent", percent)

    @property
    @pulumi.getter
    def fixed(self) -> int:
        """
        Specifies a fixed value.
        """
        return pulumi.get(self, "fixed")

    @property
    @pulumi.getter
    def percent(self) -> int:
        """
        Specifies the relative value defined as a percentage, which will be multiplied by a reference value.
        """
        return pulumi.get(self, "percent")


@pulumi.output_type
class GcsObjectResponse(dict):
    """
    Cloud Storage object representation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "generationNumber":
            suggest = "generation_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GcsObjectResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GcsObjectResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GcsObjectResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 generation_number: str,
                 object: str):
        """
        Cloud Storage object representation.
        :param str bucket: Bucket of the Cloud Storage object.
        :param str generation_number: Generation number of the Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.
        :param str object: Name of the Cloud Storage object.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "generation_number", generation_number)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Bucket of the Cloud Storage object.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="generationNumber")
    def generation_number(self) -> str:
        """
        Generation number of the Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.
        """
        return pulumi.get(self, "generation_number")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Name of the Cloud Storage object.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GooSettingsResponse(dict):
    """
    Googet patching is performed by running `googet update`.
    """
    def __init__(__self__):
        """
        Googet patching is performed by running `googet update`.
        """
        pass


@pulumi.output_type
class MonthlyScheduleResponse(dict):
    """
    Represents a monthly schedule. An example of a valid monthly schedule is "on the third Tuesday of the month" or "on the 15th of the month".
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "monthDay":
            suggest = "month_day"
        elif key == "weekDayOfMonth":
            suggest = "week_day_of_month"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonthlyScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonthlyScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonthlyScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 month_day: int,
                 week_day_of_month: 'outputs.WeekDayOfMonthResponse'):
        """
        Represents a monthly schedule. An example of a valid monthly schedule is "on the third Tuesday of the month" or "on the 15th of the month".
        :param int month_day: One day of the month. 1-31 indicates the 1st to the 31st day. -1 indicates the last day of the month. Months without the target day will be skipped. For example, a schedule to run "every month on the 31st" will not run in February, April, June, etc.
        :param 'WeekDayOfMonthResponse' week_day_of_month: Week day in a month.
        """
        pulumi.set(__self__, "month_day", month_day)
        pulumi.set(__self__, "week_day_of_month", week_day_of_month)

    @property
    @pulumi.getter(name="monthDay")
    def month_day(self) -> int:
        """
        One day of the month. 1-31 indicates the 1st to the 31st day. -1 indicates the last day of the month. Months without the target day will be skipped. For example, a schedule to run "every month on the 31st" will not run in February, April, June, etc.
        """
        return pulumi.get(self, "month_day")

    @property
    @pulumi.getter(name="weekDayOfMonth")
    def week_day_of_month(self) -> 'outputs.WeekDayOfMonthResponse':
        """
        Week day in a month.
        """
        return pulumi.get(self, "week_day_of_month")


@pulumi.output_type
class OSPolicyAssignmentInstanceFilterInventoryResponse(dict):
    """
    VM inventory details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osShortName":
            suggest = "os_short_name"
        elif key == "osVersion":
            suggest = "os_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSPolicyAssignmentInstanceFilterInventoryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSPolicyAssignmentInstanceFilterInventoryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSPolicyAssignmentInstanceFilterInventoryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 os_short_name: str,
                 os_version: str):
        """
        VM inventory details.
        :param str os_short_name: The OS short name
        :param str os_version: The OS version Prefix matches are supported if asterisk(*) is provided as the last character. For example, to match all versions with a major version of `7`, specify the following value for this field `7.*` An empty string matches all OS versions.
        """
        pulumi.set(__self__, "os_short_name", os_short_name)
        pulumi.set(__self__, "os_version", os_version)

    @property
    @pulumi.getter(name="osShortName")
    def os_short_name(self) -> str:
        """
        The OS short name
        """
        return pulumi.get(self, "os_short_name")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> str:
        """
        The OS version Prefix matches are supported if asterisk(*) is provided as the last character. For example, to match all versions with a major version of `7`, specify the following value for this field `7.*` An empty string matches all OS versions.
        """
        return pulumi.get(self, "os_version")


@pulumi.output_type
class OSPolicyAssignmentInstanceFilterResponse(dict):
    """
    Filters to select target VMs for an assignment. If more than one filter criteria is specified below, a VM will be selected if and only if it satisfies all of them.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exclusionLabels":
            suggest = "exclusion_labels"
        elif key == "inclusionLabels":
            suggest = "inclusion_labels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSPolicyAssignmentInstanceFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSPolicyAssignmentInstanceFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSPolicyAssignmentInstanceFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all: bool,
                 exclusion_labels: Sequence['outputs.OSPolicyAssignmentLabelSetResponse'],
                 inclusion_labels: Sequence['outputs.OSPolicyAssignmentLabelSetResponse'],
                 inventories: Sequence['outputs.OSPolicyAssignmentInstanceFilterInventoryResponse']):
        """
        Filters to select target VMs for an assignment. If more than one filter criteria is specified below, a VM will be selected if and only if it satisfies all of them.
        :param bool all: Target all VMs in the project. If true, no other criteria is permitted.
        :param Sequence['OSPolicyAssignmentLabelSetResponse'] exclusion_labels: List of label sets used for VM exclusion. If the list has more than one label set, the VM is excluded if any of the label sets are applicable for the VM.
        :param Sequence['OSPolicyAssignmentLabelSetResponse'] inclusion_labels: List of label sets used for VM inclusion. If the list has more than one `LabelSet`, the VM is included if any of the label sets are applicable for the VM.
        :param Sequence['OSPolicyAssignmentInstanceFilterInventoryResponse'] inventories: List of inventories to select VMs. A VM is selected if its inventory data matches at least one of the following inventories.
        """
        pulumi.set(__self__, "all", all)
        pulumi.set(__self__, "exclusion_labels", exclusion_labels)
        pulumi.set(__self__, "inclusion_labels", inclusion_labels)
        pulumi.set(__self__, "inventories", inventories)

    @property
    @pulumi.getter
    def all(self) -> bool:
        """
        Target all VMs in the project. If true, no other criteria is permitted.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter(name="exclusionLabels")
    def exclusion_labels(self) -> Sequence['outputs.OSPolicyAssignmentLabelSetResponse']:
        """
        List of label sets used for VM exclusion. If the list has more than one label set, the VM is excluded if any of the label sets are applicable for the VM.
        """
        return pulumi.get(self, "exclusion_labels")

    @property
    @pulumi.getter(name="inclusionLabels")
    def inclusion_labels(self) -> Sequence['outputs.OSPolicyAssignmentLabelSetResponse']:
        """
        List of label sets used for VM inclusion. If the list has more than one `LabelSet`, the VM is included if any of the label sets are applicable for the VM.
        """
        return pulumi.get(self, "inclusion_labels")

    @property
    @pulumi.getter
    def inventories(self) -> Sequence['outputs.OSPolicyAssignmentInstanceFilterInventoryResponse']:
        """
        List of inventories to select VMs. A VM is selected if its inventory data matches at least one of the following inventories.
        """
        return pulumi.get(self, "inventories")


@pulumi.output_type
class OSPolicyAssignmentLabelSetResponse(dict):
    """
    Message representing label set. * A label is a key value pair set for a VM. * A LabelSet is a set of labels. * Labels within a LabelSet are ANDed. In other words, a LabelSet is applicable for a VM only if it matches all the labels in the LabelSet. * Example: A LabelSet with 2 labels: `env=prod` and `type=webserver` will only be applicable for those VMs with both labels present.
    """
    def __init__(__self__, *,
                 labels: Mapping[str, str]):
        """
        Message representing label set. * A label is a key value pair set for a VM. * A LabelSet is a set of labels. * Labels within a LabelSet are ANDed. In other words, a LabelSet is applicable for a VM only if it matches all the labels in the LabelSet. * Example: A LabelSet with 2 labels: `env=prod` and `type=webserver` will only be applicable for those VMs with both labels present.
        :param Mapping[str, str] labels: Labels are identified by key/value pairs in this map. A VM should contain all the key/value pairs specified in this map to be selected.
        """
        pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Labels are identified by key/value pairs in this map. A VM should contain all the key/value pairs specified in this map to be selected.
        """
        return pulumi.get(self, "labels")


@pulumi.output_type
class OSPolicyAssignmentRolloutResponse(dict):
    """
    Message to configure the rollout at the zonal level for the OS policy assignment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disruptionBudget":
            suggest = "disruption_budget"
        elif key == "minWaitDuration":
            suggest = "min_wait_duration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSPolicyAssignmentRolloutResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSPolicyAssignmentRolloutResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSPolicyAssignmentRolloutResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disruption_budget: 'outputs.FixedOrPercentResponse',
                 min_wait_duration: str):
        """
        Message to configure the rollout at the zonal level for the OS policy assignment.
        :param 'FixedOrPercentResponse' disruption_budget: The maximum number (or percentage) of VMs per zone to disrupt at any given moment.
        :param str min_wait_duration: This determines the minimum duration of time to wait after the configuration changes are applied through the current rollout. A VM continues to count towards the `disruption_budget` at least until this duration of time has passed after configuration changes are applied.
        """
        pulumi.set(__self__, "disruption_budget", disruption_budget)
        pulumi.set(__self__, "min_wait_duration", min_wait_duration)

    @property
    @pulumi.getter(name="disruptionBudget")
    def disruption_budget(self) -> 'outputs.FixedOrPercentResponse':
        """
        The maximum number (or percentage) of VMs per zone to disrupt at any given moment.
        """
        return pulumi.get(self, "disruption_budget")

    @property
    @pulumi.getter(name="minWaitDuration")
    def min_wait_duration(self) -> str:
        """
        This determines the minimum duration of time to wait after the configuration changes are applied through the current rollout. A VM continues to count towards the `disruption_budget` at least until this duration of time has passed after configuration changes are applied.
        """
        return pulumi.get(self, "min_wait_duration")


@pulumi.output_type
class OSPolicyInventoryFilterResponse(dict):
    """
    Filtering criteria to select VMs based on inventory details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osShortName":
            suggest = "os_short_name"
        elif key == "osVersion":
            suggest = "os_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSPolicyInventoryFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSPolicyInventoryFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSPolicyInventoryFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 os_short_name: str,
                 os_version: str):
        """
        Filtering criteria to select VMs based on inventory details.
        :param str os_short_name: The OS short name
        :param str os_version: The OS version Prefix matches are supported if asterisk(*) is provided as the last character. For example, to match all versions with a major version of `7`, specify the following value for this field `7.*` An empty string matches all OS versions.
        """
        pulumi.set(__self__, "os_short_name", os_short_name)
        pulumi.set(__self__, "os_version", os_version)

    @property
    @pulumi.getter(name="osShortName")
    def os_short_name(self) -> str:
        """
        The OS short name
        """
        return pulumi.get(self, "os_short_name")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> str:
        """
        The OS version Prefix matches are supported if asterisk(*) is provided as the last character. For example, to match all versions with a major version of `7`, specify the following value for this field `7.*` An empty string matches all OS versions.
        """
        return pulumi.get(self, "os_version")


@pulumi.output_type
class OSPolicyResourceExecResourceExecResponse(dict):
    """
    A file or script to execute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "outputFilePath":
            suggest = "output_file_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSPolicyResourceExecResourceExecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSPolicyResourceExecResourceExecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSPolicyResourceExecResourceExecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 args: Sequence[str],
                 file: 'outputs.OSPolicyResourceFileResponse',
                 interpreter: str,
                 output_file_path: str,
                 script: str):
        """
        A file or script to execute.
        :param Sequence[str] args: Optional arguments to pass to the source during execution.
        :param 'OSPolicyResourceFileResponse' file: A remote or local file.
        :param str interpreter: The script interpreter to use.
        :param str output_file_path: Only recorded for enforce Exec. Path to an output file (that is created by this Exec) whose content will be recorded in OSPolicyResourceCompliance after a successful run. Absence or failure to read this file will result in this ExecResource being non-compliant. Output file size is limited to 100K bytes.
        :param str script: An inline script. The size of the script is limited to 1024 characters.
        """
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "file", file)
        pulumi.set(__self__, "interpreter", interpreter)
        pulumi.set(__self__, "output_file_path", output_file_path)
        pulumi.set(__self__, "script", script)

    @property
    @pulumi.getter
    def args(self) -> Sequence[str]:
        """
        Optional arguments to pass to the source during execution.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def file(self) -> 'outputs.OSPolicyResourceFileResponse':
        """
        A remote or local file.
        """
        return pulumi.get(self, "file")

    @property
    @pulumi.getter
    def interpreter(self) -> str:
        """
        The script interpreter to use.
        """
        return pulumi.get(self, "interpreter")

    @property
    @pulumi.getter(name="outputFilePath")
    def output_file_path(self) -> str:
        """
        Only recorded for enforce Exec. Path to an output file (that is created by this Exec) whose content will be recorded in OSPolicyResourceCompliance after a successful run. Absence or failure to read this file will result in this ExecResource being non-compliant. Output file size is limited to 100K bytes.
        """
        return pulumi.get(self, "output_file_path")

    @property
    @pulumi.getter
    def script(self) -> str:
        """
        An inline script. The size of the script is limited to 1024 characters.
        """
        return pulumi.get(self, "script")


@pulumi.output_type
class OSPolicyResourceExecResourceResponse(dict):
    """
    A resource that allows executing scripts on the VM. The `ExecResource` has 2 stages: `validate` and `enforce` and both stages accept a script as an argument to execute. When the `ExecResource` is applied by the agent, it first executes the script in the `validate` stage. The `validate` stage can signal that the `ExecResource` is already in the desired state by returning an exit code of `100`. If the `ExecResource` is not in the desired state, it should return an exit code of `101`. Any other exit code returned by this stage is considered an error. If the `ExecResource` is not in the desired state based on the exit code from the `validate` stage, the agent proceeds to execute the script from the `enforce` stage. If the `ExecResource` is already in the desired state, the `enforce` stage will not be run. Similar to `validate` stage, the `enforce` stage should return an exit code of `100` to indicate that the resource in now in its desired state. Any other exit code is considered an error. NOTE: An exit code of `100` was chosen over `0` (and `101` vs `1`) to have an explicit indicator of `in desired state`, `not in desired state` and errors. Because, for example, Powershell will always return an exit code of `0` unless an `exit` statement is provided in the script. So, for reasons of consistency and being explicit, exit codes `100` and `101` were chosen.
    """
    def __init__(__self__, *,
                 enforce: 'outputs.OSPolicyResourceExecResourceExecResponse',
                 validate: 'outputs.OSPolicyResourceExecResourceExecResponse'):
        """
        A resource that allows executing scripts on the VM. The `ExecResource` has 2 stages: `validate` and `enforce` and both stages accept a script as an argument to execute. When the `ExecResource` is applied by the agent, it first executes the script in the `validate` stage. The `validate` stage can signal that the `ExecResource` is already in the desired state by returning an exit code of `100`. If the `ExecResource` is not in the desired state, it should return an exit code of `101`. Any other exit code returned by this stage is considered an error. If the `ExecResource` is not in the desired state based on the exit code from the `validate` stage, the agent proceeds to execute the script from the `enforce` stage. If the `ExecResource` is already in the desired state, the `enforce` stage will not be run. Similar to `validate` stage, the `enforce` stage should return an exit code of `100` to indicate that the resource in now in its desired state. Any other exit code is considered an error. NOTE: An exit code of `100` was chosen over `0` (and `101` vs `1`) to have an explicit indicator of `in desired state`, `not in desired state` and errors. Because, for example, Powershell will always return an exit code of `0` unless an `exit` statement is provided in the script. So, for reasons of consistency and being explicit, exit codes `100` and `101` were chosen.
        :param 'OSPolicyResourceExecResourceExecResponse' enforce: What to run to bring this resource into the desired state. An exit code of 100 indicates "success", any other exit code indicates a failure running enforce.
        :param 'OSPolicyResourceExecResourceExecResponse' validate: What to run to validate this resource is in the desired state. An exit code of 100 indicates "in desired state", and exit code of 101 indicates "not in desired state". Any other exit code indicates a failure running validate.
        """
        pulumi.set(__self__, "enforce", enforce)
        pulumi.set(__self__, "validate", validate)

    @property
    @pulumi.getter
    def enforce(self) -> 'outputs.OSPolicyResourceExecResourceExecResponse':
        """
        What to run to bring this resource into the desired state. An exit code of 100 indicates "success", any other exit code indicates a failure running enforce.
        """
        return pulumi.get(self, "enforce")

    @property
    @pulumi.getter
    def validate(self) -> 'outputs.OSPolicyResourceExecResourceExecResponse':
        """
        What to run to validate this resource is in the desired state. An exit code of 100 indicates "in desired state", and exit code of 101 indicates "not in desired state". Any other exit code indicates a failure running validate.
        """
        return pulumi.get(self, "validate")


@pulumi.output_type
class OSPolicyResourceFileGcsResponse(dict):
    """
    Specifies a file available as a Cloud Storage Object.
    """
    def __init__(__self__, *,
                 bucket: str,
                 generation: str,
                 object: str):
        """
        Specifies a file available as a Cloud Storage Object.
        :param str bucket: Bucket of the Cloud Storage object.
        :param str generation: Generation number of the Cloud Storage object.
        :param str object: Name of the Cloud Storage object.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "generation", generation)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Bucket of the Cloud Storage object.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def generation(self) -> str:
        """
        Generation number of the Cloud Storage object.
        """
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Name of the Cloud Storage object.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class OSPolicyResourceFileRemoteResponse(dict):
    """
    Specifies a file available via some URI.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sha256Checksum":
            suggest = "sha256_checksum"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSPolicyResourceFileRemoteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSPolicyResourceFileRemoteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSPolicyResourceFileRemoteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sha256_checksum: str,
                 uri: str):
        """
        Specifies a file available via some URI.
        :param str sha256_checksum: SHA256 checksum of the remote file.
        :param str uri: URI from which to fetch the object. It should contain both the protocol and path following the format `{protocol}://{location}`.
        """
        pulumi.set(__self__, "sha256_checksum", sha256_checksum)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="sha256Checksum")
    def sha256_checksum(self) -> str:
        """
        SHA256 checksum of the remote file.
        """
        return pulumi.get(self, "sha256_checksum")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        URI from which to fetch the object. It should contain both the protocol and path following the format `{protocol}://{location}`.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class OSPolicyResourceFileResourceResponse(dict):
    """
    A resource that manages the state of a file.
    """
    def __init__(__self__, *,
                 content: str,
                 file: 'outputs.OSPolicyResourceFileResponse',
                 path: str,
                 permissions: str,
                 state: str):
        """
        A resource that manages the state of a file.
        :param str content: A a file with this content. The size of the content is limited to 1024 characters.
        :param 'OSPolicyResourceFileResponse' file: A remote or local source.
        :param str path: The absolute path of the file within the VM.
        :param str permissions: Consists of three octal digits which represent, in order, the permissions of the owner, group, and other users for the file (similarly to the numeric mode used in the linux chmod utility). Each digit represents a three bit number with the 4 bit corresponding to the read permissions, the 2 bit corresponds to the write bit, and the one bit corresponds to the execute permission. Default behavior is 755. Below are some examples of permissions and their associated values: read, write, and execute: 7 read and execute: 5 read and write: 6 read only: 4
        :param str state: Desired state of the file.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "file", file)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        A a file with this content. The size of the content is limited to 1024 characters.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def file(self) -> 'outputs.OSPolicyResourceFileResponse':
        """
        A remote or local source.
        """
        return pulumi.get(self, "file")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The absolute path of the file within the VM.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def permissions(self) -> str:
        """
        Consists of three octal digits which represent, in order, the permissions of the owner, group, and other users for the file (similarly to the numeric mode used in the linux chmod utility). Each digit represents a three bit number with the 4 bit corresponding to the read permissions, the 2 bit corresponds to the write bit, and the one bit corresponds to the execute permission. Default behavior is 755. Below are some examples of permissions and their associated values: read, write, and execute: 7 read and execute: 5 read and write: 6 read only: 4
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Desired state of the file.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class OSPolicyResourceFileResponse(dict):
    """
    A remote or local file.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowInsecure":
            suggest = "allow_insecure"
        elif key == "localPath":
            suggest = "local_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSPolicyResourceFileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSPolicyResourceFileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSPolicyResourceFileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_insecure: bool,
                 gcs: 'outputs.OSPolicyResourceFileGcsResponse',
                 local_path: str,
                 remote: 'outputs.OSPolicyResourceFileRemoteResponse'):
        """
        A remote or local file.
        :param bool allow_insecure: Defaults to false. When false, files are subject to validations based on the file type: Remote: A checksum must be specified. Cloud Storage: An object generation number must be specified.
        :param 'OSPolicyResourceFileGcsResponse' gcs: A Cloud Storage object.
        :param str local_path: A local path within the VM to use.
        :param 'OSPolicyResourceFileRemoteResponse' remote: A generic remote file.
        """
        pulumi.set(__self__, "allow_insecure", allow_insecure)
        pulumi.set(__self__, "gcs", gcs)
        pulumi.set(__self__, "local_path", local_path)
        pulumi.set(__self__, "remote", remote)

    @property
    @pulumi.getter(name="allowInsecure")
    def allow_insecure(self) -> bool:
        """
        Defaults to false. When false, files are subject to validations based on the file type: Remote: A checksum must be specified. Cloud Storage: An object generation number must be specified.
        """
        return pulumi.get(self, "allow_insecure")

    @property
    @pulumi.getter
    def gcs(self) -> 'outputs.OSPolicyResourceFileGcsResponse':
        """
        A Cloud Storage object.
        """
        return pulumi.get(self, "gcs")

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> str:
        """
        A local path within the VM to use.
        """
        return pulumi.get(self, "local_path")

    @property
    @pulumi.getter
    def remote(self) -> 'outputs.OSPolicyResourceFileRemoteResponse':
        """
        A generic remote file.
        """
        return pulumi.get(self, "remote")


@pulumi.output_type
class OSPolicyResourceGroupResponse(dict):
    """
    Resource groups provide a mechanism to group OS policy resources. Resource groups enable OS policy authors to create a single OS policy to be applied to VMs running different operating Systems. When the OS policy is applied to a target VM, the appropriate resource group within the OS policy is selected based on the `OSFilter` specified within the resource group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inventoryFilters":
            suggest = "inventory_filters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSPolicyResourceGroupResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSPolicyResourceGroupResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSPolicyResourceGroupResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 inventory_filters: Sequence['outputs.OSPolicyInventoryFilterResponse'],
                 resources: Sequence['outputs.OSPolicyResourceResponse']):
        """
        Resource groups provide a mechanism to group OS policy resources. Resource groups enable OS policy authors to create a single OS policy to be applied to VMs running different operating Systems. When the OS policy is applied to a target VM, the appropriate resource group within the OS policy is selected based on the `OSFilter` specified within the resource group.
        :param Sequence['OSPolicyInventoryFilterResponse'] inventory_filters: List of inventory filters for the resource group. The resources in this resource group are applied to the target VM if it satisfies at least one of the following inventory filters. For example, to apply this resource group to VMs running either `RHEL` or `CentOS` operating systems, specify 2 items for the list with following values: inventory_filters[0].os_short_name='rhel' and inventory_filters[1].os_short_name='centos' If the list is empty, this resource group will be applied to the target VM unconditionally.
        :param Sequence['OSPolicyResourceResponse'] resources: List of resources configured for this resource group. The resources are executed in the exact order specified here.
        """
        pulumi.set(__self__, "inventory_filters", inventory_filters)
        pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter(name="inventoryFilters")
    def inventory_filters(self) -> Sequence['outputs.OSPolicyInventoryFilterResponse']:
        """
        List of inventory filters for the resource group. The resources in this resource group are applied to the target VM if it satisfies at least one of the following inventory filters. For example, to apply this resource group to VMs running either `RHEL` or `CentOS` operating systems, specify 2 items for the list with following values: inventory_filters[0].os_short_name='rhel' and inventory_filters[1].os_short_name='centos' If the list is empty, this resource group will be applied to the target VM unconditionally.
        """
        return pulumi.get(self, "inventory_filters")

    @property
    @pulumi.getter
    def resources(self) -> Sequence['outputs.OSPolicyResourceResponse']:
        """
        List of resources configured for this resource group. The resources are executed in the exact order specified here.
        """
        return pulumi.get(self, "resources")


@pulumi.output_type
class OSPolicyResourcePackageResourceAPTResponse(dict):
    """
    A package managed by APT. - install: `apt-get update && apt-get -y install [name]` - remove: `apt-get -y remove [name]`
    """
    def __init__(__self__, *,
                 name: str):
        """
        A package managed by APT. - install: `apt-get update && apt-get -y install [name]` - remove: `apt-get -y remove [name]`
        :param str name: Package name.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Package name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class OSPolicyResourcePackageResourceDebResponse(dict):
    """
    A deb package file. dpkg packages only support INSTALLED state.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pullDeps":
            suggest = "pull_deps"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSPolicyResourcePackageResourceDebResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSPolicyResourcePackageResourceDebResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSPolicyResourcePackageResourceDebResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pull_deps: bool,
                 source: 'outputs.OSPolicyResourceFileResponse'):
        """
        A deb package file. dpkg packages only support INSTALLED state.
        :param bool pull_deps: Whether dependencies should also be installed. - install when false: `dpkg -i package` - install when true: `apt-get update && apt-get -y install package.deb`
        :param 'OSPolicyResourceFileResponse' source: A deb package.
        """
        pulumi.set(__self__, "pull_deps", pull_deps)
        pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter(name="pullDeps")
    def pull_deps(self) -> bool:
        """
        Whether dependencies should also be installed. - install when false: `dpkg -i package` - install when true: `apt-get update && apt-get -y install package.deb`
        """
        return pulumi.get(self, "pull_deps")

    @property
    @pulumi.getter
    def source(self) -> 'outputs.OSPolicyResourceFileResponse':
        """
        A deb package.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class OSPolicyResourcePackageResourceGooGetResponse(dict):
    """
    A package managed by GooGet. - install: `googet -noconfirm install package` - remove: `googet -noconfirm remove package`
    """
    def __init__(__self__, *,
                 name: str):
        """
        A package managed by GooGet. - install: `googet -noconfirm install package` - remove: `googet -noconfirm remove package`
        :param str name: Package name.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Package name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class OSPolicyResourcePackageResourceMSIResponse(dict):
    """
    An MSI package. MSI packages only support INSTALLED state.
    """
    def __init__(__self__, *,
                 properties: Sequence[str],
                 source: 'outputs.OSPolicyResourceFileResponse'):
        """
        An MSI package. MSI packages only support INSTALLED state.
        :param Sequence[str] properties: Additional properties to use during installation. This should be in the format of Property=Setting. Appended to the defaults of `ACTION=INSTALL REBOOT=ReallySuppress`.
        :param 'OSPolicyResourceFileResponse' source: The MSI package.
        """
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def properties(self) -> Sequence[str]:
        """
        Additional properties to use during installation. This should be in the format of Property=Setting. Appended to the defaults of `ACTION=INSTALL REBOOT=ReallySuppress`.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def source(self) -> 'outputs.OSPolicyResourceFileResponse':
        """
        The MSI package.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class OSPolicyResourcePackageResourceRPMResponse(dict):
    """
    An RPM package file. RPM packages only support INSTALLED state.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pullDeps":
            suggest = "pull_deps"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSPolicyResourcePackageResourceRPMResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSPolicyResourcePackageResourceRPMResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSPolicyResourcePackageResourceRPMResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pull_deps: bool,
                 source: 'outputs.OSPolicyResourceFileResponse'):
        """
        An RPM package file. RPM packages only support INSTALLED state.
        :param bool pull_deps: Whether dependencies should also be installed. - install when false: `rpm --upgrade --replacepkgs package.rpm` - install when true: `yum -y install package.rpm` or `zypper -y install package.rpm`
        :param 'OSPolicyResourceFileResponse' source: An rpm package.
        """
        pulumi.set(__self__, "pull_deps", pull_deps)
        pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter(name="pullDeps")
    def pull_deps(self) -> bool:
        """
        Whether dependencies should also be installed. - install when false: `rpm --upgrade --replacepkgs package.rpm` - install when true: `yum -y install package.rpm` or `zypper -y install package.rpm`
        """
        return pulumi.get(self, "pull_deps")

    @property
    @pulumi.getter
    def source(self) -> 'outputs.OSPolicyResourceFileResponse':
        """
        An rpm package.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class OSPolicyResourcePackageResourceResponse(dict):
    """
    A resource that manages a system package.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "desiredState":
            suggest = "desired_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSPolicyResourcePackageResourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSPolicyResourcePackageResourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSPolicyResourcePackageResourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 apt: 'outputs.OSPolicyResourcePackageResourceAPTResponse',
                 deb: 'outputs.OSPolicyResourcePackageResourceDebResponse',
                 desired_state: str,
                 googet: 'outputs.OSPolicyResourcePackageResourceGooGetResponse',
                 msi: 'outputs.OSPolicyResourcePackageResourceMSIResponse',
                 rpm: 'outputs.OSPolicyResourcePackageResourceRPMResponse',
                 yum: 'outputs.OSPolicyResourcePackageResourceYUMResponse',
                 zypper: 'outputs.OSPolicyResourcePackageResourceZypperResponse'):
        """
        A resource that manages a system package.
        :param 'OSPolicyResourcePackageResourceAPTResponse' apt: A package managed by Apt.
        :param 'OSPolicyResourcePackageResourceDebResponse' deb: A deb package file.
        :param str desired_state: The desired state the agent should maintain for this package.
        :param 'OSPolicyResourcePackageResourceGooGetResponse' googet: A package managed by GooGet.
        :param 'OSPolicyResourcePackageResourceMSIResponse' msi: An MSI package.
        :param 'OSPolicyResourcePackageResourceRPMResponse' rpm: An rpm package file.
        :param 'OSPolicyResourcePackageResourceYUMResponse' yum: A package managed by YUM.
        :param 'OSPolicyResourcePackageResourceZypperResponse' zypper: A package managed by Zypper.
        """
        pulumi.set(__self__, "apt", apt)
        pulumi.set(__self__, "deb", deb)
        pulumi.set(__self__, "desired_state", desired_state)
        pulumi.set(__self__, "googet", googet)
        pulumi.set(__self__, "msi", msi)
        pulumi.set(__self__, "rpm", rpm)
        pulumi.set(__self__, "yum", yum)
        pulumi.set(__self__, "zypper", zypper)

    @property
    @pulumi.getter
    def apt(self) -> 'outputs.OSPolicyResourcePackageResourceAPTResponse':
        """
        A package managed by Apt.
        """
        return pulumi.get(self, "apt")

    @property
    @pulumi.getter
    def deb(self) -> 'outputs.OSPolicyResourcePackageResourceDebResponse':
        """
        A deb package file.
        """
        return pulumi.get(self, "deb")

    @property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> str:
        """
        The desired state the agent should maintain for this package.
        """
        return pulumi.get(self, "desired_state")

    @property
    @pulumi.getter
    def googet(self) -> 'outputs.OSPolicyResourcePackageResourceGooGetResponse':
        """
        A package managed by GooGet.
        """
        return pulumi.get(self, "googet")

    @property
    @pulumi.getter
    def msi(self) -> 'outputs.OSPolicyResourcePackageResourceMSIResponse':
        """
        An MSI package.
        """
        return pulumi.get(self, "msi")

    @property
    @pulumi.getter
    def rpm(self) -> 'outputs.OSPolicyResourcePackageResourceRPMResponse':
        """
        An rpm package file.
        """
        return pulumi.get(self, "rpm")

    @property
    @pulumi.getter
    def yum(self) -> 'outputs.OSPolicyResourcePackageResourceYUMResponse':
        """
        A package managed by YUM.
        """
        return pulumi.get(self, "yum")

    @property
    @pulumi.getter
    def zypper(self) -> 'outputs.OSPolicyResourcePackageResourceZypperResponse':
        """
        A package managed by Zypper.
        """
        return pulumi.get(self, "zypper")


@pulumi.output_type
class OSPolicyResourcePackageResourceYUMResponse(dict):
    """
    A package managed by YUM. - install: `yum -y install package` - remove: `yum -y remove package`
    """
    def __init__(__self__, *,
                 name: str):
        """
        A package managed by YUM. - install: `yum -y install package` - remove: `yum -y remove package`
        :param str name: Package name.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Package name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class OSPolicyResourcePackageResourceZypperResponse(dict):
    """
    A package managed by Zypper. - install: `zypper -y install package` - remove: `zypper -y rm package`
    """
    def __init__(__self__, *,
                 name: str):
        """
        A package managed by Zypper. - install: `zypper -y install package` - remove: `zypper -y rm package`
        :param str name: Package name.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Package name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class OSPolicyResourceRepositoryResourceAptRepositoryResponse(dict):
    """
    Represents a single apt package repository. These will be added to a repo file that will be managed at `/etc/apt/sources.list.d/google_osconfig.list`.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "archiveType":
            suggest = "archive_type"
        elif key == "gpgKey":
            suggest = "gpg_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSPolicyResourceRepositoryResourceAptRepositoryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSPolicyResourceRepositoryResourceAptRepositoryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSPolicyResourceRepositoryResourceAptRepositoryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 archive_type: str,
                 components: Sequence[str],
                 distribution: str,
                 gpg_key: str,
                 uri: str):
        """
        Represents a single apt package repository. These will be added to a repo file that will be managed at `/etc/apt/sources.list.d/google_osconfig.list`.
        :param str archive_type: Type of archive files in this repository.
        :param Sequence[str] components: List of components for this repository. Must contain at least one item.
        :param str distribution: Distribution of this repository.
        :param str gpg_key: URI of the key file for this repository. The agent maintains a keyring at `/etc/apt/trusted.gpg.d/osconfig_agent_managed.gpg`.
        :param str uri: URI for this repository.
        """
        pulumi.set(__self__, "archive_type", archive_type)
        pulumi.set(__self__, "components", components)
        pulumi.set(__self__, "distribution", distribution)
        pulumi.set(__self__, "gpg_key", gpg_key)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="archiveType")
    def archive_type(self) -> str:
        """
        Type of archive files in this repository.
        """
        return pulumi.get(self, "archive_type")

    @property
    @pulumi.getter
    def components(self) -> Sequence[str]:
        """
        List of components for this repository. Must contain at least one item.
        """
        return pulumi.get(self, "components")

    @property
    @pulumi.getter
    def distribution(self) -> str:
        """
        Distribution of this repository.
        """
        return pulumi.get(self, "distribution")

    @property
    @pulumi.getter(name="gpgKey")
    def gpg_key(self) -> str:
        """
        URI of the key file for this repository. The agent maintains a keyring at `/etc/apt/trusted.gpg.d/osconfig_agent_managed.gpg`.
        """
        return pulumi.get(self, "gpg_key")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        URI for this repository.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class OSPolicyResourceRepositoryResourceGooRepositoryResponse(dict):
    """
    Represents a Goo package repository. These are added to a repo file that is managed at `C:/ProgramData/GooGet/repos/google_osconfig.repo`.
    """
    def __init__(__self__, *,
                 name: str,
                 url: str):
        """
        Represents a Goo package repository. These are added to a repo file that is managed at `C:/ProgramData/GooGet/repos/google_osconfig.repo`.
        :param str name: The name of the repository.
        :param str url: The url of the repository.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the repository.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The url of the repository.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class OSPolicyResourceRepositoryResourceResponse(dict):
    """
    A resource that manages a package repository.
    """
    def __init__(__self__, *,
                 apt: 'outputs.OSPolicyResourceRepositoryResourceAptRepositoryResponse',
                 goo: 'outputs.OSPolicyResourceRepositoryResourceGooRepositoryResponse',
                 yum: 'outputs.OSPolicyResourceRepositoryResourceYumRepositoryResponse',
                 zypper: 'outputs.OSPolicyResourceRepositoryResourceZypperRepositoryResponse'):
        """
        A resource that manages a package repository.
        :param 'OSPolicyResourceRepositoryResourceAptRepositoryResponse' apt: An Apt Repository.
        :param 'OSPolicyResourceRepositoryResourceGooRepositoryResponse' goo: A Goo Repository.
        :param 'OSPolicyResourceRepositoryResourceYumRepositoryResponse' yum: A Yum Repository.
        :param 'OSPolicyResourceRepositoryResourceZypperRepositoryResponse' zypper: A Zypper Repository.
        """
        pulumi.set(__self__, "apt", apt)
        pulumi.set(__self__, "goo", goo)
        pulumi.set(__self__, "yum", yum)
        pulumi.set(__self__, "zypper", zypper)

    @property
    @pulumi.getter
    def apt(self) -> 'outputs.OSPolicyResourceRepositoryResourceAptRepositoryResponse':
        """
        An Apt Repository.
        """
        return pulumi.get(self, "apt")

    @property
    @pulumi.getter
    def goo(self) -> 'outputs.OSPolicyResourceRepositoryResourceGooRepositoryResponse':
        """
        A Goo Repository.
        """
        return pulumi.get(self, "goo")

    @property
    @pulumi.getter
    def yum(self) -> 'outputs.OSPolicyResourceRepositoryResourceYumRepositoryResponse':
        """
        A Yum Repository.
        """
        return pulumi.get(self, "yum")

    @property
    @pulumi.getter
    def zypper(self) -> 'outputs.OSPolicyResourceRepositoryResourceZypperRepositoryResponse':
        """
        A Zypper Repository.
        """
        return pulumi.get(self, "zypper")


@pulumi.output_type
class OSPolicyResourceRepositoryResourceYumRepositoryResponse(dict):
    """
    Represents a single yum package repository. These are added to a repo file that is managed at `/etc/yum.repos.d/google_osconfig.repo`.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseUrl":
            suggest = "base_url"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "gpgKeys":
            suggest = "gpg_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSPolicyResourceRepositoryResourceYumRepositoryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSPolicyResourceRepositoryResourceYumRepositoryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSPolicyResourceRepositoryResourceYumRepositoryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_url: str,
                 display_name: str,
                 gpg_keys: Sequence[str]):
        """
        Represents a single yum package repository. These are added to a repo file that is managed at `/etc/yum.repos.d/google_osconfig.repo`.
        :param str base_url: The location of the repository directory.
        :param str display_name: The display name of the repository.
        :param Sequence[str] gpg_keys: URIs of GPG keys.
        """
        pulumi.set(__self__, "base_url", base_url)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "gpg_keys", gpg_keys)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> str:
        """
        The location of the repository directory.
        """
        return pulumi.get(self, "base_url")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the repository.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="gpgKeys")
    def gpg_keys(self) -> Sequence[str]:
        """
        URIs of GPG keys.
        """
        return pulumi.get(self, "gpg_keys")


@pulumi.output_type
class OSPolicyResourceRepositoryResourceZypperRepositoryResponse(dict):
    """
    Represents a single zypper package repository. These are added to a repo file that is managed at `/etc/zypp/repos.d/google_osconfig.repo`.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseUrl":
            suggest = "base_url"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "gpgKeys":
            suggest = "gpg_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSPolicyResourceRepositoryResourceZypperRepositoryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSPolicyResourceRepositoryResourceZypperRepositoryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSPolicyResourceRepositoryResourceZypperRepositoryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_url: str,
                 display_name: str,
                 gpg_keys: Sequence[str]):
        """
        Represents a single zypper package repository. These are added to a repo file that is managed at `/etc/zypp/repos.d/google_osconfig.repo`.
        :param str base_url: The location of the repository directory.
        :param str display_name: The display name of the repository.
        :param Sequence[str] gpg_keys: URIs of GPG keys.
        """
        pulumi.set(__self__, "base_url", base_url)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "gpg_keys", gpg_keys)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> str:
        """
        The location of the repository directory.
        """
        return pulumi.get(self, "base_url")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the repository.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="gpgKeys")
    def gpg_keys(self) -> Sequence[str]:
        """
        URIs of GPG keys.
        """
        return pulumi.get(self, "gpg_keys")


@pulumi.output_type
class OSPolicyResourceResponse(dict):
    """
    An OS policy resource is used to define the desired state configuration and provides a specific functionality like installing/removing packages, executing a script etc. The system ensures that resources are always in their desired state by taking necessary actions if they have drifted from their desired state.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exec":
            suggest = "exec_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSPolicyResourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSPolicyResourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSPolicyResourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exec_: 'outputs.OSPolicyResourceExecResourceResponse',
                 file: 'outputs.OSPolicyResourceFileResourceResponse',
                 pkg: 'outputs.OSPolicyResourcePackageResourceResponse',
                 repository: 'outputs.OSPolicyResourceRepositoryResourceResponse'):
        """
        An OS policy resource is used to define the desired state configuration and provides a specific functionality like installing/removing packages, executing a script etc. The system ensures that resources are always in their desired state by taking necessary actions if they have drifted from their desired state.
        :param 'OSPolicyResourceExecResourceResponse' exec_: Exec resource
        :param 'OSPolicyResourceFileResourceResponse' file: File resource
        :param 'OSPolicyResourcePackageResourceResponse' pkg: Package resource
        :param 'OSPolicyResourceRepositoryResourceResponse' repository: Package repository resource
        """
        pulumi.set(__self__, "exec_", exec_)
        pulumi.set(__self__, "file", file)
        pulumi.set(__self__, "pkg", pkg)
        pulumi.set(__self__, "repository", repository)

    @property
    @pulumi.getter(name="exec")
    def exec_(self) -> 'outputs.OSPolicyResourceExecResourceResponse':
        """
        Exec resource
        """
        return pulumi.get(self, "exec_")

    @property
    @pulumi.getter
    def file(self) -> 'outputs.OSPolicyResourceFileResourceResponse':
        """
        File resource
        """
        return pulumi.get(self, "file")

    @property
    @pulumi.getter
    def pkg(self) -> 'outputs.OSPolicyResourcePackageResourceResponse':
        """
        Package resource
        """
        return pulumi.get(self, "pkg")

    @property
    @pulumi.getter
    def repository(self) -> 'outputs.OSPolicyResourceRepositoryResourceResponse':
        """
        Package repository resource
        """
        return pulumi.get(self, "repository")


@pulumi.output_type
class OSPolicyResponse(dict):
    """
    An OS policy defines the desired state configuration for a VM.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowNoResourceGroupMatch":
            suggest = "allow_no_resource_group_match"
        elif key == "resourceGroups":
            suggest = "resource_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_no_resource_group_match: bool,
                 description: str,
                 mode: str,
                 resource_groups: Sequence['outputs.OSPolicyResourceGroupResponse']):
        """
        An OS policy defines the desired state configuration for a VM.
        :param bool allow_no_resource_group_match: This flag determines the OS policy compliance status when none of the resource groups within the policy are applicable for a VM. Set this value to `true` if the policy needs to be reported as compliant even if the policy has nothing to validate or enforce.
        :param str description: Policy description. Length of the description is limited to 1024 characters.
        :param str mode: Policy mode
        :param Sequence['OSPolicyResourceGroupResponse'] resource_groups: List of resource groups for the policy. For a particular VM, resource groups are evaluated in the order specified and the first resource group that is applicable is selected and the rest are ignored. If none of the resource groups are applicable for a VM, the VM is considered to be non-compliant w.r.t this policy. This behavior can be toggled by the flag `allow_no_resource_group_match`
        """
        pulumi.set(__self__, "allow_no_resource_group_match", allow_no_resource_group_match)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "resource_groups", resource_groups)

    @property
    @pulumi.getter(name="allowNoResourceGroupMatch")
    def allow_no_resource_group_match(self) -> bool:
        """
        This flag determines the OS policy compliance status when none of the resource groups within the policy are applicable for a VM. Set this value to `true` if the policy needs to be reported as compliant even if the policy has nothing to validate or enforce.
        """
        return pulumi.get(self, "allow_no_resource_group_match")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Policy description. Length of the description is limited to 1024 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        Policy mode
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="resourceGroups")
    def resource_groups(self) -> Sequence['outputs.OSPolicyResourceGroupResponse']:
        """
        List of resource groups for the policy. For a particular VM, resource groups are evaluated in the order specified and the first resource group that is applicable is selected and the rest are ignored. If none of the resource groups are applicable for a VM, the VM is considered to be non-compliant w.r.t this policy. This behavior can be toggled by the flag `allow_no_resource_group_match`
        """
        return pulumi.get(self, "resource_groups")


@pulumi.output_type
class OneTimeScheduleResponse(dict):
    """
    Sets the time for a one time patch deployment. Timestamp is in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executeTime":
            suggest = "execute_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OneTimeScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OneTimeScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OneTimeScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execute_time: str):
        """
        Sets the time for a one time patch deployment. Timestamp is in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
        :param str execute_time: The desired patch job execution time.
        """
        pulumi.set(__self__, "execute_time", execute_time)

    @property
    @pulumi.getter(name="executeTime")
    def execute_time(self) -> str:
        """
        The desired patch job execution time.
        """
        return pulumi.get(self, "execute_time")


@pulumi.output_type
class PatchConfigResponse(dict):
    """
    Patch configuration specifications. Contains details on how to apply the patch(es) to a VM instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "postStep":
            suggest = "post_step"
        elif key == "preStep":
            suggest = "pre_step"
        elif key == "rebootConfig":
            suggest = "reboot_config"
        elif key == "windowsUpdate":
            suggest = "windows_update"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PatchConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PatchConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PatchConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 apt: 'outputs.AptSettingsResponse',
                 goo: 'outputs.GooSettingsResponse',
                 post_step: 'outputs.ExecStepResponse',
                 pre_step: 'outputs.ExecStepResponse',
                 reboot_config: str,
                 windows_update: 'outputs.WindowsUpdateSettingsResponse',
                 yum: 'outputs.YumSettingsResponse',
                 zypper: 'outputs.ZypperSettingsResponse'):
        """
        Patch configuration specifications. Contains details on how to apply the patch(es) to a VM instance.
        :param 'AptSettingsResponse' apt: Apt update settings. Use this setting to override the default `apt` patch rules.
        :param 'GooSettingsResponse' goo: Goo update settings. Use this setting to override the default `goo` patch rules.
        :param 'ExecStepResponse' post_step: The `ExecStep` to run after the patch update.
        :param 'ExecStepResponse' pre_step: The `ExecStep` to run before the patch update.
        :param str reboot_config: Post-patch reboot settings.
        :param 'WindowsUpdateSettingsResponse' windows_update: Windows update settings. Use this override the default windows patch rules.
        :param 'YumSettingsResponse' yum: Yum update settings. Use this setting to override the default `yum` patch rules.
        :param 'ZypperSettingsResponse' zypper: Zypper update settings. Use this setting to override the default `zypper` patch rules.
        """
        pulumi.set(__self__, "apt", apt)
        pulumi.set(__self__, "goo", goo)
        pulumi.set(__self__, "post_step", post_step)
        pulumi.set(__self__, "pre_step", pre_step)
        pulumi.set(__self__, "reboot_config", reboot_config)
        pulumi.set(__self__, "windows_update", windows_update)
        pulumi.set(__self__, "yum", yum)
        pulumi.set(__self__, "zypper", zypper)

    @property
    @pulumi.getter
    def apt(self) -> 'outputs.AptSettingsResponse':
        """
        Apt update settings. Use this setting to override the default `apt` patch rules.
        """
        return pulumi.get(self, "apt")

    @property
    @pulumi.getter
    def goo(self) -> 'outputs.GooSettingsResponse':
        """
        Goo update settings. Use this setting to override the default `goo` patch rules.
        """
        return pulumi.get(self, "goo")

    @property
    @pulumi.getter(name="postStep")
    def post_step(self) -> 'outputs.ExecStepResponse':
        """
        The `ExecStep` to run after the patch update.
        """
        return pulumi.get(self, "post_step")

    @property
    @pulumi.getter(name="preStep")
    def pre_step(self) -> 'outputs.ExecStepResponse':
        """
        The `ExecStep` to run before the patch update.
        """
        return pulumi.get(self, "pre_step")

    @property
    @pulumi.getter(name="rebootConfig")
    def reboot_config(self) -> str:
        """
        Post-patch reboot settings.
        """
        return pulumi.get(self, "reboot_config")

    @property
    @pulumi.getter(name="windowsUpdate")
    def windows_update(self) -> 'outputs.WindowsUpdateSettingsResponse':
        """
        Windows update settings. Use this override the default windows patch rules.
        """
        return pulumi.get(self, "windows_update")

    @property
    @pulumi.getter
    def yum(self) -> 'outputs.YumSettingsResponse':
        """
        Yum update settings. Use this setting to override the default `yum` patch rules.
        """
        return pulumi.get(self, "yum")

    @property
    @pulumi.getter
    def zypper(self) -> 'outputs.ZypperSettingsResponse':
        """
        Zypper update settings. Use this setting to override the default `zypper` patch rules.
        """
        return pulumi.get(self, "zypper")


@pulumi.output_type
class PatchInstanceFilterGroupLabelResponse(dict):
    """
    Targets a group of VM instances by using their [assigned labels](https://cloud.google.com/compute/docs/labeling-resources). Labels are key-value pairs. A `GroupLabel` is a combination of labels that is used to target VMs for a patch job. For example, a patch job can target VMs that have the following `GroupLabel`: `{"env":"test", "app":"web"}`. This means that the patch job is applied to VMs that have both the labels `env=test` and `app=web`.
    """
    def __init__(__self__, *,
                 labels: Mapping[str, str]):
        """
        Targets a group of VM instances by using their [assigned labels](https://cloud.google.com/compute/docs/labeling-resources). Labels are key-value pairs. A `GroupLabel` is a combination of labels that is used to target VMs for a patch job. For example, a patch job can target VMs that have the following `GroupLabel`: `{"env":"test", "app":"web"}`. This means that the patch job is applied to VMs that have both the labels `env=test` and `app=web`.
        :param Mapping[str, str] labels: Compute Engine instance labels that must be present for a VM instance to be targeted by this filter.
        """
        pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Compute Engine instance labels that must be present for a VM instance to be targeted by this filter.
        """
        return pulumi.get(self, "labels")


@pulumi.output_type
class PatchInstanceFilterResponse(dict):
    """
    A filter to target VM instances for patching. The targeted VMs must meet all criteria specified. So if both labels and zones are specified, the patch job targets only VMs with those labels and in those zones.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupLabels":
            suggest = "group_labels"
        elif key == "instanceNamePrefixes":
            suggest = "instance_name_prefixes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PatchInstanceFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PatchInstanceFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PatchInstanceFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all: bool,
                 group_labels: Sequence['outputs.PatchInstanceFilterGroupLabelResponse'],
                 instance_name_prefixes: Sequence[str],
                 instances: Sequence[str],
                 zones: Sequence[str]):
        """
        A filter to target VM instances for patching. The targeted VMs must meet all criteria specified. So if both labels and zones are specified, the patch job targets only VMs with those labels and in those zones.
        :param bool all: Target all VM instances in the project. If true, no other criteria is permitted.
        :param Sequence['PatchInstanceFilterGroupLabelResponse'] group_labels: Targets VM instances matching ANY of these GroupLabels. This allows targeting of disparate groups of VM instances.
        :param Sequence[str] instance_name_prefixes: Targets VMs whose name starts with one of these prefixes. Similar to labels, this is another way to group VMs when targeting configs, for example prefix="prod-".
        :param Sequence[str] instances: Targets any of the VM instances specified. Instances are specified by their URI in the form `zones/[ZONE]/instances/[INSTANCE_NAME]`, `projects/[PROJECT_ID]/zones/[ZONE]/instances/[INSTANCE_NAME]`, or `https://www.googleapis.com/compute/v1/projects/[PROJECT_ID]/zones/[ZONE]/instances/[INSTANCE_NAME]`
        :param Sequence[str] zones: Targets VM instances in ANY of these zones. Leave empty to target VM instances in any zone.
        """
        pulumi.set(__self__, "all", all)
        pulumi.set(__self__, "group_labels", group_labels)
        pulumi.set(__self__, "instance_name_prefixes", instance_name_prefixes)
        pulumi.set(__self__, "instances", instances)
        pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter
    def all(self) -> bool:
        """
        Target all VM instances in the project. If true, no other criteria is permitted.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter(name="groupLabels")
    def group_labels(self) -> Sequence['outputs.PatchInstanceFilterGroupLabelResponse']:
        """
        Targets VM instances matching ANY of these GroupLabels. This allows targeting of disparate groups of VM instances.
        """
        return pulumi.get(self, "group_labels")

    @property
    @pulumi.getter(name="instanceNamePrefixes")
    def instance_name_prefixes(self) -> Sequence[str]:
        """
        Targets VMs whose name starts with one of these prefixes. Similar to labels, this is another way to group VMs when targeting configs, for example prefix="prod-".
        """
        return pulumi.get(self, "instance_name_prefixes")

    @property
    @pulumi.getter
    def instances(self) -> Sequence[str]:
        """
        Targets any of the VM instances specified. Instances are specified by their URI in the form `zones/[ZONE]/instances/[INSTANCE_NAME]`, `projects/[PROJECT_ID]/zones/[ZONE]/instances/[INSTANCE_NAME]`, or `https://www.googleapis.com/compute/v1/projects/[PROJECT_ID]/zones/[ZONE]/instances/[INSTANCE_NAME]`
        """
        return pulumi.get(self, "instances")

    @property
    @pulumi.getter
    def zones(self) -> Sequence[str]:
        """
        Targets VM instances in ANY of these zones. Leave empty to target VM instances in any zone.
        """
        return pulumi.get(self, "zones")


@pulumi.output_type
class PatchRolloutResponse(dict):
    """
    Patch rollout configuration specifications. Contains details on the concurrency control when applying patch(es) to all targeted VMs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disruptionBudget":
            suggest = "disruption_budget"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PatchRolloutResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PatchRolloutResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PatchRolloutResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disruption_budget: 'outputs.FixedOrPercentResponse',
                 mode: str):
        """
        Patch rollout configuration specifications. Contains details on the concurrency control when applying patch(es) to all targeted VMs.
        :param 'FixedOrPercentResponse' disruption_budget: The maximum number (or percentage) of VMs per zone to disrupt at any given moment. The number of VMs calculated from multiplying the percentage by the total number of VMs in a zone is rounded up. During patching, a VM is considered disrupted from the time the agent is notified to begin until patching has completed. This disruption time includes the time to complete reboot and any post-patch steps. A VM contributes to the disruption budget if its patching operation fails either when applying the patches, running pre or post patch steps, or if it fails to respond with a success notification before timing out. VMs that are not running or do not have an active agent do not count toward this disruption budget. For zone-by-zone rollouts, if the disruption budget in a zone is exceeded, the patch job stops, because continuing to the next zone requires completion of the patch process in the previous zone. For example, if the disruption budget has a fixed value of `10`, and 8 VMs fail to patch in the current zone, the patch job continues to patch 2 VMs at a time until the zone is completed. When that zone is completed successfully, patching begins with 10 VMs at a time in the next zone. If 10 VMs in the next zone fail to patch, the patch job stops.
        :param str mode: Mode of the patch rollout.
        """
        pulumi.set(__self__, "disruption_budget", disruption_budget)
        pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="disruptionBudget")
    def disruption_budget(self) -> 'outputs.FixedOrPercentResponse':
        """
        The maximum number (or percentage) of VMs per zone to disrupt at any given moment. The number of VMs calculated from multiplying the percentage by the total number of VMs in a zone is rounded up. During patching, a VM is considered disrupted from the time the agent is notified to begin until patching has completed. This disruption time includes the time to complete reboot and any post-patch steps. A VM contributes to the disruption budget if its patching operation fails either when applying the patches, running pre or post patch steps, or if it fails to respond with a success notification before timing out. VMs that are not running or do not have an active agent do not count toward this disruption budget. For zone-by-zone rollouts, if the disruption budget in a zone is exceeded, the patch job stops, because continuing to the next zone requires completion of the patch process in the previous zone. For example, if the disruption budget has a fixed value of `10`, and 8 VMs fail to patch in the current zone, the patch job continues to patch 2 VMs at a time until the zone is completed. When that zone is completed successfully, patching begins with 10 VMs at a time in the next zone. If 10 VMs in the next zone fail to patch, the patch job stops.
        """
        return pulumi.get(self, "disruption_budget")

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        Mode of the patch rollout.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class RecurringScheduleResponse(dict):
    """
    Sets the time for recurring patch deployments.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "lastExecuteTime":
            suggest = "last_execute_time"
        elif key == "nextExecuteTime":
            suggest = "next_execute_time"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "timeOfDay":
            suggest = "time_of_day"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecurringScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecurringScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecurringScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: str,
                 frequency: str,
                 last_execute_time: str,
                 monthly: 'outputs.MonthlyScheduleResponse',
                 next_execute_time: str,
                 start_time: str,
                 time_of_day: 'outputs.TimeOfDayResponse',
                 time_zone: 'outputs.TimeZoneResponse',
                 weekly: 'outputs.WeeklyScheduleResponse'):
        """
        Sets the time for recurring patch deployments.
        :param str end_time: Optional. The end time at which a recurring patch deployment schedule is no longer active.
        :param str frequency: The frequency unit of this recurring schedule.
        :param str last_execute_time: The time the last patch job ran successfully.
        :param 'MonthlyScheduleResponse' monthly: Schedule with monthly executions.
        :param str next_execute_time: The time the next patch job is scheduled to run.
        :param str start_time: Optional. The time that the recurring schedule becomes effective. Defaults to `create_time` of the patch deployment.
        :param 'TimeOfDayResponse' time_of_day: Time of the day to run a recurring deployment.
        :param 'TimeZoneResponse' time_zone: Defines the time zone that `time_of_day` is relative to. The rules for daylight saving time are determined by the chosen time zone.
        :param 'WeeklyScheduleResponse' weekly: Schedule with weekly executions.
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "last_execute_time", last_execute_time)
        pulumi.set(__self__, "monthly", monthly)
        pulumi.set(__self__, "next_execute_time", next_execute_time)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "time_of_day", time_of_day)
        pulumi.set(__self__, "time_zone", time_zone)
        pulumi.set(__self__, "weekly", weekly)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        Optional. The end time at which a recurring patch deployment schedule is no longer active.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def frequency(self) -> str:
        """
        The frequency unit of this recurring schedule.
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter(name="lastExecuteTime")
    def last_execute_time(self) -> str:
        """
        The time the last patch job ran successfully.
        """
        return pulumi.get(self, "last_execute_time")

    @property
    @pulumi.getter
    def monthly(self) -> 'outputs.MonthlyScheduleResponse':
        """
        Schedule with monthly executions.
        """
        return pulumi.get(self, "monthly")

    @property
    @pulumi.getter(name="nextExecuteTime")
    def next_execute_time(self) -> str:
        """
        The time the next patch job is scheduled to run.
        """
        return pulumi.get(self, "next_execute_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Optional. The time that the recurring schedule becomes effective. Defaults to `create_time` of the patch deployment.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="timeOfDay")
    def time_of_day(self) -> 'outputs.TimeOfDayResponse':
        """
        Time of the day to run a recurring deployment.
        """
        return pulumi.get(self, "time_of_day")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> 'outputs.TimeZoneResponse':
        """
        Defines the time zone that `time_of_day` is relative to. The rules for daylight saving time are determined by the chosen time zone.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter
    def weekly(self) -> 'outputs.WeeklyScheduleResponse':
        """
        Schedule with weekly executions.
        """
        return pulumi.get(self, "weekly")


@pulumi.output_type
class TimeOfDayResponse(dict):
    """
    Represents a time of day. The date and time zone are either not significant or are specified elsewhere. An API may choose to allow leap seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.
    """
    def __init__(__self__, *,
                 hours: int,
                 minutes: int,
                 nanos: int,
                 seconds: int):
        """
        Represents a time of day. The date and time zone are either not significant or are specified elsewhere. An API may choose to allow leap seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.
        :param int hours: Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        :param int minutes: Minutes of hour of day. Must be from 0 to 59.
        :param int nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        :param int seconds: Seconds of minutes of the time. Must normally be from 0 to 59. An API may allow the value 60 if it allows leap-seconds.
        """
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)
        pulumi.set(__self__, "nanos", nanos)
        pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def hours(self) -> int:
        """
        Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> int:
        """
        Minutes of hour of day. Must be from 0 to 59.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter
    def nanos(self) -> int:
        """
        Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        """
        return pulumi.get(self, "nanos")

    @property
    @pulumi.getter
    def seconds(self) -> int:
        """
        Seconds of minutes of the time. Must normally be from 0 to 59. An API may allow the value 60 if it allows leap-seconds.
        """
        return pulumi.get(self, "seconds")


@pulumi.output_type
class TimeZoneResponse(dict):
    """
    Represents a time zone from the [IANA Time Zone Database](https://www.iana.org/time-zones).
    """
    def __init__(__self__, *,
                 version: str):
        """
        Represents a time zone from the [IANA Time Zone Database](https://www.iana.org/time-zones).
        :param str version: Optional. IANA Time Zone Database version number, e.g. "2019a".
        """
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Optional. IANA Time Zone Database version number, e.g. "2019a".
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class WeekDayOfMonthResponse(dict):
    """
    Represents one week day in a month. An example is "the 4th Sunday".
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfWeek":
            suggest = "day_of_week"
        elif key == "dayOffset":
            suggest = "day_offset"
        elif key == "weekOrdinal":
            suggest = "week_ordinal"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WeekDayOfMonthResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WeekDayOfMonthResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WeekDayOfMonthResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_week: str,
                 day_offset: int,
                 week_ordinal: int):
        """
        Represents one week day in a month. An example is "the 4th Sunday".
        :param str day_of_week: A day of the week.
        :param int day_offset: Optional. Represents the number of days before or after the given week day of month that the patch deployment is scheduled for. For example if `week_ordinal` and `day_of_week` values point to the second day of the month and this `day_offset` value is set to `3`, the patch deployment takes place three days after the second Tuesday of the month. If this value is negative, for example -5, the patches are deployed five days before before the second Tuesday of the month. Allowed values are in range [-30, 30].
        :param int week_ordinal: Week number in a month. 1-4 indicates the 1st to 4th week of the month. -1 indicates the last week of the month.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "day_offset", day_offset)
        pulumi.set(__self__, "week_ordinal", week_ordinal)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> str:
        """
        A day of the week.
        """
        return pulumi.get(self, "day_of_week")

    @property
    @pulumi.getter(name="dayOffset")
    def day_offset(self) -> int:
        """
        Optional. Represents the number of days before or after the given week day of month that the patch deployment is scheduled for. For example if `week_ordinal` and `day_of_week` values point to the second day of the month and this `day_offset` value is set to `3`, the patch deployment takes place three days after the second Tuesday of the month. If this value is negative, for example -5, the patches are deployed five days before before the second Tuesday of the month. Allowed values are in range [-30, 30].
        """
        return pulumi.get(self, "day_offset")

    @property
    @pulumi.getter(name="weekOrdinal")
    def week_ordinal(self) -> int:
        """
        Week number in a month. 1-4 indicates the 1st to 4th week of the month. -1 indicates the last week of the month.
        """
        return pulumi.get(self, "week_ordinal")


@pulumi.output_type
class WeeklyScheduleResponse(dict):
    """
    Represents a weekly schedule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfWeek":
            suggest = "day_of_week"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WeeklyScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WeeklyScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WeeklyScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_week: str):
        """
        Represents a weekly schedule.
        :param str day_of_week: Day of the week.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> str:
        """
        Day of the week.
        """
        return pulumi.get(self, "day_of_week")


@pulumi.output_type
class WindowsUpdateSettingsResponse(dict):
    """
    Windows patching is performed using the Windows Update Agent.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exclusivePatches":
            suggest = "exclusive_patches"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsUpdateSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsUpdateSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsUpdateSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 classifications: Sequence[str],
                 excludes: Sequence[str],
                 exclusive_patches: Sequence[str]):
        """
        Windows patching is performed using the Windows Update Agent.
        :param Sequence[str] classifications: Only apply updates of these windows update classifications. If empty, all updates are applied.
        :param Sequence[str] excludes: List of KBs to exclude from update.
        :param Sequence[str] exclusive_patches: An exclusive list of kbs to be updated. These are the only patches that will be updated. This field must not be used with other patch configurations.
        """
        pulumi.set(__self__, "classifications", classifications)
        pulumi.set(__self__, "excludes", excludes)
        pulumi.set(__self__, "exclusive_patches", exclusive_patches)

    @property
    @pulumi.getter
    def classifications(self) -> Sequence[str]:
        """
        Only apply updates of these windows update classifications. If empty, all updates are applied.
        """
        return pulumi.get(self, "classifications")

    @property
    @pulumi.getter
    def excludes(self) -> Sequence[str]:
        """
        List of KBs to exclude from update.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter(name="exclusivePatches")
    def exclusive_patches(self) -> Sequence[str]:
        """
        An exclusive list of kbs to be updated. These are the only patches that will be updated. This field must not be used with other patch configurations.
        """
        return pulumi.get(self, "exclusive_patches")


@pulumi.output_type
class YumSettingsResponse(dict):
    """
    Yum patching is performed by executing `yum update`. Additional options can be set to control how this is executed. Note that not all settings are supported on all platforms.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exclusivePackages":
            suggest = "exclusive_packages"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in YumSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        YumSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        YumSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 excludes: Sequence[str],
                 exclusive_packages: Sequence[str],
                 minimal: bool,
                 security: bool):
        """
        Yum patching is performed by executing `yum update`. Additional options can be set to control how this is executed. Note that not all settings are supported on all platforms.
        :param Sequence[str] excludes: List of packages to exclude from update. These packages are excluded by using the yum `--exclude` flag.
        :param Sequence[str] exclusive_packages: An exclusive list of packages to be updated. These are the only packages that will be updated. If these packages are not installed, they will be ignored. This field must not be specified with any other patch configuration fields.
        :param bool minimal: Will cause patch to run `yum update-minimal` instead.
        :param bool security: Adds the `--security` flag to `yum update`. Not supported on all platforms.
        """
        pulumi.set(__self__, "excludes", excludes)
        pulumi.set(__self__, "exclusive_packages", exclusive_packages)
        pulumi.set(__self__, "minimal", minimal)
        pulumi.set(__self__, "security", security)

    @property
    @pulumi.getter
    def excludes(self) -> Sequence[str]:
        """
        List of packages to exclude from update. These packages are excluded by using the yum `--exclude` flag.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter(name="exclusivePackages")
    def exclusive_packages(self) -> Sequence[str]:
        """
        An exclusive list of packages to be updated. These are the only packages that will be updated. If these packages are not installed, they will be ignored. This field must not be specified with any other patch configuration fields.
        """
        return pulumi.get(self, "exclusive_packages")

    @property
    @pulumi.getter
    def minimal(self) -> bool:
        """
        Will cause patch to run `yum update-minimal` instead.
        """
        return pulumi.get(self, "minimal")

    @property
    @pulumi.getter
    def security(self) -> bool:
        """
        Adds the `--security` flag to `yum update`. Not supported on all platforms.
        """
        return pulumi.get(self, "security")


@pulumi.output_type
class ZypperSettingsResponse(dict):
    """
    Zypper patching is performed by running `zypper patch`. See also https://en.opensuse.org/SDB:Zypper_manual.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exclusivePatches":
            suggest = "exclusive_patches"
        elif key == "withOptional":
            suggest = "with_optional"
        elif key == "withUpdate":
            suggest = "with_update"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ZypperSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ZypperSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ZypperSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 categories: Sequence[str],
                 excludes: Sequence[str],
                 exclusive_patches: Sequence[str],
                 severities: Sequence[str],
                 with_optional: bool,
                 with_update: bool):
        """
        Zypper patching is performed by running `zypper patch`. See also https://en.opensuse.org/SDB:Zypper_manual.
        :param Sequence[str] categories: Install only patches with these categories. Common categories include security, recommended, and feature.
        :param Sequence[str] excludes: List of patches to exclude from update.
        :param Sequence[str] exclusive_patches: An exclusive list of patches to be updated. These are the only patches that will be installed using 'zypper patch patch:' command. This field must not be used with any other patch configuration fields.
        :param Sequence[str] severities: Install only patches with these severities. Common severities include critical, important, moderate, and low.
        :param bool with_optional: Adds the `--with-optional` flag to `zypper patch`.
        :param bool with_update: Adds the `--with-update` flag, to `zypper patch`.
        """
        pulumi.set(__self__, "categories", categories)
        pulumi.set(__self__, "excludes", excludes)
        pulumi.set(__self__, "exclusive_patches", exclusive_patches)
        pulumi.set(__self__, "severities", severities)
        pulumi.set(__self__, "with_optional", with_optional)
        pulumi.set(__self__, "with_update", with_update)

    @property
    @pulumi.getter
    def categories(self) -> Sequence[str]:
        """
        Install only patches with these categories. Common categories include security, recommended, and feature.
        """
        return pulumi.get(self, "categories")

    @property
    @pulumi.getter
    def excludes(self) -> Sequence[str]:
        """
        List of patches to exclude from update.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter(name="exclusivePatches")
    def exclusive_patches(self) -> Sequence[str]:
        """
        An exclusive list of patches to be updated. These are the only patches that will be installed using 'zypper patch patch:' command. This field must not be used with any other patch configuration fields.
        """
        return pulumi.get(self, "exclusive_patches")

    @property
    @pulumi.getter
    def severities(self) -> Sequence[str]:
        """
        Install only patches with these severities. Common severities include critical, important, moderate, and low.
        """
        return pulumi.get(self, "severities")

    @property
    @pulumi.getter(name="withOptional")
    def with_optional(self) -> bool:
        """
        Adds the `--with-optional` flag to `zypper patch`.
        """
        return pulumi.get(self, "with_optional")

    @property
    @pulumi.getter(name="withUpdate")
    def with_update(self) -> bool:
        """
        Adds the `--with-update` flag, to `zypper patch`.
        """
        return pulumi.get(self, "with_update")


