# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

from enum import Enum

__all__ = [
    'AggregationCrossSeriesReducer',
    'AggregationPerSeriesAligner',
    'AxisScale',
    'ChartOptionsMode',
    'DataSetPlotType',
    'DataSetTargetAxis',
    'PickTimeSeriesFilterDirection',
    'PickTimeSeriesFilterRankingMethod',
    'SparkChartViewSparkChartType',
    'TextFormat',
    'ThresholdColor',
    'ThresholdDirection',
    'ThresholdTargetAxis',
]


class AggregationCrossSeriesReducer(str, Enum):
    """
    The reduction operation to be used to combine time series into a single time series, where the value of each data point in the resulting series is a function of all the already aligned values in the input time series.Not all reducer operations can be applied to all time series. The valid choices depend on the metric_kind and the value_type of the original time series. Reduction can yield a time series with a different metric_kind or value_type than the input time series.Time series data must first be aligned (see per_series_aligner) in order to perform cross-time series reduction. If cross_series_reducer is specified, then per_series_aligner must be specified, and must not be ALIGN_NONE. An alignment_period must also be specified; otherwise, an error is returned.
    """
    REDUCE_NONE = "REDUCE_NONE"
    """
    No cross-time series reduction. The output of the Aligner is returned.
    """
    REDUCE_MEAN = "REDUCE_MEAN"
    """
    Reduce by computing the mean value across time series for each alignment period. This reducer is valid for DELTA and GAUGE metrics with numeric or distribution values. The value_type of the output is DOUBLE.
    """
    REDUCE_MIN = "REDUCE_MIN"
    """
    Reduce by computing the minimum value across time series for each alignment period. This reducer is valid for DELTA and GAUGE metrics with numeric values. The value_type of the output is the same as the value_type of the input.
    """
    REDUCE_MAX = "REDUCE_MAX"
    """
    Reduce by computing the maximum value across time series for each alignment period. This reducer is valid for DELTA and GAUGE metrics with numeric values. The value_type of the output is the same as the value_type of the input.
    """
    REDUCE_SUM = "REDUCE_SUM"
    """
    Reduce by computing the sum across time series for each alignment period. This reducer is valid for DELTA and GAUGE metrics with numeric and distribution values. The value_type of the output is the same as the value_type of the input.
    """
    REDUCE_STDDEV = "REDUCE_STDDEV"
    """
    Reduce by computing the standard deviation across time series for each alignment period. This reducer is valid for DELTA and GAUGE metrics with numeric or distribution values. The value_type of the output is DOUBLE.
    """
    REDUCE_COUNT = "REDUCE_COUNT"
    """
    Reduce by computing the number of data points across time series for each alignment period. This reducer is valid for DELTA and GAUGE metrics of numeric, Boolean, distribution, and string value_type. The value_type of the output is INT64.
    """
    REDUCE_COUNT_TRUE = "REDUCE_COUNT_TRUE"
    """
    Reduce by computing the number of True-valued data points across time series for each alignment period. This reducer is valid for DELTA and GAUGE metrics of Boolean value_type. The value_type of the output is INT64.
    """
    REDUCE_COUNT_FALSE = "REDUCE_COUNT_FALSE"
    """
    Reduce by computing the number of False-valued data points across time series for each alignment period. This reducer is valid for DELTA and GAUGE metrics of Boolean value_type. The value_type of the output is INT64.
    """
    REDUCE_FRACTION_TRUE = "REDUCE_FRACTION_TRUE"
    """
    Reduce by computing the ratio of the number of True-valued data points to the total number of data points for each alignment period. This reducer is valid for DELTA and GAUGE metrics of Boolean value_type. The output value is in the range 0.0, 1.0 and has value_type DOUBLE.
    """
    REDUCE_PERCENTILE99 = "REDUCE_PERCENTILE_99"
    """
    Reduce by computing the 99th percentile (https://en.wikipedia.org/wiki/Percentile) of data points across time series for each alignment period. This reducer is valid for GAUGE and DELTA metrics of numeric and distribution type. The value of the output is DOUBLE.
    """
    REDUCE_PERCENTILE95 = "REDUCE_PERCENTILE_95"
    """
    Reduce by computing the 95th percentile (https://en.wikipedia.org/wiki/Percentile) of data points across time series for each alignment period. This reducer is valid for GAUGE and DELTA metrics of numeric and distribution type. The value of the output is DOUBLE.
    """
    REDUCE_PERCENTILE50 = "REDUCE_PERCENTILE_50"
    """
    Reduce by computing the 50th percentile (https://en.wikipedia.org/wiki/Percentile) of data points across time series for each alignment period. This reducer is valid for GAUGE and DELTA metrics of numeric and distribution type. The value of the output is DOUBLE.
    """
    REDUCE_PERCENTILE05 = "REDUCE_PERCENTILE_05"
    """
    Reduce by computing the 5th percentile (https://en.wikipedia.org/wiki/Percentile) of data points across time series for each alignment period. This reducer is valid for GAUGE and DELTA metrics of numeric and distribution type. The value of the output is DOUBLE.
    """


class AggregationPerSeriesAligner(str, Enum):
    """
    An Aligner describes how to bring the data points in a single time series into temporal alignment. Except for ALIGN_NONE, all alignments cause all the data points in an alignment_period to be mathematically grouped together, resulting in a single data point for each alignment_period with end timestamp at the end of the period.Not all alignment operations may be applied to all time series. The valid choices depend on the metric_kind and value_type of the original time series. Alignment can change the metric_kind or the value_type of the time series.Time series data must be aligned in order to perform cross-time series reduction. If cross_series_reducer is specified, then per_series_aligner must be specified and not equal to ALIGN_NONE and alignment_period must be specified; otherwise, an error is returned.
    """
    ALIGN_NONE = "ALIGN_NONE"
    """
    No alignment. Raw data is returned. Not valid if cross-series reduction is requested. The value_type of the result is the same as the value_type of the input.
    """
    ALIGN_DELTA = "ALIGN_DELTA"
    """
    Align and convert to DELTA. The output is delta = y1 - y0.This alignment is valid for CUMULATIVE and DELTA metrics. If the selected alignment period results in periods with no data, then the aligned value for such a period is created by interpolation. The value_type of the aligned result is the same as the value_type of the input.
    """
    ALIGN_RATE = "ALIGN_RATE"
    """
    Align and convert to a rate. The result is computed as rate = (y1 - y0)/(t1 - t0), or "delta over time". Think of this aligner as providing the slope of the line that passes through the value at the start and at the end of the alignment_period.This aligner is valid for CUMULATIVE and DELTA metrics with numeric values. If the selected alignment period results in periods with no data, then the aligned value for such a period is created by interpolation. The output is a GAUGE metric with value_type DOUBLE.If, by "rate", you mean "percentage change", see the ALIGN_PERCENT_CHANGE aligner instead.
    """
    ALIGN_INTERPOLATE = "ALIGN_INTERPOLATE"
    """
    Align by interpolating between adjacent points around the alignment period boundary. This aligner is valid for GAUGE metrics with numeric values. The value_type of the aligned result is the same as the value_type of the input.
    """
    ALIGN_NEXT_OLDER = "ALIGN_NEXT_OLDER"
    """
    Align by moving the most recent data point before the end of the alignment period to the boundary at the end of the alignment period. This aligner is valid for GAUGE metrics. The value_type of the aligned result is the same as the value_type of the input.
    """
    ALIGN_MIN = "ALIGN_MIN"
    """
    Align the time series by returning the minimum value in each alignment period. This aligner is valid for GAUGE and DELTA metrics with numeric values. The value_type of the aligned result is the same as the value_type of the input.
    """
    ALIGN_MAX = "ALIGN_MAX"
    """
    Align the time series by returning the maximum value in each alignment period. This aligner is valid for GAUGE and DELTA metrics with numeric values. The value_type of the aligned result is the same as the value_type of the input.
    """
    ALIGN_MEAN = "ALIGN_MEAN"
    """
    Align the time series by returning the mean value in each alignment period. This aligner is valid for GAUGE and DELTA metrics with numeric values. The value_type of the aligned result is DOUBLE.
    """
    ALIGN_COUNT = "ALIGN_COUNT"
    """
    Align the time series by returning the number of values in each alignment period. This aligner is valid for GAUGE and DELTA metrics with numeric or Boolean values. The value_type of the aligned result is INT64.
    """
    ALIGN_SUM = "ALIGN_SUM"
    """
    Align the time series by returning the sum of the values in each alignment period. This aligner is valid for GAUGE and DELTA metrics with numeric and distribution values. The value_type of the aligned result is the same as the value_type of the input.
    """
    ALIGN_STDDEV = "ALIGN_STDDEV"
    """
    Align the time series by returning the standard deviation of the values in each alignment period. This aligner is valid for GAUGE and DELTA metrics with numeric values. The value_type of the output is DOUBLE.
    """
    ALIGN_COUNT_TRUE = "ALIGN_COUNT_TRUE"
    """
    Align the time series by returning the number of True values in each alignment period. This aligner is valid for GAUGE metrics with Boolean values. The value_type of the output is INT64.
    """
    ALIGN_COUNT_FALSE = "ALIGN_COUNT_FALSE"
    """
    Align the time series by returning the number of False values in each alignment period. This aligner is valid for GAUGE metrics with Boolean values. The value_type of the output is INT64.
    """
    ALIGN_FRACTION_TRUE = "ALIGN_FRACTION_TRUE"
    """
    Align the time series by returning the ratio of the number of True values to the total number of values in each alignment period. This aligner is valid for GAUGE metrics with Boolean values. The output value is in the range 0.0, 1.0 and has value_type DOUBLE.
    """
    ALIGN_PERCENTILE99 = "ALIGN_PERCENTILE_99"
    """
    Align the time series by using percentile aggregation (https://en.wikipedia.org/wiki/Percentile). The resulting data point in each alignment period is the 99th percentile of all data points in the period. This aligner is valid for GAUGE and DELTA metrics with distribution values. The output is a GAUGE metric with value_type DOUBLE.
    """
    ALIGN_PERCENTILE95 = "ALIGN_PERCENTILE_95"
    """
    Align the time series by using percentile aggregation (https://en.wikipedia.org/wiki/Percentile). The resulting data point in each alignment period is the 95th percentile of all data points in the period. This aligner is valid for GAUGE and DELTA metrics with distribution values. The output is a GAUGE metric with value_type DOUBLE.
    """
    ALIGN_PERCENTILE50 = "ALIGN_PERCENTILE_50"
    """
    Align the time series by using percentile aggregation (https://en.wikipedia.org/wiki/Percentile). The resulting data point in each alignment period is the 50th percentile of all data points in the period. This aligner is valid for GAUGE and DELTA metrics with distribution values. The output is a GAUGE metric with value_type DOUBLE.
    """
    ALIGN_PERCENTILE05 = "ALIGN_PERCENTILE_05"
    """
    Align the time series by using percentile aggregation (https://en.wikipedia.org/wiki/Percentile). The resulting data point in each alignment period is the 5th percentile of all data points in the period. This aligner is valid for GAUGE and DELTA metrics with distribution values. The output is a GAUGE metric with value_type DOUBLE.
    """
    ALIGN_PERCENT_CHANGE = "ALIGN_PERCENT_CHANGE"
    """
    Align and convert to a percentage change. This aligner is valid for GAUGE and DELTA metrics with numeric values. This alignment returns ((current - previous)/previous) * 100, where the value of previous is determined based on the alignment_period.If the values of current and previous are both 0, then the returned value is 0. If only previous is 0, the returned value is infinity.A 10-minute moving mean is computed at each point of the alignment period prior to the above calculation to smooth the metric and prevent false positives from very short-lived spikes. The moving mean is only applicable for data whose values are >= 0. Any values < 0 are treated as a missing datapoint, and are ignored. While DELTA metrics are accepted by this alignment, special care should be taken that the values for the metric will always be positive. The output is a GAUGE metric with value_type DOUBLE.
    """


class AxisScale(str, Enum):
    """
    The axis scale. By default, a linear scale is used.
    """
    SCALE_UNSPECIFIED = "SCALE_UNSPECIFIED"
    """
    Scale is unspecified. The view will default to LINEAR.
    """
    LINEAR = "LINEAR"
    """
    Linear scale.
    """
    LOG10 = "LOG10"
    """
    Logarithmic scale (base 10).
    """


class ChartOptionsMode(str, Enum):
    """
    The chart mode.
    """
    MODE_UNSPECIFIED = "MODE_UNSPECIFIED"
    """
    Mode is unspecified. The view will default to COLOR.
    """
    COLOR = "COLOR"
    """
    The chart distinguishes data series using different color. Line colors may get reused when there are many lines in the chart.
    """
    X_RAY = "X_RAY"
    """
    The chart uses the Stackdriver x-ray mode, in which each data set is plotted using the same semi-transparent color.
    """
    STATS = "STATS"
    """
    The chart displays statistics such as average, median, 95th percentile, and more.
    """


class DataSetPlotType(str, Enum):
    """
    How this data should be plotted on the chart.
    """
    PLOT_TYPE_UNSPECIFIED = "PLOT_TYPE_UNSPECIFIED"
    """
    Plot type is unspecified. The view will default to LINE.
    """
    LINE = "LINE"
    """
    The data is plotted as a set of lines (one line per series).
    """
    STACKED_AREA = "STACKED_AREA"
    """
    The data is plotted as a set of filled areas (one area per series), with the areas stacked vertically (the base of each area is the top of its predecessor, and the base of the first area is the X axis). Since the areas do not overlap, each is filled with a different opaque color.
    """
    STACKED_BAR = "STACKED_BAR"
    """
    The data is plotted as a set of rectangular boxes (one box per series), with the boxes stacked vertically (the base of each box is the top of its predecessor, and the base of the first box is the X axis). Since the boxes do not overlap, each is filled with a different opaque color.
    """
    HEATMAP = "HEATMAP"
    """
    The data is plotted as a heatmap. The series being plotted must have a DISTRIBUTION value type. The value of each bucket in the distribution is displayed as a color. This type is not currently available in the Stackdriver Monitoring application.
    """


class DataSetTargetAxis(str, Enum):
    """
    Optional. The target axis to use for plotting the metric.
    """
    TARGET_AXIS_UNSPECIFIED = "TARGET_AXIS_UNSPECIFIED"
    """
    The target axis was not specified. Defaults to Y1.
    """
    Y1 = "Y1"
    """
    The y_axis (the right axis of chart).
    """
    Y2 = "Y2"
    """
    The y2_axis (the left axis of chart).
    """


class PickTimeSeriesFilterDirection(str, Enum):
    """
    How to use the ranking to select time series that pass through the filter.
    """
    DIRECTION_UNSPECIFIED = "DIRECTION_UNSPECIFIED"
    """
    Not allowed. You must specify a different Direction if you specify a PickTimeSeriesFilter.
    """
    TOP = "TOP"
    """
    Pass the highest num_time_series ranking inputs.
    """
    BOTTOM = "BOTTOM"
    """
    Pass the lowest num_time_series ranking inputs.
    """


class PickTimeSeriesFilterRankingMethod(str, Enum):
    """
    ranking_method is applied to each time series independently to produce the value which will be used to compare the time series to other time series.
    """
    METHOD_UNSPECIFIED = "METHOD_UNSPECIFIED"
    """
    Not allowed. You must specify a different Method if you specify a PickTimeSeriesFilter.
    """
    METHOD_MEAN = "METHOD_MEAN"
    """
    Select the mean of all values.
    """
    METHOD_MAX = "METHOD_MAX"
    """
    Select the maximum value.
    """
    METHOD_MIN = "METHOD_MIN"
    """
    Select the minimum value.
    """
    METHOD_SUM = "METHOD_SUM"
    """
    Compute the sum of all values.
    """
    METHOD_LATEST = "METHOD_LATEST"
    """
    Select the most recent value.
    """


class SparkChartViewSparkChartType(str, Enum):
    """
    Required. The type of sparkchart to show in this chartView.
    """
    SPARK_CHART_TYPE_UNSPECIFIED = "SPARK_CHART_TYPE_UNSPECIFIED"
    """
    Not allowed in well-formed requests.
    """
    SPARK_LINE = "SPARK_LINE"
    """
    The sparkline will be rendered as a small line chart.
    """
    SPARK_BAR = "SPARK_BAR"
    """
    The sparkbar will be rendered as a small bar chart.
    """


class TextFormat(str, Enum):
    """
    How the text content is formatted.
    """
    FORMAT_UNSPECIFIED = "FORMAT_UNSPECIFIED"
    """
    Format is unspecified. Defaults to MARKDOWN.
    """
    MARKDOWN = "MARKDOWN"
    """
    The text contains Markdown formatting.
    """
    RAW = "RAW"
    """
    The text contains no special formatting.
    """


class ThresholdColor(str, Enum):
    """
    The state color for this threshold. Color is not allowed in a XyChart.
    """
    COLOR_UNSPECIFIED = "COLOR_UNSPECIFIED"
    """
    Color is unspecified. Not allowed in well-formed requests.
    """
    YELLOW = "YELLOW"
    """
    Crossing the threshold is "concerning" behavior.
    """
    RED = "RED"
    """
    Crossing the threshold is "emergency" behavior.
    """


class ThresholdDirection(str, Enum):
    """
    The direction for the current threshold. Direction is not allowed in a XyChart.
    """
    DIRECTION_UNSPECIFIED = "DIRECTION_UNSPECIFIED"
    """
    Not allowed in well-formed requests.
    """
    ABOVE = "ABOVE"
    """
    The threshold will be considered crossed if the actual value is above the threshold value.
    """
    BELOW = "BELOW"
    """
    The threshold will be considered crossed if the actual value is below the threshold value.
    """


class ThresholdTargetAxis(str, Enum):
    """
    The target axis to use for plotting the threshold. Target axis is not allowed in a Scorecard.
    """
    TARGET_AXIS_UNSPECIFIED = "TARGET_AXIS_UNSPECIFIED"
    """
    The target axis was not specified. Defaults to Y1.
    """
    Y1 = "Y1"
    """
    The y_axis (the right axis of chart).
    """
    Y2 = "Y2"
    """
    The y2_axis (the left axis of chart).
    """
