# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetRulesetResult',
    'AwaitableGetRulesetResult',
    'get_ruleset',
    'get_ruleset_output',
]

@pulumi.output_type
class GetRulesetResult:
    def __init__(__self__, create_time=None, metadata=None, name=None, source=None):
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if metadata and not isinstance(metadata, dict):
            raise TypeError("Expected argument 'metadata' to be a dict")
        pulumi.set(__self__, "metadata", metadata)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if source and not isinstance(source, dict):
            raise TypeError("Expected argument 'source' to be a dict")
        pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Time the `Ruleset` was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def metadata(self) -> 'outputs.MetadataResponse':
        """
        The metadata for this ruleset.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the `Ruleset`. The ruleset_id is auto generated by the service. Format: `projects/{project_id}/rulesets/{ruleset_id}`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def source(self) -> 'outputs.SourceResponse':
        """
        `Source` for the `Ruleset`.
        """
        return pulumi.get(self, "source")


class AwaitableGetRulesetResult(GetRulesetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRulesetResult(
            create_time=self.create_time,
            metadata=self.metadata,
            name=self.name,
            source=self.source)


def get_ruleset(project: Optional[str] = None,
                ruleset_id: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRulesetResult:
    """
    Get a `Ruleset` by name including the full `Source` contents.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['rulesetId'] = ruleset_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:firebaserules/v1:getRuleset', __args__, opts=opts, typ=GetRulesetResult).value

    return AwaitableGetRulesetResult(
        create_time=__ret__.create_time,
        metadata=__ret__.metadata,
        name=__ret__.name,
        source=__ret__.source)


@_utilities.lift_output_func(get_ruleset)
def get_ruleset_output(project: Optional[pulumi.Input[Optional[str]]] = None,
                       ruleset_id: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRulesetResult]:
    """
    Get a `Ruleset` by name including the full `Source` contents.
    """
    ...
