# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'DnsKeySpecResponse',
    'ManagedZoneCloudLoggingConfigResponse',
    'ManagedZoneDnsSecConfigResponse',
    'ManagedZoneForwardingConfigNameServerTargetResponse',
    'ManagedZoneForwardingConfigResponse',
    'ManagedZonePeeringConfigResponse',
    'ManagedZonePeeringConfigTargetNetworkResponse',
    'ManagedZonePrivateVisibilityConfigGKEClusterResponse',
    'ManagedZonePrivateVisibilityConfigNetworkResponse',
    'ManagedZonePrivateVisibilityConfigResponse',
    'ManagedZoneReverseLookupConfigResponse',
    'ManagedZoneServiceDirectoryConfigNamespaceResponse',
    'ManagedZoneServiceDirectoryConfigResponse',
    'PolicyAlternativeNameServerConfigResponse',
    'PolicyAlternativeNameServerConfigTargetNameServerResponse',
    'PolicyNetworkResponse',
    'RRSetRoutingPolicyGeoPolicyGeoPolicyItemResponse',
    'RRSetRoutingPolicyGeoPolicyResponse',
    'RRSetRoutingPolicyResponse',
    'RRSetRoutingPolicyWrrPolicyResponse',
    'RRSetRoutingPolicyWrrPolicyWrrPolicyItemResponse',
    'ResourceRecordSetResponse',
    'ResponsePolicyGKEClusterResponse',
    'ResponsePolicyNetworkResponse',
    'ResponsePolicyRuleLocalDataResponse',
]

@pulumi.output_type
class DnsKeySpecResponse(dict):
    """
    Parameters for DnsKey key generation. Used for generating initial keys for a new ManagedZone and as default when adding a new DnsKey.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyLength":
            suggest = "key_length"
        elif key == "keyType":
            suggest = "key_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DnsKeySpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DnsKeySpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DnsKeySpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm: str,
                 key_length: int,
                 key_type: str,
                 kind: str):
        """
        Parameters for DnsKey key generation. Used for generating initial keys for a new ManagedZone and as default when adding a new DnsKey.
        :param str algorithm: String mnemonic specifying the DNSSEC algorithm of this key.
        :param int key_length: Length of the keys in bits.
        :param str key_type: Specifies whether this is a key signing key (KSK) or a zone signing key (ZSK). Key signing keys have the Secure Entry Point flag set and, when active, are only used to sign resource record sets of type DNSKEY. Zone signing keys do not have the Secure Entry Point flag set and are used to sign all other types of resource record sets.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "key_length", key_length)
        pulumi.set(__self__, "key_type", key_type)
        pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter
    def algorithm(self) -> str:
        """
        String mnemonic specifying the DNSSEC algorithm of this key.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="keyLength")
    def key_length(self) -> int:
        """
        Length of the keys in bits.
        """
        return pulumi.get(self, "key_length")

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> str:
        """
        Specifies whether this is a key signing key (KSK) or a zone signing key (ZSK). Key signing keys have the Secure Entry Point flag set and, when active, are only used to sign resource record sets of type DNSKEY. Zone signing keys do not have the Secure Entry Point flag set and are used to sign all other types of resource record sets.
        """
        return pulumi.get(self, "key_type")

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")


@pulumi.output_type
class ManagedZoneCloudLoggingConfigResponse(dict):
    """
    Cloud Logging configurations for publicly visible zones.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableLogging":
            suggest = "enable_logging"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedZoneCloudLoggingConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedZoneCloudLoggingConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedZoneCloudLoggingConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_logging: bool,
                 kind: str):
        """
        Cloud Logging configurations for publicly visible zones.
        :param bool enable_logging: If set, enable query logging for this ManagedZone. False by default, making logging opt-in.
        """
        pulumi.set(__self__, "enable_logging", enable_logging)
        pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter(name="enableLogging")
    def enable_logging(self) -> bool:
        """
        If set, enable query logging for this ManagedZone. False by default, making logging opt-in.
        """
        return pulumi.get(self, "enable_logging")

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")


@pulumi.output_type
class ManagedZoneDnsSecConfigResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultKeySpecs":
            suggest = "default_key_specs"
        elif key == "nonExistence":
            suggest = "non_existence"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedZoneDnsSecConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedZoneDnsSecConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedZoneDnsSecConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_key_specs: Sequence['outputs.DnsKeySpecResponse'],
                 kind: str,
                 non_existence: str,
                 state: str):
        """
        :param Sequence['DnsKeySpecResponse'] default_key_specs: Specifies parameters for generating initial DnsKeys for this ManagedZone. Can only be changed while the state is OFF.
        :param str non_existence: Specifies the mechanism for authenticated denial-of-existence responses. Can only be changed while the state is OFF.
        :param str state: Specifies whether DNSSEC is enabled, and what mode it is in.
        """
        pulumi.set(__self__, "default_key_specs", default_key_specs)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "non_existence", non_existence)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="defaultKeySpecs")
    def default_key_specs(self) -> Sequence['outputs.DnsKeySpecResponse']:
        """
        Specifies parameters for generating initial DnsKeys for this ManagedZone. Can only be changed while the state is OFF.
        """
        return pulumi.get(self, "default_key_specs")

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="nonExistence")
    def non_existence(self) -> str:
        """
        Specifies the mechanism for authenticated denial-of-existence responses. Can only be changed while the state is OFF.
        """
        return pulumi.get(self, "non_existence")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Specifies whether DNSSEC is enabled, and what mode it is in.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class ManagedZoneForwardingConfigNameServerTargetResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "forwardingPath":
            suggest = "forwarding_path"
        elif key == "ipv4Address":
            suggest = "ipv4_address"
        elif key == "ipv6Address":
            suggest = "ipv6_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedZoneForwardingConfigNameServerTargetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedZoneForwardingConfigNameServerTargetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedZoneForwardingConfigNameServerTargetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 forwarding_path: str,
                 ipv4_address: str,
                 ipv6_address: str,
                 kind: str):
        """
        :param str forwarding_path: Forwarding path for this NameServerTarget. If unset or set to DEFAULT, Cloud DNS makes forwarding decisions based on IP address ranges; that is, RFC1918 addresses go to the VPC network, non-RFC1918 addresses go to the internet. When set to PRIVATE, Cloud DNS always sends queries through the VPC network for this target.
        :param str ipv4_address: IPv4 address of a target name server.
        :param str ipv6_address: IPv6 address of a target name server. Does not accept both fields (ipv4 & ipv6) being populated.
        """
        pulumi.set(__self__, "forwarding_path", forwarding_path)
        pulumi.set(__self__, "ipv4_address", ipv4_address)
        pulumi.set(__self__, "ipv6_address", ipv6_address)
        pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter(name="forwardingPath")
    def forwarding_path(self) -> str:
        """
        Forwarding path for this NameServerTarget. If unset or set to DEFAULT, Cloud DNS makes forwarding decisions based on IP address ranges; that is, RFC1918 addresses go to the VPC network, non-RFC1918 addresses go to the internet. When set to PRIVATE, Cloud DNS always sends queries through the VPC network for this target.
        """
        return pulumi.get(self, "forwarding_path")

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> str:
        """
        IPv4 address of a target name server.
        """
        return pulumi.get(self, "ipv4_address")

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> str:
        """
        IPv6 address of a target name server. Does not accept both fields (ipv4 & ipv6) being populated.
        """
        return pulumi.get(self, "ipv6_address")

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")


@pulumi.output_type
class ManagedZoneForwardingConfigResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetNameServers":
            suggest = "target_name_servers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedZoneForwardingConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedZoneForwardingConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedZoneForwardingConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: str,
                 target_name_servers: Sequence['outputs.ManagedZoneForwardingConfigNameServerTargetResponse']):
        """
        :param Sequence['ManagedZoneForwardingConfigNameServerTargetResponse'] target_name_servers: List of target name servers to forward to. Cloud DNS selects the best available name server if more than one target is given.
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "target_name_servers", target_name_servers)

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="targetNameServers")
    def target_name_servers(self) -> Sequence['outputs.ManagedZoneForwardingConfigNameServerTargetResponse']:
        """
        List of target name servers to forward to. Cloud DNS selects the best available name server if more than one target is given.
        """
        return pulumi.get(self, "target_name_servers")


@pulumi.output_type
class ManagedZonePeeringConfigResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetNetwork":
            suggest = "target_network"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedZonePeeringConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedZonePeeringConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedZonePeeringConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: str,
                 target_network: 'outputs.ManagedZonePeeringConfigTargetNetworkResponse'):
        """
        :param 'ManagedZonePeeringConfigTargetNetworkResponse' target_network: The network with which to peer.
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "target_network", target_network)

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="targetNetwork")
    def target_network(self) -> 'outputs.ManagedZonePeeringConfigTargetNetworkResponse':
        """
        The network with which to peer.
        """
        return pulumi.get(self, "target_network")


@pulumi.output_type
class ManagedZonePeeringConfigTargetNetworkResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deactivateTime":
            suggest = "deactivate_time"
        elif key == "networkUrl":
            suggest = "network_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedZonePeeringConfigTargetNetworkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedZonePeeringConfigTargetNetworkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedZonePeeringConfigTargetNetworkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deactivate_time: str,
                 kind: str,
                 network_url: str):
        """
        :param str deactivate_time: The time at which the zone was deactivated, in RFC 3339 date-time format. An empty string indicates that the peering connection is active. The producer network can deactivate a zone. The zone is automatically deactivated if the producer network that the zone targeted is deleted. Output only.
        :param str network_url: The fully qualified URL of the VPC network to forward queries to. This should be formatted like https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}
        """
        pulumi.set(__self__, "deactivate_time", deactivate_time)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "network_url", network_url)

    @property
    @pulumi.getter(name="deactivateTime")
    def deactivate_time(self) -> str:
        """
        The time at which the zone was deactivated, in RFC 3339 date-time format. An empty string indicates that the peering connection is active. The producer network can deactivate a zone. The zone is automatically deactivated if the producer network that the zone targeted is deleted. Output only.
        """
        return pulumi.get(self, "deactivate_time")

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="networkUrl")
    def network_url(self) -> str:
        """
        The fully qualified URL of the VPC network to forward queries to. This should be formatted like https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}
        """
        return pulumi.get(self, "network_url")


@pulumi.output_type
class ManagedZonePrivateVisibilityConfigGKEClusterResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gkeClusterName":
            suggest = "gke_cluster_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedZonePrivateVisibilityConfigGKEClusterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedZonePrivateVisibilityConfigGKEClusterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedZonePrivateVisibilityConfigGKEClusterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gke_cluster_name: str,
                 kind: str):
        """
        :param str gke_cluster_name: The resource name of the cluster to bind this ManagedZone to. This should be specified in the format like: projects/*/locations/*/clusters/*. This is referenced from GKE projects.locations.clusters.get API: https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters/get
        """
        pulumi.set(__self__, "gke_cluster_name", gke_cluster_name)
        pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter(name="gkeClusterName")
    def gke_cluster_name(self) -> str:
        """
        The resource name of the cluster to bind this ManagedZone to. This should be specified in the format like: projects/*/locations/*/clusters/*. This is referenced from GKE projects.locations.clusters.get API: https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters/get
        """
        return pulumi.get(self, "gke_cluster_name")

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")


@pulumi.output_type
class ManagedZonePrivateVisibilityConfigNetworkResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkUrl":
            suggest = "network_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedZonePrivateVisibilityConfigNetworkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedZonePrivateVisibilityConfigNetworkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedZonePrivateVisibilityConfigNetworkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: str,
                 network_url: str):
        """
        :param str network_url: The fully qualified URL of the VPC network to bind to. Format this URL like https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "network_url", network_url)

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="networkUrl")
    def network_url(self) -> str:
        """
        The fully qualified URL of the VPC network to bind to. Format this URL like https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}
        """
        return pulumi.get(self, "network_url")


@pulumi.output_type
class ManagedZonePrivateVisibilityConfigResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gkeClusters":
            suggest = "gke_clusters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedZonePrivateVisibilityConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedZonePrivateVisibilityConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedZonePrivateVisibilityConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gke_clusters: Sequence['outputs.ManagedZonePrivateVisibilityConfigGKEClusterResponse'],
                 kind: str,
                 networks: Sequence['outputs.ManagedZonePrivateVisibilityConfigNetworkResponse']):
        """
        :param Sequence['ManagedZonePrivateVisibilityConfigGKEClusterResponse'] gke_clusters: The list of Google Kubernetes Engine clusters that can see this zone.
        :param Sequence['ManagedZonePrivateVisibilityConfigNetworkResponse'] networks: The list of VPC networks that can see this zone.
        """
        pulumi.set(__self__, "gke_clusters", gke_clusters)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "networks", networks)

    @property
    @pulumi.getter(name="gkeClusters")
    def gke_clusters(self) -> Sequence['outputs.ManagedZonePrivateVisibilityConfigGKEClusterResponse']:
        """
        The list of Google Kubernetes Engine clusters that can see this zone.
        """
        return pulumi.get(self, "gke_clusters")

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def networks(self) -> Sequence['outputs.ManagedZonePrivateVisibilityConfigNetworkResponse']:
        """
        The list of VPC networks that can see this zone.
        """
        return pulumi.get(self, "networks")


@pulumi.output_type
class ManagedZoneReverseLookupConfigResponse(dict):
    def __init__(__self__, *,
                 kind: str):
        pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")


@pulumi.output_type
class ManagedZoneServiceDirectoryConfigNamespaceResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deletionTime":
            suggest = "deletion_time"
        elif key == "namespaceUrl":
            suggest = "namespace_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedZoneServiceDirectoryConfigNamespaceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedZoneServiceDirectoryConfigNamespaceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedZoneServiceDirectoryConfigNamespaceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deletion_time: str,
                 kind: str,
                 namespace_url: str):
        """
        :param str deletion_time: The time that the namespace backing this zone was deleted; an empty string if it still exists. This is in RFC3339 text format. Output only.
        :param str namespace_url: The fully qualified URL of the namespace associated with the zone. Format must be https://servicedirectory.googleapis.com/v1/projects/{project}/locations/{location}/namespaces/{namespace}
        """
        pulumi.set(__self__, "deletion_time", deletion_time)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "namespace_url", namespace_url)

    @property
    @pulumi.getter(name="deletionTime")
    def deletion_time(self) -> str:
        """
        The time that the namespace backing this zone was deleted; an empty string if it still exists. This is in RFC3339 text format. Output only.
        """
        return pulumi.get(self, "deletion_time")

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="namespaceUrl")
    def namespace_url(self) -> str:
        """
        The fully qualified URL of the namespace associated with the zone. Format must be https://servicedirectory.googleapis.com/v1/projects/{project}/locations/{location}/namespaces/{namespace}
        """
        return pulumi.get(self, "namespace_url")


@pulumi.output_type
class ManagedZoneServiceDirectoryConfigResponse(dict):
    """
    Contains information about Service Directory-backed zones.
    """
    def __init__(__self__, *,
                 kind: str,
                 namespace: 'outputs.ManagedZoneServiceDirectoryConfigNamespaceResponse'):
        """
        Contains information about Service Directory-backed zones.
        :param 'ManagedZoneServiceDirectoryConfigNamespaceResponse' namespace: Contains information about the namespace associated with the zone.
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def namespace(self) -> 'outputs.ManagedZoneServiceDirectoryConfigNamespaceResponse':
        """
        Contains information about the namespace associated with the zone.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class PolicyAlternativeNameServerConfigResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetNameServers":
            suggest = "target_name_servers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyAlternativeNameServerConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyAlternativeNameServerConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyAlternativeNameServerConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: str,
                 target_name_servers: Sequence['outputs.PolicyAlternativeNameServerConfigTargetNameServerResponse']):
        """
        :param Sequence['PolicyAlternativeNameServerConfigTargetNameServerResponse'] target_name_servers: Sets an alternative name server for the associated networks. When specified, all DNS queries are forwarded to a name server that you choose. Names such as .internal are not available when an alternative name server is specified.
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "target_name_servers", target_name_servers)

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="targetNameServers")
    def target_name_servers(self) -> Sequence['outputs.PolicyAlternativeNameServerConfigTargetNameServerResponse']:
        """
        Sets an alternative name server for the associated networks. When specified, all DNS queries are forwarded to a name server that you choose. Names such as .internal are not available when an alternative name server is specified.
        """
        return pulumi.get(self, "target_name_servers")


@pulumi.output_type
class PolicyAlternativeNameServerConfigTargetNameServerResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "forwardingPath":
            suggest = "forwarding_path"
        elif key == "ipv4Address":
            suggest = "ipv4_address"
        elif key == "ipv6Address":
            suggest = "ipv6_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyAlternativeNameServerConfigTargetNameServerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyAlternativeNameServerConfigTargetNameServerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyAlternativeNameServerConfigTargetNameServerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 forwarding_path: str,
                 ipv4_address: str,
                 ipv6_address: str,
                 kind: str):
        """
        :param str forwarding_path: Forwarding path for this TargetNameServer. If unset or set to DEFAULT, Cloud DNS makes forwarding decisions based on address ranges; that is, RFC1918 addresses go to the VPC network, non-RFC1918 addresses go to the internet. When set to PRIVATE, Cloud DNS always sends queries through the VPC network for this target.
        :param str ipv4_address: IPv4 address to forward to.
        :param str ipv6_address: IPv6 address to forward to. Does not accept both fields (ipv4 & ipv6) being populated.
        """
        pulumi.set(__self__, "forwarding_path", forwarding_path)
        pulumi.set(__self__, "ipv4_address", ipv4_address)
        pulumi.set(__self__, "ipv6_address", ipv6_address)
        pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter(name="forwardingPath")
    def forwarding_path(self) -> str:
        """
        Forwarding path for this TargetNameServer. If unset or set to DEFAULT, Cloud DNS makes forwarding decisions based on address ranges; that is, RFC1918 addresses go to the VPC network, non-RFC1918 addresses go to the internet. When set to PRIVATE, Cloud DNS always sends queries through the VPC network for this target.
        """
        return pulumi.get(self, "forwarding_path")

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> str:
        """
        IPv4 address to forward to.
        """
        return pulumi.get(self, "ipv4_address")

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> str:
        """
        IPv6 address to forward to. Does not accept both fields (ipv4 & ipv6) being populated.
        """
        return pulumi.get(self, "ipv6_address")

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")


@pulumi.output_type
class PolicyNetworkResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkUrl":
            suggest = "network_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyNetworkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyNetworkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyNetworkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: str,
                 network_url: str):
        """
        :param str network_url: The fully qualified URL of the VPC network to bind to. This should be formatted like https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "network_url", network_url)

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="networkUrl")
    def network_url(self) -> str:
        """
        The fully qualified URL of the VPC network to bind to. This should be formatted like https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}
        """
        return pulumi.get(self, "network_url")


@pulumi.output_type
class RRSetRoutingPolicyGeoPolicyGeoPolicyItemResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "signatureRrdatas":
            suggest = "signature_rrdatas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RRSetRoutingPolicyGeoPolicyGeoPolicyItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RRSetRoutingPolicyGeoPolicyGeoPolicyItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RRSetRoutingPolicyGeoPolicyGeoPolicyItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: str,
                 location: str,
                 rrdatas: Sequence[str],
                 signature_rrdatas: Sequence[str]):
        """
        :param str location: The geo-location granularity is a GCP region. This location string should correspond to a GCP region. e.g. "us-east1", "southamerica-east1", "asia-east1", etc.
        :param Sequence[str] signature_rrdatas: DNSSEC generated signatures for the above geo_rrdata.
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "rrdatas", rrdatas)
        pulumi.set(__self__, "signature_rrdatas", signature_rrdatas)

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The geo-location granularity is a GCP region. This location string should correspond to a GCP region. e.g. "us-east1", "southamerica-east1", "asia-east1", etc.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def rrdatas(self) -> Sequence[str]:
        return pulumi.get(self, "rrdatas")

    @property
    @pulumi.getter(name="signatureRrdatas")
    def signature_rrdatas(self) -> Sequence[str]:
        """
        DNSSEC generated signatures for the above geo_rrdata.
        """
        return pulumi.get(self, "signature_rrdatas")


@pulumi.output_type
class RRSetRoutingPolicyGeoPolicyResponse(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.RRSetRoutingPolicyGeoPolicyGeoPolicyItemResponse'],
                 kind: str):
        """
        :param Sequence['RRSetRoutingPolicyGeoPolicyGeoPolicyItemResponse'] items: The primary geo routing configuration. If there are multiple items with the same location, an error is returned instead.
        """
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.RRSetRoutingPolicyGeoPolicyGeoPolicyItemResponse']:
        """
        The primary geo routing configuration. If there are multiple items with the same location, an error is returned instead.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")


@pulumi.output_type
class RRSetRoutingPolicyResponse(dict):
    """
    A RRSetRoutingPolicy represents ResourceRecordSet data that is returned dynamically with the response varying based on configured properties such as geolocation or by weighted random selection.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "geoPolicy":
            suggest = "geo_policy"
        elif key == "wrrPolicy":
            suggest = "wrr_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RRSetRoutingPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RRSetRoutingPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RRSetRoutingPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 geo: 'outputs.RRSetRoutingPolicyGeoPolicyResponse',
                 geo_policy: 'outputs.RRSetRoutingPolicyGeoPolicyResponse',
                 kind: str,
                 wrr: 'outputs.RRSetRoutingPolicyWrrPolicyResponse',
                 wrr_policy: 'outputs.RRSetRoutingPolicyWrrPolicyResponse'):
        """
        A RRSetRoutingPolicy represents ResourceRecordSet data that is returned dynamically with the response varying based on configured properties such as geolocation or by weighted random selection.
        """
        pulumi.set(__self__, "geo", geo)
        pulumi.set(__self__, "geo_policy", geo_policy)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "wrr", wrr)
        pulumi.set(__self__, "wrr_policy", wrr_policy)

    @property
    @pulumi.getter
    def geo(self) -> 'outputs.RRSetRoutingPolicyGeoPolicyResponse':
        return pulumi.get(self, "geo")

    @property
    @pulumi.getter(name="geoPolicy")
    def geo_policy(self) -> 'outputs.RRSetRoutingPolicyGeoPolicyResponse':
        return pulumi.get(self, "geo_policy")

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def wrr(self) -> 'outputs.RRSetRoutingPolicyWrrPolicyResponse':
        return pulumi.get(self, "wrr")

    @property
    @pulumi.getter(name="wrrPolicy")
    def wrr_policy(self) -> 'outputs.RRSetRoutingPolicyWrrPolicyResponse':
        return pulumi.get(self, "wrr_policy")


@pulumi.output_type
class RRSetRoutingPolicyWrrPolicyResponse(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.RRSetRoutingPolicyWrrPolicyWrrPolicyItemResponse'],
                 kind: str):
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.RRSetRoutingPolicyWrrPolicyWrrPolicyItemResponse']:
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")


@pulumi.output_type
class RRSetRoutingPolicyWrrPolicyWrrPolicyItemResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "signatureRrdatas":
            suggest = "signature_rrdatas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RRSetRoutingPolicyWrrPolicyWrrPolicyItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RRSetRoutingPolicyWrrPolicyWrrPolicyItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RRSetRoutingPolicyWrrPolicyWrrPolicyItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: str,
                 rrdatas: Sequence[str],
                 signature_rrdatas: Sequence[str],
                 weight: float):
        """
        :param Sequence[str] signature_rrdatas: DNSSEC generated signatures for the above wrr_rrdata.
        :param float weight: The weight corresponding to this subset of rrdata. When multiple WeightedRoundRobinPolicyItems are configured, the probability of returning an rrset is proportional to its weight relative to the sum of weights configured for all items. This weight should be non-negative.
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "rrdatas", rrdatas)
        pulumi.set(__self__, "signature_rrdatas", signature_rrdatas)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def rrdatas(self) -> Sequence[str]:
        return pulumi.get(self, "rrdatas")

    @property
    @pulumi.getter(name="signatureRrdatas")
    def signature_rrdatas(self) -> Sequence[str]:
        """
        DNSSEC generated signatures for the above wrr_rrdata.
        """
        return pulumi.get(self, "signature_rrdatas")

    @property
    @pulumi.getter
    def weight(self) -> float:
        """
        The weight corresponding to this subset of rrdata. When multiple WeightedRoundRobinPolicyItems are configured, the probability of returning an rrset is proportional to its weight relative to the sum of weights configured for all items. This weight should be non-negative.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class ResourceRecordSetResponse(dict):
    """
    A unit of data that is returned by the DNS servers.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "routingPolicy":
            suggest = "routing_policy"
        elif key == "signatureRrdatas":
            suggest = "signature_rrdatas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceRecordSetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceRecordSetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceRecordSetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: str,
                 name: str,
                 routing_policy: 'outputs.RRSetRoutingPolicyResponse',
                 rrdatas: Sequence[str],
                 signature_rrdatas: Sequence[str],
                 ttl: int,
                 type: str):
        """
        A unit of data that is returned by the DNS servers.
        :param str name: For example, www.example.com.
        :param 'RRSetRoutingPolicyResponse' routing_policy: Configures dynamic query responses based on geo location of querying user or a weighted round robin based routing policy. A ResourceRecordSet should only have either rrdata (static) or routing_policy (dynamic). An error is returned otherwise.
        :param Sequence[str] rrdatas: As defined in RFC 1035 (section 5) and RFC 1034 (section 3.6.1) -- see examples.
        :param Sequence[str] signature_rrdatas: As defined in RFC 4034 (section 3.2).
        :param int ttl: Number of seconds that this ResourceRecordSet can be cached by resolvers.
        :param str type: The identifier of a supported record type. See the list of Supported DNS record types.
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "routing_policy", routing_policy)
        pulumi.set(__self__, "rrdatas", rrdatas)
        pulumi.set(__self__, "signature_rrdatas", signature_rrdatas)
        pulumi.set(__self__, "ttl", ttl)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        For example, www.example.com.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="routingPolicy")
    def routing_policy(self) -> 'outputs.RRSetRoutingPolicyResponse':
        """
        Configures dynamic query responses based on geo location of querying user or a weighted round robin based routing policy. A ResourceRecordSet should only have either rrdata (static) or routing_policy (dynamic). An error is returned otherwise.
        """
        return pulumi.get(self, "routing_policy")

    @property
    @pulumi.getter
    def rrdatas(self) -> Sequence[str]:
        """
        As defined in RFC 1035 (section 5) and RFC 1034 (section 3.6.1) -- see examples.
        """
        return pulumi.get(self, "rrdatas")

    @property
    @pulumi.getter(name="signatureRrdatas")
    def signature_rrdatas(self) -> Sequence[str]:
        """
        As defined in RFC 4034 (section 3.2).
        """
        return pulumi.get(self, "signature_rrdatas")

    @property
    @pulumi.getter
    def ttl(self) -> int:
        """
        Number of seconds that this ResourceRecordSet can be cached by resolvers.
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The identifier of a supported record type. See the list of Supported DNS record types.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ResponsePolicyGKEClusterResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gkeClusterName":
            suggest = "gke_cluster_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponsePolicyGKEClusterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponsePolicyGKEClusterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponsePolicyGKEClusterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gke_cluster_name: str,
                 kind: str):
        """
        :param str gke_cluster_name: The resource name of the cluster to bind this response policy to. This should be specified in the format like: projects/*/locations/*/clusters/*. This is referenced from GKE projects.locations.clusters.get API: https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters/get
        """
        pulumi.set(__self__, "gke_cluster_name", gke_cluster_name)
        pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter(name="gkeClusterName")
    def gke_cluster_name(self) -> str:
        """
        The resource name of the cluster to bind this response policy to. This should be specified in the format like: projects/*/locations/*/clusters/*. This is referenced from GKE projects.locations.clusters.get API: https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters/get
        """
        return pulumi.get(self, "gke_cluster_name")

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")


@pulumi.output_type
class ResponsePolicyNetworkResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkUrl":
            suggest = "network_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponsePolicyNetworkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponsePolicyNetworkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponsePolicyNetworkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: str,
                 network_url: str):
        """
        :param str network_url: The fully qualified URL of the VPC network to bind to. This should be formatted like https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "network_url", network_url)

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="networkUrl")
    def network_url(self) -> str:
        """
        The fully qualified URL of the VPC network to bind to. This should be formatted like https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}
        """
        return pulumi.get(self, "network_url")


@pulumi.output_type
class ResponsePolicyRuleLocalDataResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localDatas":
            suggest = "local_datas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponsePolicyRuleLocalDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponsePolicyRuleLocalDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponsePolicyRuleLocalDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 local_datas: Sequence['outputs.ResourceRecordSetResponse']):
        """
        :param Sequence['ResourceRecordSetResponse'] local_datas: All resource record sets for this selector, one per resource record type. The name must match the dns_name.
        """
        pulumi.set(__self__, "local_datas", local_datas)

    @property
    @pulumi.getter(name="localDatas")
    def local_datas(self) -> Sequence['outputs.ResourceRecordSetResponse']:
        """
        All resource record sets for this selector, one per resource record type. The name must match the dns_name.
        """
        return pulumi.get(self, "local_datas")


