# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'BindingResponse',
    'ExprResponse',
    'GoogleCloudDatacatalogV1BigQueryConnectionSpecResponse',
    'GoogleCloudDatacatalogV1BigQueryDateShardedSpecResponse',
    'GoogleCloudDatacatalogV1BigQueryRoutineSpecResponse',
    'GoogleCloudDatacatalogV1BigQueryTableSpecResponse',
    'GoogleCloudDatacatalogV1CloudSqlBigQueryConnectionSpecResponse',
    'GoogleCloudDatacatalogV1ColumnSchemaResponse',
    'GoogleCloudDatacatalogV1DataSourceConnectionSpecResponse',
    'GoogleCloudDatacatalogV1DataSourceResponse',
    'GoogleCloudDatacatalogV1DatabaseTableSpecResponse',
    'GoogleCloudDatacatalogV1GcsFileSpecResponse',
    'GoogleCloudDatacatalogV1GcsFilesetSpecResponse',
    'GoogleCloudDatacatalogV1PersonalDetailsResponse',
    'GoogleCloudDatacatalogV1RoutineSpecArgumentResponse',
    'GoogleCloudDatacatalogV1RoutineSpecResponse',
    'GoogleCloudDatacatalogV1SchemaResponse',
    'GoogleCloudDatacatalogV1SystemTimestampsResponse',
    'GoogleCloudDatacatalogV1TableSpecResponse',
    'GoogleCloudDatacatalogV1UsageSignalResponse',
    'GoogleCloudDatacatalogV1ViewSpecResponse',
]

@pulumi.output_type
class BindingResponse(dict):
    """
    Associates `members`, or principals, with a `role`.
    """
    def __init__(__self__, *,
                 condition: 'outputs.ExprResponse',
                 members: Sequence[str],
                 role: str):
        """
        Associates `members`, or principals, with a `role`.
        :param 'ExprResponse' condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param Sequence[str] members: Specifies the principals requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param str role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.ExprResponse':
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        Specifies the principals requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class ExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class GoogleCloudDatacatalogV1BigQueryConnectionSpecResponse(dict):
    """
    Specification for the BigQuery connection.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudSql":
            suggest = "cloud_sql"
        elif key == "connectionType":
            suggest = "connection_type"
        elif key == "hasCredential":
            suggest = "has_credential"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatacatalogV1BigQueryConnectionSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatacatalogV1BigQueryConnectionSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatacatalogV1BigQueryConnectionSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_sql: 'outputs.GoogleCloudDatacatalogV1CloudSqlBigQueryConnectionSpecResponse',
                 connection_type: str,
                 has_credential: bool):
        """
        Specification for the BigQuery connection.
        :param 'GoogleCloudDatacatalogV1CloudSqlBigQueryConnectionSpecResponse' cloud_sql: Specification for the BigQuery connection to a Cloud SQL instance.
        :param str connection_type: The type of the BigQuery connection.
        :param bool has_credential: True if there are credentials attached to the BigQuery connection; false otherwise.
        """
        pulumi.set(__self__, "cloud_sql", cloud_sql)
        pulumi.set(__self__, "connection_type", connection_type)
        pulumi.set(__self__, "has_credential", has_credential)

    @property
    @pulumi.getter(name="cloudSql")
    def cloud_sql(self) -> 'outputs.GoogleCloudDatacatalogV1CloudSqlBigQueryConnectionSpecResponse':
        """
        Specification for the BigQuery connection to a Cloud SQL instance.
        """
        return pulumi.get(self, "cloud_sql")

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> str:
        """
        The type of the BigQuery connection.
        """
        return pulumi.get(self, "connection_type")

    @property
    @pulumi.getter(name="hasCredential")
    def has_credential(self) -> bool:
        """
        True if there are credentials attached to the BigQuery connection; false otherwise.
        """
        return pulumi.get(self, "has_credential")


@pulumi.output_type
class GoogleCloudDatacatalogV1BigQueryDateShardedSpecResponse(dict):
    """
    Specification for a group of BigQuery tables with the `[prefix]YYYYMMDD` name pattern. For more information, see [Introduction to partitioned tables] (https://cloud.google.com/bigquery/docs/partitioned-tables#partitioning_versus_sharding).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "latestShardResource":
            suggest = "latest_shard_resource"
        elif key == "shardCount":
            suggest = "shard_count"
        elif key == "tablePrefix":
            suggest = "table_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatacatalogV1BigQueryDateShardedSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatacatalogV1BigQueryDateShardedSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatacatalogV1BigQueryDateShardedSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset: str,
                 latest_shard_resource: str,
                 shard_count: str,
                 table_prefix: str):
        """
        Specification for a group of BigQuery tables with the `[prefix]YYYYMMDD` name pattern. For more information, see [Introduction to partitioned tables] (https://cloud.google.com/bigquery/docs/partitioned-tables#partitioning_versus_sharding).
        :param str dataset: The Data Catalog resource name of the dataset entry the current table belongs to. For example: `projects/{PROJECT_ID}/locations/{LOCATION}/entrygroups/{ENTRY_GROUP_ID}/entries/{ENTRY_ID}`.
        :param str latest_shard_resource: BigQuery resource name of the latest shard.
        :param str shard_count: Total number of shards.
        :param str table_prefix: The table name prefix of the shards. The name of any given shard is `[table_prefix]YYYYMMDD`. For example, for the `MyTable20180101` shard, the `table_prefix` is `MyTable`.
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "latest_shard_resource", latest_shard_resource)
        pulumi.set(__self__, "shard_count", shard_count)
        pulumi.set(__self__, "table_prefix", table_prefix)

    @property
    @pulumi.getter
    def dataset(self) -> str:
        """
        The Data Catalog resource name of the dataset entry the current table belongs to. For example: `projects/{PROJECT_ID}/locations/{LOCATION}/entrygroups/{ENTRY_GROUP_ID}/entries/{ENTRY_ID}`.
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter(name="latestShardResource")
    def latest_shard_resource(self) -> str:
        """
        BigQuery resource name of the latest shard.
        """
        return pulumi.get(self, "latest_shard_resource")

    @property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> str:
        """
        Total number of shards.
        """
        return pulumi.get(self, "shard_count")

    @property
    @pulumi.getter(name="tablePrefix")
    def table_prefix(self) -> str:
        """
        The table name prefix of the shards. The name of any given shard is `[table_prefix]YYYYMMDD`. For example, for the `MyTable20180101` shard, the `table_prefix` is `MyTable`.
        """
        return pulumi.get(self, "table_prefix")


@pulumi.output_type
class GoogleCloudDatacatalogV1BigQueryRoutineSpecResponse(dict):
    """
    Fields specific for BigQuery routines.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "importedLibraries":
            suggest = "imported_libraries"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatacatalogV1BigQueryRoutineSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatacatalogV1BigQueryRoutineSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatacatalogV1BigQueryRoutineSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 imported_libraries: Sequence[str]):
        """
        Fields specific for BigQuery routines.
        :param Sequence[str] imported_libraries: Paths of the imported libraries.
        """
        pulumi.set(__self__, "imported_libraries", imported_libraries)

    @property
    @pulumi.getter(name="importedLibraries")
    def imported_libraries(self) -> Sequence[str]:
        """
        Paths of the imported libraries.
        """
        return pulumi.get(self, "imported_libraries")


@pulumi.output_type
class GoogleCloudDatacatalogV1BigQueryTableSpecResponse(dict):
    """
    Describes a BigQuery table.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tableSourceType":
            suggest = "table_source_type"
        elif key == "tableSpec":
            suggest = "table_spec"
        elif key == "viewSpec":
            suggest = "view_spec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatacatalogV1BigQueryTableSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatacatalogV1BigQueryTableSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatacatalogV1BigQueryTableSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 table_source_type: str,
                 table_spec: 'outputs.GoogleCloudDatacatalogV1TableSpecResponse',
                 view_spec: 'outputs.GoogleCloudDatacatalogV1ViewSpecResponse'):
        """
        Describes a BigQuery table.
        :param str table_source_type: The table source type.
        :param 'GoogleCloudDatacatalogV1TableSpecResponse' table_spec: Specification of a BigQuery table. Populated only if the `table_source_type` is `BIGQUERY_TABLE`.
        :param 'GoogleCloudDatacatalogV1ViewSpecResponse' view_spec: Table view specification. Populated only if the `table_source_type` is `BIGQUERY_VIEW`.
        """
        pulumi.set(__self__, "table_source_type", table_source_type)
        pulumi.set(__self__, "table_spec", table_spec)
        pulumi.set(__self__, "view_spec", view_spec)

    @property
    @pulumi.getter(name="tableSourceType")
    def table_source_type(self) -> str:
        """
        The table source type.
        """
        return pulumi.get(self, "table_source_type")

    @property
    @pulumi.getter(name="tableSpec")
    def table_spec(self) -> 'outputs.GoogleCloudDatacatalogV1TableSpecResponse':
        """
        Specification of a BigQuery table. Populated only if the `table_source_type` is `BIGQUERY_TABLE`.
        """
        return pulumi.get(self, "table_spec")

    @property
    @pulumi.getter(name="viewSpec")
    def view_spec(self) -> 'outputs.GoogleCloudDatacatalogV1ViewSpecResponse':
        """
        Table view specification. Populated only if the `table_source_type` is `BIGQUERY_VIEW`.
        """
        return pulumi.get(self, "view_spec")


@pulumi.output_type
class GoogleCloudDatacatalogV1CloudSqlBigQueryConnectionSpecResponse(dict):
    """
    Specification for the BigQuery connection to a Cloud SQL instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceId":
            suggest = "instance_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatacatalogV1CloudSqlBigQueryConnectionSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatacatalogV1CloudSqlBigQueryConnectionSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatacatalogV1CloudSqlBigQueryConnectionSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database: str,
                 instance_id: str,
                 type: str):
        """
        Specification for the BigQuery connection to a Cloud SQL instance.
        :param str database: Database name.
        :param str instance_id: Cloud SQL instance ID in the format of `project:location:instance`.
        :param str type: Type of the Cloud SQL database.
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        Database name.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        Cloud SQL instance ID in the format of `project:location:instance`.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the Cloud SQL database.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GoogleCloudDatacatalogV1ColumnSchemaResponse(dict):
    """
    A column within a schema. Columns can be nested inside other columns.
    """
    def __init__(__self__, *,
                 column: str,
                 description: str,
                 mode: str,
                 subcolumns: Sequence['outputs.GoogleCloudDatacatalogV1ColumnSchemaResponse'],
                 type: str):
        """
        A column within a schema. Columns can be nested inside other columns.
        :param str column: Name of the column. Must be a UTF-8 string without dots (.). The maximum size is 64 bytes.
        :param str description: Optional. Description of the column. Default value is an empty string. The description must be a UTF-8 string with the maximum size of 2000 bytes.
        :param str mode: Optional. A column's mode indicates whether values in this column are required, nullable, or repeated. Only `NULLABLE`, `REQUIRED`, and `REPEATED` values are supported. Default mode is `NULLABLE`.
        :param Sequence['GoogleCloudDatacatalogV1ColumnSchemaResponse'] subcolumns: Optional. Schema of sub-columns. A column can have zero or more sub-columns.
        :param str type: Type of the column. Must be a UTF-8 string with the maximum size of 128 bytes.
        """
        pulumi.set(__self__, "column", column)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "subcolumns", subcolumns)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def column(self) -> str:
        """
        Name of the column. Must be a UTF-8 string without dots (.). The maximum size is 64 bytes.
        """
        return pulumi.get(self, "column")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the column. Default value is an empty string. The description must be a UTF-8 string with the maximum size of 2000 bytes.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        Optional. A column's mode indicates whether values in this column are required, nullable, or repeated. Only `NULLABLE`, `REQUIRED`, and `REPEATED` values are supported. Default mode is `NULLABLE`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def subcolumns(self) -> Sequence['outputs.GoogleCloudDatacatalogV1ColumnSchemaResponse']:
        """
        Optional. Schema of sub-columns. A column can have zero or more sub-columns.
        """
        return pulumi.get(self, "subcolumns")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the column. Must be a UTF-8 string with the maximum size of 128 bytes.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GoogleCloudDatacatalogV1DataSourceConnectionSpecResponse(dict):
    """
    Specification that applies to a data source connection. Valid only for entries with the `DATA_SOURCE_CONNECTION` type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bigqueryConnectionSpec":
            suggest = "bigquery_connection_spec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatacatalogV1DataSourceConnectionSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatacatalogV1DataSourceConnectionSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatacatalogV1DataSourceConnectionSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bigquery_connection_spec: 'outputs.GoogleCloudDatacatalogV1BigQueryConnectionSpecResponse'):
        """
        Specification that applies to a data source connection. Valid only for entries with the `DATA_SOURCE_CONNECTION` type.
        :param 'GoogleCloudDatacatalogV1BigQueryConnectionSpecResponse' bigquery_connection_spec: Fields specific to BigQuery connections.
        """
        pulumi.set(__self__, "bigquery_connection_spec", bigquery_connection_spec)

    @property
    @pulumi.getter(name="bigqueryConnectionSpec")
    def bigquery_connection_spec(self) -> 'outputs.GoogleCloudDatacatalogV1BigQueryConnectionSpecResponse':
        """
        Fields specific to BigQuery connections.
        """
        return pulumi.get(self, "bigquery_connection_spec")


@pulumi.output_type
class GoogleCloudDatacatalogV1DataSourceResponse(dict):
    """
    Physical location of an entry.
    """
    def __init__(__self__, *,
                 resource: str,
                 service: str):
        """
        Physical location of an entry.
        :param str resource: Full name of a resource as defined by the service. For example: `//bigquery.googleapis.com/projects/{PROJECT_ID}/locations/{LOCATION}/datasets/{DATASET_ID}/tables/{TABLE_ID}`
        :param str service: Service that physically stores the data.
        """
        pulumi.set(__self__, "resource", resource)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def resource(self) -> str:
        """
        Full name of a resource as defined by the service. For example: `//bigquery.googleapis.com/projects/{PROJECT_ID}/locations/{LOCATION}/datasets/{DATASET_ID}/tables/{TABLE_ID}`
        """
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Service that physically stores the data.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class GoogleCloudDatacatalogV1DatabaseTableSpecResponse(dict):
    """
    Specification that applies to a table resource. Valid only for entries with the `TABLE` type.
    """
    def __init__(__self__, *,
                 type: str):
        """
        Specification that applies to a table resource. Valid only for entries with the `TABLE` type.
        :param str type: Type of this table.
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of this table.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GoogleCloudDatacatalogV1GcsFileSpecResponse(dict):
    """
    Specification of a single file in Cloud Storage.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filePath":
            suggest = "file_path"
        elif key == "gcsTimestamps":
            suggest = "gcs_timestamps"
        elif key == "sizeBytes":
            suggest = "size_bytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatacatalogV1GcsFileSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatacatalogV1GcsFileSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatacatalogV1GcsFileSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_path: str,
                 gcs_timestamps: 'outputs.GoogleCloudDatacatalogV1SystemTimestampsResponse',
                 size_bytes: str):
        """
        Specification of a single file in Cloud Storage.
        :param str file_path: Full file path. Example: `gs://bucket_name/a/b.txt`.
        :param 'GoogleCloudDatacatalogV1SystemTimestampsResponse' gcs_timestamps: Creation, modification, and expiration timestamps of a Cloud Storage file.
        :param str size_bytes: File size in bytes.
        """
        pulumi.set(__self__, "file_path", file_path)
        pulumi.set(__self__, "gcs_timestamps", gcs_timestamps)
        pulumi.set(__self__, "size_bytes", size_bytes)

    @property
    @pulumi.getter(name="filePath")
    def file_path(self) -> str:
        """
        Full file path. Example: `gs://bucket_name/a/b.txt`.
        """
        return pulumi.get(self, "file_path")

    @property
    @pulumi.getter(name="gcsTimestamps")
    def gcs_timestamps(self) -> 'outputs.GoogleCloudDatacatalogV1SystemTimestampsResponse':
        """
        Creation, modification, and expiration timestamps of a Cloud Storage file.
        """
        return pulumi.get(self, "gcs_timestamps")

    @property
    @pulumi.getter(name="sizeBytes")
    def size_bytes(self) -> str:
        """
        File size in bytes.
        """
        return pulumi.get(self, "size_bytes")


@pulumi.output_type
class GoogleCloudDatacatalogV1GcsFilesetSpecResponse(dict):
    """
    Describes a Cloud Storage fileset entry.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filePatterns":
            suggest = "file_patterns"
        elif key == "sampleGcsFileSpecs":
            suggest = "sample_gcs_file_specs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatacatalogV1GcsFilesetSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatacatalogV1GcsFilesetSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatacatalogV1GcsFilesetSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_patterns: Sequence[str],
                 sample_gcs_file_specs: Sequence['outputs.GoogleCloudDatacatalogV1GcsFileSpecResponse']):
        """
        Describes a Cloud Storage fileset entry.
        :param Sequence[str] file_patterns: Patterns to identify a set of files in Google Cloud Storage. For more information, see [Wildcard Names] (https://cloud.google.com/storage/docs/gsutil/addlhelp/WildcardNames). Note: Currently, bucket wildcards are not supported. Examples of valid `file_patterns`: * `gs://bucket_name/dir/*`: matches all files in `bucket_name/dir` directory * `gs://bucket_name/dir/**`: matches all files in `bucket_name/dir` and all subdirectories * `gs://bucket_name/file*`: matches files prefixed by `file` in `bucket_name` * `gs://bucket_name/??.txt`: matches files with two characters followed by `.txt` in `bucket_name` * `gs://bucket_name/[aeiou].txt`: matches files that contain a single vowel character followed by `.txt` in `bucket_name` * `gs://bucket_name/[a-m].txt`: matches files that contain `a`, `b`, ... or `m` followed by `.txt` in `bucket_name` * `gs://bucket_name/a/*/b`: matches all files in `bucket_name` that match the `a/*/b` pattern, such as `a/c/b`, `a/d/b` * `gs://another_bucket/a.txt`: matches `gs://another_bucket/a.txt` You can combine wildcards to match complex sets of files, for example: `gs://bucket_name/[a-m]??.j*g`
        :param Sequence['GoogleCloudDatacatalogV1GcsFileSpecResponse'] sample_gcs_file_specs: Sample files contained in this fileset, not all files contained in this fileset are represented here.
        """
        pulumi.set(__self__, "file_patterns", file_patterns)
        pulumi.set(__self__, "sample_gcs_file_specs", sample_gcs_file_specs)

    @property
    @pulumi.getter(name="filePatterns")
    def file_patterns(self) -> Sequence[str]:
        """
        Patterns to identify a set of files in Google Cloud Storage. For more information, see [Wildcard Names] (https://cloud.google.com/storage/docs/gsutil/addlhelp/WildcardNames). Note: Currently, bucket wildcards are not supported. Examples of valid `file_patterns`: * `gs://bucket_name/dir/*`: matches all files in `bucket_name/dir` directory * `gs://bucket_name/dir/**`: matches all files in `bucket_name/dir` and all subdirectories * `gs://bucket_name/file*`: matches files prefixed by `file` in `bucket_name` * `gs://bucket_name/??.txt`: matches files with two characters followed by `.txt` in `bucket_name` * `gs://bucket_name/[aeiou].txt`: matches files that contain a single vowel character followed by `.txt` in `bucket_name` * `gs://bucket_name/[a-m].txt`: matches files that contain `a`, `b`, ... or `m` followed by `.txt` in `bucket_name` * `gs://bucket_name/a/*/b`: matches all files in `bucket_name` that match the `a/*/b` pattern, such as `a/c/b`, `a/d/b` * `gs://another_bucket/a.txt`: matches `gs://another_bucket/a.txt` You can combine wildcards to match complex sets of files, for example: `gs://bucket_name/[a-m]??.j*g`
        """
        return pulumi.get(self, "file_patterns")

    @property
    @pulumi.getter(name="sampleGcsFileSpecs")
    def sample_gcs_file_specs(self) -> Sequence['outputs.GoogleCloudDatacatalogV1GcsFileSpecResponse']:
        """
        Sample files contained in this fileset, not all files contained in this fileset are represented here.
        """
        return pulumi.get(self, "sample_gcs_file_specs")


@pulumi.output_type
class GoogleCloudDatacatalogV1PersonalDetailsResponse(dict):
    """
    Entry metadata relevant only to the user and private to them.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "starTime":
            suggest = "star_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatacatalogV1PersonalDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatacatalogV1PersonalDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatacatalogV1PersonalDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 star_time: str,
                 starred: bool):
        """
        Entry metadata relevant only to the user and private to them.
        :param str star_time: Set if the entry is starred; unset otherwise.
        :param bool starred: True if the entry is starred by the user; false otherwise.
        """
        pulumi.set(__self__, "star_time", star_time)
        pulumi.set(__self__, "starred", starred)

    @property
    @pulumi.getter(name="starTime")
    def star_time(self) -> str:
        """
        Set if the entry is starred; unset otherwise.
        """
        return pulumi.get(self, "star_time")

    @property
    @pulumi.getter
    def starred(self) -> bool:
        """
        True if the entry is starred by the user; false otherwise.
        """
        return pulumi.get(self, "starred")


@pulumi.output_type
class GoogleCloudDatacatalogV1RoutineSpecArgumentResponse(dict):
    """
    Input or output argument of a function or stored procedure.
    """
    def __init__(__self__, *,
                 mode: str,
                 name: str,
                 type: str):
        """
        Input or output argument of a function or stored procedure.
        :param str mode: Specifies whether the argument is input or output.
        :param str name: The name of the argument. A return argument of a function might not have a name.
        :param str type: Type of the argument. The exact value depends on the source system and the language.
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        Specifies whether the argument is input or output.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the argument. A return argument of a function might not have a name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the argument. The exact value depends on the source system and the language.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GoogleCloudDatacatalogV1RoutineSpecResponse(dict):
    """
    Specification that applies to a routine. Valid only for entries with the `ROUTINE` type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bigqueryRoutineSpec":
            suggest = "bigquery_routine_spec"
        elif key == "definitionBody":
            suggest = "definition_body"
        elif key == "returnType":
            suggest = "return_type"
        elif key == "routineArguments":
            suggest = "routine_arguments"
        elif key == "routineType":
            suggest = "routine_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatacatalogV1RoutineSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatacatalogV1RoutineSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatacatalogV1RoutineSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bigquery_routine_spec: 'outputs.GoogleCloudDatacatalogV1BigQueryRoutineSpecResponse',
                 definition_body: str,
                 language: str,
                 return_type: str,
                 routine_arguments: Sequence['outputs.GoogleCloudDatacatalogV1RoutineSpecArgumentResponse'],
                 routine_type: str):
        """
        Specification that applies to a routine. Valid only for entries with the `ROUTINE` type.
        :param 'GoogleCloudDatacatalogV1BigQueryRoutineSpecResponse' bigquery_routine_spec: Fields specific for BigQuery routines.
        :param str definition_body: The body of the routine.
        :param str language: The language the routine is written in. The exact value depends on the source system. For BigQuery routines, possible values are: * `SQL` * `JAVASCRIPT`
        :param str return_type: Return type of the argument. The exact value depends on the source system and the language.
        :param Sequence['GoogleCloudDatacatalogV1RoutineSpecArgumentResponse'] routine_arguments: Arguments of the routine.
        :param str routine_type: The type of the routine.
        """
        pulumi.set(__self__, "bigquery_routine_spec", bigquery_routine_spec)
        pulumi.set(__self__, "definition_body", definition_body)
        pulumi.set(__self__, "language", language)
        pulumi.set(__self__, "return_type", return_type)
        pulumi.set(__self__, "routine_arguments", routine_arguments)
        pulumi.set(__self__, "routine_type", routine_type)

    @property
    @pulumi.getter(name="bigqueryRoutineSpec")
    def bigquery_routine_spec(self) -> 'outputs.GoogleCloudDatacatalogV1BigQueryRoutineSpecResponse':
        """
        Fields specific for BigQuery routines.
        """
        return pulumi.get(self, "bigquery_routine_spec")

    @property
    @pulumi.getter(name="definitionBody")
    def definition_body(self) -> str:
        """
        The body of the routine.
        """
        return pulumi.get(self, "definition_body")

    @property
    @pulumi.getter
    def language(self) -> str:
        """
        The language the routine is written in. The exact value depends on the source system. For BigQuery routines, possible values are: * `SQL` * `JAVASCRIPT`
        """
        return pulumi.get(self, "language")

    @property
    @pulumi.getter(name="returnType")
    def return_type(self) -> str:
        """
        Return type of the argument. The exact value depends on the source system and the language.
        """
        return pulumi.get(self, "return_type")

    @property
    @pulumi.getter(name="routineArguments")
    def routine_arguments(self) -> Sequence['outputs.GoogleCloudDatacatalogV1RoutineSpecArgumentResponse']:
        """
        Arguments of the routine.
        """
        return pulumi.get(self, "routine_arguments")

    @property
    @pulumi.getter(name="routineType")
    def routine_type(self) -> str:
        """
        The type of the routine.
        """
        return pulumi.get(self, "routine_type")


@pulumi.output_type
class GoogleCloudDatacatalogV1SchemaResponse(dict):
    """
    Represents a schema, for example, a BigQuery, GoogleSQL, or Avro schema.
    """
    def __init__(__self__, *,
                 columns: Sequence['outputs.GoogleCloudDatacatalogV1ColumnSchemaResponse']):
        """
        Represents a schema, for example, a BigQuery, GoogleSQL, or Avro schema.
        :param Sequence['GoogleCloudDatacatalogV1ColumnSchemaResponse'] columns: The unified GoogleSQL-like schema of columns. The overall maximum number of columns and nested columns is 10,000. The maximum nested depth is 15 levels.
        """
        pulumi.set(__self__, "columns", columns)

    @property
    @pulumi.getter
    def columns(self) -> Sequence['outputs.GoogleCloudDatacatalogV1ColumnSchemaResponse']:
        """
        The unified GoogleSQL-like schema of columns. The overall maximum number of columns and nested columns is 10,000. The maximum nested depth is 15 levels.
        """
        return pulumi.get(self, "columns")


@pulumi.output_type
class GoogleCloudDatacatalogV1SystemTimestampsResponse(dict):
    """
    Timestamps associated with this resource in a particular system.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createTime":
            suggest = "create_time"
        elif key == "expireTime":
            suggest = "expire_time"
        elif key == "updateTime":
            suggest = "update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatacatalogV1SystemTimestampsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatacatalogV1SystemTimestampsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatacatalogV1SystemTimestampsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_time: str,
                 expire_time: str,
                 update_time: str):
        """
        Timestamps associated with this resource in a particular system.
        :param str create_time: Creation timestamp of the resource within the given system.
        :param str expire_time: Expiration timestamp of the resource within the given system. Currently only applicable to BigQuery resources.
        :param str update_time: Timestamp of the last modification of the resource or its metadata within a given system. Note: Depending on the source system, not every modification updates this timestamp. For example, BigQuery timestamps every metadata modification but not data or permission changes.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "expire_time", expire_time)
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Creation timestamp of the resource within the given system.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> str:
        """
        Expiration timestamp of the resource within the given system. Currently only applicable to BigQuery resources.
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        Timestamp of the last modification of the resource or its metadata within a given system. Note: Depending on the source system, not every modification updates this timestamp. For example, BigQuery timestamps every metadata modification but not data or permission changes.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class GoogleCloudDatacatalogV1TableSpecResponse(dict):
    """
    Normal BigQuery table specification.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupedEntry":
            suggest = "grouped_entry"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatacatalogV1TableSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatacatalogV1TableSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatacatalogV1TableSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 grouped_entry: str):
        """
        Normal BigQuery table specification.
        :param str grouped_entry: If the table is date-sharded, that is, it matches the `[prefix]YYYYMMDD` name pattern, this field is the Data Catalog resource name of the date-sharded grouped entry. For example: `projects/{PROJECT_ID}/locations/{LOCATION}/entrygroups/{ENTRY_GROUP_ID}/entries/{ENTRY_ID}`. Otherwise, `grouped_entry` is empty.
        """
        pulumi.set(__self__, "grouped_entry", grouped_entry)

    @property
    @pulumi.getter(name="groupedEntry")
    def grouped_entry(self) -> str:
        """
        If the table is date-sharded, that is, it matches the `[prefix]YYYYMMDD` name pattern, this field is the Data Catalog resource name of the date-sharded grouped entry. For example: `projects/{PROJECT_ID}/locations/{LOCATION}/entrygroups/{ENTRY_GROUP_ID}/entries/{ENTRY_ID}`. Otherwise, `grouped_entry` is empty.
        """
        return pulumi.get(self, "grouped_entry")


@pulumi.output_type
class GoogleCloudDatacatalogV1UsageSignalResponse(dict):
    """
    The set of all usage signals that Data Catalog stores. Note: Usually, these signals are updated daily. In rare cases, an update may fail but will be performed again on the next day.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "updateTime":
            suggest = "update_time"
        elif key == "usageWithinTimeRange":
            suggest = "usage_within_time_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatacatalogV1UsageSignalResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatacatalogV1UsageSignalResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatacatalogV1UsageSignalResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 update_time: str,
                 usage_within_time_range: Mapping[str, str]):
        """
        The set of all usage signals that Data Catalog stores. Note: Usually, these signals are updated daily. In rare cases, an update may fail but will be performed again on the next day.
        :param str update_time: The end timestamp of the duration of usage statistics.
        :param Mapping[str, str] usage_within_time_range: Usage statistics over each of the predefined time ranges. Supported time ranges are `{"24H", "7D", "30D"}`.
        """
        pulumi.set(__self__, "update_time", update_time)
        pulumi.set(__self__, "usage_within_time_range", usage_within_time_range)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The end timestamp of the duration of usage statistics.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="usageWithinTimeRange")
    def usage_within_time_range(self) -> Mapping[str, str]:
        """
        Usage statistics over each of the predefined time ranges. Supported time ranges are `{"24H", "7D", "30D"}`.
        """
        return pulumi.get(self, "usage_within_time_range")


@pulumi.output_type
class GoogleCloudDatacatalogV1ViewSpecResponse(dict):
    """
    Table view specification.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "viewQuery":
            suggest = "view_query"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatacatalogV1ViewSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatacatalogV1ViewSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatacatalogV1ViewSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 view_query: str):
        """
        Table view specification.
        :param str view_query: The query that defines the table view.
        """
        pulumi.set(__self__, "view_query", view_query)

    @property
    @pulumi.getter(name="viewQuery")
    def view_query(self) -> str:
        """
        The query that defines the table view.
        """
        return pulumi.get(self, "view_query")


